@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.CurrencyList')</h3>
    <table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>

  <table class="main-table">
 <thead>
  <tr class="bg">
    <td><div class="center">@lang('layout.Record') </div></td>
    <th>@lang('layout.Currency')</th>
    @if(systemConfig()[30] == 1)
    <th>@lang('layout.StaticRate')</th>
    @endif
    <th>@lang('layout.ExchangeRate')</th>
    <th>@lang('layout.Name')</th>
    <th>@lang('layout.Date')</th>
    <th>@lang('layout.Hour')</th>
 </tr>
 </thead>
 <?php
 $count = 0;
 ?>
 @foreach($data AS $record)
 <tr>
   <td class="center">{{++$count}}</td>
   <td class="center">{{$record->name}}</td>
   @if(systemConfig()[30] == 1)
    <td class="center">{{$record->static_rate}}</td>
    @endif
   <td class="center">{{$record->exchange_rate}}</td>
   <td class="center">{{$record->uname}}</td>
   <td class="center">{{$record->date}}</td>
   <td class="center">{{$record->hour}}</td>
</tr>
  @endforeach   
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection