
@push('scripts')
    <script type="text/javascript">
        Vue.component('company', {

            data: function () {
                return {
                    companies: [],
                    selected: '{{ getCompanyID() }}',
                    type:'{{ getCalculationType() }}',
                    my_company_id:'{{auth()->user()->company_id}}'
                }
            },
            created() {
                @if(isGroupCompany() && \Entrust::can('groupCompany-show'))
                    this.getAllCompany();
                @endif
            }, 
            template:
                `
            @if(isGroupCompany() && \Entrust::can('groupCompany-show'))
                <section class="row hidden-print" v-if="companies.length> 1">
                    <div class="col-xs-1, .col-sm-1, .col-md-4, .col-lg-4"></div>
                    <div class="col-xs-1, .col-sm-1, .col-md-4, .col-lg-4"></div>
                    <div class="col-xs-1, .col-sm-1, .col-md-2, .col-lg-2"></div>
                    <div class="col-xs-9, .col-sm-9, .col-md-2, .col-lg-2"  style="padding-right: 1px !important; padding-left: 1px !important;">
                        <table>
                            <tr>
                                <td>
                                    <select class="form-control" v-model="selected" id ="company-filter" style="margin:15px !important;border-radius:5px;padding: 0px 10px;" @change="selectCompany()">
                                        <option disabled> @lang('layout.SelectBranch')</option>
                                        <option :value="'all'" >@lang('layout.All')</option>
                                        <option v-for="c in companies" :value="c.id" :key="c.id" :style="my_company_id == c.id? 'font-weight: bold': null">
                                                @{{c.name}}
                                        </option>
                                    </select>
                                </td>
                            <!--td>
                                <template v-if="my_company_id != selected && selected != 'all'">
                                        <i class="fa fa-calculator" @click="setType" :class="type == 1 ? 'text-primary': 'text-default'"></i>
                                </template>
                            </td-->
                            </tr>
                        </table>
                    </div>
                </section>
            @endif
        `,
            methods: {
                getAllCompany() {
                    axios.get('{!! route('group.company.all') !!}',)
                        .then((response) => {
                            this.companies = response.data;
                            // console.log('SSSS',this.companies)
                        });
                },
                selectCompany() {
                    axios.post('{!! route('set.company.id') !!}', {
                        company_id: this.selected
                    }).then((response) => {
                        this.$emit('company', {
                            company: response.data.company,
                        });
                    });
                },
                /*setType(){

                    let type = this.type == 0 ? 1: 0;

                    axios.post('{!! route('set.calculation.type') !!}',{
                        type: type
                    }).then((response)=>{
                        this.type = response.data.type;
                        this.$emit('company', {
                            company: response.data.company,
                        });
                    })
                }*/

            }
        });
    </script>
@endpush