@extends('layouts.app')
@section('style')
    <style type="text/css">
        table.td {
            border-top: 0px;
        }

        .header {

        }

    </style>
@stop
@section('content')

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title" id="backbtn">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.BranchDetails')</span>
                </div>
                
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                <div class="row">
                    <div class="panel-info">
                        <div class="panel-heading">
                            <h4 class="text-center panel-title"> @lang('layout.Details') </h4>
                        </div>
                        <div class="panel-body">
                            <div class="panel-body">
                                @if($company->logo)
                                    <img src="{!!url('/uploads/'.$company->logo)!!}" style="max-width: 120px; margin-left: 45%;margin-right: 45%"
                                         class="img img-rounded" >

                                @endif
                                <div class="row">
                                    <div class="col-md-6 col-sm-12">
                                        <table class="table">
                                            <thead>
                                            <th><b>@lang('layout.Title')</b></th>
                                            <th><b>@lang('layout.Data')</b></th>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td>
                                                    <i class="fa fa-check-square"></i>
                                                    <b>@lang('layout.CompanyName')</b>
                                                </td>
                                                <td>
                                                    @if($detail)
                                                        {!!$detail->company_name!!}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <i class="fa fa-check-circle"></i> <b>@lang('layout.Type')</b>
                                                </td>
                                                <td>
                                                    @if($company->type)
                                                        {{__("layout.$company->type")}}
                                                    @endif

                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <i class="fa fa-globe"></i> <b>@lang('layout.WebSite')</b>
                                                </td>
                                                <td>{!!$company->website!!}</td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <i class="fa fa-envelope-o"></i> <b>@lang('layout.Email')</b>
                                                </td>
                                                <td>{!!$company->email!!}</td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <i class="fa fa-globe"></i> <b>@lang('layout.Country')</b>
                                                </td>
                                                <td>
                                                    @if($detail)
                                                        {!!$detail->country!!}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <i class="fa fa-globe"></i> <b>@lang('layout.City')</b>
                                                </td>
                                                <td>
                                                    @if($detail)
                                                        {!!$detail->city!!}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <i class="fa fa-street-view"></i>
                                                    <b>@lang('layout.StreetAddress')</b>
                                                </td>
                                                <td>
                                                    @if($detail)
                                                        {!!$detail->street_address!!}
                                                    @endif
                                                </td>
                                            </tr>
                                            </tbody>

                                        </table>
                                    </div>
                                    <div class="col-md-6 col-sm-12">
                                        <table class="table">
                                            <thead>
                                            <th><b>@lang('layout.Title')</b></th>
                                            <th><b>@lang('layout.Data')</b></th>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td>
                                                    <b><i class="fa fa-users"></i> @lang('layout.UserCount') </b>
                                                </td>
                                                <td>
                                                    {!! $config->user_count !!}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <b><i class="fa fa-database"></i> @lang('layout.InventorySiteCount')
                                                    </b>
                                                </td>
                                                <td>
                                                    {!! $config->inventory_site_count !!}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <b><i class="fa fa-file-excel-o"></i> @lang('layout.CustomReport')
                                                    </b>
                                                </td>
                                                <td>
                                                    {{ $config->custom_report? __('layout.yes') : __('layout.Not') }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <b><i class="fa fa-file-excel-o"></i> @lang('layout.Build')</b>
                                                </td>
                                                <td>
                                                    {{ $config->build? __('layout.yes') : __('layout.Not') }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <b><i class="fa fa-podcast"></i> @lang('layout.Prophil')</b>
                                                </td>
                                                <td>
                                                    {{ $config->prophil? __('layout.yes') : __('layout.Not') }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <b><i class="fa fa-windows"></i> @lang('layout.PVC')</b>
                                                </td>
                                                <td>
                                                    {{ $config->pvc? __('layout.yes') : __('layout.Not') }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <i class="fa fa-university"></i> <b>@lang('layout.Bank')</b>
                                                </td>
                                                <td>
                                                    @if($detail)
                                                        {!!$detail->bank!!}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <i class="fa fa-address-card-o"></i>
                                                    <b>@lang('layout.Description')</b>
                                                </td>
                                                <td>
                                                    @if($detail)
                                                        {!!$detail->description!!}
                                                    @endif
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <table class="table">
                                    <thead>
                                    <tr class="header">

                                    </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    {{--/end of righ panel--}}

                </div>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
@endsection
 
