@extends('layouts.app')
@section('styles')
    <style type="text/css">
        .selected-company {
            box-shadow: #686868;
        }


    </style>
@endsection
@section('content')

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.groupCompanyList')</span>
                </div>
                <div class="tools"></div>

                <div class="btn-group pull-right">

                    <a href="{{route('group.company.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                </div>
            </div>
            {{--end of portlet title--}}
            <div class="portlet-body" id="companies">
                <div class="row">
                    {{--for all selection --}}
                    <div class="col-sm-12 col-md-4" v-if="companies.length > 1">
                        <div class="panel" :class="selected == 'all' ? 'panel-info' : 'panel-default'" @click="setSelected('all')">
                            <div class="panel-heading">
                                <h4 class="text-center" style="color: white;"> <i class="fa fa-check" v-if="selected == 'all'"></i>@lang('layout.SelectAll')</h4>

                            </div>
                            <div class="panel-body">
                                <p class="text-center" :class="selected == 'all' ? 'text-info': null"
                                   style="margin-top: 25px">
                                    <i class="fa fa-th-large" style="font-size: 90px; padding-top: 25px"></i>
                                </p>

                            </div>
                            <div class="panel-footer">
                                <div class="text-center">
                                    <button class="btn" :class="selected == 'all'?'btn-info' :'btn-default'"
                                            :style="selected == 'all'? 'cursor: not-allowed':null">
                                        <i class="fa fa-hand-o-up"></i>
                                    </button>

                                </div>
                            </div>
                        </div>
                    </div>

                    {{--end for all--}}


                    <div class="col-sm-12 col-md-4" v-for="company in companies">
                        <div class="panel"
                             :class="(selected == company.id || selected=='all') ? 'panel-info' : 'panel-default'">
                            <div class="panel-heading">
                                <h4 class="text-center" style="color: white !important;"><i class="fa fa-check" v-if="selected == 'all'|| selected == company.id"></i> @{{ company.name }} <span v-if="mainBranchId == company.id"> (@lang('layout.MainCompany')) </span> </h4>
                            </div>
                            <div class="panel-body">
                                <div style="margin: 10px;padding: 10px;" class="text-center">
                                    <img :src="'uploads/'+company.logo" class="img img-circle " v-if="company.logo"
                                         style="max-width: 30%;">
                                    <h1 v-else class="text-center"
                                        :class="(selected == company.id || selected =='all')? 'text-info':''">
                                        <i :class="(mainBranchId == company.id)? 'fa fa-university':'fa fa-home'" style="font-size: 90px"></i></h1>
                                </div>
                            </div>
                            <div class="panel-footer">
                                <div class="text-center">
                                    <a :href="`{!! route('group.company.show') !!}` +'/'+company.id" class="btn"
                                       :class="(selected == company.id || selected == 'all')?'btn-info' :'btn-default'">
                                        <i class="fa fa-info"></i>
                                    </a>
                                    <button class="btn"
                                            :class="(selected == company.id || selected == 'all')?'btn-info' :'btn-default'"
                                            :style="selected == company.id? 'cursor: not-allowed':null"
                                            @click="setSelected(company.id)">
                                        <i class="fa fa-hand-o-up"></i>
                                    </button>
                                    <a :href="`{!! route('group.company.edit') !!}` + '/'+company.id" class="btn"
                                       :class="(selected == company.id|| selected =='all')?'btn-info' :'btn-default'">
                                        <i class="fa fa-pencil"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            {{--end of portlet-body--}}
        </div>
        {{--end of portlet--}}
    </div>
@stop
@push('scripts')
    <script>
        $(document).ready(function () {

            $('#companyGroup').DataTable({
                ajax: '{{route("group.company.list")}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'company_name', name: 'company_details.company_name'},
                    {data: 'email', name: 'companies.email'},
                    {data: 'description', name: 'company_details.description'},
                    {data: 'tag', searchable: false, orderable: false},
                    {data: 'action', searchable: false, orderable: false},
                ]
            });
        });

        let companies = {!! $companies !!};
      let vm =  new Vue({
            el: "#companies",
            data: {
                companies: companies,
                selected: '{!! getCompanyID() !!}',
                mainBranchId: "{!! getMainBranchId() !!}"
            },
            methods: {
                setSelected(id) {
                    if (id == this.selected)
                        return;
                    axios.post('{!! route('set.company.id') !!}', {
                        company_id: id
                    }).then((response) => {
                        this.selected = response.data.company;
                        this.$emit('company', {
                            company: response.data.company,
                        });
                    });
                },
            }
        });

       $(document).keydown(function(event){
          if ((event.which == 97 || event.which == 65 ) && event.ctrlKey){
              event.preventDefault();
              vm.setSelected('all');
          }
       });
    </script>
@endpush