@section('style')
<style type="text/css">
    #main {
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
        border-collapse: collapse;
        width: 100%;
    }

    #main th,
    #main td {
        border: 1px solid #ddd;
        padding: 8px;
    }

    /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
    #main tr:hover {
        background-color: #ddd;
    }

    #main th {
        padding-top: 12px;
        padding-bottom: 12px;
        /*text-align: left;*/
        background-color: #768585;
        color: white;
    }
</style>
@stop
@push('scripts')
<script type="text/javascript">
    Vue.component('profit', {
        props: [
            'symbol',
            'income',
            'costOfGoodSold',
            'expense',
            'otherExpense',
            'otherIncome',
            'totalIncome',
            'totalCostOfGoodSold',
            'totalExpense',
            'totalOtherExpense',
            'totalOtherIncome',
            'grossProfit',
            'netProfit',
        ],
        filters: {
            currencyFormat(value) {
                let formatter = new Intl.NumberFormat('en-US', {
                    minimumFractionDigits: 2,
                });
                // console.log('symbol in filter', this.symbol);
                return formatter.format(value);
            }
        },
        created() {
            // console.log('symbol', this.symbol)
        },
        template: `
                <div class="row">
                    <div class="col-sm-12 col-md-12 table-responsive">
                        <table  id="main">
                            <thead>
                                <tr>
                                     <th>@lang('layout.Category')</th>
                                     <th>@lang('layout.AccountName')</th>
                                     <th>@lang('layout.AccountType')</th>
                                     <th>@lang('layout.Amount')</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="4" style="background-color: #e8edff; color:#669;">
                                      @lang('layout.Income'):
                                    </td>
                                </tr>
                                <template v-for="inc in income">
                                    <tr>
                                        <td></td>
                                        <td>
                                            <a :href="'{!! url('/account') !!}/'+inc.id">
                                                @{{ inc.AccountName }}
                                            </a>
                                        </td>
                                         <td></td>
                                        <td>
                                            @{{symbol}}@{{inc.Amount|currencyFormat }}
                                            <template v-if="inc.children">
                                            <br/>
                                                @lang('layout.Total')  @{{inc.AccountName}} : @{{inc.total}}
                                            </template>
                                        </td>
                                    </tr>

                                    <template v-if="inc.children" v-for="(ch,index) in inc.children">
                                        <tr>
                                            <td></td>
                                            <td style="padding:0px 40px 0px 0px; color: yellow; font-weight: bolder; font-size: 20px">
                                               <b> @{{ index + 1 }} </b>
                                               <a :href="'{!! url('/account/') !!}/'+ch.id"
                                                         style="color: yellow">
                                                         @{{ch.AccountName}}
                                               </a>

                                            </td>
                                             <td></td>
                                            <td>

                                                @{{ch.Amount|currencyFormat}}
                                                <template v-if="ch.children">
                                                    <br/> @lang('layout.Total')
                                                    @{{  ch.AccountName }} : @{{  ch.total|currencyFormat }}
                                                </template>
                                            </td>
                                        </tr>


                                        <template v-if="ch.children" v-for = "(cch, index1) in ch.children">
                                            <tr>
                                                <td></td>
                                                <td style="padding:0px 80px 0px 0px;">
                                                    <a :href="'{{url('/account/')}}/'+cch.id">
                                                                                            @{{cch.AccountName}}
                                                                                        </a>
                                                                                        <br>
                                                                                    </td>
                                                                                    <td></td>
                                                                                    <td>

                                                                                        @{{cch.Amount|currencyFormat}}
                                                                                        <template v-if="cch.children">
                                                                                        <br>
                                                                                        @lang('layout.Total')
                                                    @{{cch.AccountName}} :@{{cch.total}}
                                                </template>
                                            </td>
                                        </tr>
                                    </template>
                                    </template>
                                    </template>
                                    <tr>
                                    <td colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">
                                    @lang('layout.TotalIncome'):
                                    </td>
                                    <td style="background-color: #e8edff; color:#669;">
                                        @{{totalIncome|currencyFormat}}
                                    </td>
                                </tr>

                                <template v-for="inc in costOfGoodSold">
                                    <tr>
                                        <td></td>
                                        <td>
                                            <a :href="'{!! url('/account') !!}/'+inc.id">
                                                @{{ inc.AccountName }}
                                            </a>
                                        </td>
                                         <td></td>
                                        <td>
                                            @{{ inc.Amount|currencyFormat }}
                                            <template v-if="inc.children">
                                            <br/>
                                                @lang('layout.Total')  @{{inc.AccountName}} : @{{inc.total|currencyFormat}}
                                            </template>
                                        </td>
                                    </tr>

                                    <template v-if="inc.children" v-for="(ch,index) in inc.children">
                                        <tr>
                                            <td></td>
                                            <td style="padding:0px 40px 0px 0px; color: yellow; font-weight: bolder; font-size: 20px">
                                               <b> @{{ index + 1 }} </b>
                                               <a :href="'{!! url('/account/') !!}/'+ch.id"
                                                         style="color: yellow">
                                                         @{{ch.AccountName}}
                                               </a>

                                            </td>
                                             <td></td>
                                            <td>

                                                @{{ch.Amount}}
                                                <template v-if="ch.children">
                                                    <br/> @lang('layout.Total')
                                                    @{{  ch.AccountName }} : @{{  ch.total|currencyFormat }}
                                                </template>
                                            </td>
                                        </tr>


                                    <template v-if="ch.children" v-for = "(cch, index1) in ch.children">
                                        <tr>
                                            <td></td>
                                            <td style="padding:0px 80px 0px 0px;">
                                                <a :href="'{{url('/account/')}}/'+cch.id">
                                                                                        @{{cch.AccountName}}
                                                                                    </a>
                                                                                    <br>
                                                                                </td>
                                                                                <td></td>
                                                                                <td>
                                                                                    @{{cch.Amount|currencyFormat}}
                                                                                    <template v-if="cch.children">
                                                                                    <br>
                                                                                    @lang('layout.Total')
                                                    @{{cch.AccountName}} :@{{cch.total|currencyFormat}}
                                                </template>
                                            </td>
                                        </tr>
                                    </template>
                                    </template>
                                    </template>

                                    <tr>
                                    <td colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">
                                    @lang('layout.TotalCostOfGoodSold'):
                                </td>
                                <td style="background-color: #e8edff; color:#669;">
                                    @{{totalCostOfGoodSold|currencyFormat}}
                                </td>
                            </tr>

                             <tr>
                               <th colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.GrossProfit'):
                                    {{-- <span style="margin-left: 78.5%;font-size: 15px">{{$totalAsset}}</span> --}}
                                </th>
                                <td style="background-color: #e8edff; color:#669;">@{{grossProfit|currencyFormat}}</td>
                            </tr>

                            <tr>
                                <th>@lang('layout.Category')</th>
                                <th>@lang('layout.AccountName')</th>
                                <th>@lang('layout.AccountType')</th>
                                <th>@lang('layout.Amount')</th>
                            </tr>
                            <tr>
                                <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.AllExpenseAccounts'):</th>
                            </tr>
                           <template v-for="inc in expense">
                                <tr>
                                    <td></td>
                                    <td>
                                        <a :href="'{!! url('/account') !!}/'+inc.id">
                                            @{{ inc.AccountName }}
                                        </a>
                                    </td>
                                     <td></td>
                                    <td>
                                        @{{ inc.Amount }}
                                        <template v-if="inc.children">
                                        <br/>
                                            @lang('layout.Total')  @{{inc.AccountName}} : @{{inc.total|currencyFormat}}
                                        </template>
                                    </td>
                                </tr>

                                <template v-if="inc.children" v-for="(ch,index) in inc.children">
                                    <tr>
                                        <td></td>
                                        <td style="padding:0px 40px 0px 0px; color: yellow; font-weight: bolder; font-size: 20px">
                                           <b> @{{ index + 1 }} </b>
                                           <a :href="'{!! url('/account/') !!}/'+ch.id"
                                                     style="color: yellow">
                                                     @{{ch.AccountName}}
                                           </a>

                                        </td>
                                         <td></td>
                                        <td>

                                            @{{ch.Amount|currencyFormat}}
                                            <template v-if="ch.children">
                                                <br/> @lang('layout.Total')
                                                @{{  ch.AccountName }} : @{{  ch.total|currencyFormat }}
                                            </template>
                                        </td>
                                    </tr>


                                <template v-if="ch.children" v-for = "(cch, index1) in ch.children">
                                    <tr>
                                        <td></td>
                                        <td style="padding:0px 80px 0px 0px;">
                                            <a :href="'{{url('/account/')}}/'+cch.id">
                                                                                @{{cch.AccountName}}
                                                                            </a>
                                                                            <br>
                                                                        </td>
                                                                        <td></td>
                                                                        <td>
                                                                            @{{cch.Amount|currencyFormat}}
                                                                            <template v-if="cch.children">
                                                                            <br>
                                                                            @lang('layout.Total')
                                                @{{cch.AccountName}} :@{{cch.total|currencyFormat}}
                                            </template>
                                        </td>
                                    </tr>
                                </template>
                                </template>
                                </template>

                                <tr>
                                <th colspan="3"
                                style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalOtherExpenses'):
                                {{-- <span style="margin-left: 70%;">{{$TotalLiability}}</span> --}}
                            </th>
                            <td style="background-color: #e8edff; color:#669;">@{{totalExpense|currencyFormat}}</td>

                        </tr>
                        <tr>
                        <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.AllOtherExpenseAccounts'):</th>
                        </tr>

                        <template v-for="inc in otherExpense">
                            <tr>
                                <td></td>
                                <td>
                                    <a :href="'{!! url('/account') !!}/'+inc.id">
                                        @{{ inc.AccountName }}
                                    </a>
                                </td>
                                 <td></td>
                                <td>
                                    @{{ inc.Amount }}
                                    <template v-if="inc.children">
                                    <br/>
                                        @lang('layout.Total')  @{{inc.AccountName}} : @{{inc.total|currencyFormat}}
                                    </template>
                                </td>
                            </tr>

                            <template v-if="inc.children" v-for="(ch,index) in inc.children">
                                <tr>
                                    <td></td>
                                    <td style="padding:0px 40px 0px 0px; color: yellow; font-weight: bolder; font-size: 20px">
                                       <b> @{{ index + 1 }} </b>
                                       <a :href="'{!! url('/account/') !!}/'+ch.id"
                                                 style="color: yellow">
                                                 @{{ch.AccountName}}
                                       </a>

                                    </td>
                                     <td></td>
                                    <td>
                                        @{{ch.Amount|currencyFormat}}
                                        <template v-if="ch.children">
                                            <br/> @lang('layout.Total')
                                            @{{  ch.AccountName }} : @{{  ch.total|currencyFormat }}
                                        </template>
                                    </td>
                                </tr>


                                <template v-if="ch.children" v-for = "(cch, index1) in ch.children">
                                    <tr>
                                        <td></td>
                                        <td style="padding:0px 80px 0px 0px;">
                                            <a :href="'{{url('/account/')}}/'+cch.id">
                                                                                @{{cch.AccountName}}
                                                                             </a>
                                                                             <br>
                                                                         </td>
                                                                         <td></td>
                                                                         <td>
                                                                            @{{cch.Amount|currencyFormat}}
                                                                            <template v-if="cch.children">
                                                                              <br>
                                                                              @lang('layout.Total')
                                            @{{cch.AccountName}} :@{{cch.total|currencyFormat}}
                                        </template>
                                    </td>
                                </tr>
                            </template>
                            </template>
                            </template>
                            <tr>
                            <th colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">
                            @lang('layout.TotalOtherExpenses'):
                            </th>
                            <td style="background-color: #e8edff; color:#669;">
                                @{{totalOtherExpense|currencyFormat}}
                            </td>
                        </tr>


                    <tr>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.AccountName')</th>
                        <th>@lang('layout.AccountType')</th>
                        <th>@lang('layout.Amount')</th>
                    </tr>
                    <tr>
                        <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.AllOtherIncomeAccounts'):</th>
                    </tr>
                    <template v-for="inc in otherIncome">
                        <tr>
                            <td></td>
                            <td>
                                <a :href="'{!! url('/account') !!}/'+inc.id">
                                    @{{ inc.AccountName }}
                                </a>
                            </td>
                             <td></td>
                            <td>
                                @{{ inc.Amount }}
                                <template v-if="inc.children">
                                <br/>
                                    @lang('layout.Total')  @{{inc.AccountName}} : @{{inc.total|currencyFormat}}
                                </template>
                            </td>
                        </tr>

                        <template v-if="inc.children" v-for="(ch,index) in inc.children">
                            <tr>
                                <td></td>
                                <td style="padding:0px 40px 0px 0px; color: yellow; font-weight: bolder; font-size: 20px">
                                   <b> @{{ index + 1 }} </b>
                                   <a :href="'{!! url('/account/') !!}/'+ch.id"
                                             style="color: yellow">
                                             @{{ch.AccountName}}
                                   </a>

                                </td>
                                 <td></td>
                                <td>

                                    @{{ch.Amount}}
                                    <template v-if="ch.children">
                                        <br/> @lang('layout.Total')
                                        @{{  ch.AccountName }} : @{{  ch.total|currencyFormat}}
                                    </template>
                                </td>
                            </tr>


                            <template v-if="ch.children" v-for = "(cch, index1) in ch.children">
                            <tr>
                                <td></td>
                                <td style="padding:0px 80px 0px 0px;">
                                    <a :href="'{{url('/account/')}}/'+cch.id">
                                        @{{cch.AccountName}}
                                    </a>
                                    <br>
                                 </td>
                                 <td></td>
                                 <td>
                                    @{{cch.Amount|currencyFormat}}
                                    <template v-if="cch.children">
                                        <br>
                                        @lang('layout.Total')
                                    @{{cch.AccountName}} :@{{cch.total|currencyFormat}}
                                    </template>
                                 </td>
                              </tr>
                            </template>
                        </template>
                        </template>

                        <tr>
                        <th colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">
                        @lang('layout.TotalOtherIncome'):
                         </th>
                        <td style="background-color: #e8edff; color:#669;">
                            @{{totalOtherIncome|currencyFormat}}
                        </td>

                    </tr>
                    <tr>
                        <th colspan="3" stle="background-color: #e8edff; color:#669; font-size: 12px">
                            @lang('layout.NetProfit'):
                        </th>
                        <td style="background-color: #e8edff; color:#669;">
                            @{{netProfit|currencyFormat}}
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
`,
        methods: {

        }
    });
</script>
@endpush