@extends('layouts.app')
@section('content')

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.AccountList')</span>
                </div>
                <div class="tools"></div>

                <div class="btn-group pull-right">
                    <div class="tabbable tabbable-tabdrop">
                    </div>
                </div>
            </div>
            {{--end of portlet title--}}
            <div class="portlet-body" id="app">
                {{--carousel--}}

                <div class="row">
                    <div class="col-sm-12">
                        <div id="myCarousel" class="carousel slide">

                            <div class="carousel-inner">

                                <div class="item" v-for="company in companies"
                                     :class="{'active': company.id == selected}" :data-id="company.id">
                                    <div class="panel panel-info">
                                        <div class="panel-heading">
                                            <p class='text-center' style="font-size: 25px; color: white !important;">@{{company.name}}</p>
                                        </div>
                                        <div class="panel-body">
                                            <profit

                                                    :income="income"
                                                    :cost-of-good-sold="costOfGoodSold"
                                                    :expense="expense"
                                                    :otherExpense="otherExpense"
                                                    :other-income="otherIncome"
                                                    :total-income="totalIncome"
                                                    :total-cost-of-good-sold="totalCostOfGoodSold"
                                                    :total-expense="totalExpense"
                                                    :total-other-expense="totalOtherExpense"
                                                    :total-other-income="totalOtherIncome"
                                                    :gross-profit="grossProfit"
                                                    :net-profit="netProfit"
                                                    :symbol="symbol"></profit>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <a href="#myCarousel" class="left carousel-control"
                               style="background-image:none;margin-top:18px"
                               data-slide="prev">
                                <i class="fa @if(App::getLocale() =="en") fa-chevron-left @else fa-chevron-right @endif"></i>
                                <span class="sr-only">@lang('layout.Previous')</span>
                            </a>

                            <a href="#myCarousel" class="right carousel-control" data-slide="next"
                               style="background-image:none;margin-top:18px">

                                <i class="fa  @if(App::getLocale() =="en") fa-chevron-right @else fa-chevron-left @endif"></i>
                                <span class="sr-only">@lang('layout.Next')</span>
                            </a>
                        </div>
                    </div>
                </div>


                {{--end carousel--}}
            </div>
            {{--end of portlet-body--}}
        </div>
        {{--end of portlet--}}
    </div>
@stop
@include('group-company.financial.profit_loss_template')
@push('scripts')
    <script>
        let vm = new Vue({
            el: "#app",
            data: {
                companies: [],
                selected: '{!! auth()->user()->company_id !!}',
                income: [],
                costOfGoodSold: [],
                expense: [],
                otherExpense: [],
                otherIncome: [],
                totalIncome: null,
                totalCostOfGoodSold: null,
                totalExpense: null,
                totalOtherExpense: null,
                totalOtherIncome: [],
                grossProfit: null,
                netProfit: null,
                symbol: {}
            },
            methods: {
                getAllCompany() {
                    axios.get('{!! route('group.company.all') !!}',)
                        .then((response) => {
                            this.companies = response.data;
                        });
                },
                fetchAccounts(company_id) {
                    this.income = [];
                    this.costOfGoodSold = [];
                    this.expense = [];
                    this.otherExpense = [];
                    this.otherIncome = [];
                    this.totalIncome = null;
                    this.totalCostOfGoodSold = null;
                    this.totalExpense = null;
                    this.totalOtherExpense = null;
                    this.totalOtherIncome = [];
                    this.grossProfit = null;
                    this.netProfit = null;
                    this.symbol = null;
                    axios.get('{!! route('group.company.los.profit') !!}', {
                        params: {
                            company_id: company_id
                        }
                    }).then((response) => {
                        this.income = response.data.income;
                        this.costOfGoodSold = response.data.costOfGoodSold;
                        this.expense = response.data.expense;
                        this.otherExpense = response.data.otherExpense;
                        this.otherIncome = response.data.otherIncome;
                        this.totalIncome = response.data.totalIncome;
                        this.totalCostOfGoodSold = response.data.totalCostOfGoodSold;
                        this.totalExpense = response.data.totalExpense;
                        this.totalOtherExpense = response.data.totalOtherExpense;
                        this.totalOtherIncome = response.data.totalOtherIncome;
                        this.grossProfit = response.data.grossProfit;
                        this.netProfit = response.data.netProfit;
                        this.symbol = response.data.homeCurrency.symbol;
                        // console.log('home ',response.data.homeCurrency)
                    })
                },
                setSelected() {
                    if (this.companies.length > 1) {
                        let company_id = $('div#myCarousel div.active').attr('data-id');
                        this.selected = company_id;
                        this.fetchAccounts(company_id);
                    }
                }
            },
            created() {
                this.getAllCompany();
                this.fetchAccounts(this.selected);
            }
        });
        $(document).ready(function () {
            $('#myCarousel').bind('slid.bs.carousel', function (e) {
                vm.setSelected();
            })

        });

    </script>
@endpush