@section('style')
    <style type="text/css">
        #main {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        #main th, #main td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
        #main tr:hover {
            background-color: #ddd;
        }

        #main th {
            padding-top: 12px;
            padding-bottom: 12px;

            background-color: #768585;
            color: white;
        }

        .doubleLine {
            text-decoration-line: underline;
            text-decoration-style: double;
        }

        .modal-mask {
            position: fixed;
            z-index: 9998;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, .5);
            display: table;
            transition: opacity .3s ease;
        }

        .modal-wrapper {
            display: table-cell;
            vertical-align: middle;
        }

        .modal-container {
            width: 80%;
            max-width: 90%;
            margin: 0px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 2px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
            transition: all .3s ease;
            font-family: Helvetica, Arial, sans-serif;
        }

        .modal-header h3 {
            margin-top: 0;
            color: #42b983;
        }

        .modal-body {
            margin: 20px 0;
        }

        .modal-default-button {
            float: right;
        }

        .modal-enter {
            opacity: 0;
        }

        .modal-leave-active {
            opacity: 0;
        }

        .modal-enter .modal-container,
        .modal-leave-active .modal-container {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }

    </style>
@stop
@push('scripts')
    <script type="text/javascript">
       let d= Vue.component('balance-sheet', {
            props: [
                'noneCurrentAsset',
                'currentAsset',
                'totalNoneCurrentAsset',
                'totalCurrentAsset',
                'totalAsset',
                'liability',
                'totalLiability',
                'equity',
                'totalEquities',
                'netProfit',
                'totalLiabilityAndEquity',
                'r_accounts',
                'p_accounts',
                'payableAmount',
                'color',
                'nonePosting',
                'currency'
            ],
            filters: {
                number_format:function(value,currency) {
                    let formatter = new Intl.NumberFormat('en-US', {
                        minimumFractionDigits: 2,
                    });

                    return currency + formatter.format(value);

                },
                toUpperCase(arg){
                    // console.log(3232,arg);
                    if (arg) {
                        
                    return arg.split(/(?=[A-Z])/).join(" ").toLowerCase();
                    }
                },
            },
            created(){
                console.log('symbol in created',this.currency)
            },
            template:`
            <div class="row">
                <div class="col-sm-12 col-lg-12 table-responsive">
                    <table  id="main" class="main-table">
                        <thead>
                            <tr>
                                 <th>@lang('layout.Category')</th>
                                 <th>@lang('layout.AccountName')</th>
                                 <th>@lang('layout.AccountType')</th>
                                 <th>@lang('layout.Amount')</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                 <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.Assets'):</th>
                            </tr>
                            <template v-for="asset in currentAsset">
                                <tr>
                                    <td></td>
                                    <td>@{{asset.AccountName}}</td>
                                    <td>@{{asset.Type|toUpperCase}}</td>
                                    <td>@{{asset.Amount|number_format(currency)}}</td>
                                </tr>
                            </template>

                             <tr>
                                <td colspan="3"
                                    style="background-color: #e8edff; color:#669; font-size: 12px"> @lang('layout.TotalCurrentAssets'):
                                </td>
                                <td style="background-color: #e8edff; color:#669;">@{{totalCurrentAsset|number_format(currency)}}</td>
                             </tr>

                             <template v-for="asset in noneCurrentAsset">
                                 <tr>
                                    <td></td>
                                    <td>@{{asset.AccountName}}</td>
                                    <td>@{{asset.Type|toUpperCase}}</td>
                                    <td>@{{asset.Amount|number_format(currency)}}</td>
                                 </tr>
                             </template>

                              <tr>
                                <td colspan="3"
                                    style="background-color: #e8edff; color:#669; font-size: 12px"> @lang('layout.TotalNoneCurrentAssets'):
                                </td>
                                <td style="background-color: #e8edff; color:#669">@{{totalNoneCurrentAsset|number_format(currency)}}</td>
                              </tr>

                              <tr>
                                <th colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalAssets'):

                                </th>
                                <td style="background-color: #e8edff; color:#669;" class="doubleLine">@{{totalAsset|number_format(currency)}}</td>
                              </tr>

                              <tr>
                                    <th>@lang('layout.Category')</th>
                                    <th>@lang('layout.AccountName')</th>
                                    <th>@lang('layout.AccountType')</th>
                                    <th>@lang('layout.Amount')</th>
                              </tr>

                               <tr>
                                  <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.Liabilities'):</th>
                               </tr>

                               <tr v-for="lab in liability">
                                    <td></td>
                                    <td>@{{lab.AccountName}}</td>
                                    <td>@{{lab.Type|toUpperCase}}</td>
                                    <td>@{{lab.Amount|number_format(currency)}}</td>
                               </tr>

                               <tr>
                                    <th colspan="3"
                                        style="background-color: #e8edff; color:#669; font-size: 12px">
                                        @lang('layout.TotalLiabilities'):
                                    </th>
                                    <td style="background-color: #e8edff; color:#669;">@{{totalLiability|number_format(currency)}}</td>
                               </tr>

                               <tr>
                                    <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.Equity'):</th>
                               </tr>
                                <tr v-for="eq in equity">
                                    <td></td>
                                    <td>@{{eq.AccountName}}</td>
                                    <td>@{{eq.Type|toUpperCase}}</td>
                                    <td>@{{eq.Amount|number_format(currency)}}</td>
                                </tr>

                                 <tr>
                                    <td>@lang('layout.NetProfit/NetIncome')</td>
                                    <td></td>
                                    <td></td>
                                    <td>@{{netProfit|number_format(currency)}}</td>
                                 </tr>

                                 <tr>
                                    <th colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">
                                        @lang('layout.TotalEquity'):
                                    </th>
                                    <td style="background-color: #e8edff; color:#669;">
                                      @{{totalEquities|number_format(currency)}}
                                    </td>
                                 </tr>
                                 <tr>
                                      <th colspan="3"
                                            style="background-color: #e8edff; color:#669; font-size: 12px">
                                        @lang('layout.TotalLibilities&Equity'):
                                      </th>
                                      <td style="background-color: #e8edff; color:#669;" class="doubleLine">
                                        @{{totalLiabilityAndEquity|number_format(currency)}}
                                      </td>
                                 </tr>

                        </tbody>
                    </table>

                </div>
            </div>
            `,
            methods: {

            }
        });

    </script>
@endpush