@extends('layouts.app')
@section('content')

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.BalanceSheet')</span>
                </div>
                <div class="tools"></div>

                <div class="btn-group pull-right">
                    <div class="tabbable tabbable-tabdrop">
                    </div>
                </div>
            </div>
            {{--end of portlet title--}}
            <div class="portlet-body" id="app">
                {{--carousel--}}

                <div class="row">
                    <div class="col-sm-12">
                        <div id="myCarousel" class="carousel slide">

                            <div class="carousel-inner">

                                <div class="item" v-for="company in companies"
                                     :class="{'active': company.id == selected}" :data-id="company.id">
                                    <div class="panel panel-info">
                                        <div class="panel-heading">
                                            <p class='text-center' style="font-size: 25px; color: white !important;">@{{company.name}}</p>
                                        </div>
                                        <div class="panel-body">
                                            <balance-sheet
                                                :none-current-asset="noneCurrentAsset"
                                                :current-asset="currentAsset"
                                                :total-none-current-asset= "TotalNoneCurrentAsset"
                                                :total-current-asset="TotalCurrentAsset"
                                                :total-asset="totalAsset"
                                                :liability="liability"
                                                :total-liability="TotalLiability"
                                                :equity="equity"
                                                :total-equities="TotalEquities"
                                                :net-profit="netProfit"
                                                :total-liability-and-equity="totalLiabilityAndEquity"
                                                :r_accounts="r_accounts"
                                                :p_accounts="p_accounts"
                                                :payable-amount="payableAmount"
                                                :color="color"
                                                :none-posting="nonePosting"
                                                :currency="currency">
                                            </balance-sheet>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <a href="#myCarousel" class="left carousel-control"
                               style="background-image:none;margin-top:18px"
                               data-slide="prev">
                                <i class="fa @if(App::getLocale() =="en") fa-chevron-left @else fa-chevron-right @endif"></i>
                                <span class="sr-only">@lang('layout.Previous')</span>
                            </a>

                            <a href="#myCarousel" class="right carousel-control" data-slide="next"
                               style="background-image:none;margin-top:18px">

                                <i class="fa  @if(App::getLocale() =="en") fa-chevron-right @else fa-chevron-left @endif"></i>
                                <span class="sr-only">@lang('layout.Next')</span>
                            </a>
                        </div>
                    </div>
                </div>


                {{--end carousel--}}
            </div>
            {{--end of portlet-body--}}
        </div>
        {{--end of portlet--}}
    </div>
@stop
@include('group-company.financial.balance_template')
@push('scripts')
    <script>
        let vm = new Vue({
            el: "#app",
            data: {
                companies: [],
                selected: '{!! auth()->user()->company_id !!}',
                noneCurrentAsset: [],
                currentAsset: [],
                TotalNoneCurrentAsset: null,
                TotalCurrentAsset: null,
                totalAsset: null,
                liability: [],
                TotalLiability: null,
                equity: [],
                TotalEquities: null,
                netProfit: null,
                totalLiabilityAndEquity: null,
                r_accounts: null,
                p_accounts: null,
                payableAmount: null,
                color: null,
                nonePosting: null,
                currency: ' '
            },
            methods: {
                getAllCompany() {
                    axios.get('{!! route('group.company.all') !!}',)
                        .then((response) => {
                            this.companies = response.data;
                        });
                },
                fetchBalanceSheet(company_id) {
                    var vv = this;
                    axios.get('{!! route('group.company.balance.sheet') !!}', {
                        params: {
                            company_id: company_id
                        }
                    }).then((response) => {
                        
                        // console.log('response',response.data.currentAsset);
                        vv.noneCurrentAsset = response.data.noneCurrentAsset;
                        vv.noneCurrentAsset = response.data.noneCurrentAsset;
                        vv.currentAsset = response.data.currentAsset;
                        vv.TotalNoneCurrentAsset = response.data.TotalNoneCurrentAsset;
                        vv.TotalCurrentAsset = response.data.TotalCurrentAsset;
                        vv.totalAsset = response.data.totalAsset;
                        vv.liability = response.data.liability;
                        vv.TotalLiability = response.data.TotalLiability;
                        vv.equity = response.data.equity;
                        vv.TotalEquities = response.data.TotalEquities;
                        vv.netProfit = response.data.netProfit;
                        vv.totalLiabilityAndEquity = response.data.totalLiabilityAndEquity;
                        vv.r_accounts = response.data.r_accounts;
                        vv.p_accounts = response.data.p_accounts;
                        vv.payableAmount = response.data.payableAmount;
                        vv.color = response.data.color;
                        vv.nonePosting = response.data.nonePosting;
                        vv.currency = response.data.homeCurrency.symbol;
                        // console.log('symbol api call', vv.currency)
                    })
                },
                setSelected() {
                    if (this.companies.length > 1) {
                        let company_id = $('div#myCarousel div.active').attr('data-id');
                        this.selected = company_id;
                        this.fetchBalanceSheet(company_id);
                    }
                }
            },
            created() {
                this.getAllCompany();
                this.fetchBalanceSheet(this.selected);
            }
        });
        $(document).ready(function () {
            $('#myCarousel').bind('slid.bs.carousel', function (e) {
                vm.setSelected();
            })

        });

    </script>
@endpush