@extends('layouts.app')
@section('style')
    <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">

    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>

    <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.css') }}" rel="stylesheet"
          type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-markdown/css/bootstrap-markdown.min.css') }}" rel="stylesheet"
          type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.css') }}" rel="stylesheet"
          type="text/css"/>
@endsection
@section('content')

    <h3 style="color:red">@lang('layout.SomeOfThisInformationOnlyShowsInThisAccount')</h3>
    <hr/>
    {{Form::open(array('route'=>['group.company.update',$company->id], 'method'=>'patch','enctype'=>'multipart/form-data'))}}
    <div style="margin-top: 10px" id="app" class="tabbable-line">
        <div class="row">
            <?php
                $logo = null;
                if($company && $company->logo!=null)
                {
                    $logo =  $company->logo;
                }
            ?>

            <div class="col-md-4">
                <div class="form-group">
                    <div class="fileinput fileinput-new" data-provides="fileinput">
                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                            <img src="{!!url('/uploads/'.$logo)!!}" alt=""/>
                        </div>
                        <div class="fileinput-preview fileinput-exists thumbnail"
                             style="max-width: 200px; max-height: 150px;"></div>
                        <div>
                                <span class="btn default btn-file">
                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                    <!-- <input type="file" name="photo">  -->
                                    {!! Form::file('photo', []) !!}
                                </span>
                            {!! Form::hidden('photo1' , (!$company)?null:$company->logo) !!}
                            <a href="javascript:;" class="btn default fileinput-exists"
                               data-dismiss="fileinput">@lang('layout.Remove')</a>
                        </div>
                    </div>

                </div>
            </div>

            <div class="col-md-4">

                <input type="hidden" name="lang" value="{{(!$detail)?null:$detail->lang}}">
                <input type="hidden" name="detail_id" value="{{(!$detail)?null:$detail->id}}">

                <label for="tag">@lang('layout.Branch')</label>
                <input type="text" class="form-control" value="{{(!$company)?null:$company->tag}}" disabled>
            </div>
            <div class="col-md-4">
                <label for="home-currency">@lang('layout.HomeCurency')</label>
                <select name="homeCurrency" id="home-currency" required class="form-control">
                    <option disabled>@lang('layout.Select')</option>
                    @foreach($currencies as $currency=>$value)
                        <option value="{{ $value->id }}"
                                @if($homeCurrency['code']== $value->code) selected @endif>
                            {{$value->code}}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="name">@lang('layout.CompanyName') <span class="text-warning">*</span></label>
                    

                        <textarea id="company_name_editor" class="form-control" name="name">{!! (!$detail)?null: $detail->company_name!!}
                </textarea>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="city">@lang('layout.City') <span class="text-warning">*</span></label>
                   

                    <textarea id="city_editor" class="form-control" name="city">{!! (!$detail)?null: $detail->city!!}
                   </textarea>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="country">@lang('layout.Country') <span class="text-warning">*</span></label>
                    
                    <textarea id="country_editor" class="form-control" name="country">{!! (!$detail)?null: $detail->country!!}
                   </textarea>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="phone">@lang('layout.Phone')</label>
                    

                    <textarea id="phone_editor" class="form-control" name="phone">{!! (!$company)?null: $company->phone!!}
                   </textarea>

                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="email">@lang('layout.Email')</label>
                   

                           <textarea id="email_editor" class="form-control" name="email">{!! (!$company)?null: $company->email!!}
                   </textarea>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="webSite">@lang('layout.WebSite')</label>
                    
                    <textarea id="webSite_editor" class="form-control" name="webSite">{!! (!$company)?null: $company->website!!}
                   </textarea>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="bank">({{__('layout.BankNumber')}})</label>

                         <textarea id="bankNumber_editor" class="form-control" name="bank">{!! (!$detail)?null:$detail->bank!!}
                        </textarea>
                </div>


            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="color">@lang('layout.TextColor')</label>
                    <input type="color" class="form-control" id="color" name="color"
                        value="{{($company)?null:$company->color}}">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="streetAddress">@lang('layout.StreetAddress')</label>
                  

                     <textarea id="streetAddress_editor" class="form-control" name="streetAddress">{!! (!$detail)?null: $detail->street_address!!}
                   </textarea>
                </div>
            </div>
            <div class="col-md-8 mt-radio-inline">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="sole" class="mt-radio">@lang('layout.SoleProprietorship')</label>
                        <input type="radio" name="type" id="sole" v-model="type" value="sole">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="llp" class="mt-radio">@lang('layout.llp')</label>
                        <input type="radio" name="type" id="llp" v-model="type" value="llp">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="llc" lass="mt-radio">@lang('layout.llc')</label>
                        <input type="radio" name="type" id="llc" v-model="type" value="llc" >
                    </div>
                </div>
            </div>

            <div class="portlet light bordered">
                <div class="portlet-title hidden-print">
                    <div class="caption font-dark">
                    </div>
                </div>
                <div class="portlet-body">
                    <h3 style="color:red">@lang('layout.SystemCalculationMethod')</h3>
                    <?php
                    $fifo_check = "";
                    $lifo_check = "";
                    $average_check = "";
                    if ($company) {

                        $fifo_check = ($company->calculation_method == 'fifo') ? 'checked="checked"' : '';
                        $lifo_check = ($company->calculation_method == 'lifo') ? 'checked="checked"' : '';
                        $average_check = ($company->calculation_method == 'average') ? 'checked="checked"' : '';
                    }


                    ?>

                    <hr style="border: 2px solid">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="fifo" class="mt-radio">@lang('layout.FIFO')</label>
                                <input type="radio" name="calculation_method" {{$fifo_check}} value="fifo" id="fifo">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="lifo" class="mt-radio">@lang('layout.LIFO')</label>
                                <input type="radio" name="calculation_method" {{$lifo_check}} value="lifo" id="lifo" >
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="average" lass="mt-radio">@lang('layout.AVERAGEMETHOD')</label>
                                <input type="radio" name="calculation_method" {{$average_check}} value="average" id="average">
                            </div>
                        </div>
                    </div>
                    <hr style="border: 2px solid">
                </div>
            </div>

        <div class="portlet light bordered">

                <div class="portlet-body">
                    <h3 style="color:red">@lang('layout.VoucherMessage')</h3>


                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.InventoryTransferMessage')</label>
                                <textarea class="form-control" id="transfer_message_editor" 
                                          name="inventory_transfer_message">{{(!$detail)?null: $detail->inventory_transfer_message}}</textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.InvoiceMessage')</label>
                                {{--
                                   <textarea class="form-control"
                                          name="invoice_message">{{(!$detail)?null: $detail->invoice_message}}</textarea>
                                 --}}

                                <textarea id="invoice_message_editor" class="form-control" name="invoice_message">{!! (!$detail)?null: $detail->invoice_message!!}
                                 </textarea>

                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.GrnMessage')</label>
                                <textarea class="form-control" id="grn_message_editor" 
                                          name="grn_message">{{(!$detail)?null: $detail->grn_message}}</textarea>
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.ReceiverMessage')</label>
                                <textarea class="form-control" id="receive_message_editor" 
                                          name="receiver_message">{{(!$detail)?null: $detail->receiver_message}}</textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.PayMessage')</label>
                                <textarea class="form-control" id="payment_message_editor" 
                                          name="pay_message">{{(!$detail)?null: $detail->pay_message}}</textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.PaySalaryMessage')</label>
                                <textarea class="form-control" id="paySalary_message_editor" 
                                          name="pay_salary_message">{{(!$detail)?null: $detail->pay_salary_message}}</textarea>
                            </div>
                        </div>

                    </div>
                </div>
            </div>



                   <div class="portlet light bordered">

                <div class="portlet-body">
                    <h3 style="color:red">@lang('layout.WorkAmount')</h3>


                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.Shifty')</label>

                                          <input type="number" name="shifty" class="form-control"  value="{{(!$detail)?null:$detail->shifty}}">
                                          
        
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.Hourly')</label>
                                <input type="number" name="hourly" class="form-control" value="{{(!$detail)?null:$detail->hourly}}">
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-7">
                <div class="form-group last">
                    <label>@lang('layout.CompanyInformation')
                    </label>

                    <textarea name="description" class="form-control" id="summernote_1">{{(!$detail)?null:$detail->description}}</textarea>


                </div>
            </div>
            <div class="col-md-5">
                <div v-for="(social,index) in socials">


                    <div class="form-group">
                        <div class="col-md-5">
                            <label :for="'socialName'+index"> @lang('layout.SocialName')</label>
                            <input type="text" name="socialName[]" class="form-control" v-model="social.socialName"
                                   placeholder="@lang('layout.SocialName')" :id="'socialName'+index">
                        </div>

                        <div class="col-md-5">
                            <label :for="'socialUrl'">@lang('layout.SocialUrl')</label>
                            <input type="text" name="socialUrl[]" class="form-control" v-model="social.socialUrl"
                                   placeholder="@lang('layout.SocialUrl')">
                        </div>

                        <div class="col-md-2">
                            <a href="javascript:;" class="btn btn-circle btn-icon-only green" @click="addrow"><i
                                        class="fa fa-plus"></i></a>
                            <a href="javascript:;" class="btn btn-circle btn-icon-only red "
                               @click="removerow(index,1)"><i class="fa fa-minus"></i></a>
                        </div>
                    </div>

                </div>
            </div>

            <div class="form-actions">
                <div class="row">
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-md-offset-6 col-md-6">

                                <button type="button" onclick="regForm(this)"
                                        class="btn green">@lang('layout.Submit')</button>

                                <a href="{{route('group.company.list')}}" class="btn default"><i
                                            class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-6"></div>
                </div>
            </div>
        </div>


    </div>
    {{Form::close()}}

@endsection
@push('scripts')
    <script>

    $(document).ready(function () {

            $('#summernote_1').summernote({
                 toolbar: [
                    // [groupName, [list of button]]
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']]
                  ],
                  dialogsFade:true
            });
            $('#company_name_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });            

            $('#city_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });            

            $('#country_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });            

            $('#phone_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });            

            $('#email_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });            

            $('#webSite_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,

            });            

            $('#streetAddress_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            

            $('#invoice_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            $('#grn_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            $('#transfer_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            $('#receive_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            $('#payment_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            $('#paySalary_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });           
            
            $('#bankNumber_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });
        });


        let socials = {!! $socials !!};
        new Vue({
            el: '#app',
            data: {
                socials: [],
                type: '{!! $company->type !!}',

            },
            created() {
                this.setSocials();

            },
            methods: {
                setSocials(){
                    if (socials.length){
                        socials.forEach((social)=>{
                            this.socials.push({
                                socialName: social.social_name,
                                socialUrl: social.social_address,
                            });
                        })
                    }else{
                        this.addrow();
                    }
                },
                addrow() {
                    // console.log('test',this.socials);
                    this.socials.push({socialName: null, socialUrl: null});
                },
                removerow(index, id) {
                    if (this.socials.length > 1)
                        this.socials.splice(index, 1)
                }
            }

        });


    </script>
    <script src="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/jquery.sparkline.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/app.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/profile.min.js')}}" type="text/javascript"></script>

    <script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js') }}"
            type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js') }}"
            type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-markdown/lib/markdown.js') }}"
            type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-markdown/js/bootstrap-markdown.js') }}"
            type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.js') }}"
            type="text/javascript"></script>
    <script src="{{ url('/assets/pages/scripts/components-editors.js') }}" type="text/javascript"></script>
@endpush

