@extends('layouts.app')
@section('style')
    <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">

    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>

    <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.css') }}" rel="stylesheet"
          type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-markdown/css/bootstrap-markdown.min.css') }}" rel="stylesheet"
          type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.css') }}" rel="stylesheet"
          type="text/css"/>
@endsection
@section('content')

    <h3 style="color:red">@lang('layout.SomeOfThisInformationOnlyShowsInThisAccount')</h3>
    <hr/>
    {{Form::open(array('route'=>'group.company.store', 'method'=>'POST','enctype'=>'multipart/form-data'))}}
    <div style="margin-top: 10px" id="app" class="tabbable-line">
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <div class="fileinput fileinput-new" data-provides="fileinput">
                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                            <img src="" alt=""/>
                        </div>
                        <div class="fileinput-preview fileinput-exists thumbnail"
                             style="max-width: 200px; max-height: 150px;"></div>
                        <div>
                                <span class="btn default btn-file">
                                    <span class="fileinput-new">@lang('layout.ComapyLogo')</span>
                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                    <!-- <input type="file" name="photo">  -->
                                    {!! Form::file('photo', []) !!}
                                </span>
                            {!! Form::hidden('photo1') !!}
                            <a href="javascript:;" class="btn default fileinput-exists"
                               data-dismiss="fileinput">@lang('layout.Remove')</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-4">
                        <label for="tag">@lang('layout.Branch')</label>
                        <select name="branch_conf" id="tag" class="form-control" v-model="selectedTag" required>
                            <option disabled>@lang('layout.Select')</option>
                                <option
                                        v-for="tag in tags" :value="tag"
                                        :disabled="tag.taken == 1" :title="tag.taken ?'@lang("layout.AlreadyTaken")':null">
                                    @{{ tag.tag }}
                                </option>
                        </select>
                        <input type="hidden" name="tag" :value="selectedTag ? selectedTag.id:null">
                    </div>
                </div>
                <div class="row" v-if="selectedTag">
                    <div class="col-md-12">
                        <div class="row">

                            <div class="col-md-4">
                                <label for="user-count">@lang('layout.UserCount')</label>
                                <input type="text" disabled :value="selectedTag.user_count"
                                       id="user-count" class="form-control">
                            </div>

                            <div class="col-md-4">
                                <label for="inventory-site-count">@lang('layout.InventorySiteCount')</label>
                                <input type="text" class="form-control" id="inventory-site-count" disabled
                                       :value="selectedTag.inventory_site_count">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="costom-report">@lang('layout.CustomReport')</label>
                                <input type="text" class="form-control" disabled :value="selectedTag.custom_report? '@lang("layout.yes")' : '@lang("layout.Not")'" id="costom-report">
                            </div>

                            <div class="col-md-3">
                                <label for="build">@lang('layout.Build')</label>
                                <input type="text" class="form-control" disabled
                                       :value="selectedTag.build ? '@lang("layout.yes")' : '@lang("layout.Not")'">
                            </div>

                            <div class="col-md-3">
                                <label for="prophil">@lang('layout.Prophil')</label>
                                <input type="text" class="form-control" disabled :value="selectedTag.prophil? '@lang("layout.yes")': '@lang("layout.Not")'" id="prophil">
                            </div>

                            <div class="col-md-3">
                                <label for="pvc">@lang('layout.Project')</label>
                                <input type="text" class="form-control" disabled
                                       :value="selectedTag.pvc? '@lang("layout.yes")':'@lang("layout.Not")'" id="pvc">
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <div class="col-md-4">
                <label for="home-currency">@lang('layout.HomeCurency')</label>
                <select name="homeCurrency" id="home-currency" required class="form-control">
                    <option disabled>@lang('layout.Select')</option>
                    @foreach($currencies as $currency=>$value)
                        <option value="{{ $value->id }}">
                            {{$value->code}}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                    <label for="name">@lang('layout.BranchName') <span class="text-warning">*</span></label>
                    <input type="text" class="form-control" name="name" placeholder="@lang('layout.BranchName')">
                    <!-- <div class="col-md-9"> -->

                    <!-- </div> -->
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="city">@lang('layout.City') <span class="text-warning">*</span></label>
                    <input type="text" id="city" class="form-control" name="city" placeholder="@lang('layout.City')">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="country">@lang('layout.Country') <span class="text-warning">*</span></label>
                    <input type="text" class="form-control" name="country" placeholder="@lang('layout.Country')">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="phone">@lang('layout.Phone')</label>
                    <input type="text" class="form-control" name="phone" placeholder="@lang('layout.Phone')" id="phone">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="email">@lang('layout.Email')</label>
                    <input type="email" class="form-control" name="email" placeholder="@lang('layout.Email')"
                           id="email">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="webSite">@lang('layout.WebSite')</label>
                    <input type="url" id="website" class="form-control" name="website"
                           placeholder="@lang('layout.WebSite')">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="bank"><span style="color: green">({{__('layout.BankMessage')}})</span></label>
                    <input type="text" class="form-control" name="bank" id="bank"
                           placeholder="@lang('layout.BankNumber')">
                </div>


            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="color">@lang('layout.TextColor')</label>
                    <input type="color" class="form-control" id="color" name="color">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="streetAddress">@lang('layout.StreetAddress')</label>
                    <input type="text" name="streetAddress" id="streetAddress" class="form-control"
                           placeholder="@lang('layout.StreetAddress')">
                </div>
            </div>
            <div class="col-md-8 mt-radio-inline">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="sole" class="mt-radio">@lang('layout.SoleProprietorship')</label>
                        <input type="radio" name="type" id="sole" v-model="type" value="sole">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="llp" class="mt-radio">@lang('layout.llp')</label>
                        <input type="radio" name="type" id="llp" v-model="type" value="llp">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="llc" lass="mt-radio">@lang('layout.llc')</label>
                        <input type="radio" name="type" id="llc" v-model="type" value="llc">
                    </div>
                </div>
            </div>

            <div class="portlet light bordered">
                <div class="portlet-title hidden-print">
                    <div class="caption font-dark">
                    </div>
                </div>
                <div class="portlet-body">
                    <h3 style="color:red">@lang('layout.SystemCalculationMethod')</h3>

                    <hr style="border: 2px solid">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="fifo" class="mt-radio">@lang('layout.FIFO')</label>
                                <input type="radio" id="fifo" name="calculation_method" value="fifo">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="lifo" class="mt-radio">@lang('layout.LIFO')</label>
                                <input type="radio" id="lifo" name="calculation_method" value="lifo">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="average" lass="mt-radio">@lang('layout.AVERAGEMETHOD')</label>
                                <input type="radio" name="calculation_method" id="average" value="average">
                            </div>
                        </div>
                    </div>
                    <hr style="border: 2px solid">
                </div>
            </div>

            <div class="portlet light bordered">

                <div class="portlet-body">
                    <h3 style="color:red">@lang('layout.VoucherMessage')</h3>


                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="inventory">@lang('layout.InventoryTransferMessage')</label>
                                <textarea id="inventory" class="form-control"
                                          name="inventory_transfer_message"></textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.InvoiceMessage')</label>
                                <textarea class="form-control" name="invoice_message"></textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.GrnMessage')</label>
                                <textarea class="form-control" name="grn_message"></textarea>
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.ReceiverMessage')</label>
                                <textarea class="form-control" name="receiver_message"></textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.PayMessage')</label>
                                <textarea class="form-control" name="pay_message"></textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.PaySalaryMessage')</label>
                                <textarea class="form-control" name="pay_salary_message"></textarea>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="portlet light bordered">

                <div class="portlet-body">
                    <h3 style="color:red">@lang('layout.WorkAmount')</h3>


                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.Shifty')</label>

                                          <input type="number" name="shifty" class="form-control">
                                          
        
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('layout.Hourly')</label>
                                <input type="number" name="hourly" class="form-control">
                            </div>
                        </div>

                    </div>
                </div>
            </div>


            <div class="col-md-7">
                <div class="form-group last">
                    <label>@lang('layout.CompanyInformation')
                    </label>

                    <textarea name="description" class="form-control" id="summernote_1"></textarea>


                </div>
            </div>
            <div class="col-md-5">
                <div v-for="(social,index) in socials">


                    <div class="form-group">
                        <div class="col-md-5">
                            <label :for="'socialName'+index"> @lang('layout.SocialName')</label>
                            <input type="text" name="socialName[]" class="form-control" v-model="social.socialName"
                                   placeholder="@lang('layout.SocialName')" :id="'socialName'+index">
                        </div>

                        <div class="col-md-5">
                            <label :for="'socialUrl'">@lang('layout.SocialUrl')</label>
                            <input type="text" name="socialUrl[]" class="form-control" v-model="social.socialUrl"
                                   placeholder="@lang('layout.SocialUrl')">
                        </div>

                        <div class="col-md-2">
                            <a href="javascript:;" class="btn btn-circle btn-icon-only green" @click="addrow"><i
                                        class="fa fa-plus"></i></a>
                            <a href="javascript:;" class="btn btn-circle btn-icon-only red "
                               @click="removerow(index,1)"><i class="fa fa-minus"></i></a>
                        </div>
                    </div>

                </div>
            </div>

            <div class="form-actions">
                <div class="row">
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-md-offset-6 col-md-6">

                                <button type="button" onclick="regForm(this)"
                                        class="btn green">@lang('layout.Submit')</button>

                                <a href="{{route('group.company.list')}}" class="btn default"><i
                                            class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-6"></div>
                </div>
            </div>
        </div>

    </div>
    {{Form::close()}}

@endsection
@push('scripts')
    <script>
        let tags = {!! json_encode($tags) !!}
        new Vue({
            el: '#app',
            data: {
                socials: [],
                type: null,
                tags: tags,
                selectedTag:null

            },
            created() {
                this.socials.push({
                    socialName: null,
                    socialUrl: null
                });

            },
            methods: {
                addrow() {
                    // console.log('test',this.socials);
                    this.socials.push({socialName: null, socialUrl: null});
                },
                removerow(index, id) {
                    if (this.socials.length > 1)
                        this.socials.splice(index, 1)
                }
            }

        });


    </script>
    <script src="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/jquery.sparkline.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/app.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/profile.min.js')}}" type="text/javascript"></script>

    <script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js') }}"
            type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js') }}"
            type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-markdown/lib/markdown.js') }}"
            type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-markdown/js/bootstrap-markdown.js') }}"
            type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.min.js') }}"
            type="text/javascript"></script>
    <script src="{{ url('/assets/pages/scripts/components-editors.js') }}" type="text/javascript"></script>
@endpush

