@extends('layouts.app')
@section('style')

    <style type="text/css">
        .modal-container{
            width: 30%;
        } 
    </style>
@stop
@section('content')
@include('itemAssemblies.modal')


<!-- END PAGE HEADER-->
@if (Session('message'))

    <div class="m-heading-1 border-green m-bordered success-action">

        
        <ul class="success-body">

            <li>{{ Session('message') }}</li>

        </ul>

    </div>

@endif
@if (Session('error'))

    <div class="m-heading-1 border-red m-bordered errors-action">

        <h4 class="error-title"><strong>Whoops!</strong> </h4>
        <ul class="error-body">

            <li>{{ Session('error') }}</li>

        </ul>

    </div>

@endif

@if (count($errors) > 0)

    <div class="m-heading-1 border-red m-bordered errors-action">

        <h4 class="error-title"><strong>Whoops!</strong>  There were some problems with your input</h4>
        <ul class="error-body">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>

    </div>

@endif

<!-- BEGIN TAB PORTLET-->
  <div id="app" v-cloak>
        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
         <input type="hidden" name="type" value="itemAssemblyReport"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false" >
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectProject') </label>
                            <v-select class="vue-select2" v-model="selectedProject" label="name"
                                      :options="project">
                            </v-select>
                            <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.id">
                     
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control" id="range-from-example" autocomplete="off" name="from_date">
                                   
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control" id="range-to-example" autocomplete="off" name="to_date">
                                   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- app -->
    <div id="app2" v-cloak>
       {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="itemAssemblyReport"/>
        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false" >
            <div slot="body">
                <div class="row">
                    <div class="form-group">

                        <div  class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectProject') </label>
                            <v-select class="vue-select2" v-model="selectedProject" label="name"
                                      :options="project">
                            </v-select>
                            <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.id">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control" id="range-from-example2" autocomplete="off" name="from_date">
                                   
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control" id="range-to-example2" autocomplete="off" name="to_date">
                                 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase"> @lang('layout.AssemblyItemList') </span>
            </div>
            <div class="tools"></div> 
                <div class="pull-right">
                    @permission('assembly-export')
                        
                        <button type="submit" id="excell_all"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        
                        
                        <button type="submit" class="btn btn-success" id="print_pdf_all"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                       
                    @endpermission
                    @permission('assembly-create')
                        <a href="{{route('itemAssembly.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button></a>
                    @endpermission
                </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="dailyExpenses">
                <thead>
                <tr>
                        <th>@lang('layout.ProjectName')</th>
                        <th>@lang('layout.Code')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Actions')</th>
                </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>


<!-- END TAB PORTLET-->

<!-- END CONTENT BODY -->


@endsection
 
@push('scripts')
<script>
    $(document).ready(function () {
        $('#dailyExpenses').DataTable({
            ajax: '{{route("itemAssembly.index")}}',
            pageLength:'{{getPageRows()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,

            columns: [
                {data: 'name', name: 'project.name'},
                {data: 'code', name: 'code'},
                {data: 'description', name: 'description'},
                {data: 'date', name: 'date',},
                {data: 'actions', name: 'account',orderable:false,searchable:false},
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },


            ]

        });
    });
    Vue.component('v-select', VueSelect.VueSelect)
     var Modal=Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });

    new Vue({
        el: '#app',
        data: {
            showModal: false,
            selectedProject:null,
            project:null,
        
        },
        methods:{
            ok:function(){
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample : function(){
                this.project={!! $project !!}

                    //Your other code that launches the modal
                    this.showModal= true;
                this.$nextTick(function(){
                    $(document).ready(function(){
                        var to, from;
                        to = $("#range-to-example").persianDatepicker(modelDate());
                        from = $("#range-from-example").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    $('#print_pdf_all').on('click',function(e){
        $('#show-modal').click();
        e.preventDefault();
    })


    new Vue({
        el: '#app2',
        data: {
            showModal: false,
            selectedProject:null,
            project:null,
           
        },
        methods:{
            ok:function(){
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample2 : function(){
                this.project={!! $project !!}

                    //Your other code that launches the modal
                    this.showModal= true;
                this.$nextTick(function(){
                    $(document).ready(function(){
                        var to, from;
                        to = $("#range-to-example2").persianDatepicker(modelDate());
                        from = $("#range-from-example2").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    $('#excell_all').on('click',function(e){
        $('#show-modal2').click();
        e.preventDefault();
    })
</script>


@endpush
