@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'GiftList'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>

                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example"
                                           autocomplete="off" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example"
                                           autocomplete="off" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">  @lang('layout.GiftList')  </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
	  
      	  <span id="anchore-modal">
             <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                <i class="fa fa-print"></i>
             </a>
         </span>

                    @permission('gift-list')
                    <a href="{{route('gift.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="customer_rate">
                    <thead>
                    <tr>
                        {{--<th>#</th>--}}
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.Measure')</th>
                        <th>@lang('layout.Quantities')</th>
                        <th>@lang('layout.Percentage')</th>
                        <th>@lang('layout.CustomerClass')</th>
                        <th>@lang('layout.FromDate')</th>
                        <th>@lang('layout.ToDate')</th>
                        <th>@lang('layout.Duration')</th>
                        <th>@lang('layout.ItemName')</th>
                        <th>@lang('layout.Measure')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#customer_rate').DataTable({
                ajax: '{{route("gift.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:6}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                  /*  {data: 'id', name: 'gifts.id'},*/
                    {data: 'member', name: 'members.name'},
                    {data: 'category_name', name: 'inventory_categories.name'},
                    {data: 'measure_name', name: 'measure_units.name'},
                    {data: 'qty', name: 'qty'},
                    {data: 'gift_qty', name: 'gift_qty'},
                    {data: 'customer_type', name: 'customer_type'},
                    {data: 'start_date', name: 'start_date'},
                    {data: 'end_date', name: 'end_date'},
                    {data: 'mounth', name: 'mounth'},
                    {data: 'item_name', name: 'items.name'},
                    {data: 'gift_unit', name: 'gift_unit', searchable: false},
                    {data: 'status', name: 'status'},
                    {data: 'description', name: 'description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        });


        // for new modal

        Vue.component('v-select', VueSelect.VueSelect)

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

                selectedMember: null,
                memberlist: [],

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // /for new modal

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>
@endpush
