@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>

  .modal-container{
            width: 50%;
        }

</style>

@stop
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")
<div class="row"> 
    <div class="portlet light bordered">
          <!-- BEGIN TAB PORTLET-->
          <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.AddNewGiftCustomer')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="appInvoice" class="portlet-body">
        
                    <div class="tabbable tabbable-tabdrop">
          
                     
                        <div>
                          {{Form::open(['route' => 'gift.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
                           {{ csrf_field() }}
                           <div class="tab-content">

                               <div class="tab-pane active" id="tab1">
                                 
                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                  <!-- begin sale order modal -->
                  <div id="salOrderApp" v-cloak>
                    <!-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}} -->
                    <input type="hidden" name="type" value="invoicelist"/>
                    <!-- use the modal component, pass in the prop -->
                  
                    <!-- {{Form::close()}} -->
                  </div>
                <!-- end sale order modal -->

                <!-- BEGIN FORM-->
           
                    <div class="form-body">
                      <div class="row">
                          <!-- begin inputs -->
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
                                    <label class="control-label">@lang('layout.Customer')</label>
                                      
                                       <v-select  label="name" :options="customer" v-model="selected_customer"></v-select>
                                       <input type="hidden" name="customer_id" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
										<span class="required">@{{ errors.first('customer_id') }}</span>
							</div> 
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
									<label class="control-label">@lang('layout.Category'):</label>
									<v-select placeholder="@lang('layout.SelectCategory')" label="name" tabindex='4'  :options="categories" v-model="category" ></v-select>
									<input type="hidden" name="inventory_category_id" v-validate="'required'" data-vv-as="@lang('layout.Category')" :value="(category)?category.id:null">
									<span class="required">@{{ errors.first('inventory_category_id') }}</span>
                              </div> 
                            </div>
							
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                               <div class="form-group">
                                   <label class="control-label">@lang('layout.U_M_Set')</label>
                                   <v-select placeholder="@lang('layout.SelectUnitMeasure') " tabindex="3" label="name"  :options="measureList" v-model="measureSelected" ></v-select>
                                   <input type="hidden" name="categ_um_id" v-validate="'required'" data-vv-as="@lang('layout.U_M_Set')" :value="(measureSelected)?measureSelected.id:null">
									<span class="required">@{{ errors.first('categ_um_id') }}</span>
							   </div>
                           </div>
							<div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
							<div class="form-group">
								<label class="control-label">@lang('layout.Quantities'):</label>
								{{Form::number('qty',null,['class' => 'form-control','tabindex' =>'2',
								'placeholder' => __('layout.Quantities'),'v-validate' =>'"required"','data-vv-as' => __('layout.Quantities')])}}
								<span class="required">@{{ errors.first('qty') }}</span>
							</div>
							
						  </div>
							
						<div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
							<div class="form-group">
								<label class="control-label">@lang('layout.Percentage'):</label>
								<div class="input-group">
								{{Form::number('gift_qty',null,['class' => 'form-control','tabindex' =>'2',
								'placeholder' => __('layout.Percentage'),'v-validate' =>'"required"','data-vv-as' => __('layout.Percentage')])}}
								<span class="input-group-addon">
									%
								</span>
							</div>
								<span class="required">@{{ errors.first('gift_qty') }}</span>
							</div>
							
						  </div>
						
                      </div>
					  <div class="row">
								<div class="col-md-3">
					   
								   <div class="form-group">
									  <label class="control-label">@lang('layout.CustomerClass')</label>
										<select class="form-control" v-model="customer_type" style="border: 1px solid #c2cad8 !important;" name="customer_type">
											<option selected="selected" value="WithDate">@lang('layout.WithDate')</option>
											<option value="WithOutDate">@lang('layout.WithOutDate')</option>
										</select>
								  </div>
							  </div>
							
							  <div class="col-md-3">
								<div class="form-group">
									<label class="control-label">@lang('layout.FromDate')</label>
									
										<input type="text" id="start_date" name="start_date" v-validate="'required'" data-vv-as="@lang('layout.FromDate')" class="form-control date" autocomplete="off">
										<span class="required">@{{ errors.first('start_date') }}</span>
								</div>
							</div>
							  <div v-if="customer_type == 'WithDate'" class="col-md-3">
								<div class="form-group">
									<label class="control-label">@lang('layout.ToDate')</label>
										<input type="text" id="end_date" name="end_date"  v-validate="'required'" data-vv-as="@lang('layout.ToDate')"  class="form-control date" autocomplete="off">
										<span class="required">@{{ errors.first('end_date') }}</span>
								</div>
							</div>
							<div v-if="customer_type == 'WithOutDate'" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
							<div class="form-group">
								<label class="control-label">@lang('layout.Duration'):</label>
								{{Form::number('mounth',null,['class' => 'form-control','tabindex' =>'2',
								'placeholder' => __('layout.Duration')])}}
								
							</div>
							
						  </div>
                      </div>
					  
					  <div class="row">
					  <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
							<div class="form-group">
                                <label class="control-label">@lang('layout.Description')</label>
                                {{Form::textarea('description',null,['class' => 'form-control','rows' => '2','placeholder' => __('layout.Description')])}}
                            </div>
							
						  </div>
                      </div>

                     <div class="row" v-if="inventories.length>0" >
                         <table id="table_content" class="table table-bordered table-advance">
                          <thead>
                              <tr>
                                  <!--th>#</th -->
                                  <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                  <th style="min-width: 100px">@lang('layout.Measure') </th>
                                  <!--th style="min-width: 100px">@lang('layout.NewPrice') </th>
                                  <th></th -->
                              </tr>
                          </thead>
                          <tbody>
                              <tr v-for="(item,index) in inventories">
                                  <!--td>@{{index+1}}</td-->
                                  <td class="highlight">
								  <!-- @click.native="addNew('inventory',index)" -->
                                      <v-select  label="name" v-model="item.item" :options="temp_items"  @search="onItemSearch"></v-select>
                                      <input type="hidden" name="item_id" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
										                  <span class="required">@{{ errors.first('item_id') }}</span>
                                  </td>
                                  <td class="highlight">
                                      <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                          <option value="null">@lang('layout.Select')</option>
                                          <span v-if="(item.item ==null)?false:true">
                                              <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>
                                          
                                         
                                      </select>
                                     
                                      <input type="hidden" name="gift_um_id" :value="(item.item==null)?null:item.item.measure.measure_id">
                                  </td>
                                  <!--td>
                                    <div class="input-group">
                                      <input type="number" name="inventory_price[]"  placeholder="@lang('layout.NewPrice')"   v-bind:value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate)" ref='in'  @input="setNewRate('inventory',index)" class="form-control">
                                      <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>
                                     
                                  </td>
                                  <td>
                                       <span v-if="index >= 0"  v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                  </td -->
                              </tr>
							   <!--tr style="background-color: #ffffff;">
								<td></td>
								<td><center>
									<button type="button" @click="addNew('inventory',100)" class="btn btn-success" ><i class="fa fa-plus"></i></button>
								</center></td>
								<td></td>
								<td></td>
								<td></td>
                              </tr -->
                          </tbody>
                      </table>

                     </div>
                                        
                                   
                     
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" @click="handleSubmit($event)"  class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('inventorySite.index')}}"   class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                    </div>  
            </div>


                               </div>



                             

 {!! Form::close() !!}

                           </div>
                          
                        </div>


                        </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
          </div>
          <!-- END TAB PORTLET-->
    </div>
</div> 

@endsection
@push('scripts')


<script type="text/javascript">
 
            @if(App::getLocale())
            Vue.use(VeeValidate, {
                locale: '{{App::getLocale()}}',
            });
            @else
            Vue.use(VeeValidate, {
                locale: 'en',
            });
            @endif



 Vue.component('v-select', VueSelect.VueSelect);

  Vue.component("modal",{
    template:"#modal-template",
    props:['show'],

  });

  //begin new member
  Vue.component("cmodal",{
    template:'#cmodal-template',

    props: ['show'],
    data(){
        return {
            types: [],
            classes:[],
            receivables: [],
            payables: [],
            code: null,
            selectType: null,
            selectPay: null,
            selectedClass: null,
            selectReceive: null,
        }
    },
  });

// end new member
  var customer={!! $member !!};
  var v = new Vue({
    el: '#appInvoice',
    data: {
	   categories:{!! json_encode($category) !!},
       category:null,
	   measureList:{!! json_encode($measure) !!},
       measureSelected:null,
	   
       customer_type:'WithDate',
       showModal: false,
       invoiceDescription: null,
       saleOrderList:[],
       selected_sale_order:null,
       setDatas: [],
       customer:customer,
       selected_customer:null,
       selected_banks:null,
       selected_currency:defaultCurrency(),
       rate:0,
       discountFiled: 0,
       discountIsAmount:false,
       temp_items:[],
       totalAmountes: [],
       types: null,
       newCost:[
       null,
       null,
       null,
       null],
       inventories:[
          {item:null}
       ],
       
    },
    methods:
    {
         // set new price
       setNewRate(type=null,index=null)
       {
          if(type=='inventory')
          { 
              if(this.inventories[index].item)
              {

                 this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
              }
          }
          if(type=='service')
          {
              if(this.services[index].item)
              {
                 console.log('service changed');
                 this.services[index].item.new_rate = this.$refs.ser[index].value/this.selected_currency.rate;
              }
          }
       },
        // detect member change and searh
      

    handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
            // alert(e.target);
                        v.submitForm(e.target);
                    }
                });
            },
             // generic function for adding item to list
       addNew(type=null,index)
       {
          this.temp_items=[];
          if(type !=null)
          {
             if(type=='inventory')
             {
                if(this.inventories[index+1]==undefined)
                {
                  this.temp_items=[];
                  this.inventories.push({item:null});
                }
             }
            if(type=='service')
             {
                if(this.services[index+1]==undefined)
                {
                  this.checkExistingService(index,'');
                  this.services.push({
                    items: this.all_services,
                    item: null,
                });
                }
             }
             if(type=='payment')
             {
                if(this.payments[index+1]==undefined)
                {
                  this.checkExistingPayment(index,'');
                  this.payments.push({
                    items: this.banks,
                    item: null,
                });
                }
             }
          }
          
       },
             // submit the form
       submitForm() 
       {

          if(this.isError==true) {
            alert('there is no item');
            return false;
          }
          swal({
                title:"@lang('layout.AreYouSure?')",
                buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
                text: "",
                icon: "info",
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete)
                {
                    document.getElementById("sales-form").submit()

                }
                else
                {

                }
            });

        },
       //ajax call to get items
        onItemSearch:_.debounce((search,loading)=>{
           loading(true);
           axios.get("{{route('callMethod.search')}}",
           {

            params:{
              method_name:'itemSearchSale',
              keyword:search,
            },
           })
           .then(function (response)
           {
             v.temp_items=[];
             if(response.data.length>0)
             {
                v.temp_items=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
         
       },getDebounceTime()),


    },
    

  });

</script>



@endpush