@extends('layouts.app')
@section('style')
	
        <!-- BEGIN PAGE LEVEL STYLES -->
        <link href="{{url('assets/pages/css/search.css')}}" rel="stylesheet" type="text/css" />
		<!-- END PAGE LEVEL STYLES -->
		
@endsection

@section('content')

<div class="row" id="app">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
				<i class="icon-magnifier" style="color:green;font-size:40px"></i>
				&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.GeneralSearch')</span>
			</div>
			
			<div class="pull-right">

				
			</div>

			
											

		</div>
		<div class="portlet-body">
			<div class="search-page search-content-4" >
			    <div class="search-bar bordered">
			        <div class="row">
			            <div class="col-lg-10 col-md-10 col-sm-12">
			                <search></search>
			            </div>
			         
			        </div>
			    </div>
			</div>
		</div>
	</div>
</div>
@endsection
@push('scripts')

 
	<script>
		Vue.component('search',{
			template:`
			
			<div class="row">
			
			<div class="col-lg-4  col-md-4  col-sm-12">
				<select v-model="part" v-on:keyup="autoComplete" class="form-control " @input="changePart">
				    <option value="">@lang('layout.SelectPart')</option> 
					@if(\Entrust::can('customers-list'))
	                <option value="members"><span class="input-group-addon">@lang('layout.Members')</span></option> 
					@endif
					@if(systemConfig()[23] == 1)
					@if(\Entrust::can('invoice-list'))
	                <option value="invoices"><span class="input-group-addon">@lang('layout.Invoice')</span></option>
					@endif
					@if(systemConfig()[4] != 0 && \Entrust::can('invoiceRoll-list'))
					<option value="invoice_roll"><span class="input-group-addon">@lang('menu.InvoiceRoll')</span></option>
                    @endif
					@if(\Entrust::can('sales-list'))
	                <option value="salesReceipt"><span class="input-group-addon">@lang('menu.SaleReceipt')</span></option>
					@endif
					@if(\Entrust::can('bill-list'))
	                <option value="bills"><span class="input-group-addon">@lang('menu.EnterBills')</span></option>
					@endif
					@if(systemConfig()[4] != 0 && \Entrust::can('billRoll-list'))
	                <option value="bill_roll"><span class="input-group-addon">@lang('menu.EnterBillsRoll')</span></option>
					@endif
					@if(\Entrust::can('purchase-list'))
	                <option value="purchase"><span class="input-group-addon">@lang('menu.WriteChecks')</span></option>
					@endif
					@if(\Entrust::can('inventory-list'))
	                <option value="items"><span class="input-group-addon">@lang('layout.Items')</span></option>
					@endif
					@endif
					@if(\Entrust::can('account-list'))
	                <option value="accounts"><span class="input-group-addon">@lang('menu.Account')</span></option>
					@endif
					@if(\Entrust::can('contract-list'))
	                <option value="contracts"><span class="input-group-addon">@lang('menu.Contract')</span></option>
					@endif

	            </select>
			</div>
			<div class="input-group col-lg-8  col-md-8  col-sm-12 input-icon ">
						<i class="icon-magnifier" style="color:green"></i>
	                    
	                    <input type="text" class="form-control "  placeholder="{{__('layout.SearchFor')}}" v-model="searchquery" v-on:keyup="autoComplete">
						
						<div v-if="isLoading">
							<div class="table-scrollable">
								<table class="table">
									<tr>
										<td colspan="3" style="text-align: center">
											<img src="{{asset('ltr/assets/layouts/layout/img/load8.gif')}}" style="width: 80px"/>
										</td>

									</tr>
								</table>
							</div>
						</div>

                	    <div  v-if="data_results.length">
					        <table class="table table-bordered table-hover">
					            <thead class="bg-blue">
					                <tr>
					                    <th style="text-align:center">
					                    	<i class="fa fa-list-ol"></i>
					                    </th>
					                    <th style="text-align:center">
					                    	<i ></i>
					                        {{__('layout.ReferenceNumber')}}
					                    </th>
					                    <th style="text-align:center">
					                    	<i ></i>
					                        {{__('layout.Name')}}
					                    </th>
					                    <th style="text-align:center">
					                    	<i ></i>
					                        {{__('layout.Description')}}
					                    </th> 
					              		<th style="text-align:center">
					                        {{__('layout.Show')}}
					                    </th>
					                   
					                   
					                </tr>
					            </thead>
					            <tbody>
					            
					                <tr v-if="data_results.length>0" v-for="result in data_results"  v-if="result.type!='Shareholder'" >
					                   
					                    <td>
					                        <p style="text-align:center;">@{{result.number}}</p>
					                    </td>
					                    <td>
					                        <p style="text-align:center;">@{{result.ref_no}}</p>
					                    </td>
					                    <td>
					                        <p style="text-align:center;">@{{result.name}}</p>
					                    </td>
					                    <td>
					                        <p style="text-align:center;">@{{result.description}}</p>
					                    </td>
					                    

					                    <td style="text-align:center">
						                    <a @click="getUrl(result.part,result.id,result)" >
						                        <i  class = "fa fa-info-circle"></i>
						                    </a>
					                    </td>
					                    
					                </tr>
					            </tbody>
					        </table>
					    </div>              	    

					    <div  v-if="no_data && !data_results.length">
					        <table class="table table-bordered ">
					            <thead class="">
					                <tr>
					                    <th>
					                    	 <p style="color:red;text-align:center;font-size:16px;">@{{no_data}}</p>
					                    </th>
					                </tr>
					            </thead>
					        </table>
					    </div>

						<p v-if="search_result">{{__('layout.SearchResult')}}: (@{{result_count}})</p>
	                </div>
	                </div>`, 

	                
	        data: function(){
	        	return {
	        		searchquery: '',
	        		part: '',
	        		data_results: [],
	        		no_data:null,
					result_count:0,
					isLoading:false,
					search_result:false
	        	}
	        },
	        methods: {
	        	autoComplete(){
	        		this.data_results = [];
					this.isLoading = true;

	        		if(this.searchquery.length && this.part){
	        			axios.get('{{route("generalSearch.search")}}',
	        				{params:{
	        					searchquery:this.searchquery,
	        					part:this.part
	        				}})

	        			.then(response=>{
	        				if (response.data.length>0) {
	        					this.data_results = response.data;
								this.result_count = response.data.length;
								this.isLoading = false;
								this.search_result = true;
	        				}
	        				else{
	        					this.no_data = "@lang('message.NoDataFound')";
								this.result_count = 0;
								this.isLoading = false;
								this.search_result = false;
	        				}
	        				
	        			
	        			});
	        		}
					else
					{
						this.result_count = 0;
						this.isLoading = false;
						this.search_result = false;
					}
	        	},
	        	getUrl(part,id,data)
	        	{
					if (part == 'Inventory') {
						if (data.m_type == 'material') {
	        				window.location.href   ="{{url('/')}}"+'/inventory/m_show/'+id;
						}else{
	        				window.location.href   ="{{url('/')}}"+'/'+part.toLowerCase()+'/'+id;
						}	
					}else{
	        			window.location.href   ="{{url('/')}}"+'/'+part.toLowerCase()+'/'+id;
					}
	        	},
				changePart(){
					// this.data_results =  [];
					this.searchquery  =  '';
				}
	        },
		})

		const app = new Vue({
			el: "#app"
		});
	</script>
@endpush

    