@extends('layouts.app')
@section('content')
    @include('receives.modal')
    <!-- BEGIN CONTENT -->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'gasStationCounter'" @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12 col-xs-12">
                            <label class="control-label">@lang('layout.PumpNumber') </label>
                            <v-select label="name" :options="oilpart" v-model="selected_oil_part"></v-select>
                            <input type="hidden" name="oil_par_id" v-bind:value="(!selected_oil_part)?null:selected_oil_part.id"/>
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="typeCounter" class="form-control">
                                <option value="oilPumpCountert">@lang('layout.Simple')</option>
                                <option value="GeneralSaleReportCounter">@lang('layout.Details')</option>
                            </select>
                        </div>


                        <div class="col-md-12" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
               
                </div>
            </div>
        </report-modal>
    </div>


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.GasStationCounterList')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
                    @permission('OilPartCounter-export')
                        <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                        </span>
                    @endpermission

                    @permission('OilPartCounter-create')
                    <a href="{{route('oilPartCounter.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="gas_station_counter">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Counter')</th>
                            <th>@lang('layout.PumpNumber')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Action')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
@stop
@include('print.modal')
@include('groupCompanyFilter.select')

@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#gas_station_counter').DataTable({
                ajax:'{{route("oilPartCounter.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [ 
                    {data: 'gas_number', name: 'gas_number'},
                    {data: 'counter', name: 'gas_station_counter.counter'},
                    {data: 'oil_number', name: 'oil_number'},
                    {data: 'date', name: 'gas_station_counter.date', orderable: false, searchable: false},
                    {data: 'description', name: 'gas_station_counter.description'},
                    {data: 'actions', name: 'actions', orderable:false, searchable:false},
                    // {data: 'driver_name', name: 'weighbridges.driver_name'},
                    // {data: 'item_name', name: 'item_name', orderable: false, searchable: false},
                    // {data: 'measure_name', name: 'measure_name', orderable: false, searchable: false}
                ]
            }); 

            
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

        Vue.component("v-select", VueSelect.VueSelect);
        var oilPart = {!! $oilPart !!};

        var vm = new Vue({

            el: '#print-modal',
            data: {
                oilpart: oilPart,
                selected_oil_part: null,
                is_show: false,
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}'
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
    </script>


@endpush
