@extends('layouts.factor-master')

@section('content')

	<h4 class="table-caption" style="text-align: center;">@lang('layout.GasStationCounterReport')</h4>
  @if($from_date || $to_date)
  <table class="main-table">
    <tr>
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
            </td>
        @endif
    </tr>
  </table>
  <br>
  @endif

<?php 
$counter = 0;
?>

<table class="main-table">
    <thead>
    <tr class="bg">
        <td class="center" >
            <div>@lang('layout.Record')  </div>
        </td>
        <td class="center" >
            <div> @lang('layout.Date')</div>
        </td>
        <td class="center" >
            <div> @lang('layout.ItemName')</div>
        </td>
        <td class="center" >
            <div> @lang('layout.PumpNumber')</div>
        </td>
        <td class="center" >
            <div> @lang('layout.Counter')</div>
        </td>
        <td class="center" >
            <div> @lang('layout.ChangeQuantity')</div>
        </td>
        <td class="center" >
            <div> @lang('layout.SaleQty')</div>
        </td>
        <td class="center" >
            <div> @lang('layout.Differ')</div>
        </td>
        <td class="center" >
            <div> @lang('layout.Unit')</div>
        </td>
    </tr>
    </thead>

    <?php
    $count = 0;
    $current_counter = 0;
    $quantityOut = 0;
    $differ = 0;
    $currencies = [];
    ?>
    @foreach($data AS $record)
    <tr>
      <?php
      $current_counter += $record->current_counter;
      $quantityOut += $record->quantityOut;
      $differ += ($record->quantityOut - $record->current_counter);
      
      ?>

      <td class="center">{{++$count}}</td>
      <td class="center">{{convertDate($record->Date)}}</td>
      <td class="center">{{$record->item_name}}</td>
      <td class="center">{{$record->oil_part_number}}</td>
      <td class="center">{{$record->counter}}</td>
      <td class="center">{{$record->current_counter}}</td>
      <td class="center">{{$record->quantityOut}}</td>
      <td class="center">{{myRound($record->quantityOut - $record->current_counter)}}</td>
      <td class="center">{{$record->um}}</td>
      
    </tr>
    @endforeach
    <tr class="bg">
        <td class="center" colspan="5">@lang('layout.Total')</td>
        <td class="center">{{myRound($current_counter)}}</td>
        <td class="center">{{myRound($quantityOut)}}</td>
        <td class="center">{{myRound($differ)}}</td>
        <td class="center"></td>
        
    </tr>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection