@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.OilPumpCreate')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="oil_part">
            {!! Form::open(array('route' => 'oilPartCounter.store','method'=>'POST','class'=>'form-horizontal')) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="col-lg-3 col-xs-12">
                        <div class="form-group">
                                <label class="control-label col-md-4">@lang('layout.Number') </label>
                                <div class="col-md-8">
                                    <input type="integer" value="{{$number}}" name="number" class="form-control now" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-xs-12">
                        <div class="form-group">
                                <label class="control-label col-md-4">@lang('layout.PumpNumber') </label>
                                <div class="col-md-8">
                                <v-select label="name" :options="oilpart" v-model="selected_oil_part"></v-select>
                                <input type="hidden" name="oil_par_id" v-bind:value="(!selected_oil_part)?null:selected_oil_part.id"/>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-xs-12">
                        <div class="form-group">
                                <label class="control-label col-md-4">@lang('layout.Date') </label>
                                <div class="col-md-8">
                                    <input type="text" name="date" class="form-control date now" autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-xs-12">
                        <div class="form-group">
                                <label class="control-label col-md-4">@lang('layout.Counter') </label>
                                <div class="col-md-8">
                                    <input type="number" step="any" name="counter" class="form-control now" autocomplete="off">
                            </div>
                        </div>
                    </div>

                </div>
                

                <div class="row">
                   
                     <div class="col-md-6"> 
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Description'):</label>
                            <div class="col-md-9">
                                   {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 3, 'cols' => 60)) !!}
                            </div>
                        </div>
                        
                    </div>
                </div>

            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                <a href="{{route('oilPartCounter.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection

@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

Vue.component("v-select", VueSelect.VueSelect);
        var oilPart = {!! $oilPart !!};
        let vu = new Vue({
                el: '#oil_part',
                data: {
                    selected_oil_part: null,
                    oilpart: oilPart
                },
                methods: {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                regForm(e.target);
                            }
                        });
                    },
                }
            })
    </script>
@endpush
