@extends('layouts.factor-master')

@section('content')

	<h4 class="table-caption" style="text-align: center;">@lang('layout.GasStationCounterReport')</h4>
  @if($from_date || $to_date)
  <table class="main-table">
    <tr>
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
            </td>
        @endif
    </tr>
  </table>
  <br>
  @endif

<?php 
$counter = 0;
?>

<table class="main-table">
    <thead>
    <tr class="bg">
        <th>@lang('layout.Number')</th>
        <th>@lang('layout.Counter')</th>
        <th>@lang('layout.Category')</th>
        <th>@lang('layout.Date')</th>
        <th>@lang('layout.Description')</th>
    </tr>
    </thead>

    <?php
      $count = 0;
      $total_net_qty = 0;
      $total_sale_qty = 0;
      $total_differ_qty = 0;
    ?>
    <tbody>
    @foreach($data AS $record)
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record['counter']}}</td>
        <td class="center">{{$record['sale_number']}}</td>
        <td class="center">{{convertDate($record['date'])}}</td>
        <td class="center">{{$record['description']}}</td>
    </tr>
    @endforeach

  </tbody>
</table>



<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection