@extends('layouts.app')

@section('content')
    @include('bills.modal')
    @include('returns.modal')


    <!-- END PAGE HEADER-->

    <div id="ww" v-cloak>
        {{Form::open(['route' => 'return.findReturn','method' => 'POST','class' => 'inline'])}}
        <button id="show-modalww" style="display: none" type="button" @click="editExampleww">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.PurchaseNumber') </label>
                            <input type="number" name="number" class="form-control">
                            <input type="hidden" name="type" value="Bill">
                        </div>
                    </div>
                </div>

            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>



    <!-- new modal for print -->

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'builllist'"
                      @closed="closeModal">

            <div slot=body>
                <div class="row">
                    <div class="form-group">
						<div class="col-md-6">
                            <label class="control-label ">@lang('layout.MemberClass') </label>
                            <v-select class="vue-select2" v-model="selectedClass" label="name" @search="onClassSearch"
                                      :options="classlist">
                            </v-select>
                            <input type="hidden" name="class_id"
                                   v-model.number="(!selectedClass)?null:selectedClass.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name"
                                      :options="member">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.member_id">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- /new modal for print -->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Enterbill') </span>
                </div>
                <div class="tools"></div>
                <div class=" pull-right">
                    @permission('bill-export')

                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>
                    @endpermission
                    @permission('bill-export')
                    <a href="{{route('gBill.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="bill_table">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Vendor')</th>
                        <th>@lang('layout.Account') </th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions') </th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>


        function factorPrint(id) {

            var a = document.createElement('a');
            a.href = "{{url('billFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        let data_table;
        $(document).ready(function () {

           data_table =  $('#bill_table').DataTable({
                ajax: '{{route("bill.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:4}}", "{{getRowOrder()}}"]],
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'number', name: 'purchases.number'},
                    {data: 'ref_no', name: 'purchases.ref_no'},
                    {data: 'vendor', name: 'members.name'},
                    {data: 'account', name: 'accoutn', orderable: false, searchable: false},
                    {data: 'date', name: 'date'},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'currency', name: 'currency', orderable: false, searchable: false},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'username', name: 'username', orderable: false, searchable: false},
                    {data: 'description', name: 'purchases.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},

                ]

            });
        });
        Vue.component('v-select', VueSelect.VueSelect)

        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });
        // for new modal

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                member:{!!$member!!},
                classlist: [],
                selectedClass: null,


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
				
				onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                },
                
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.classlist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // /for new modal

        // Return Modal Vue
        new Vue({
            el: '#ww',
            data: {
                showModal: false
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExampleww: function () {

                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });

        $('#addNewReturnww').on('click', function (e) {
            $('#show-modalww').click();
            e.preventDefault();
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
    </script>


@endpush






