@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('content')
  <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Enterbill') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app" v-cloak>
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'gBill.store','method' => 'POST','class' => 'form-horizontal','id'=>'gas-purchase-form'])}}
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-9">

                            <div class="row">
                                <div v-show="showWhat('member_class')=='yes'"
                                     class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                            <label class="control-label">@lang('layout.MemberClass') </label>

                                            <v-select label="name" :options="memberClass"
                                                      v-model="selected_class"
                                                      @input="memberClassChange()"></v-select>
                                            <input type="hidden" name="class_id"
                                                   :value="!selected_class?null:selected_class.id">
                                    </div>
                                </div>
                            </div>

                            <!-- second row -->
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Vendor')</label>

                                            <v-select label="name" @input="memberChange()" :options="vendor"
                                                      v-model="selected_vendor"></v-select>
                                            <input type="hidden" name="vendor" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Vendor')"
                                                   :value="!selected_vendor?null:selected_vendor.id" required>
                                            <span class="required">@{{ errors.first('vendor') }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label col-md-12"><br></label>

                                            <button type="button" class="btn blue btn-block"
                                                    @click="showModalNewMember = true">@lang('layout.NewVendor')</button>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.BillNumber')</label>

                                            <input type="number" name="number" v-validate="'required|numeric'"
                                                   data-vv-as="@lang('layout.BillNumber')" v-model="number"
                                                   class="form-control">
                                            <span class="required">@{{ errors.first('number') }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>

                                            <input type="text" name="ref_no" v-model="ref_no" class="form-control"
                                                   @input="checkRefNo($event)">
                                            <span  class="input-has-error" id="ref_no_msg" style="color: red"></span>
                                        </div>
                                    </div>
                                </div>

                               
                            </div>
                            <!-- end second row -->

                            <!-- third row -->
                            <div class="row">
                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3' : 'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency') </label>


                                            <v-select label="code" @input="selectedRate" :options="currency"
                                                      v-model="selected_currency"></v-select>
                                            <input type="hidden" name="currency" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Currency')"
                                                   :value="selected_currency.code">
                                            <span class="required">@{{ errors.first('currency') }}</span>

                                        </div>
                                    </div>
                                </div>

                                <div class="{{ auth()->user()->company()->first()->tag != 1? 'col-lg-3 col-md-3' : 'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Rate')</label>

                                            <input type="number" name="currency_rate" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Rate')" 
                                                   v-model="!selected_currency?0:selected_currency.rate"
                                                   class="form-control" :class="{'has-error':rate<=0}">
                                            <span class="required">@{{ errors.first('currency_rate') }}</span>


                                        </div>
                                    </div>
                                </div>
                                @if(auth()->user()->company()->first()->tag != 1)
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <div class="form-group">

                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.ExchangeRateHQ')</label>

                                                <input type="number" name="currency_rate_hq" v-validate="'required'"
                                                       data-vv-as="@lang('layout.Rate')"
                                                       v-model="!selected_currency?0:selected_currency.hq_rate"
                                                       class="form-control" :class="{'has-error':rate<=0}">
                                                <span class="required">@{{ errors.first('currency_rate') }}</span>


                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3': 'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ContractName')</label>

                                            <v-select label="Contract_Name" @input="contractChange()"
                                                      :options="contract" v-model="selected_contract"></v-select>
                                            <input type="hidden" name="contract_id"
                                                   :value="(this.selected_contract==null)?null:selected_contract.id">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end third row -->

                           
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Discount')</label>

                                            <div class="input-group">

                                                <input v-model="discountFiled" class="form-control"
                                                       type="number" min="0">
                                                <span v-if="discountIsAmount"
                                                      @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">@{{selected_currency.symbol}}
                                                    <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                </span>
                                                   <span v-else @click="discountIsAmount = !discountIsAmount"
                                                          class="input-group-addon">%
                                                    <input type="hidden" name="discount_type" value="percent">
                                                  </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    

                                    <input type="text" name="date" class="form-control date" autocomplete="off">
                                    <span class="required">@{{errors.first('date')}}</span>
                                </div>

                                 <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.OverdueDate')</label>

                                            <input type="text" name="overdue_date" class="form-control date"
                                                   autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                
                            </div>

                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12"
                                     v-if="(this.selected_contract==null)?false:true">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.WagonNumber')</label>

                                            <input type="text" name="wagon_number" class="form-control"
                                                   placeholder="0011">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-8">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    

                                    <textarea name="description" class="form-control"></textarea>
                                    <span class="required">@{{errors.first('description')}}</span>
                                </div>

                            </div>

                        </div>
                        <!-- begin items -->

                        <div class="col-md-12" v-if="purchase_item">

                            <div class="col-md-12">
                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th v-show="showWhat('sale_category')=='yes'"
                                                style="min-width: 100px">@lang('layout.Category') </th>
                                            @if(getSerailNumber() =="true")
                                                <th style="min-width: 80px">@lang('layout.SerialNum') </th>
                                            @endif
                                            <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                            <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                            <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                            <th v-show="showWhat('expire_date')=='yes'"
                                                style="min-width: 100px">@lang('layout.ExpireDate') </th>
                                            <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                            <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                            <th v-show="showWhat('other_measure')=='yes'"
                                                style="min-width: 100px">@lang('layout.OMeasureValue') 1
                                            </th>
                                            <th v-show="showWhat('other_measure')=='yes'"
                                                style="min-width: 100px">@lang('layout.OMeasureValue') 2
                                            </th>

                                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                                            <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                            <th v-show="showWhat('sale_discount')=='yes'"
                                                style="min-width: 100px">@lang('layout.Discount') </th>
                                            <th style="min-width: 100px">@lang('layout.Total') </th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(item,index) in purchase_item">
                                            <td>@{{index+1}}</td>
                                            <td v-show="showWhat('sale_category')=='yes'" class="highlight">
                                                <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                                          @input="itemCategoryChange(index)"></v-select>
                                                <input type="hidden" name="inventory_category_id[]"
                                                       :value="(!item.item_category)?null:item.item_category.id">
                                            </td>
                                            @if(getSerailNumber() =="true")
                                                <td>
                                                    <input :value="(!item.item)?null:item.item.number"
                                                           class="form-control input-style input-number"
                                                           placeholder="@lang('layout.SerialNum')" disabled>
                                                </td>
                                            @endif
                                            <td class="highlight">
                                                <v-select label="name" @keyup.native="onItemload(index)"
                                                          @Click.native="onItemload(index)" v-model="item.inventory"
                                                          :options="temp_items" @search="onItemSearch"></v-select>
                                                <input type="hidden" :name="'inventory_id['+index+']'" v-validate="'required'"
                                                       data-vv-as="@lang('layout.ItemName')"
                                                       :value="(!item.item)?null:item.item.id">
                                                <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>

                                                <input type="hidden" name="purchase_order_detail_id[]"
                                                       :value="(!item.item)?null:item.item.purchase_order_detail_id">
                                                <input type="hidden" name="contract_detail_id[]"
                                                       :value="(!item.item)?null:item.item.contract_detail_id">

                                            </td>
                                            <td class="highlight">
                                                <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <span v-if="(item.item != null)">
                                                        <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                            @{{site.site_name}}
                                                        </option>
                                                    </span>
                                                </select>
                                                <input type="hidden" name="inventory_site[]"
                                                       :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                            </td>
                                            <td v-show="showWhat('sale_description')=='yes'">
                                                <input type="text" placeholder="@lang('layout.Description')"
                                                       name="inventory_description[]" class="form-control">
                                            </td>
                                            <td v-show="showWhat('expire_date')=='yes'">
                                                <date_picker :name="'expire_date['+index+']'" placeholder="@lang('layout.ExpireDate')" ></date_picker>
                                             </td>
                                            <td>
                                                <input type="number" :name="'quantity['+index+']'" v-validate="'required'"
                                                       data-vv-as="@lang('layout.Quantity')"
                                                       v-model.number="(item.item==null)?null:item.item.quantity"
                                                       class="form-control input-style input-number"
                                                       placeholder="@lang('layout.Quantity')">
                                                <span class="required">@{{ errors.first('quantity['+index+']') }}</span>

                                            </td>

                                            <td>
                                                @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                                            </td>
                                            <td v-show="showWhat('other_measure')=='yes'">
                                                <input type="number" name="other_measure_amount[]"
                                                       class="form-control input-style input-number"
                                                       placeholder="@lang('layout.OMeasureValue') 1">
                                            </td>
                                            <td v-show="showWhat('other_measure')=='yes'">
                                                <input type="number" name="other_measure_amount2[]"
                                                       class="form-control input-style input-number"
                                                       placeholder="@lang('layout.OMeasureValue') 2">
                                            </td>
                                            <td class="highlight">
                                                <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                                        @change="measureChange(index)">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <span v-if="(item.item ==null)?false:true">
                                                      <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                        @{{measure.measure_name}}
                                                      </option>
                                                    </span>


                                                </select>

                                                <input type="hidden" name="measure[]"
                                                       :value="(item.item==null)?null:item.item.measure.measure_id">
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                                           :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate)"
                                                           ref="in" @input="setNewRate(index)" class="form-control">
                                                    <span class="input-group-addon">
                                                      @{{selected_currency.symbol}}
                                                    </span>
                                                </div>

                                            </td>
                                            <td v-show="showWhat('sale_discount')=='yes'">
                                                <div class="input-group">
                                                    <input type="number" name="inventory_discount[]"
                                                           placeholder="@lang('layout.Discount')"
                                                           v-model.number="(item.item==null)?null:item.item.discount"
                                                           class="form-control">
                                                    <span class="input-group-addon" v-if="discountIsAmount">
                                                      @{{selected_currency.symbol}}
                                                    </span>
                                                    <span class="input-group-addon" v-if="!discountIsAmount">
                                                     %
                                                    </span>
                                                </div>

                                            </td>
                                            <td>
                                                @{{ (item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate).result }}
                                                <b>@{{selected_currency.symbol}}</b>
                                            </td>
                                            <td>
                                                <span v-if="index > 0" v-on:click="deleteItem('inventory',index)"><i
                                                            class="paddint-both glyphicon glyphicon-trash"></i></span>
                                            </td>
                                        </tr>
                                        
                                    </tbody>
                                </table>
                                <button type="button" @click="addNew('inventory')" class="btn btn-success"><i class="fa fa-plus"></i></button>

                                <hr>
                                <!-- begin payments -->
                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                    <thead>
                                    <tr>
                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                        <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                        <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                        <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                        <th></th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(payment,index) in payments">
                                        <td>@{{index+1}}</td>
                                        <td class="highlight">
                                            <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                                      @click.native="addNew('payment',index)"
                                                      @input="checkExistingPayment(index)">

                                            </v-select>
                                            <input type="hidden" name="payment_id[]"
                                                   :value="(payment.item==null)?null:payment.item.id">
                                        </td>

                                        <td>
                                            <span v-if="payment.item !=null">
                                             @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                           </span>
                                        </td>
                                        <td>
                                            <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                                   type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                                   class="form-control"
                                                   placeholder="@lang('layout.Rate')" required/>
                                            <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                                   v-bind:value="payment.item.rate">
                                            <input v-if="payment.item !=null" type="hidden" name="payment_rate_hq[]"
                                                   v-bind:value="payment.item.hq_rate">
                                        </td>
                                        <td>
                                            <input type="text" name="payment_currency[]" class="form-control"
                                                   v-model="(payment.item==null)?null:payment.item.code"
                                                   placeholder="@lang('layout.Currency')" required disabled/>

                                            <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                                   v-bind:value="payment.item.code"/>
                                        </td>
                                        <td>
                                            <div class="input-group">
                                                <input type="number" class="form-control"
                                                       v-model.number="(payment.item==null)?null:payment.item.amount "
                                                       placeholder="@lang('layout.PayAmount')" required/>

                                                <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                                       v-bind:value="payment.item.amount">

                                                <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                            </div>
                                        </td>
                                        <td>
                                            @{{ (payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate).result }}
                                            <b>@{{selected_currency.symbol}}</b>
                                        </td>
                                        <td>
                                            <span v-on:click="deleteItem('payment',index)"><i
                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                                <button type="button" @click="addNew('payment')" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                <!-- end payments -->


                                <!-- begin transporter -->
                                @if(systemConfig()[7] != 0)
                        
                                <div class="row"  style="overflow-x: scroll;">
                                    <table v-if="driveres.length>0" id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th style="min-width: 100px">@lang('layout.Transporter_name') </th>
                                            <th style="min-width: 100px">@lang('layout.PlateNumber') </th>
                                            <th style="min-width: 100px">@lang('layout.TransitNumber') </th>
                                            <th style="min-width: 100px">@lang('layout.TankerNumber') </th>
                                            <th style="min-width: 100px">@lang('layout.WayBillNumber') </th>
                                            <th style="min-width: 100px">@lang('layout.SourcePlace') </th>
                                            <th style="min-width: 100px">@lang('layout.Destination') </th>
                                            <th style="min-width: 100px">@lang('layout.LoadingDate') </th>
                                            <th style="min-width: 100px">@lang('layout.ItemName') </th>
                                            <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                            <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                                            <th style="min-width: 100px">@lang('layout.Amount') </th>
                                            <th style="min-width: 100px">@lang('layout.Currency') </th>
                                            <th style="min-width: 100px">@lang('layout.Rate') </th>
                                            <th></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr v-for="(item,index) in driveres">
                                            <td>@{{index+1}}</td>
                                            
                                            <td>
                                                <v-select label="name" v-model="item.driver" @Click.native="addNew('driver',index)"
                                                          :options="driver"></v-select>
                                                <input type="hidden" name="driver_id[]"
                                                       :value="(!item.driver)?null:item.driver.id">
                                            </td>
                                            <td>
                                                <input type="text" name="plate_number[]"
                                                       v-model="(item.driver==null)?null:item.driver.plate_number"
                                                       class="form-control" placeholder="@lang('layout.PlateNumber')">
                                            </td>
                                            <td>
                                                <input type="text" name="transit_number[]" placeholder="@lang('layout.TransitNumber')" class="form-control">
                                            </td>
                                            <td>
                                                <input type="text" name="tanker_number[]" placeholder="@lang('layout.TankerNumber')" class="form-control">
                                            </td>
                                            <td>
                                                <input type="text" name="way_bill_number[]" placeholder="@lang('layout.WayBillNumber')" class="form-control">
                                            </td>
                                            <td>
                                                <input type="text" name="source[]" placeholder="@lang('layout.SourcePlace')" class="form-control">
                                            </td>
                                            <td>
                                                <input type="text" name="destination[]" placeholder="@lang('layout.Destination')" class="form-control">
                                            </td>
                                            <td>
                                                <date_picker :name="'loading_date['+index+']'" placeholder="@lang('layout.LoadingDate')" ></date_picker>
                                            </td>
                                            <td class="highlight">
                                                <v-select label="name"
                                                           v-model="item.inventory"
                                                          :options="temp_driver" @search="onItemSearch"></v-select>
                                                <input type="hidden" :name="'inventory_id['+index+']'" 
                                                       :value="(!item.item)?null:item.item.id">
                                                <input type="hidden" name="purchase_order_detail_id[]"
                                                       :value="(!item.item)?null:item.item.purchase_order_detail_id">
                                                <input type="hidden" name="contract_detail_id[]"
                                                       :value="(!item.item)?null:item.item.contract_detail_id">

                                            </td>
                                            <td class="highlight">
                                                <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <span v-if="(item.item != null)">
                                                        <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                            @{{site.site_name}}
                                                        </option>
                                                    </span>
                                                </select>
                                                <input type="hidden" name="inventory_site[]"
                                                       :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                            </td>
                                            <td>
                                                <input type="number" :name="'quantity['+index+']'" 
                                                       v-model.number="(item.item==null)?null:item.item.quantity"
                                                       class="form-control input-style input-number"
                                                       placeholder="@lang('layout.Quantity')">
                                            </td>
                                            <td class="highlight">
                                                <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                                        @change="measureChange(index)">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <span v-if="(item.item ==null)?false:true">
                                                      <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                        @{{measure.measure_name}}
                                                      </option>
                                                    </span>
                                                </select>

                                                <input type="hidden" name="measure[]"
                                                       :value="(item.item==null)?null:item.item.measure.measure_id">
                                            </td>
                                            <td>
                                                <input type="number" :name="'driv_amount['+index+']'" 
                                                       class="form-control input-style input-number"
                                                       placeholder="@lang('layout.Amount')">
                                            </td>
                                            <td>
                                                <v-select label="code" :options="currency"
                                                          v-model="item.selected_dir_currency"></v-select>
                                                <input type="hidden" name="currency"
                                                       :value="(!item.selected_dir_currency)?null:item.selected_dir_currency.code">
                                            </td>
                                            <td>
                                                <input type="number" name="currency_rate"
                                                   v-model="!item.selected_dir_currency?0:item.selected_dir_currency.rate"
                                                   class="form-control" :class="{'has-error':rate<=0}">
                                            </td>
                                            
                                            <td>
                                                <span v-if="driveres.length>0" v-on:click="deleteItem('driver',index)"><i
                                                            class="paddint-both glyphicon glyphicon-trash"></i></span>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                    
                                    
                                </div>
                                
                                @endif
                                <!-- end of transporter -->





                            </div>
                        </div>
                        
                        <!-- end purchase item -->

                       <!-- end item -->

                    </div>
                </div>
                <div class="col-md-10">
                    <div class="row">
                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                            <button v-if="isError ==false" type="button" class="btn green"
                                    @click="saveAndNew($event)">@lang('layout.Submit')</button>
                            <button v-if="isError ==false" type="button" class="btn blue"
                                    @click="saveAndNew($event,'new')">@lang('layout.SaveAndNew')</button>
                            <a href="{{route('payByFactor.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}

                <!-- begin add new member -->
                <cmodal :show='showModalNewMember' @close="showModalNewMember=false"></cmodal>
                <!-- end new member -->


            </div>
            <!-- END FORM-->

            


        </div>
    </div>




    
@endsection
@include("layouts.Cmodal")
@include("bills.modal")
@push('scripts')
<script>

	// add new vendor
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif


    Vue.component("modal", {
        template: "#modal-template",
        props: ['show'],

    });
    Vue.component('v-select', VueSelect.VueSelect);
    Vue.component("cmodal", {
        template: '#cmodal-template',

        props: ['show'],
        data() {
            return {
                classes: [],
                selectedClass: null,
                types: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectReceive: null,
            }
        },

        created() {

            axios.get('{{route("customer.create")}}').then(
                response => {
                    this.types = response.data.types;
                    if (this.types) {
                        for (var i = 0; i < this.types.length; i++) {
                            if (this.types[i].type == "Vendor") {
                                this.selectType = this.types[i];
                            }
                        }
                    }
                    this.receivables = response.data.receivable;
                    this.payables = response.data.payable;
                    this.code = response.data.code;
                    this.classes = response.data.member_class;
                    if(this.receivables.length>0)
                    {
                        this.selectReceive=this.receivables[0];
                    }
                    if(this.payables.length>0)
                    {
                        this.selectPay=this.payables[0];
                    }

                }).catch(error => console.log(error));
        },
        methods: {
            onSubmit() {

                vm.showModalNewMember = false;
                //this.member.type = this.member.type.id;
                var datas = $("#modalForm").serializeArray();
                $.ajax({
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        'code': datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },
                    dataType: 'json',

                }).done(function (response) {
                    axios.get('{{route("bill.create")}}').then(response => {

                        vm.vendor = response.data.customer;
                        document.getElementById("modalForm").reset();

                    }).catch(error => console.log(error));

                }).fail(function (error) {
                    console.log('error', error);
                });

            }
        }
    });
    // end new vendor

	Vue.component("v-select", VueSelect.VueSelect);

	var currency ={!! $currency !!};
    var homeCurrency = {!! json_encode(getHomeCurrency()) !!};
    var code = '{!! getHomeCurrency()['code'] !!}';
    var banks ={!! $banks !!};

    var vendor ={!! $vendor !!};
    var inventory_category = {!! $inventory_category !!};
    var memberClass = {!! $memberClass !!};

    var driver = {!! $driver !!};

	var vm = new Vue({
		el:'#app',
		data:{
			number: "{{$number}}",
			memberClass:{!! $memberClass  !!},
			selected_class:null,
			vendor:{!! $vendor !!},
			selected_vendor: null,
            currency:currency,
            selected_currency: homeCurrency,
            isError: false,
            purchase_item: [
                    {inventory: null, item: null, item_category: null},
                ],
                driveres: [
                    {item: null, driver: null, selected_dir_currency: homeCurrency},
                    {item: null, driver: null, selected_dir_currency: homeCurrency},
                ],
                payments: [
                    {
                        items: banks,
                        item: null,
                    }
                ],
            temp_items: [],
            discountIsAmount: false,
            discountFiled: 0,
            showModalNewMember: false,
            ref_no: '',
            rate:0,
            contract: [],
            selected_contract: null,
            banks:banks,
            temp_driver: [],

		},
		computed:{
            selectedRate() 
            {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
            },

            discount() 
            {
                if (this.discountIsAmount)
                {

                    if (this.subtotal > 0 && this.discountFiled) {
                        return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                    } else {
                        return 0;
                    }
                } else {

                    return this.discountFiled
                }

            },
        },
		created:function(){
			
		},
		methods:{
 
            memberClassChange()
            {
                vm.member = vm.all_member;
                console.log(vm.all_member);
                if (vm.selected_class) {
                    vm.member = vm.all_member.filter((m) => {
                        return vm.selected_class.id == m.class_id;
                    });

                }
            },
		
            // check ref
            checkRefNo(e)
            {
                var ref=e.target.value;
              
                axios.get("{{route('callMethod.search')}}",
                {
                    params: {
                        ref_no: ref,
                        method_name: 'Search_ref_no',
                        table_name: 'purchases'
                    },
                })
                .then(function (response) {
                    if (response.data.result != null) {
                        let msg = "@lang('layout.DuplicateData')";
                        $('#ref_no_msg').html(msg);
                    }
                    else {
                        $('#ref_no_msg').html('');

                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            },

            // begin item search

            onItemSearch: _.debounce((search, loading) => {

                loading(true);
                let inventory_category_id = (vm.purchase_item[vm.selected_index]['item_category'] != undefined) ? vm.purchase_item[vm.selected_index]['item_category'].id : '';

                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        member_id: vm.member_id,
                        method_name: 'itemesSearchSale',
                        keyword: search,
                        inventory_category_id: inventory_category_id,
                    }
                })
                .then(function (response) {
                    vm.temp_items = [];
                    if (response.data.length > 0) {
                        vm.temp_items = response.data;
                    }
                    loading(false);
                })
                .catch(function (error) {
                    console.log(error);
                })
            }, getDebounceTime()),


            onItemload(index) {
                vm.selected_index = index;
                if (vm.purchase_item[index].inventory != null) {
                    var inventory_id = vm.purchase_item[index].inventory.id;
                    let inventory_category_id = (vm.purchase_item[index]['item_category'] != undefined) ? vm.purchase_item[index]['item_category'].id : '';

                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: vm.member_id,
                            method_name: 'itemSearchPurchase',
                            inventory_id: inventory_id,
                            inventory_category_id: inventory_category_id,
                        }
                    })
                    .then(function (response) {
                        vm.purchase_item[index].item = null;
                        if (response.data.length > 0) {
                            vm.purchase_item[index].item = response.data[0];
                            
                            @if(getDefaultSite() > 0)
                                var sites_id = {{getDefaultSite()}}
                            for (var i = 0; i < vm.purchase_item[index].item.site_list.length; i++) {
                                if (vm.purchase_item[index].item.site_list[i].site_id == sites_id) {
                                    vm.purchase_item[index].item.site = vm.purchase_item[index].item.site_list[i];
                                }
                            }
                            @endif
                            
                        }
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                }
            },
            
            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingPayment(index = null, name = '') {
                var bank_temp = this.banks.slice();
                var bank_temp1 = [];
                for (var i = 0; i < this.payments.length; i++) {
                    if (this.payments[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                        }
                    }
                }
                this.payments[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },
            // generic function for adding item to list
            addNew(type = null,payment_index=null)
            {
                //this.temp_items = [];
                if (type != null) {
                    
                    if (type == 'payment') 
                    {
                        this.payments.push({
                            items: banks,
                            item: null,
                        });
                    }
                    if (type == 'inventory') {
                        this.purchase_item.push({inventory: null, item: null, item_category: null});
                    }
                     if (type == 'driver') 
                     {
                        this.temp_driver = [];
                        this.driveres.push({
                            item: null, driver: null, selected_dir_currency: homeCurrency
                        });
                        
                    }
                   
                } 
            },

            // delete item from list
            deleteItem(type = null, index,payment_index) {
                if (type != null) {
                    if (type == 'payment') {
                        this.payments.splice(payment_index, 1);
                    }
                    if (type == 'inventory') {
                        this.purchase_item.splice(index, 1);
                    }
                }
            },

            // detect member change and searh
            memberChange() {
                if (this.selected_vendor) {
                    // get member contract
                    this.contract = [];
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member_contract',
                            member_id: this.selected_vendor.id
                        }
                    })
                    .then(function (response) {
                        if (response.data.length > 0) {
                            vm.contract = response.data;
                        }
                    })
                    .catch(function (error) {
                        console.log(error);
                    });

                    this.purchaseOrderSearch(this.selected_vendor.id)
                }
            },

            // begin purchase order search
            purchaseOrderSearch(member_id = null) {
                this.purchaseOrderList = [];
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'memberPurchaseOrder',
                        member_id: member_id,
                    }
                })
                .then(function (response) {

                    if (response.data.length > 0) {
                        vm.showModalPurchaseOrder = true;
                        vm.purchaseOrderList = response.data;
                        console.log('qweqwew', response.data);

                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            },


            // save or new

            saveAndNew(e,type=null) 
            {
                
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {

                            var url = "{{route('payByFactor.store')}}";
                            
                            var data = $('#gas-purchase-form').serialize();

                            axios.post(url, data)
                                .then(function (response) {
                                   
                                    if (response.data.result == 1) {
                                        $('#gas-purchase-form').trigger('reset');
                                        toastr.success('', response.data.message);

                                        if(type==null)
                                        {
                                            window.location.href="{{route('payByFactor.index')}}"
                                        }
                                        else
                                        {
                                           
                                            vm.temp_items= [];
                                            vm.selectedMember=null;
                                        }
                                       
                                    }
                                    else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }

                                    
                                    
                                })
                                .catch(function (error) {
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },

		}

	});
</script>
@endpush
