@extends('layouts.app')
@section('style')
    <style>
        .v-select input[type=search], .v-select input[type=search]:focus {
            width: 50% !important;
        }
        .table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th {
            padding: 8px;
            padding: 4px 2px;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
    </style>
@stop
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase"> @lang('menu.ImportExcel') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                
                <div class="pull-right">
                </div>
            </div>
            <div class="row">
                <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 text-center">
                    <div class="tools">
                        <a href="{{url('/')}}/import_file/simple_import_fixed_asset_managemen.xlsx" style="text-decoration: none; color: black;"> --------
                           <button class="btn btn-success">
                           <i class="fa fa-download"></i>
                           @lang('layout.ImportExcelSample')
                           </button>
                        -------- </a>
                   </div>
                   <!-- BEGIN FORM-->
                   {{Form::open(['route'=>'fixedAssetManagementImport.store','method'=>'POST','enctype'=>'multipart/form-data','class'=>'form-horizontal','id'=>'import-form'])}}
                   {{ csrf_field() }}
                       <div class="form-body">
                           <div class="col-md-12">
                               <div class="form-group" style="margin-top: 20px;">
                                   <label class="control-label col-md-5">@lang('layout.SelectFile') @lang('layout.Excel') :</label>
                                   <div class="col-md-7">
                                       {{Form::file('customer_file',null,['class' => 'form-control','placeholder' => __('layout.File')])}}
                                   </div>
                               </div>
                           </div>
                       </div>
                       <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center" style="margin-top: 20px;">
                           <button type="button" onClick="sendFormData(this)" class="btn green">@lang('layout.Submit')</button>
                           <button type="reset" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')
                           </button>
                           <br/>
                           <br/>
                           <br/>
                           <br/>
                       </div>
                   {{Form::close()}}
                   <!-- end form -->
                </div>
                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                    <ul class="text-danger">
                        <p class="text-danger">@lang('message.Info')</p>
                        <li class="text-danger">@lang('message.TipOne')</li>
                        <li class="text-danger">@lang('message.TipTwo')</li>
                        <li class="text-danger">@lang('message.TipThree')</li>
                    </ul>
                </div>
            </div>
            <div id="app" v-cloak>
                <h1 v-if="flag=='no'">@lang('layout.import_measure_msg')</h1>
                <div v-if="flag=='yes'" class="portlet-body form" style="margin-bottom:50%;">
                    
                    <div v-if="record.length>0">
                        <div style="overflow-x:scroll; width: 100%">
                            <!-- begint table -->
                            {{Form::open(['route'=>'fixedAssetManagementImport.store','method'=>'POST','class'=>'form-horizontal','enctype'=>'multipart/form-data','id'=>'import-form-second'])}}
                            {{csrf_field()}}
                            <div class="row">
                                <div class="col-md-12 col-md-12">
                                    <div class="col-md-12" style="height: 400px;">
                                        <table id="table_content" class="table table-bordered ">
                                            <thead>
                                            <tr>
                                                <th class="text-center" style="width:20px;"> # </th>
                                                <th class="text-center" style="min-width: 200px;">
                                                    @lang('layout.Name') @lang('layout.Asset')
                                                </th>
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.Number')
                                                </th>
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.BarcodeNumber')
                                                </th>
                                                <th class="text-center" style="min-width: 230px;">
                                                    @lang('layout.AssetAccount')
                                                </th>
                                                <th class="text-center" style="min-width: 230px;">
                                                    @lang('layout.ExpenseAccount')
                                                </th>
                                                <th class="text-center" style="min-width: 150px;">
                                                    @lang('layout.Date')
                                                </th>
                                                <th class="text-center" style="min-width: 150px;">
                                                    @lang('layout.LifeSpan')
                                                </th>
                                                <th class="text-center" style="min-width: 150px;">
                                                    @lang('layout.DateDepreciation')
                                                </th>
                                                <th class="text-center" style="min-width: 160px;">
                                                    @lang('layout.Type')
                                                </th>
                                                <th class="text-center" style="min-width: 160px;">
                                                    @lang('layout.Category')
                                                </th>
                                                 <th class="text-center" style="min-width: 160px;">
                                                    @lang('layout.PONumber')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.SerialNum')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Location')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Cost')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.DepreciationType')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.DepreciationDurationType')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Description')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Note')
                                                </th>
                                            </tr>
                                            </thead>
                                            <tr v-for="(obj,index) in record">
                                                <td class="td_one"><span class="badge badge3 badge-success badge-roundless">@{{index+1}} </span>
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'name['+index+']'" v-model="obj.name">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'number['+index+']'" v-model="obj.number">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'barcode_number['+index+']'" v-model="obj.barcode_number">                                                
                                                </td>
                                                <td class="td_one"> 
                                                    <select class="form-control input-style" v-model="obj.asset_id"
                                                    required="required" :name="'asset_id['+index+']'" >
                                                    <option value="">@lang('layout.Select')</option>
                                                        <option v-if="selectedAsset" v-for="Asset in (selectedAsset?selectedAsset:null)" :value="Asset.id">
                                                            @{{Asset.name}}
                                                        </option>
                                                    </select>
                                                </td>
                                                {{-- Expense --}}
                                                <td class="td_one"> 
                                                    <select class="form-control input-style" v-model="obj.expense"
                                                    required="required" :name="'expense['+index+']'" >
                                                    <option value="">@lang('layout.Select')</option>
                                                        <option v-if="selectedExpense" v-for="Expense in (selectedExpense?selectedExpense:null)" :value="Expense.id">
                                                            @{{Expense.name}}
                                                        </option>
                                                    </select>
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control date" :name="'date['+index+']'" autocomplete="off" v-model="obj.date">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control date" :name="'expire_date['+index+']'" autocomplete="off" v-model="obj.expire_date">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control date" :name="'date_depreciation['+index+']'" autocomplete="off" v-model="obj.date_depreciation">
                                                </td>
                                                <td class="td_one">
                                                    <select :name="'type['+index+']'" class="form-control"  v-model="obj.type">
                                                        <option value="new">@lang('type.new')</option>
                                                        <option value="used">@lang('type.used')</option>
                                                    </select>
                                                </td>
                                                <td class="td_one">
                                                    <select class="form-control input-style" v-model="obj.category"
                                                    required="required" :name="'category_id['+index+']'">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option v-if="category_list"
                                                                v-for="cat in (category_list?category_list:null)"
                                                                :value="cat.id">
                                                            @{{cat.name}}
                                                        </option>
                                                    </select>
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'po_number['+index+']'" v-model="obj.po_number">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'serial_number['+index+']'" v-model="obj.serial_number">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'location['+index+']'" v-model="obj.location">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'cost['+index+']'" v-model="obj.cost">
                                                </td>
                                                <td class="td_one">
                                                    <select :name="'depreciation_type['+index+']'" class="form-control" v-model="obj.depreciation_type">
                                                        <option value="straightLineMethod">@lang('layout.StraightLineMethod')</option>
                                                        <option value="sumOfDigits">@lang('layout.SumOfDigits')</option>
                                                        <option value="reducingBalance">@lang('layout.ReducingBalance')</option>
                                                    </select>
                                                </td>  
                                                <td class="td_one">
                                                    <select  :name="'depreciation_duration_typ['+index+']'"  class="form-control" v-model="obj.depreciation_duration_typ">
                                                        <option value="yearly">@lang('layout.Yearly')</option>
                                                        <option value="montly">@lang('layout.Montly')</option>
                                                    </select>                                                
                                                </td>
                                                <td class="td_one">
                                                    <textarea name="" id="" class="form-control" cols="30" :name="'description['+index+']'" rows="1" v-model="obj.description"></textarea>
                                                </td>
                                                <td class="td_one">
                                                    <textarea name="" id="" class="form-control" cols="30" :name="'note['+index+']'" rows="1" v-model="obj.note"></textarea>
                                                </td> 
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <!-- end table -->
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                            <button type="button" @click="sendFormData(this)" class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
                        </div>
                        {{Form::close()}}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        Vue.component('v-select', VueSelect.VueSelect);
        var data ={!! $data !!};
        var currency ={!! $currency !!};
        var Category ={!! $fixedAssetCategory !!};
        var getAsset ={!! $getAsset !!}; 
        var fixedAssetExpense ={!! $fixedAssetExpense !!}; 
        new Vue({ 
            el: '#app',
            data: {
                flag: 'yes',
                record: data,
                selectedAsset: getAsset,
                selectedExpense: fixedAssetExpense,
                category_list: Category,
                currency_list: currency,
                measure_list: currency,
                site_q: [],
                type: 'new',
                depreciation_type: 'straightLineMethod',
                depreciation_duration_typ: 'yearly',
            },
            mounted(){
                for (var i = 0; i < data.length; i++) {
                    if(!data[i].type){
                        data[i].type = 'new';
                    }
                    if(!data[i].depreciation_type){
                        data[i].depreciation_type = 'straightLineMethod';
                    }
                    if(!data[i].depreciation_duration_typ){
                        data[i].depreciation_duration_typ = 'yearly';
                    }
                }
            },
            methods: {
                setNewRate(index = null) {
                    if (this.record[index].currency) {
                        this.record[index].currency.rate = this.$refs.rate[index].value;
                    }
                },
                changeCost(e, index) {
                    this.record[index].cost = e.event.target.value;
                    return true;
                },
                changeAsset(e, index) {
                    this.record[index].asset = e.event.target.value;
                    return true;
                },
                sendFormData(e) {
                    var el = $(e);
                    var form = el.parents('form').get(0);
                    var data = $('#import-form').serialize();
                    console.log('test 22', data);
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        icon: 'warning',
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        dangerMode: true,
                    }).then((wichButton) => {
                        if (wichButton) {
                            //form.submit();
                            document.getElementById('import-form-second').submit();
                            return true;
                        }
                        return false;
                    });
                }
            },
            created: function () {
                console.log('ssssss', this.flag);
                for (var i = 0; i < this.record.length; i++) {
                    
                }
            }
        });
        function sendFormData(e) {
            var el = $(e);
            var form = el.parents('form').get(0);
            var data = $('#import-form').serialize();
            console.log('test 22', data);
            swal({
                title: "@lang('layout.AreYouSure?')",
                icon: 'warning',
                buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                dangerMode: true,
            }).then((wichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            });
        }
        // to send inventory data
        function sendData(element) {
            e = $(e);
            var form = e.parents('form').get(0);
            swal({
                'title': "@lang('layout.AreYouSure?')",
                'icon': 'dander',
                'buttons': ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                danderMode: true
            }).then((whichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            })
        }
        // end inventory data
    </script>
@endpush