@extends('layouts.app')
@section('style')
<style type="text/css">
   table.td{
        border-top:0px;
    }
    .header{
    
    }
   
</style>
@stop
@section('content')
 
      <div class="row">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.FixedAssetManagementShow')</span>
                    </div>
                   
                    <div class="tools"></div>
                    <div class="actions">
                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="fixed_asset_Details"/>
                           <input type="hidden" name="id" value="{{$fixedAsset->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.Report') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="row">
                       <div class="col-md-12">
                           <table class="table table-striped table-bordered table-advance table-hover">
                                <thead>
                                    <tr>
                                        <th>@lang('layout.Number')</th>
                                        <th>@lang('layout.FixedAsset')</th>
                                        <th>@lang('layout.SerialNum')</th>
                                        <th>@lang('layout.Category')</th>
                                        <th>@lang('layout.Type')</th>
                                        <th>@lang('layout.Cost')</th>
                                        <th>@lang('layout.AssetValue')</th>
                                        <th>@lang('layout.Asset')</th>
                                        <th>@lang('layout.Location')</th>
                                        <th>@lang('layout.PONumber')</th>
                                        <th>@lang('layout.Date') </th>
                                        <th>@lang('layout.LifeSpan') </th>
                                        <th>@lang('layout.ExpenseAccount') </th>
                                        <th>@lang('layout.Status') </th>
                                    </tr>
                                </thead>
                                <tbody> 
                                    <tr>  
                                        <td class=""> {{ $fixedAsset->number}}  </td>
                                        <td class=""> {{ $fixedAsset->name}}  </td>
                                        <td class=""> {{ $fixedAsset->serial_number}}  </td>
                                        <td class=""> {{ $fixedAsset->category}}  </td>
                                        <td class=""> {{ __('type.'.$fixedAsset->type)}}</td>
                                        <td class=""> {{ myRound($fixedAsset->Cost)}} {{ $fixedAsset->unit}}</td>
                                        <td class=""> {{ myRound($fixedAsset->Cost - $fixedAsset->depre_amount)}} {{ $fixedAsset->unit}}</td>
                                        <td class=""> {{ $fixedAsset->asset_name}}</td>
                                        <td class=""> {{ $fixedAsset->location}}</td>
                                        <td class=""> {{ $fixedAsset->po_number}}</td>
                                        <td class=""> {{ $fixedAsset->date}}</td>
                                        <td class=""> {{ $fixedAsset->expire_date}}</td>
                                        <td class=""> {{ $fixedAsset->expense_name}}</td>
                                        <td class=""> {{ __('type.'.$fixedAsset->status)}}</td>
                                    </tr>
                                </tbody>
                            </table>
                       </div> 
                       @if($fixedAsset->buy_check)
                       <div class="col-md-12">
                           <table class="table table-striped table-bordered table-advance table-hover">
                                <thead>
                                    <tr>
                                        
                                        <th>@lang('layout.Currency') </th>
                                        <th>@lang('layout.Rate') </th>
                                        <th>@lang('layout.Amount')</th>
                                        <th>@lang('layout.PaymentType')</th>
                                        <th>@lang('layout.Account')</th>
                                    </tr>
                                </thead>
                                <tbody> 
                                    <tr>  
                                        <td class=""> {{ $fixedAsset->currency}}</td>
                                        <td class=""> {{ $fixedAsset->rate}}</td>
                                        <td class=""> {{ $amount}}</td>
                                        <td class=""> {{ __('layout.'.ucfirst($fixedAsset->payment_type))}}</td>
                                        <td class=""> {{ $account}}</td>
                                    </tr>
                                </tbody>
                            </table>
                       </div> 
                       @endif
                       <div class="col-md-12">
                           <table class="table table-striped table-bordered table-advance table-hover">
                                <thead>
                                    <tr>
                                        <th>@lang('layout.DepreciationType') </th>
                                        <th>@lang('layout.DepreciationDurationType') </th>
                                        <th>@lang('layout.DateDepreciation') </th>
                                        <th>@lang('layout.Description') </th>
                                        <th>@lang('layout.Note')</th>
                                    </tr>
                                </thead>
                                <tbody> 
                                    <tr>  
                                        <td class=""> {{ __('layout.'.ucfirst($fixedAsset->depreciation_type))}}</td>
                                        <td class=""> {{ __('layout.'.ucfirst($fixedAsset->depreciation_duration_type))}}</td>
                                        <td class=""> {{ $fixedAsset->date_depreciation}}</td>
                                        <td class=""> {{ $fixedAsset->description}}</td>
                                        <td class=""> {{ $fixedAsset->note}}</td>
                                    </tr>
                                </tbody>
                            </table>
                       </div> 
                    </div>
                    <div class="row" >

                    <div class="tabbable tabbable-tabdrop">

                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="">@lang('layout.CalculateDepreciation')</a>
                            </li>
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="">@lang('layout.Attachments')</a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                @if(count($depreciation_data) > 0)
                                <div class="col-md-12">
                                    <table class="table table-striped table-bordered table-advance table-hover">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Period') </th>
                                                    <th>@lang('layout.Date') </th>
                                                    <th>@lang('layout.AssetValue')</th>
                                                    <th>@lang('layout.DepreciationAmount')</th>
                                                    <th>@lang('layout.DepreciationPercent')</th>
                                                    <th>@lang('layout.TotalDepreciation')</th>
                                                    <th>@lang('layout.RemainAmount')</th>
                                                </tr>
                                            </thead>
                                            <tbody> 
                                                @foreach($depreciation_data AS $record)
                                                <tr>  
                                                    <td class=""> {{$record['year']}}</td>
                                                    <td class=""> {{convertDate(date_format($record['year_end'], 'Y-m-d'))}}</td>
                                                    <td class=""> {{myRound($record['amount'])}}</td>
                                                    <td class=""> {{myRound($record['year_amount'])}}</td>
                                                    <td class=""> {{round($record['depr_percent'])}} %</td>
                                                    <td class=""> {{myRound($record['year_amount_total'])}}</td>
                                                    <td class=""> {{myRound($record['amount_total'])}}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                </div> 
                                @endif
                            </div>
                            <div class="tab-pane" id="tab2">
                                <div class="portlet light bordered">
                                    <div class="title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <div class="portlet light bordered">
                                            <div class="portlet-body">

                                                <form role="form" action="{{route('attachment.store')}}" method="post"
                                                    enctype="multipart/form-data">

                                                    @csrf
                                                    <input type="hidden" name="redirect_route" value="fixedAssetManagement.show">
                                                    <input type="hidden" name="foreign_data_id" value="{{$fixedAsset->id}}">
                                                    <input type="hidden" name="path" value="uploads/fixedAsset">
                                                    <input type="hidden" name="table_name" value="fixed_asset_management">

                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                                <input type="text" name="title" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control"></textarea>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-7">
                                                            <div class="form-group">
                                                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                                                    <div class="fileinput-new thumbnail"
                                                                        style="width: 200px; height: 150px;">
                                                                        <img src="" alt=""></div>
                                                                    <div class="fileinput-preview fileinput-exists thumbnail"
                                                                        style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                                    <div>
                                                                                <span class="btn default btn-file">
                                                                                    <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                    <input type="hidden" value="" name=""><input
                                                                                            type="file" name="photo"> </span>

                                                                        <a href="javascript:;" class="btn default fileinput-exists"
                                                                        data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="margiv-top-10">
                                                        <button type="button" onclick="regForm(this)"
                                                                class="btn green"> @lang('layout.Submit') </button>
                                                        <a href="{{route('dailyExpense.index')}}"
                                                        class="btn default">@lang('layout.Cancel')</a>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <table class="table table-striped table-bordered table-hover" id="attachment">
                                            <thead>
                                            <tr>
                                                <th>@lang('layout.AttachmentTitle')</th>
                                                <th>@lang('layout.Description')</th>
                                                <th>@lang('layout.Action')</th>
                                            </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>        
                        </div>
                    </div>
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
    </div>
@endsection
@push('scripts') 
<script>

    $(document).ready(function(){
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#attachment').DataTable({
            ajax: {
                url: '{{route("fixedAssetManagement.show",$fixedAsset->id)}}',
                data: {type: 'attachment'}
            },
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',

            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [

                {data: 'title', name: 'attachments.title'},
                {data: 'description', name: 'attachments.description'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false},
            ]
        });   
    });

</script>
@endpush