@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('contract', 'index');
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.NGOProjectReport')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Code')</th>
            <th>@lang('layout.Name')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.Location')</th>
            <th>@lang('layout.Description') </th>
            <th>@lang('layout.Date') </th>
            <th>@lang('layout.StartDate') </th>
            <th>@lang('layout.EndDate') </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class="hidden-xs"> {{ $data->code}} </td>
            <td class="hidden-xs"> {{ $data->name}} </td>
            <td class="hidden-xs"> {{ $data->ref_no}} </td>
            <td class="hidden-xs"> {{ $data->category}}</td>
            <td class="hidden-xs"> {{ $data->location}}</td>
            <td class="hidden-xs"> {{ $data->description}}</td>
            <td class="hidden-xs"> {{ $data->date}}</td>
            <td class="hidden-xs"> {{ $data->start_date}}</td>
            <td class="hidden-xs"> {{ $data->end_date}}</td>
        </tr>
    </tbody>
</table>
<hr />

<h3>@lang('layout.Donator')</h3>
<table class="main-table">
    <tr class="bg">
        <th>#</th>
        <th>@lang('layout.Name')</th>
        <th>@lang('layout.Description')</th>
    </tr>
    <?php
    $count = 0;
    ?>
    @foreach($projectDonator AS $record1)
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record1->name}}</td>
        <td class="center">{{$record1->description}}</td>
    </tr>
    @endforeach
</table>
<hr />
<?php //dd($nProOrder); ?>
<h3>@lang('layout.Request')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>#</th>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Member')</th>
            <th>@lang('layout.Date') </th>
            <th>@lang('layout.Currency') </th>
            <th>@lang('layout.Rate') </th>
            <th>@lang('layout.Total')</th>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.Priority')</th>
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.Driver')</th>
            <th>@lang('layout.VehicleName')</th>
            <th>@lang('layout.DateRequired') </th>
            <th>@lang('layout.User') </th>
            <th>@lang('layout.Description') </th>
        </tr>
    </thead>
    <?php
    $count = 0;
    ?>
    @foreach($nProOrder AS $record2)
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="hidden-xs"> {{ $record2->number}} </td>
        <td class="hidden-xs"> {{ $record2->ref_no}} </td>
        <td class="hidden-xs"> {{ $record2->member}} </td>
        <td class="hidden-xs"> {{ convertDate($record2->date) }}</td>
        <td class="hidden-xs"> {{ $record2->currency}}</td>
        <td class="hidden-xs"> {{ $record2->currency_rate}}</td>
        <td class="hidden-xs"> {{ $record2->price}}</td>
        <td class="hidden-xs"> {{ $record2->category}}</td>
        <td class="hidden-xs"> {{ __('type.'.$record2->priority)}}</td>
        <td class="hidden-xs"> {{ __('layout.'.$record2->type)}}</td>
        <td class="hidden-xs"> {{ $record2->driver_name }}</td>
        <td class="hidden-xs"> {{ $record2->vehicle_name}} -- {{ $record2->palet_number}}</td>
        <td class="hidden-xs"> {{ convertDate($record2->requir_date) }}</td>
        <td class="hidden-xs"> {{ $record2->user}}</td>
        <td class="hidden-xs"> {{ $record2->description}}</td>
    </tr>
    @endforeach
</table>
<hr />

<h3>@lang('layout.ReceiveAndPayment')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>#</th>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Member')</th>
            <th>@lang('layout.Date') </th>
            <th>@lang('layout.Currency') </th>
            <th>@lang('layout.Rate') </th>
            <th>@lang('layout.Total')</th>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.Priority')</th>
            <th>@lang('layout.DateRequired') </th>
            <th>@lang('layout.User') </th>
            <th>@lang('layout.Description') </th>

            <th>@lang('layout.RequestNO')</th>
            <th>@lang('layout.ExpenseType')</th>
            <th>@lang('layout.PaymentType')</th>
            <th>@lang('layout.ExpenseAccount')</th>
            <th>@lang('layout.BankAccount')</th>
            <th>@lang('layout.Vendor')</th>
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.Driver')</th>
            <th>@lang('layout.VehicleName')</th>
            <th>@lang('layout.PaletNumber')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $currencies = [];
    ?>
    @foreach($nProOrderRP AS $record3)
    <?php
    if (array_key_exists($record3->unit, $currencies)) {
        $currencies[$record3->unit] = $currencies[$record3->unit] + (($record3->expense_type == 'Receive')?(-1 * $record3->price):$record3->price);
    } else {
        $currencies[$record3->unit] = (($record3->expense_type == 'Receive')?(-1 * $record3->price):$record3->price);
    }
    ?> 
    <tr>
        <td class="hidden-xs"> {{ ++$count}} </td>
        <td class="hidden-xs"> {{ $record3->number}} </td>
        <td class="hidden-xs"> {{ $record3->ref_no}} </td>
        <td class="hidden-xs"> {{ $record3->member}} </td>
        <td class="hidden-xs"> {{ convertDate($record3->date) }}</td>
        <td class="hidden-xs"> {{ $record3->unit}}</td>
        <td class="hidden-xs"> {{ $record3->rate}}</td>
        <td class="hidden-xs"> {{ (($record3->expense_type == 'Receive')?(-1 * $record3->price):$record3->price)}}</td>
        <td class="hidden-xs"> {{ $record3->category}}</td>
        <td class="hidden-xs"> {{ __('type.'.$record3->priority)}}</td>
        <td class="hidden-xs"> {{ convertDate($record3->requir_date) }}</td>
        <td class="hidden-xs"> {{ $record3->user}}</td>
        <td class="hidden-xs"> {{ $record3->description}}</td>

        <td class="hidden-xs"> {{$record3->pro_order_num}}</td>
        <td class="hidden-xs"> {{__('layout.'.ucfirst($record3->expense_type))}} </td>
        <td class="hidden-xs"> {{__('layout.'.ucfirst($record3->pay_type))}}</td>
        <td class="hidden-xs"> {{$record3->expense}}</td>
        <td class="hidden-xs"> {{$record3->bankAccount}}</td>
        <td class="hidden-xs"> {{$record3->vendor}}</td>
        <td class="hidden-xs"> {{ __('layout.'.$record3->type)}}</td>
        <td class="hidden-xs"> {{ $record3->driver_name}} </td>
        <td class="hidden-xs"> {{ $record3->vehicle_name}} </td>
        <td class="hidden-xs"> {{ $record3->palet_number}} </td>
    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="9">
            <div class="center">@lang('layout.Currency')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> #</div>
        </td>
        <td colspan="4">
            <div class="center"> @lang('layout.Category') </div>
        </td>
        <td colspan="4">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key1 => $curr) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td colspan="4">
                <div class="center">{{$key1}}</div>
            </td>
            <td colspan="4">
                <div class="center">{{round($curr,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
</table>


@endsection