@extends('layouts.app')
@section('style')
<style type="text/css">
    .v-select .selected-tag {
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
    .v-select .selected-tag > button >span{
        display: none !important;
    }
</style>
@endsection
@section('content')
@include('layouts.modal')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show" :value-type="'fixedAssetManagement_report'" @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">
                            <ul class="nav nav-tabs">       
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                               @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                                <div class="col-md-4">
                                                    <label class="control-label">@lang('layout.AssetAccount')</label>
                                                    <v-select class="vue-select2" v-model="selectedAsset" label="name" :options="{{$getAsset}}">
                                                    </v-select>
                                                    <input type="hidden" name="asset_id" v-model.number="(!selectedAsset)?null:selectedAsset.id">
                                                </div>
                                                <div class="col-md-2">
                                                    <label class="control-label">@lang('layout.Type')</label>
                                                    <select name="asset_type" class="form-control">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="new">@lang('type.new')</option>
                                                        <option value="used">@lang('type.used')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.BankAccount') </label>
                                                    <v-select class="vue-select2" v-model="selectedBank" label="name"
                                                    :multiple="true"
                                                     @search="searchBank" :options="bankList">
                                                    </v-select>
                                                    <input type="hidden" name="bank_id"
                                                    :value="bank_id.length > 0 ? bank_id:null">
                                        
                                                </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.FixedAsset') </label>
                                                    <v-select class="vue-select2" v-model="selectedproject" label="name" @search="onProjectSearch" :options="projectList">
                                                    </v-select>
                                                    <input type="hidden" name="fixed_asset_id" v-model.number="(!selectedproject)?null:selectedproject.id">
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label">@lang('layout.Category')</label>
                                                    <v-select class="vue-select2" v-model="selectedCategory" label="name" :options="{{$fixedAssetCategory}}">
                                                    </v-select>
                                                    <input type="hidden" name="category_id" v-model.number="(!selectedCategory)?null:selectedCategory.id">
                                                </div>                                                
                                              <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.AllCategory') </label>
                                                <select name="all_categories" id="" class="form-control">
                                                    <option value="">@lang('layout.SelectCategory')</option>
                                                    <option value="total_by_category">@lang('layout.TotalByFixedAssetCategory')</option>
                                                </select>
                                            </div>    
                                            </div>
                                        </div>  
                                        <div class="row">
                                            <div class="form-group">                                             
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.SerialNum') </label>
                                                    <input class="form-control" autocomplete="off" name="serial_number">
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label">@lang('layout.Status')</label>
                                                    <select name="status" class="form-control">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="on">@lang('layout.Active')</option>
                                                        <option value="off">@lang('layout.InActive')</option>
                                                    </select>
                                                </div>
                                            </div>

                                            
                                        </div>
                                        <div class="row" style="background-color: rgb(231, 227, 220); padding-bottom:15px;margin-top:10px">
                                            <div class="col-md-12">
                                                <label class="control-label ">@lang('layout.Cost')</label>
                                                <div class="input-group">
                                                  <input class="form-control" autocomplete="off" name="from_amount">
                                                  <span class="input-group-addon"> @lang('layout.To') </span>
                                                  <input class="form-control" autocomplete="off" name="to_amount">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row" style="background-color: rgb(231, 227, 220); padding-bottom:15px;margin-top:10px">
                                            <div class="col-md-12">
                                                <label class="control-label ">@lang('layout.AssetValue')</label>
                                                <div class="input-group">
                                                  <input class="form-control" autocomplete="off" name="from_depre_amount">
                                                  <span class="input-group-addon"> @lang('layout.To') </span>
                                                  <input class="form-control" autocomplete="off" name="to_depre_amount">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div slot="date">
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div> 
                                <div class="tab-pane" id="tab2"> 
                                    <div class="tab-pane" id="tab2">
                                        <div class="portlet light bordered">
                                            <div class="portlet-body">
                                                <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                                    @csrf
                                                    <input type="hidden" name="part_name" value="fixed_asset_management_index">
                                                    <div class="col-md-12 col-sm-12 col-xs-12">
                                                        <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                            <div class="form-group">
                                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" :checked="row.checkedColumn">
                                                                                <span class="slider round"></span>
                                                                            </label>
                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                                <!-- <label> @{{ row.Name }}</label>
                                                                      <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                     <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                          <span class="slider round"></span>
                                                                    </label> -->
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="margiv-top-10">
                                                        <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                        <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </report-modal>
    </div>
<!-- END PAGE HEADER-->
<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.FixedAssetManagementList') </span>
            </div>
             <div class="btn-group pull-right">
                    @permission('FixedAssetManagement-export')
                        <span id="anchore-modal">
                            <a  @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                            </a>
                        </span>
                    @endpermission
                    @permission('FixedAssetManagement-create')
                    <a href="{{route('fixedAssetManagementImport.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus "></i> @lang('menu.InventoryImport')
                        </button>
                    </a>
                    @endpermission
                    @permission('FixedAssetManagement-create')
                    <a href="{{route('fixedAssetCategory.index')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-reorder "></i> @lang('layout.FixedAssetCategory')
                        </button>
                    </a>
                    @endpermission
                    @permission('FixedAssetManagement-create')
                    <a href="{{route('fixedAssetManagement.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a>
                    @endpermission
                    <div id="nGOProject" v-cloak>
                         <!-- <button class="btn btn-success" id="show-modal" @click="showModal =true">@lang('layout.AddNew')</button>
                         <modal v-if="showModal" @close="showModal = false">
                            <div slot="header">
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <h3>
                                        @lang('layout.projectCategoryCreate')
                                    </h3>
                                </div>
                                <div class="col-md-4">
                                    <div v-if="fieldErrors.length > 0">
                                        <p class="text-danger" fieldErrors>
                                            <spna v-text="fieldErrors"></spna>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div slot="body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Name") <span class="required"> * </span></label>
                                            <input type="text" class="form-control" name="name" v-model="className">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description") <span class="required"> * </span></label>
                                            <textarea class="form-control" name="description" v-model="description">  
                                            </textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div slot="footer">
                                <button type=button class="btn btn-success" @click="addClass" >
                                    @lang('layout.OK')
                                </button>
                                <button type=button class="btn btn-danger"
                                       @click="showModal =false" >
                                    @lang('layout.Cancel')
                                </button>
                            </div>
                        </modal> --> 
                    </div> 
            </div>
            <div class="search-form" id="app">
                <div class="col-lg-12 col-md-12" class="input-group input-medium "> 
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.AssetAccount')</label>
                        <v-select class="vue-select2" @input="getData()"  v-model="selectedAsset" label="name" :options="{{$getAsset}}">
                        </v-select>
                        <input type="hidden" name="selectedAsset"  v-model.number="(!selectedAsset)?null:selectedAsset.id">
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Category')</label>
                        <v-select class="vue-select2" @input="getData()"  v-model="selectedCategory" label="name" :options="{{$fixedAssetCategory}}">
                        </v-select>
                        <input type="hidden" name="selectedCategory" v-model.number="(!selectedCategory)?null:selectedCategory.id">
                    </div> 
                     <div class="col-lg-3 col-md-3">
                        <label class="control-label">@lang('layout.Type')</label>
                        <select name="type_asset"  @change="getData()" v-model="type_asset" class="form-control" >
                            <option value="">@lang('layout.Select')</option>
                            <option value="new">@lang('type.new')</option>
                            <option value="used">@lang('type.used')</option>
                        </select>
                    </div> 
               </div>
           </div>
        </div>
        <div class="portlet-body">
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
            <table class="table table-striped table-bordered table-hover" cellspacing="1" id="nGOProjects" width="100%">
                <thead>
                <tr> 
                    <th>@lang('layout.Record')</th>
                    <th>@lang('layout.Number')</th>
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.SerialNum')</th>
                    <th>@lang('layout.Category')</th>
                    <th>@lang('layout.Type')</th>
                    <th>@lang('layout.Cost')</th>
                    <th>@lang('layout.AssetValue')</th>
                    <th>@lang('layout.Asset')</th>
                    <th>@lang('layout.Location')</th>
                    <th>@lang('layout.PONumber')</th>
                    <th>@lang('layout.Description') </th>
                    <th>@lang('layout.Date') </th>
                    <th>@lang('layout.LifeSpan') </th>
                    <th>@lang('layout.Status') </th>
                    <th>@lang('layout.Action') </th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    var cust_rep = {!!customeReportNewData('fixed_asset_management_index')!!};
    Vue.component("v-select", VueSelect.VueSelect);

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        getRecord();
    });

    function getRecord()
    {

    let data_table;
    var from_date = null;
     var to_date = null; 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        data_table = $('#nGOProjects').DataTable( {
            ajax: {
               url: '{{route("fixedAssetManagement.index")}}',
               data:{selectedAsset:vmfilter.selectedAsset,selectedCategory:vmfilter.selectedCategory, type_asset:vmfilter.type_asset}
            },
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging:         true,
            destroy: true,
            scrollCollapse: true,
 
            columns: [
            { data: 'id', name: 'fixed_asset_management.id', searchable: false},
            { data: 'number', name: 'fixed_asset_management.number' },
            { data: 'name', name: 'fixed_asset_management.name' },
            { data: 'serial_number', name: 'fixed_asset_management.serial_number' },
            { data: 'category', name: 'fixed_asset_category.name' },
            { data: 'type', name: 'fixed_asset_management.type' }, 
            { data: 'Cost', name: 'Cost', orderable: false, searchable: false},
            { data: 'current_cost', name: 'current_cost', orderable: false, searchable: false},
            { data: 'asset_name', name: 'asset_name', orderable: false, searchable: false},
            { data: 'location', name: 'fixed_asset_management.location'},
            { data: 'po_number', name: 'fixed_asset_management.po_number' },
            { data: 'description', name: 'fixed_asset_management.description' },
            { data: 'date', name: 'fixed_asset_management.date', searchable: false},
            { data: 'expire_date', name: 'fixed_asset_management.expire_date', searchable: false },
            { data: 'status', name: 'fixed_asset_management.status', orderable: false, searchable: false},
            { data: 'action', name: 'action', orderable: false, searchable: false},
            ] 
    }); 
}
 
         
    var vmfilter = new Vue({
                el: '#app',
                data:{
                // category:null,
                selectedAsset:null,
                selectedCategory:null,
                type_asset:null

                },
                methods:{
                    getData(){ 
                    getRecord();
                }
                }
            });
 
        Vue.component('modal',{
            template: '#modal-template'
        });

     let vu = new Vue({
        el: '#nGOProject',
        data:{
            showModal:false,
            fieldErrors:[],
            className: null,
            description: null,
        },
        methods:{
            addClass(){
             
                // var myData = {name: this.className,description:this.description};

                axios.post("{{route('fixedAssetManagement.store')}}",{
                    name:this.className,
                    description:this.description
                })
                .then(function(response){
                    vu.showModal = false;
                    vu.className = null;
                    vu.description = null;
                    $('#nGOProjects').DataTable().ajax.reload();
                })
            }
        }
     });

     new Vue({
         el: '#company_ll',
         methods: {
             setCompany: function (event) {
                 if (typeof data_table == 'object'){
                     data_table.clear();
                     data_table.ajax.reload();
                     
                 }
             }
         }
     });




     //Begin Export Modal

    var vm = new Vue({

        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
            selectedproject: null,
            selectedBank: null,
            selectedAsset: null,
            selectedCategory: null,
            bank_id:[],
            projectList: [],
            bankList: [],
            customReportData:
            [      
            {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
            {Name: '@lang("layout.FixedAsset")', column_name: 'name',checkedColumn:(cust_rep.name)?'checked':'',column_percentage:(cust_rep.name___percent)?cust_rep.name___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
            {Name: '@lang("layout.BarcodeNumber")', column_name: 'barcode',checkedColumn:(cust_rep.barcode)?'checked':'',column_percentage:(cust_rep.barcode___percent)?cust_rep.barcode___percent:''},
            {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_rep.account)?'checked':'',column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''},
            {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
            {Name: '@lang("layout.SerialNum")', column_name: 'serialNum',checkedColumn:(cust_rep.serialNum)?'checked':'',column_percentage:(cust_rep.serialNum___percent)?cust_rep.serialNum___percent:''},
            {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_rep.category)?'checked':'',column_percentage:(cust_rep.category___percent)?cust_rep.category___percent:''},
            {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
            {Name: '@lang("layout.Location")', column_name: 'location',checkedColumn:(cust_rep.location)?'checked':'',column_percentage:(cust_rep.location___percent)?cust_rep.location___percent:''},
            {Name: '@lang("layout.Cost")', column_name: 'cost',checkedColumn:(cust_rep.cost)?'checked':'',column_percentage:(cust_rep.cost___percent)?cust_rep.cost___percent:''},
            {Name: '@lang("layout.Asset")', column_name: 'asset',checkedColumn:(cust_rep.asset)?'checked':'',column_percentage:(cust_rep.asset___percent)?cust_rep.asset___percent:''},
            {Name: '@lang("layout.PONumber")', column_name: 'pONumber',checkedColumn:(cust_rep.pONumber)?'checked':'',column_percentage:(cust_rep.pONumber___percent)?cust_rep.pONumber___percent:''},
            {Name: '@lang("layout.LifeSpan")', column_name: 'expireDate',checkedColumn:(cust_rep.expireDate)?'checked':'',column_percentage:(cust_rep.expireDate___percent)?cust_rep.expireDate___percent:''},
            {Name: '@lang("layout.ExpenseAccount")', column_name: 'expense',checkedColumn:(cust_rep.expense)?'checked':'',column_percentage:(cust_rep.expense___percent)?cust_rep.expense___percent:''},
            {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},
            ],
            cust_rep:cust_rep
        },

        watch: {
             selectedBank: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.id);
                    });
                    this.bank_id = x;
                    console.log('x value');
                    console.log(x);
                } 
            },
        
        methods: {
            closeModal: function () {
                this.is_show = !this.is_show;
            },
            onProjectSearch(search, loading) {
                loading(true);
                this.searchProject(search, loading, this);
            },

            //ajax call to get items
            searchProject(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        'search_column': 'name',
                        'table_name': 'fixed_asset_management',
                        keyword: search,
                    }
                })
                    .then(function (response) {
                        this.projectList = [];
                        if (response.data.length > 0) {
                            vm.projectList = response.data;
                            // console.log('data', vm.projectList);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
            },

            //ajax call to get items
            searchBank(search, loading) {
                var vm = this;
                loading(true);

                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        keyword: search,
                        table_name: 'accounts',
                        filterColumn: 'type',
                        filterValue: 'bank',
                    }
                })
                .then(function (response) {
                    this.bankList = [];
                    if (response.data.length > 0) {
                        vm.bankList = response.data;
                    }
                    loading(false);
                })
                .catch(function (error) {
                    console.log(error);
                })
            },
        }
    });

    var anchor = new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function () {
                // console.log('trr')
                vm.$data.is_show = true;
            }
        }
    });

</script>

@endpush
