@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet">
@stop
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.FixedAssetManagementCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom: 50%;" id="app" >
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'fixedAssetManagement.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                        <div class="row"> 
                            <div class="col-md-12"> 
                                <div class="col-md-12" style="padding: 0px;">
                                    <div class="col-md-4">
                                        <label class="control-label ">@lang('layout.Name') @lang('layout.Asset')</label>
                                        {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.Name')])}}
                                    </div>
                                    <div class="col-md-4">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="text" name="number" value="{{$number}}" class="form-control">
                                    </div>
                                    <div class="col-md-4">
                                        <label class="control-label">@lang('layout.BarcodeNumber')</label>
                                        <input type="text" name="barcode_number" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-12" style="padding: 0px;">
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.AssetAccount')</label>
                                        <v-select class="vue-select2" v-model="selectedAsset" label="name" :options="{{$getAsset}}">
                                        </v-select>
                                        <input type="hidden" name="asset_id" v-model.number="(!selectedAsset)?null:selectedAsset.id">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        <input type="text" class="form-control date" name="date" autocomplete="off" >
                                    </div>
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Type')</label>
                                        <select name="type" class="form-control">
                                            <option value="new">@lang('type.new')</option>
                                            <option value="used">@lang('type.used')</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Category')</label>
                                        <v-select class="vue-select2" v-model="selectedCategory" label="name" :options="{{$fixedAssetCategory}}">
                                        </v-select>
                                        <input type="hidden" name="category_id" v-model.number="(!selectedCategory)?null:selectedCategory.id">
                                    
                                    </div>
                                </div>
                                <div class="col-md-12" style="padding: 0px;">
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.PONumber')</label>
                                        <input type="text" name="po_number" class="form-control" placeholder="@lang('layout.PONumber')">
                                    </div>
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.SerialNum')</label>
                                        <input type="text" name="serial_number" class="form-control" placeholder="@lang('layout.SerialNum')">
                                    </div>
                                    <div class="col-md-4">
                                        <label class="control-label">@lang('layout.Location')</label>
                                        <input type="text" name="location" class="form-control" placeholder="@lang('layout.Location')">
                                    </div>
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.DateDepreciation')</label>
                                        <input type="text" class="form-control date" name="date_depreciation" autocomplete="off" >
                                    </div>
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                        <v-select class="vue-select2" v-model="selectedExpense" label="name" :options="{{$getExpense}}">
                                        </v-select>
                                        <input type="hidden" name="expense_id" v-model.number="(!selectedExpense)?null:selectedExpense.id">
                                    </div>
                                </div>
                                <div class="col-md-12" style="padding: 0px;">
                                    <div class="col-md-4">
                                        <label class="control-label">@lang('layout.Cost')</label>
                                        <input type="number" name="cost" class="form-control" step="any" placeholder="@lang('layout.Cost')">
                                    </div>
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="form-group">

                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.DepreciationType')</label>
                                                <select name="depreciation_type" class="form-control">
                                                    <option value="straightLineMethod">@lang('layout.StraightLineMethod')</option>
                                                    <option value="sumOfDigits">@lang('layout.SumOfDigits')</option>
                                                    <option value="reducingBalance">@lang('layout.ReducingBalance')</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                        <div class="form-group">

                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.DepreciationDurationType')</label>
                                                <select name="depreciation_duration_type" class="form-control">
                                                    <option value="yearly">@lang('layout.Yearly')</option>
                                                    <option value="montly">@lang('layout.Montly')</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.LifeSpan')</label>
                                        <input type="text" class="form-control date" name="expire_date" autocomplete="off" >
                                    </div>
                                </div>
                            </div> 
                        </div>  
                        <div class="row"> 
                            <div class="col-md-12"> 
                                <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class=" control-label">@lang('layout.Purchase')</label>
                                            <div>
                                                <label class="mt-checkbox mt-checkbox-outline">
                                                    <input type="checkbox" name="buy_check" v-model="buy_check">
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3" v-if="buy_check">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" @input="selectedRate" :options="currency"
                                                v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                </div>

                                <div class="col-md-2" v-if="buy_check">
                                    <label class="control-label">@lang('layout.Rate')</label>
                                    <input type="number" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :readonly="averageRate && selected_payment_type =='writeCheck'" :class="{'has-error':rate<=0}">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  v-if="buy_check">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.PaymentType')</label>
                                            <select name="payment_type" v-model="selected_payment_type" class="form-control">
                                                <option value="writeCheck">@lang('layout.Writecheck')</option>
                                                <option value="bill">@lang('layout.Bill')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="buy_check && selected_payment_type =='bill'">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Vendor')</label>
                                            <v-select label="name" :options="vendor" v-model="selected_vendor" @search="MemberSearch" ></v-select>
                                            <input type="hidden" name="vendor" :value="!selected_vendor?null:selected_vendor.id" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="buy_check && selected_payment_type =='writeCheck'">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>
                                            <v-select label="name" :options="approperiateBank" v-model="selected_banks"  @input="test(selected_banks)"></v-select>
                                            <input type="hidden" name="bank_account" :value="(this.selected_banks==null)?null:selected_banks.id">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-md-12"> 
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Note')</label>
                                    {!! Form::textarea('note', null, array('placeholder' => __('layout.Note'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                </div>
                            </div> 
                        </div> 
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" class="btn green" onclick="regForm(this)"> @lang('layout.Submit') </button>
                        <button href="{{url('fixedAssetManagement.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
 
@push('scripts')
<script>

    Vue.component('v-select', VueSelect.VueSelect);

    var currency = {!! $currency !!};
    var banks = {!! $banks !!};

    let vu = new Vue({
    el: '#app',
    data:{
        selectedAsset: null,
        selectedExpense: null,
        selectedCategory: null,
        selected_payment_type: 'writeCheck',
        currency: currency,
        selected_currency: defaultCurrency(),
        banks: banks,
        vendor: [],
        selected_vendor: null,
        selected_banks: null,
        defuilt_banks: null,
        rate: 0,
        buy_check: false,
        averageRate: false,
    },
    computed: {
        selectedRate() {
            this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
        },

        // filter the banks according to selected currency
        approperiateBank: function () {
            this.selected_banks=null;
            var bankCopy = this.banks.slice();
            var tempBank = bankCopy.filter((account) => {
                return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
            });
            if (tempBank.length > 0) {
                if (this.defuilt_banks) {
                    this.selected_banks = this.defuilt_banks;
                    this.defuilt_banks = null;
                }else{
                    this.selected_banks = tempBank[0];
                    @if(getAverageRate() =="true")
                    this.averageRate = false;
                    if (tempBank[0].avg_rate && this.selected_payment_type == 'writeCheck') {
                        this.set_avg_rate(tempBank[0].avg_rate);
                    }
                    @endif
                }
            }
            return tempBank;
        },
    },
    methods:{
        set_avg_rate(avg_rate) {
            setTimeout(() => {
                this.averageRate = true;
                this.rate = avg_rate;
                if (this.selected_currency) {
                    this.selected_currency.rate = avg_rate;
                }
            }, 300);
        },
        MemberSearch: _.debounce((search, loading) => {
            loading(true);
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    type: 'Vendor'
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    vu.vendor = [];
                    vu.vendor = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),
        
        test(defaultAccount) {
            this.averageRate = false;
            if (defaultAccount && this.selected_currency && this.selected_payment_type == 'writeCheck') {
                @if(getAverageRate() =="true")
                if (defaultAccount.avg_rate) {
                    this.rate = defaultAccount.avg_rate;
                    this.selected_currency.rate = defaultAccount.avg_rate;
                    this.averageRate = true;
                }
                @endif
            }
        },
        selectedRates() {
            
        },

    }
    });


</script>

@endpush