@extends('layouts.factor-master')


@section('content')
<?php
$report = customeReportNew('daily_fixedAsset_index');

$_number= !in_array('number', $report);
$_date = !in_array('date', $report);
$_description = !in_array('description', $report);
$_amount = !in_array('amount', $report);
$_currency = !in_array('currency', $report);
$_rate = !in_array('rate', $report);
$_category = !in_array('category', $report);
$_fixedAsset_account = !in_array('fixedAsset_account', $report);
$_bank_account = !in_array('bank_account', $report);
$_total = !in_array('total', $report);
$_build_fixedAsset = !in_array('build_fixedAsset', $report);
 
// dd("Hello");
 
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.FixedAssetManagementReport')</h3>

@if($from_date || $to_date)
<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>
</table>
@endif
{{-- @if($ClassName || count($fixedAsset_account_name)>0 || count($bank_account_name)>0 || $fixedAsset_category_name)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($ClassName)
      <td>
        <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
      </td>
      @endif
      @if(count($fixedAsset_account_name)>0)
      <td>
        <span>@lang('layout.fixedAssetAccount')</span>: 
        @foreach($fixedAsset_account_name as $fixedAsset_a)
        {{$fixedAsset_a->name}} , 
        @endforeach

      </td>
      @endif
      @if(count($bank_account_name)>0)
      <td>
        <span>@lang('layout.BankAccount')</span>: 
        @foreach($bank_account_name as $bank)
        {{$bank['name']}} , 
        @endforeach
      </td>
      @endif
      @if($fixedAsset_category_name)
      <td>
        <span>@lang('menu.fixedAssetCategory')</span>: {{$fixedAsset_category_name}}
      </td>
      @endif
    </tr>
</table>
@endif --}}

<table class="main-table">
    <tr class="bg">
        <td colspan="4">
            <div class="center">@lang('layout.TotalByFixedAssetCategory')</div>
        </td>
    </tr>
    <tr class="bg">
        <td class="center">@lang('layout.Record')</td>
        <td class="center">@lang('layout.FixedAssetCategory')</td>
        <td class="center">@lang('layout.FirstFixedAssetDate')</td>
        <td class="center">@lang('layout.LastFixedAssetDate')</td>
        <td class="center">@lang('layout.Quantity1')</td>
        <td class="center">@lang('layout.HomeCurrencyTotal')   {{getHomeCurrency()[getCurrencyType()]}}</td>
        <td class="center">@lang('layout.Currency')
        {{-- @if(count($bank_account_name)>0)
            @if($is_same_currency != false)
                {{$bank_account_name[0]['currency']}}
            @endif
        @endif --}}
        </td>
    </tr>
    <?php
    $count = 0;
    $total_home_currency = 0;    
    $total_records = 0;    
    $currencies=[];
    ?>
    @foreach ($count_data as $key => $fixedAsset)
    <?php
        $total_home_currency += $fixedAsset['total_exchanged_amount'];
        $total_records += $fixedAsset['total'];
    ?>
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$fixedAsset['category']}}</td>
            <td class="center">{{convertDate($fixedAsset['min_date'])}}</td>
            <td class="center">{{convertDate($fixedAsset['max_date'])}}</td>
            <td class="center">
                {{$fixedAsset['total']}}
            </td>
            <td class="center">
                {{myRound($fixedAsset['total_exchanged_amount'])}}
            </td>
            <td>
                <table class="main-table">
                    <tbody>
                        @if($fixedAsset['by_currency'])
                        @foreach($fixedAsset['by_currency'] AS $key1=>$rec)
                        <?php
                        if(array_key_exists($rec->currency, $currencies))
                        {
                            $currencies[$rec->currency]=$currencies[$rec->currency]+$rec->TotalCost;
                        } else {
                            $currencies[$rec->currency]=$rec->TotalCost;
                        }
                        ?>
                        <tr>
                            <td class="center"> {{myRound($rec->TotalCost)}}  {{$rec->currency}}
                                {{-- @if($is_same_currency == false){{$rec->Currency}}@endif --}}
                            </td>
                        </tr>
                        @endforeach
                        @endif
                    </tbody>
                </table>
            </td>

        </tr>
    @endforeach

    <tr class="bg">
        <td colspan="4" rowspan="{{count($currencies)+1}}" ></td>
        <td  class="center" rowspan="{{count($currencies)+1}}">{{ $total_records }}</td>
        <td  class="center" rowspan="{{count($currencies)+1}}">{{myRound($total_home_currency)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>

    <?php
    foreach($currencies As $key=>$currency)
    {
    ?>
    <tr class="bg">
        <td colspan="1" class="center">{{myRound($currency)}} {{$key}}</td>
    </tr>
    <?php
    }
    ?>


</table>
{{--  --}}


<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection