@extends('layouts.factor-master')
@section('content')
    <?php
    $report = customeReportNew('fixed_asset_management_index');

    $_number = !in_array('number', $report);
    $_name = !in_array('name', $report);
    $_description = !in_array('description', $report);
    $_location = !in_array('location', $report);
    $_date = !in_array('date', $report);
    $_serialNum = !in_array('serialNum', $report);
    $_category = !in_array('category', $report);
    $_type = !in_array('type', $report);
    $_cost = !in_array('cost', $report);
    $_asset = !in_array('asset', $report);
    $_expireDate = !in_array('expireDate', $report);
    $_status = !in_array('status', $report);
    $_pONumber = !in_array('pONumber', $report);
    $_barcode = !in_array('barcode', $report);
    $_account = !in_array('account', $report);
    $_currency = !in_array('currency', $report);

$report_percent = customeReportNewPercent('fixed_asset_management_index');
$_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
$_name_percent= (array_key_exists('name___percent', $report_percent))?$report_percent['name___percent']:null;
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
$_location_percent= (array_key_exists('location___percent', $report_percent))?$report_percent['location___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_serialNum_percent= (array_key_exists('serialNum___percent', $report_percent))?$report_percent['serialNum___percent']:null;
$_category_percent= (array_key_exists('category___percent', $report_percent))?$report_percent['category___percent']:null;
$_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
$_asset_percent= (array_key_exists('asset___percent', $report_percent))?$report_percent['asset___percent']:null;
$_cost_percent= (array_key_exists('cost___percent', $report_percent))?$report_percent['cost___percent']:null;
$_expireDate_percent= (array_key_exists('expireDate___percent', $report_percent))?$report_percent['expireDate___percent']:null;
$_status_percent= (array_key_exists('status___percent', $report_percent))?$report_percent['status___percent']:null;
$_pONumber_percent= (array_key_exists('pONumber___percent', $report_percent))?$report_percent['pONumber___percent']:null;
$_barcode_percent= (array_key_exists('barcode___percent', $report_percent))?$report_percent['barcode___percent']:null;
$_account_percent= (array_key_exists('account___percent', $report_percent))?$report_percent['account___percent']:null;
$_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;

?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.FixedAssetManagementReport')</h3>
@if($fixedAssetCategory_name || $from_amount || $to_amount || $asset_type  || $fixedAssetname_name  || $asset_account_name || count($bank_account_name)>0   || $from_depre_amount  || $to_depre_amount || $status)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($fixedAssetCategory_name)
      <td>
        <span>@lang('layout.Category')</span>: {{$fixedAssetCategory_name}}
      </td>
      @endif           
      @if($from_amount)
      <td>
        <span> @lang('layout.Cost') @lang('layout.From')</span>: {{$from_amount}}  {{getHomeCurrency()[getCurrencyType()]}}
      </td>
      @endif 
      @if($to_amount)
      <td>
        <span>@lang('layout.To')</span>: {{$to_amount}}  {{getHomeCurrency()[getCurrencyType()]}}
      </td>
      @endif          
      @if($from_depre_amount)
      <td>
        <span> @lang('layout.AssetValue') @lang('layout.From')</span>: {{$from_depre_amount}}  {{getHomeCurrency()[getCurrencyType()]}}
      </td>
      @endif 
      @if(count($bank_account_name)>0)
        <td>
          <span>@lang('layout.BankAccount')</span>:
          @foreach($bank_account_name as $bank)
          {{$bank['name']}} , 
          @endforeach
          @if(count($bank_account_name) == 1)
          <span>{{$bank_account_name[0]['currency']}}</span>
          @endif
        </td>
      @endif
      @if($to_depre_amount)
      <td>
        <span>@lang('layout.To')</span>: {{$to_depre_amount}}  {{getHomeCurrency()[getCurrencyType()]}}
      </td>
      @endif 
      @if($asset_type)
      <td>
        <span>@lang('layout.Type')</span>: {{__('type.'.$asset_type)}}
      </td>
      @endif 
      @if($fixedAssetname_name)
      <td>
        <span>@lang('layout.Name')</span>: {{$fixedAssetname_name}}
      </td>
      @endif 
      @if($asset_account_name)
      <td>
        <span>@lang('layout.Asset')</span>: {{$asset_account_name}}
      </td>
      @endif 
      
      @if($status)
      @if($status == 'on')
      <td>
        <span>@lang('layout.Status')</span>: @lang('layout.Active')
      </td>
      @else
      <td>
        <span>@lang('layout.Status')</span>: @lang('layout.InActive')
      </td>
      @endif  
      @endif  
    </tr>
</table> 
@endif

<table>
  <tr>
    @if($asset_type)
    <td>
      <span>@lang('layout.Type')</span>: {{__('type.'.$asset_type)}}
    </td>
    @endif 
  </tr>
</table>

<table class="main-table">
<thead>
<tr class="bg" >
  <th><div class="center" > @lang('layout.Record') </div></th>
   @if($_number)<th  @if($_number_percent) width="{{$_number_percent}}%" @endif><div class="center" > @lang('layout.Number') </div></th>@endif
   @if($_date)<th @if($_date_percent) width="{{$_date_percent}}%" @endif><div class="center" > @lang('layout.Date')</div></th>@endif 
   @if(!$fixedAssetname_name) @if($_name)<th @if($_name_percent) width="{{$_name_percent}}%" @endif><div class="center"  > @lang('layout.Name')</div></th>@endif @endif
   @if($_description)<th @if($_description_percent) width="{{$_description_percent}}%" @endif><div class="center" > @lang('layout.Description')</div></th>@endif
   @if(!$fixedAssetCategory_name) @if($_category)<th @if($_category_percent) width="{{$_category_percent}}%" @endif><div class="center" > @lang('layout.Category')</div></th>@endif  @endif
   @if($_location)<th @if($_location_percent) width="{{$_location_percent}}%" @endif><div class="center" > @lang('layout.Location')</div></th>@endif
   @if($_barcode)<th @if($_barcode_percent) width="{{$_barcode_percent}}%" @endif><div class="center" > @lang('layout.BarcodeNumber')</div></th>@endif
   @if($_pONumber)<th @if($_pONumber_percent) width="{{$_pONumber_percent}}%" @endif><div class="center" > @lang('layout.PONumber')</div></th>@endif
   @if(count($bank_account_name) < 1) @if($_account)<th @if($_account_percent) width="{{$_account_percent}}%" @endif><div class="center" > @lang('layout.Account')</div></th>@endif @endif
   @if($_cost)<th @if($_cost_percent) width="{{$_cost_percent}}%" @endif><div class="center" > @lang('layout.Cost')</div></th>@endif 
   @if($_currency)<th @if($_currency_percent) width="{{$_currency_percent}}%" @endif><div class="center" > @lang('layout.Currency')</div></th>@endif 
   @if($_cost)<th @if($_cost_percent) width="{{$_cost_percent}}%" @endif><div class="center" > @lang('layout.Rate')</div></th>@endif 
   @if($_cost)<th @if($_cost_percent) width="{{$_cost_percent}}%" @endif><div class="center" > @lang('layout.Cost') ({{getHomeCurrency()[getCurrencyType()]}})</div></th>@endif 
   @if($_expireDate)<th @if($_expireDate_percent) width="{{$_expireDate_percent}}%" @endif><div class="center"  > @lang('layout.LifeSpan')</div></th>@endif
   @if($_cost)<th  @if($_cost_percent) width="{{$_cost_percent}}%" @endif><div class="center"> @lang('layout.AssetValue')  ({{getHomeCurrency()[getCurrencyType()]}})</div></th>@endif 
   @if(!$asset_type) @if($_type)<th @if($_type_percent) width="{{$_type_percent}}%" @endif><div class="center" > @lang('layout.Type')</div></th>@endif  @endif
   @if($_serialNum)<th @if($_serialNum_percent) width="{{$_serialNum_percent}}%" @endif><div class="center" > @lang('layout.SerialNum')</div></th>@endif
   @if(!$asset_account_name) @if($_asset)<th @if($_asset_percent) width="{{$_asset_percent}}%" @endif><div class="center" > @lang('layout.Asset')</div></th>@endif  @endif
   @if(!$status)@if($_status)<th @if($_status_percent) width="{{$_status_percent}}%" @endif><div class="center"> @lang('layout.Status')</div></th>@endif  @endif
   <th><div class="center"> @lang('layout.User')</div></th> 
</tr>
</thead>
<?php
$count = 0;
$totales = 0;
$total_cost = 0;
$currencies_in=[];
$colspan = 13; 
?>
@foreach($data AS $record)
<tr>
  <?php  
      $total_cost =  $totales +  ($record['Cost']);
      $totales =  $totales +  ($record['Cost'] - $record['depre_amount']);

      if($record['static_rate'] == ''){
        $record['static_rate'] = 1;
      } 
      if($record['rate'] == ''){
        $record['rate'] = $record['fix_rate']  ;
      }

      if($record['Cost']>0){
          if(array_key_exists($record['currency'], $currencies_in))
          {
            
            if(systemConfig()[30] == 1){
              $currencies_in[$record['currency']]['Cost']=$currencies_in[$record['currency']]['Cost']+($record['Cost']*$record['static_rate'] / $record['rate']);
            }else{
              $currencies_in[$record['currency']]['Cost']=$currencies_in[$record['currency']]['Cost']+($record['Cost']*$record['rate']);
            }

              $currencies_in[$record['currency']]['base_amount']=$currencies_in[$record['currency']]['base_amount']+$record['Cost'];
          
            }
          else
          {
            if(systemConfig()[30] == 1){
              $currencies_in[$record['currency']]['Cost']=($record['Cost']*$record['static_rate'] / $record['rate']);
            }else{
              $currencies_in[$record['currency']]['Cost']=($record['Cost']*$record['rate']);
            }

              $currencies_in[$record['currency']]['base_amount']=$record['Cost'];
          }
      }
  ?>
<td class="center">{{++$count}}</td>
@if($_number)<td class="center">{{$record['number']}}</td>@endif
@if($_date)<td class="center" >{{convertDate($record['date'])}}</td>@endif
@if(!$fixedAssetname_name) @if($_name)<td class="center">{{$record['name']}}</td>@endif @endif
@if($_description)<td style="@if($_description_percent) text-align: justify @endif" >{{$record['description']}}</td>@endif
@if(!$fixedAssetCategory_name) @if($_category)<td class="center" > {{$record['category']}}</td>@endif @endif
@if($_location)<td class="center" >{{$record['location']}}</td>@endif
@if($_barcode)<td class="center" >{{$record['barcode_number']}}</td>@endif
@if($_pONumber)<td class="center" > {{$record['po_number']}}</td>@endif
@if(!$bank_account_name) @if($_account)<td class="center" > {{$record['bank_name']}}</td>@endif @endif
@if(systemConfig()[30] == 1)
@if($_cost)<th @if($_cost_percent) width="{{$_cost_percent}}%" @endif><div class="center" > {{myRound($record['Cost'] * $record['static_rate'] / $record['rate'])}} </div></th>@endif 
@else 
@if($_cost)<th @if($_cost_percent) width="{{$_cost_percent}}%" @endif><div class="center" > {{myRound($record['Cost'] * $record['rate'])}} </div></th>@endif 
@endif
@if($_currency)<td class="center" >{{$record['currency']}}</td>@endif
@if($_cost)<th @if($_cost_percent) width="{{$_cost_percent}}%" @endif><div class="center" >{{myRound($record['rate'])}}</div></th>@endif 
@if($_cost)<td class="center" >{{ myRound($record['Cost'])}}</td>@endif
@if($_expireDate)<td class="center">{{convertDate($record['expire_date'])}}</td>@endif
@if($_cost)<td class="center" >{{ myRound($record['Cost'] - $record['depre_amount'])}} </td>@endif
@if(!$asset_type) @if($_type)<td class="center" > {{__('type.'.$record['type'])}}</td>@endif @endif
@if($_serialNum)<td class="center" >{{$record['serial_number']}}</td>@endif
@if(!$asset_account_name) @if($_asset)<td class="center" > {{$record['asset_name']}}</td>@endif @endif
@if(!$status) @if($_status)<td class="center" > {{__('type.'.$record['status'])}}</td>@endif @endif
<td>{{$record['user']}}</td>
</tr>
@endforeach
<tr>
  @if(!$_number)  <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_date)  <?php  $colspan = $colspan-1;  ?>  @endif
  @if($fixedAssetname_name) @if(!$_name)  <?php  $colspan = $colspan-1;  ?>  @endif @endif
  @if(!$_description)  <?php  $colspan = $colspan-1;  ?>  @endif
  @if($fixedAssetCategory_name) @if(!$_category)  <?php  $colspan = $colspan-1;  ?>  @endif @endif
  @if(!$_location)  <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_barcode)  <?php  $colspan = $colspan-1; ?>  @endif
  @if(!$_pONumber)  <?php  $colspan = $colspan-1;  ?>  @endif
  @if($bank_account_name)  @if(!$_account)  <?php  $colspan = $colspan-1;  ?>  @endif  @endif
  @if(!$_cost)  <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_currency)  <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_cost)  <?php  $colspan = $colspan-1;  ?>  @endif
  
  <td colspan="{{$colspan}}"> @lang('layout.Total') </td>
  
  @if($_cost)<td colspan="1"> {{myRound($total_cost)}} </td>@endif
  @if($_expireDate)<td >  </td> @endif
  @if($_cost)<td colspan="1"> {{myRound($totales)}} </td>@endif
</tr>
</table>
@if(isset($detail))
<h4 class="table-caption" style="text-align: center;">@lang('layout.FixAssetDepreciation')</h4>
<table class="main-table">
<thead>
<tr class="bg" >
   <td class="center" ><div>@lang('layout.Record')</div></td>
   <td class="center" ><div> @lang('layout.FixedAsset')</div></td>
   <td class="center" ><div> @lang('layout.Expense')</div></td>
   <td class="center" ><div> @lang('layout.Amount')</div></td> 
   <td class="center" ><div> @lang('layout.Currency')</div></td> 
   <td class="center" ><div> @lang('layout.Description')</div></td>
   <td class="center" ><div> @lang('layout.Date')</div></td> 
   <td class="center" ><div> @lang('layout.User')</div></td> 
</tr>
</thead>
<?php
$count = 0;
$total = 0;
?>
@foreach($detail AS $record1)
<?php
$total += $record1['Amount'];
?>
<tr>
<td class="center">{{$record1['id']}}</td>
<td class="center">{{$record1['fixed_asset']}}</td>
<td class="center">{{$record1['expense_name']}}</td>
<td class="center"> {{myRound($record1['Amount'])}}</td>
<td class="center"> {{$record1['unit']}}</td>
<td class="center">{{$record1['description']}}</td>
<td class="center">{{convertDate($record1['date'])}}</td>
<td style="text-align: justify">{{$record1['user']}}</td>
</tr>
@endforeach
<tr class="bg" >
    <td colspan="2" class="center">@lang('layout.Total')</td>
    <td colspan="2" class="center">{{myRound($total)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>
</tr>
</table>
@endif
 <!--  signature -->

 <table class="main-table" style="margin-top:1%">

  <tr>
    <td>
      <div class="center"> @lang('layout.Record') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Currency') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}} </div>
    </td>
    <td>
      <div class="center"> @lang('layout.AverageRate') </div>
    </td>
  </tr>
  <?php
$count=0;
foreach($currencies_in As $key=>$currency)
{
?>
  <tr>
    <td>
      <div class="center">{{++$count}}</div>
    </td>
    <td>
      <div class="center">{{$key}}</div>
    </td>
    <td>
      <div class="center">{{myRound($currency['Cost'])}}</div>
    </td>
    <td>
      <div class="center">{{myRound($currency['base_amount'])}}</div>
    </td>
    <td>
      <div class="center">
        {{-- {{myRound($currency['Cost'] / $currency['base_amount'])}} --}}
      {{-- kljkjhkjh --}}
        <div class="center">{{myRound((((systemConfig()[30] == 1 && (currencyList($key)[0]->static_rate))?1:0)?((currencyList($key)[0]->static_rate)/($currency['Cost']/$currency['base_amount'])):($currency['Cost']/$currency['base_amount'])))}}</div>

      </div>
    </td>

  </tr>
  <?php
}
?>
</table>
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >       
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
         @endforeach
    </tr>
</table>





 <!-- End signature -->
@endsection