@extends('layouts.factor-master')

@section('content')

    <?php
    $report = customeReportNew('fixed_asset_management_index');

    $_number = !in_array('number', $report);
    $_name = !in_array('name', $report);
    $_description = !in_array('description', $report);
    $_location = !in_array('location', $report);
    $_date = !in_array('date', $report);
    $_serialNum = !in_array('serialNum', $report);
    $_category = !in_array('category', $report);
    $_type = !in_array('type', $report);
    $_cost = !in_array('cost', $report);
    $_asset = !in_array('asset', $report);
    $_expireDate = !in_array('expireDate', $report);
    $_expense = !in_array('expense', $report);
    $_status = !in_array('status', $report);
    $_pONumber = !in_array('pONumber', $report);
    ?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.FixedAssetManagementReport')</h3>
<table class="main-table">

<thead>
<tr class="bg" >
   @if($_number)<td  class="center"><div> @lang('layout.Number') </div></td>@endif
   @if($_date)<td  class="center"><div> @lang('layout.Date')</div></td>@endif 
   @if($_name)<td  class="center"><div> @lang('layout.FixedAsset')</div></td>@endif
   @if($_serialNum)<td  class="center"><div> @lang('layout.SerialNum')</div></td>@endif
   @if($_category)<td  class="center"><div> @lang('layout.Category')</div></td>@endif
   @if($_type)<td  class="center"><div> @lang('layout.Type')</div></td>@endif 
   @if($_cost)<td  class="center"><div> @lang('layout.Cost')</div></td>@endif 
   @if($_cost)<td  class="center"><div> @lang('layout.AssetValue')</div></td>@endif 
   @if($_asset)<td  class="center"><div> @lang('layout.Asset')</div></td>@endif 
   @if($_location)<td  class="center"><div> @lang('layout.Location')</div></td>@endif
   @if($_pONumber)<td  class="center"><div> @lang('layout.PONumber')</div></td>@endif
   @if($_expireDate)<td  class="center"><div> @lang('layout.LifeSpan')</div></td>@endif
   @if($_expense)<td  class="center"><div> @lang('layout.ExpenseAccount')</div></td>@endif
   <td  class="center"><div> @lang('layout.User')</div></td> 
   @if($_status)<td class="center"><div> @lang('layout.Status')</div></td>@endif 
</tr>
</thead>
<?php
$count = 0;

?>

<tr>
@if($_number)<td class="center">{{$data->number}}</td>@endif
@if($_date)<td class="center">{{convertDate($data->date)}}</td>@endif
@if($_name)<td class="center">{{$data->name}}</td>@endif
@if($_serialNum)<td class="center">{{$data->serial_number}}</td>@endif
@if($_category)<td class="center">{{$data->category}}</td>@endif
@if($_type)<td class="center"> {{__('type.'.$data->type)}}</td>@endif
@if($_cost)<td class="center">{{ myRound($data->Cost)}} {{ $data->unit}}</td>@endif
@if($_cost)<td class="center">{{ myRound($data->Cost - $data->depre_amount)}} {{ $data->unit}}</td>@endif
@if($_asset)<td class="center"> {{$data->asset_name}}</td>@endif
@if($_location)<td class="center">{{$data->location}}</td>@endif
@if($_pONumber)<td class="center"> {{$data->po_number}}</td>@endif
@if($_expireDate)<td class="center">{{convertDate($data->expire_date)}}</td>@endif
@if($_expense)<td class="center">{{$data->expense_name}}</td>@endif
<td class="center">{{$data->user}}</td>
@if($_status)<td class="center"> {{__('type.'.$data->status)}}</td>@endif
</tr>

</table>
@if($data->buy_check)
    <table class="main-table">
        <thead>
            <tr class="bg">
                
                <th>@lang('layout.Currency') </th>
                <th>@lang('layout.Rate') </th>
                <th>@lang('layout.Amount')</th>
                <th>@lang('layout.PaymentType')</th>
                <th>@lang('layout.Account')</th>
            </tr>
        </thead>
        <tbody> 
            <tr>  
                <td class="hidden-xs"> {{ $data->currency}}</td>
                <td class="hidden-xs"> {{ $data->rate}}</td>
                <td class="hidden-xs"> {{ $amount}}</td>
                <td class="hidden-xs"> {{ __('layout.'.ucfirst($data->payment_type))}}</td>
                <td class="hidden-xs"> {{ $account}}</td>
            </tr>
        </tbody>
    </table>
@endif
    <table class="main-table">
        <thead>
            <tr class="bg">
                <th>@lang('layout.DepreciationType') </th>
                <th>@lang('layout.DepreciationDurationType') </th>
                <th>@lang('layout.DateDepreciation') </th>
                <th>@lang('layout.Description') </th>
                <th>@lang('layout.Note')</th>
            </tr>
        </thead>
        <tbody> 
            <tr>  
                <td class="hidden-xs"> {{ __('layout.'.ucfirst($data->depreciation_type))}}</td>
                <td class="hidden-xs"> {{ __('layout.'.ucfirst($data->depreciation_duration_type))}}</td>
                <td class="hidden-xs"> {{ convertDate($data->date_depreciation)}}</td>
                <td class="hidden-xs"> {{ $data->description}}</td>
                <td class="hidden-xs"> {{ $data->note}}</td>
            </tr>
        </tbody>
    </table>
@if(isset($detail))

<h4 class="table-caption" style="text-align: center;">@lang('layout.CalculateDepreciation')</h4>
@if(count($depreciation_data) > 0)
<table class="main-table">
    <thead>
        <tr class="bg" >
            <th>@lang('layout.Period') </th>
            <th>@lang('layout.Date') </th>
            <th>@lang('layout.AssetValue')</th>
            <th>@lang('layout.DepreciationAmount')</th>
            <th>@lang('layout.DepreciationPercent')</th>
            <th>@lang('layout.TotalDepreciation')</th>
            <th>@lang('layout.RemainAmount')</th>
        </tr>
    </thead>
    <tbody> 
        @foreach($depreciation_data AS $record)
        <tr>  
            <td class="hidden-xs"> {{$record['year']}}</td>
            <td class="hidden-xs"> {{convertDate(date_format($record['year_end'], 'Y-m-d'))}}</td>
            <td class="hidden-xs"> {{myRound($record['amount'])}}</td>
            <td class="hidden-xs"> {{myRound($record['year_amount'])}}</td>
            <td class="hidden-xs"> {{round($record['depr_percent'])}} %</td>
            <td class="hidden-xs"> {{myRound($record['year_amount_total'])}}</td>
            <td class="hidden-xs"> {{myRound($record['amount_total'])}}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endif

<h4 class="table-caption" style="text-align: center;">@lang('layout.FixAssetDepreciation')</h4>
<table class="main-table">
<thead>
<tr class="bg" >
   <td class="center" ><div>@lang('layout.Record')</div></td>
   <td class="center" ><div> @lang('layout.FixedAsset')</div></td>
   <td class="center" ><div> @lang('layout.Expense')</div></td>
   <td class="center" ><div> @lang('layout.Amount')</div></td> 
   <td class="center" ><div> @lang('layout.Currency')</div></td> 
   <td class="center" ><div> @lang('layout.Description')</div></td>
   <td class="center" ><div> @lang('layout.Date')</div></td> 
   <td class="center" ><div> @lang('layout.User')</div></td> 
</tr>
</thead>
<?php
$count = 0;
$total = 0;
?>

@foreach($detail AS $record1)
<?php
$total += $record1['Amount'];
?>
<tr>
<td class="center">{{$record1['id']}}</td>
<td class="center">{{$record1['fixed_asset']}}</td>
<td class="center">{{$record1['expense_name']}}</td>
<td class="center"> {{myRound($record1['Amount'])}}</td>
<td class="center"> {{$record1['unit']}}</td>
<td class="center">{{$record1['description']}}</td>
<td class="center">{{convertDate($record1['date'])}}</td>
<td class="center">{{$record1['user']}}</td>
</tr>
@endforeach
<tr class="bg" >
    <td colspan="2" class="center">@lang('layout.Total')</td>
    <td colspan="2" class="center">{{myRound($total)}} {{getHomeCurrency()[getCurrencyType()]}}</td>
</tr>
</table>

@endif
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection

