@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet">
@stop
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.FixAssetDepreciationEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom: 50%;" id="app" >
                <!-- BEGIN FORM-->
                {!! Form::model($fixAssetDepreciation,['method' => 'PATCH','route' => ['fixAssetDepreciation.update',$fixAssetDepreciation->id],'class'=>'form-horizontal']) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                        <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.FixedAsset')</label>
                                <v-select class="vue-select2" v-model="selectedAsset" label="name" :options="{{$fixedAsset}}">
                                </v-select>
                                <input type="hidden" name="fixed_asset_id" v-model.number="(!selectedAsset)?null:selectedAsset.id">
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                <v-select class="vue-select2" v-model="selectedExpense" label="name" :options="{{$expense}}">
                                </v-select>
                                <input type="hidden" name="expense_id" v-model.number="(!selectedExpense)?null:selectedExpense.id">
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Date')</label>
                                <input type="text" class="form-control date" value="{{$fixAssetDepreciation->date}}" name="date">
                            </div>
                            <div class="col-md-12" style="padding: 0px;">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    <input type="number" name="amount" value="{{$fixAssetDepreciation->amount}}" class="form-control" step="any" placeholder="@lang('layout.Amount')">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.DateDepreciation')</label>
                                    <input type="text" class="form-control date" name="date_depreciation" value="{{$selected_fixedAsset->date_depreciation}}">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                </div>
                            </div>
                        </div> 
                        </div>  
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" class="btn green" onclick="regForm(this)"> @lang('layout.Update') </button>
                        <button href="{{url('fixAssetDepreciation.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
 
@push('scripts')
<script>

    Vue.component('v-select', VueSelect.VueSelect);
    let fixedAsset = {!! $fixedAsset !!};
    let expense = {!! $expense !!};
    let vu = new Vue({
    el: '#app',
    data:{
        selectedAsset: null,
        fixedAsset: fixedAsset,
        selectedExpense: null,
        expense: expense,
        donator: null,
        donatorData: [],
    },
    mounted: function () {
        if ("{{$fixAssetDepreciation->fixed_asset_id}}") {
            this.selectedAsset=_.find(this.fixedAsset,(v)=>v.id=="{{$fixAssetDepreciation->fixed_asset_id}}");
        }
        if ("{{$fixAssetDepreciation->expense_id}}") {
            this.selectedExpense=_.find(this.expense,(v)=>v.id=="{{$fixAssetDepreciation->expense_id}}");
        }
    },
    methods:{
        addClass(){
            
        },

        // generic function for adding item to list
        addNew(type = null, index) {
            if (type != null) {
                if (type == 'donator') {
                    if (this.donatorData[index + 1] == undefined) {
                        this.donatorData.push({description: null, donator_list: this.donator, selected: null});
                    }
                }
            }

        },

        // delete item from list
        deleteItem(type = null, index) {
            if (type != null) {
                if (type == 'donator') {
                    this.donatorData.splice(index, 1);
                }
            }

        },
    }
    });


</script>

@endpush