@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet">
@stop
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.FixAssetDepreciationCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom: 50%;" id="app" >
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'fixAssetDepreciation.directStore','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                        <div class="row"> 
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Date')</label>
                                <input type="text" class="form-control date" name="date" @click="get_depreciation_amount()" v-model="date" ref="date" autocomplete="off" placeholder="@lang('layout.Date')">
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.FixedAsset')</label>
                                <v-select class="vue-select2" v-model="selectedAsset" label="name" @input="get_depreciation_amount()" @Click.native="get_depreciation_amount()" :options="{{$fixedAsset}}">
                                </v-select>
                                <input type="hidden" name="fixed_asset_id" v-model.number="(!selectedAsset)?null:selectedAsset.id">
                                <input type="hidden" name="amount" v-model="amount" class="form-control" step="any" placeholder="@lang('layout.Amount')">
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Amount')</label>
                                <input v-model="fixedAssetAmount" class="form-control" placeholder="@lang('layout.Amount')" readonly>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                <v-select class="vue-select2" v-model="selectedExpense" label="name" :options="{{$expense}}">
                                </v-select>
                                <input type="hidden" name="expense_id" v-model.number="(!selectedExpense)?null:selectedExpense.id">
                            </div>
                            <div class="col-md-4" style="padding: 0px;">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                            </div>
                        </div>  
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" class="btn green" onclick="regForm(this)"> @lang('layout.Submit') </button>
                        <button href="{{url('fixAssetDepreciation.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
 
@push('scripts')
<script>

    Vue.component('v-select', VueSelect.VueSelect);
    
    let vu = new Vue({
    el: '#app',
    data:{
        selectedAsset: null,
        selectedExpense: null,
        amount: 0,
        fixedAssetAmount: 0,
        date: null,
    },
    methods:{
        addClass(){
            
        },
        get_depreciation_amount() {
            vu.date = vu.$refs.date.value;
            // console.log(444, vu.selectedAsset, vu.date, vu.$refs.date.value);
            if (vu.selectedAsset != null && vu.date) {
                let date = vu.date
                let selectedAsset_id = vu.selectedAsset.id
                // console.log(333, date, selectedAsset_id);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getDepreciationAmount',
                        selectedAsset_id: selectedAsset_id,
                        date: date
                    }
                })
                .then(function (response) {
                    if (response.data) {
                        vu.fixedAssetAmount = response.data.data.fixedAssetAmount;
                        vu.amount = response.data.data.fixedAssetAmount;
                        // console.log(3334, response.data.data);
                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            }

        },
    }
    });


</script>

@endpush