@extends('layouts.factor-master')

@section('content')

    <?php
    $report = customeReportNew('fix_asset_depreciation_index');

    $_fixedAsset = !in_array('fixedAsset', $report);
    $_description = !in_array('description', $report);
    $_date = !in_array('date', $report);
    $_expense = !in_array('expense', $report);
    $_amount = !in_array('amount', $report);
    $_currency = !in_array('currency', $report);



    $report_percent = customeReportNewPercent('fix_asset_depreciation_index');
    $_fixedAsset_percent= (array_key_exists('fixedAsset___percent', $report_percent))?$report_percent['fixedAsset___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_expense_percent= (array_key_exists('expense___percent', $report_percent))?$report_percent['expense___percent']:null;
    $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;



    ?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.FixAssetDepreciationReport')</h3>
<table class="main-table">

<thead>
<tr class="bg" >
   <td class="center"><div>@lang('layout.Record')</div></td>
   @if($_date)<td  @if($_date_percent) width="{{$_date_percent}}%" @endif class="center"><div> @lang('layout.Date')</div></td>@endif 
   @if($_description)<td  @if($_description_percent) width="{{$_description_percent}}%" @endif class="center"><div> @lang('layout.Description')</div></td>@endif
   @if($_fixedAsset)<td  @if($_fixedAsset_percent) width="{{$_fixedAsset_percent}}%" @endif class="center"><div> @lang('layout.FixedAsset')</div></td>@endif
   @if($_expense)<td  @if($_expense_percent) width="{{$_expense_percent}}%" @endif class="center"><div> @lang('layout.Expense')</div></td>@endif
   @if($_amount)<td  @if($_amount_percent) width="{{$_amount_percent}}%" @endif class="center"><div> @lang('layout.Amount')</div></td>@endif 
   @if($_currency)<td  @if($_currency_percent) width="{{$_currency_percent}}%" @endif class="center"><div> @lang('layout.Currency')</div></td>@endif 
   <td class="center"><div > @lang('layout.User')</div></td> 
</tr>
</thead>
<?php
$count = 0;

?>

@foreach($data AS $record)
<tr>
<td class="center">{{$record['id']}}</td>
@if($_date)<td class="center">{{convertDate($record['date'])}}</td>@endif
@if($_description)<td style="@if($_description_percent) text-align: justify @endif">{{$record['description']}}</td>@endif
@if($_fixedAsset)<td class="center">{{$record['fixed_asset']}}</td>@endif
@if($_expense)<td class="center">{{$record['expense_name']}}</td>@endif
@if($_amount)<td class="center"> {{myRound($record['Amount'])}}</td>@endif
@if($_currency)<td class="center"> {{$record['unit']}}</td>@endif
<td style="text-align: justify">{{$record['user']}}</td>
</tr>
@endforeach

</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection

