@extends('layouts.app')
@section('content')
@include('member_classes.modal')


<!-- END PAGE HEADER-->

<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.ClassList') </span>
            </div>
             <div class="btn-group pull-right">
                    <!-- <a href="{{route('financialClass.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a> -->
                    <div id="financialClass" v-cloak>
                        
                         <button class="btn btn-success" id="show-modal" @click="showModal =true">@lang('layout.AddNew')</button>

                         <modal v-if="showModal" @close="showModal = false">
                            <div slot="header">
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <h3>
                                        @lang('layout.ClassCreate')
                                    </h3>
                                </div>
                                <div class="col-md-4">
                                    <div v-if="fieldErrors.length > 0">
                                        <p class="text-danger" fieldErrors>
                                            <spna v-text="fieldErrors"></spna>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div slot="body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Name") <span class="required"> * </span></label>
                                            <input type="text" class="form-control" name="name" v-model="className">
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description") <span class="required"> * </span></label>
                                            <textarea class="form-control" name="description" v-model="description">
                                                
                                            </textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label> IP <span class="required"> </span></label>
                                            <input type="text" class="form-control" name="finger_ip" v-model="finger_ip">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label> Port <span class="required"> </span></label>
                                            <input type="number" class="form-control" name="finger_port" v-model="finger_port">
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div slot="footer">
                                <button type=button class="btn btn-success" @click="addClass" >
                                    @lang('layout.OK')
                                </button>
                                <button type=button class="btn btn-danger"
                                       @click="showModal =false" >
                                    @lang('layout.Cancel')
                                </button>
                            </div>
                        </modal>
                        
                    </div>

            </div>
        </div>
        <div class="portlet-body">

            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>

            <table class="table table-striped table-bordered table-hover" cellspacing="1" id="financialClasses" width="100%">
                <thead>
                <tr> 
                    <th>@lang('layout.ID')</th>
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.Description') </th>
                    <th> IP </th>
                    <th> Port </th>
                    <th>@lang('layout.CreatedAt') </th>
                    <th>@lang('layout.Action') </th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    let data_table;
     $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        data_table = $('#financialClasses').DataTable( {
            ajax: '{{route("financialClass.index")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging:         true,
            columns: [
            { data: 'id', name: 'id' },
            { data: 'name', name: 'name' },
            { data: 'description', name: 'description' },
            { data: 'finger_ip', name: 'finger_ip' },
            { data: 'finger_port', name: 'finger_port' },
            { data: 'created_at', name: 'created_at' },
            { data: 'action', name: 'action', searchable: false, orderable: false },
            ] 
    }); 
    });
        Vue.component('modal',{
            template: '#modal-template'
        });

     let vu = new Vue({
        el: '#financialClass',
        data:{
            showModal:false,
            fieldErrors:[],
            className: null,
            description: null,
            finger_ip: null,
            finger_port: null,
        },
        methods:{
            addClass(){
             
                // var myData = {name: this.className,description:this.description};

                axios.post("{{route('financialClass.store')}}",{
                    name:this.className,
                    description:this.description,
                    finger_ip:this.finger_ip,
                    finger_port:this.finger_port
                })
                .then(function(response){
                    if (response.data) {
                        if (response.data.error) {
                            toastr.warning('', response.data.error);
                        }
                    }
                    vu.showModal = false;
                    vu.className = null;
                    vu.finger_ip = null;
                    vu.finger_port = null;
                    vu.description = null;
                    $('#financialClasses').DataTable().ajax.reload();
                })
                .catch(function (error) {
                    vu.showModal = false;
                    vu.className = null;
                    vu.finger_port = null;
                    vu.finger_ip = null;
                    console.log(error);
                    var message = "{{__('message.Warning')}}";
                    //$('#error-sound')[0].play();
                    toastr.warning('', message);
                });
            }
        }
     });

     new Vue({
         el: '#company_ll',
         methods: {
             setCompany: function (event) {
                 if (typeof data_table == 'object'){
                     data_table.clear();
                     data_table.ajax.reload();
                 }
             }
         }
     });


</script>

@endpush
