@extends('layouts.app')

@section('style')



    <style type="text/css">
      @media print{
            a[href]:after{
                content: none !important;
            }
        }

        #main {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        #main th, #main td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
        #main tr:hover {
            background-color: #ddd;
        }

        #main th {
            padding-top: 12px;
            padding-bottom: 12px;
            /*text-align: left;*/
            background-color: #768585;
            color: white;
        }
		
		.doubleLine {
				text-decoration-line: underline;
				text-decoration-style: double;
			}

    </style>
@endsection
@section('content')
<?php
$report = customeReportNew('account_show');
$_date= !in_array('date', $report);
$_description= !in_array('description', $report);
$_user= !in_array('user', $report);
$_unit= !in_array('unit', $report);
$_qut_in= !in_array('qut_in', $report);
$_qut_out= !in_array('qut_out', $report);
$_rate= !in_array('rate', $report);
$_balance= !in_array('balance', $report);
$_balance_base= !in_array('balance_base', $report);
$_total= !in_array('total', $report);




?>

    <div id="print-modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'trail_balance'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off"
                                           name="from_date">
                                    <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                    <span class="input-group-addon"> @lang('layout.To')</span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off"
                                           name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
	

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
				@lang('menu.TrailBalance')  &nbsp;&nbsp;
				<span class="text-primary">(
					<i class="fa fa-money"></i> &nbsp;
					<b>  {{getHomeCurrency()['name']}}) </b>
				</span>
                </div>
							
									
                <div class="tools"> </div>
                <div class="btn-group pull-right hidden-print">
                    @permission('financialReport-export')
                        <span id="anchore-modal">
                            <button type="submit" @click.prevent="showModal" class="btn btn-success">
                                <i class="fa fa-print"></i>
                            </button>
                        </span>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
            <div class="hidden-print">
            
                 <template v-cloak id="company_ll">
                      <company @company="setCompany"></company>
                  </template>
            </div>

<div class="row">
  <div class="col-lg-2 col-md-2"></div>
  <div class="col-lg-8 col-md-8">
  <table id="main">
      <tr>
        <th>#</th>
        <th>@lang('layout.Account')</th>
        <th>@lang('layout.Type')</th>
        <th>@lang('layout.Dr')</th>
        <th>@lang('layout.Cr')</th>
      </tr>
      
    <?php
    $count = 0;
    // $balance=0;
    // $balance1=0;
    // $tp=0;
    // $tn=0;

    // $tn_currency = 0;
    // $tp_currency = 0;

    // dd($data);

    $totalDedit = 0;
    $totalCredit = 0;

    ?>
    @foreach($data AS $record)
    <?php
      // $balance+=$record['amount']/$record['rate'];
      // $balance1+=$record['amount'];
    
      // if($record['amount']<0)
      // {
      //   $tn += $record['amount']/$record['rate'];
      // }

      // if($record['amount']>0)
      // {
      //   $tp += $record['amount']/$record['rate'];
      // }


      //  total in currency
    
      // if($record['amount']<0)
      // {
      //   $tn_currency += $record['amount'];
      // }

      // if($record['amount']>0)
      // {
      //   $tp_currency += $record['amount'];
      // }

    $debit = null;
    $credit = null;

      //Begin Dr 

      //Income
      if($record['type'] =="income"  && $record['total_amount']<0)
      {
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }  
      if($record['type'] =="otherIncome"  && $record['total_amount']<0)
      {
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }

      //Expense
      if($record['type'] =="expense" && $record['total_amount']>0){
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }   
      if($record['type'] =="otherExpense" && $record['total_amount']>0){
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }   
      if($record['type'] =="costOfGoodSold"  && $record['total_amount']>0){
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }  
      
      //Asset
      if($record['type'] =="otherCurrentAsset" && $record['total_amount']>0)
      {
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }  
      if($record['type'] =="bank" && $record['total_amount']>0)
      {
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }   
      if($record['type'] =="accountsReceivable" && $record['total_amount']>0)
      {
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }   
      if($record['type'] =="asset" && $record['total_amount']>0)
      {
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }    
      if($record['type'] =="otherAsset" && $record['total_amount']>0)
      {
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }  

      //Liabilities
      if( $record['type'] =="otherCurrentLiability" && $record['total_amount']<0){
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }   
      if( $record['type'] =="longTermLiability" && $record['total_amount']<0){
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }  
      if( $record['type'] =="accountsPayable" && $record['total_amount']<0){
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }   
      if( $record['type'] =="liability" && $record['total_amount']<0){
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }   
      if( $record['type'] =="CreditCard" && $record['total_amount']<0){
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }  

      //Capital
      if($record['type'] =="equity" && $record['total_amount']<0)
      {
        $debit = $record['total_amount'];
        $totalDedit+=ABS($record['total_amount']);
      }
      
      //End Dr

      //Begin Cr
      //Income 
      if($record['type'] =="income"  && $record['total_amount']>0)
      {
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }  
      if($record['type'] =="otherIncome"  && $record['total_amount']>0)
      {
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }

      //Expense
      if($record['type'] =="expense"  && $record['total_amount']<0){
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }   
      if($record['type'] =="otherExpense"  && $record['total_amount']<0){
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }   
      if($record['type'] =="costOfGoodSold"  && $record['total_amount']<0){
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }  

      //Asset
      if($record['type'] =="otherCurrentAsset" && $record['total_amount']<0)
      {
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }  
      if($record['type'] =="bank" && $record['total_amount']<0)
      {
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }   
      if($record['type'] =="accountsReceivable" && $record['total_amount']<0)
      {
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }   
      if($record['type'] =="asset" && $record['total_amount']<0)
      {
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }  
      if($record['type'] =="otherAsset" && $record['total_amount']<0)
      {
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      } 

      //Liabilities
      if($record['type'] =="otherCurrentLiability" && $record['total_amount']>0){
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }    
      if($record['type'] =="longTermLiability" && $record['total_amount']>0){
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      } 
      if($record['type'] =="accountsPayable" && $record['total_amount']>0){
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }  
      if($record['type'] =="liability" && $record['total_amount']>0){
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      } 
      if($record['type'] =="CreditCard" && $record['total_amount']>0){
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }

      //Capital
      if($record['type'] =="equity" && $record['total_amount']>0)
      {
        $credit = $record['total_amount'];
        $totalCredit+=ABS($record['total_amount']);
      }
      //End Cr 

    ?>
    <tr>
    <td class="center ">{{++$count}}</td>
    <td class="center "> <a href="{{url('/account/'.$record['account_id'])}}">{{$record['name']}}</a></td>
    <td class="center"> {{__('layout.'.ucfirst($record['type']))}}</td>

    <td class="center"><b>{{myRound(ABS($debit))}}</b></td>
    <td class="center"><b>{{myRound(ABS($credit))}}</b></td>

    </tr>
    @endforeach 

    <tr class="">
      <td  colspan="3" style="font-size:20px; font-weight:bold">@lang('layout.Total')</td>
      <td style="font-size:20px; font-weight:bold">
        <span class="doubleLine">
          {{myRound($totalDedit)}}
        </span>
        <span>
          {{getHomeCurrency()['symbol']}}
        </span>
      </td>  
      <td style="font-size:20px; font-weight:bold" >
        <span class="doubleLine">
          {{myRound($totalCredit)}}  
        </span>  
        <span>
          {{getHomeCurrency()['symbol']}}
        </span> 
      </td>  

    </tr>
	
 </table>
  </div>
  <div class="col-lg-2 col-md-2"></div>
</div>


				
  </div>
  </div>
</div>



@endsection
@include('print.modal')
@include('groupCompanyFilter.select')

@push('scripts')
    <script type="text/javascript">
        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                items: null,


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });

        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
    </script>
@endpush