@extends('layouts.app')
@section('style')
<style>
          @media print{
            a[href]:after{
                content: none !important;
            }
        }

        .btn-gray{
          color: white;
          background-color:green;
        }
          .mt-icon.report
          {
           {{(session()->get("system_direction") == "rtl")?'right':'left'}}: 0px !important;
            text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
          }

          .mparent{
            /* padding: 4px !important; */
            padding: 2px !important;
           {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 30px !important;
            text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
          }          
          
          .fchild{
            /* padding: 8px !important; */
            padding: 2px !important;
           {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 60px !important;
            text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
          }          
          
          .schild{
            /* padding: 12px !important; */
            padding: 2px !important;
           {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 85px !important;
            text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
          }

          .tchild{
            /* padding: 12px !important; */
            padding: 2px !important;
           {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 100px !important;
            text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
          }

          .amountS{
            padding: 0px !important;
            text-align: {{(session()->get("system_direction") == "rtl")?'left':'right'}};
          }
          .report_a{
            color: #393a3d;
          }
          a.report_a:hover{
            color: #393a3d;
            text-decoration: none;
          } 
          .report_a_title{
            color: #393a3d;
          }
          a.report_a_title:hover{
            color: #393a3d;
            text-decoration: none;
          }

          .mt-widget-1 .mt-img {
            display: inline-block;
            /* border-radius: 50% !important; */
            border: 0px !important;
            margin: 25px 0 20px 0;
        }
        .mt-body{
          display:none ;
        }

        .borders{
            text-decoration: underline;
            text-underline-position: under;
        }
        

</style>
@stop
@section('content')
@include('reports.modal')
<!-- BEGIN TAB PORTLET-->
<div class="row">
    <div class="portlet light bordered">

        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <!-- <span class="caption-subject font-green-sharp bold uppercase">@lang('menu.IncomeStatement')</span> -->
                </div>
                <div class="actions">
                </div>
                <div class="btn-group pull-right">
                    <i id="toggle_list" class="fa fa-eye-slash hidden-print text-success" style="font-size:25px;"
                        onclick="toggleList()"></i>

                    <a onclick="window.print()" class="hidden-print">

                        <i class="fa fa-print" style="font-size:25px;"></i>
                    </a>

                </div>
            </div>
            <div class="portlet-body">

                <div id="company">
                    <company @company="setCompany"></company>
                </div>

                <div class="row">
                    <div class="col-md-9 col-sm-9">
                        <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                            <tr>
                                <td colspan="5" style="text-align: center; font-size:16px;font-weight:bold;color:black">
                                    {!!company()['name']!!}
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5" style="text-align: center;">
                                    @lang('menu.ProfitAndLossByPrevYearComparison')
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5" style="text-align: center;">
                                    {{convertDate(now())}}
                                </td>
                            </tr>
                            <tr style="background-color:#eceef1">
                                <td style="width: 20%;">
                                    <span class="report_a_title"><b>@lang('layout.AccountName')</b> </span>
                                </td>
                                <td class="amountS" style="width: 20%;">
                                    <span class="report_a_title"><b>@lang('layout.Total')</b> </span>
                                </td>
                                <td class="amountS" style="width: 20%;">
                                    <span class="report_a_title"><b>@lang('layout.TotalLastYear')</b> </span>
                                </td>
                                <td class="amountS" style="width: 20%;">
                                    <span class="report_a_title"><b>@lang('layout.Change')
                                            {{getHomeCurrency()['symbol']}} </b> </span>
                                </td>
                                <td class="amountS" style="width: 20%;">
                                    <span class="report_a_title"><b>@lang('layout.Change')%</b> </span>
                                </td>
                            </tr>

                        </table>
                    </div>
                    <div class="col-md-3 col-sm-3 hidden-print">
                        <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                            <tr>
                                <td colspan="3" style="text-align: center; font-size:16px;font-weight:bold;color:red">
                                    @lang('layout.Note')
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3" style="text-align: center; font-size:16px;font-weight:bold;color:black">
                                    @lang('layout.MainAccount') 500
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3" style="text-align: center;">
                                    @lang('layout.FirstSubAccount') (200)
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3" style="text-align: center;">
                                    @lang('layout.SecondSubAccount') [300]
                                </td>
                            </tr>



                        </table>
                    </div>
                </div>

                <!----------------BEGIN Income ----------------->
                <div class="row">
                    <div class="col-md-9 col-sm-9">

                        <div onclick="showBody('income_accounts')">
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 20%;">
                                        <a class="report_a_title"><span id="income_accounts_fa"
                                                class="fa {{(session()->get(" system_direction")=="rtl"
                                                )?'fa-angle-left':'fa-angle-right'}} "> </span> @lang('layout.Income')</a>
                            </td>
                            <td class=" amountS" style="width: 20%;">
                                                <span class="report_a_title " id="income_amount">
                                                    {{currency()->format($totalIncome,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title " id="last_income_amount">
                                            {{currency()->format($last_totalIncome,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title " id="money_change_income_amount">
                                            {{currency()->format($totalIncome-$last_totalIncome,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title " id="percent_change_income_amount">
                                            @if($last_totalIncome == 0)
                                            100
                                            @else
                                            {{myRound((($totalIncome-$last_totalIncome)*100)/$last_totalIncome)}}
                                            @endif
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="mt-img">
                            <i class=""></i>
                        </div>
                        <div class="mt-body" id="income_accounts">
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                @foreach($income as $accountRow)
                                @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] != 0 || !empty($accountRow['children']))
                                <tr>
                                    <td class="mparent" style="width: 20%;"><a
                                            href="{{url('/account/'.$accountRow['id'])}}"
                                            class="report_a">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($accountRow['Amount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($accountRow['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        {{myRound($accountRow['Amount']-$accountRow['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        @if($accountRow['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td class="fchild" style="width: 20%; ">
                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                            class="report_a">{{$fc['AccountName']}}</a>
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['Amount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['Amount']-$fc['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        @if(!empty($fc['children']))
                                        @if($fc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                        @endif
                                        @endif
                                    </td>
                                </tr>
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td class="schild">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}" class="report_a">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <td class="amountS">{{myRound($sc['Amount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($sc['LAmount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($sc['Amount']-$sc['LAmount']) }}
                                    </td>
                                    <td class="amountS">
                                        @if($sc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td class="tchild">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}" class="report_a">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <td class="amountS">{{myRound($tc['Amount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($tc['LAmount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($tc['Amount']-$tc['LAmount']) }}
                                    </td>
                                    <td class="amountS">
                                        @if($tc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                @if(!empty($sc['children']))
                                <tr class="borders">
                                    <td class="schild" style="width: 20%;"> @lang('layout.Total')
                                        {{$sc['AccountName']}} </td>
                                    <td class="amountS" style="width:20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['total'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        @if($sc['Ltotal'] == 0)
                                        [100]
                                        @else
                                        [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                        @endif
                                        @endif

                                    </td>
                                </tr>
                                @endif
                                <!-- end therd child -->
                                @endforeach
                                @endif
                                @if(!empty($fc['children']))
                                <tr class="borders">
                                    <td class="fchild" style="width: 20%;"> @lang('layout.Total')
                                        {{$fc['AccountName']}} </td>
                                    <td class="amountS" style="width:20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['total'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        @if($fc['Ltotal'] == 0)
                                        [100]
                                        @else
                                        [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                        @endif
                                        @endif

                                    </td>
                                </tr>
                                @endif
                                <!-- end second child -->
                                @endif
                                @endforeach
                                @endif
                                @if(!empty($accountRow['children']))
                                <tr class="borders">
                                    <td class="mparent" style="width: 20%;"> @lang('layout.Total')
                                        {{$accountRow['AccountName']}} </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['total'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['Ltotal'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        @if($accountRow['Ltotal'] == 0)
                                        (100)
                                        @else
                                        ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                        @endif

                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- end first chiled -->
                                @endif
                                @endforeach
                                <tr>
                                    <td style="font-weight:bold"> @lang('layout.TotalIncome')
                                    </td>
                                    <td style="font-weight:bold" class="amountS">
                                        {{currency()->format($totalIncome,getRelatedCurrencyCode())}}</td>
                                    <td style="font-weight:bold" class="amountS">
                                        {{currency()->format($last_totalIncome,getRelatedCurrencyCode())}}</td>
                                    <td style="font-weight:bold" class="amountS">
                                        {{currency()->format($totalIncome-$last_totalIncome,getRelatedCurrencyCode())}}
                                    </td>
                                    <td style="font-weight:bold" class="amountS">
                                        @if($last_totalIncome == 0)
                                        100
                                        @else
                                        {{myRound((($totalIncome-$last_totalIncome)*100)/$last_totalIncome)}}
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>


                </div>

                <!----------------END Income ----------------->

                <!----------------BEGIN COGS ----------------->
                <div class="row">
                    <div class="col-md-9 col-sm-9">

                        <div onclick="showBody('cogs_account')">
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 20%;">
                                        <a class="report_a_title"><span id="cogs_account_fa" class="fa {{(session()->get(" system_direction")=="rtl")?'fa-angle-left':'fa-angle-right'}} "> </span> @lang('layout.CostOfGoodSold')</a>
                                </td>
                                <td class=" amountS" style="width: 20%;">
                                                <span class="report_a_title"
                                                    id="cogs_amount">{{currency()->format($totalCostOfGoodSold,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title"
                                            id="last_cogs_amount">{{currency()->format($last_totalCostOfGoodSold,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title"
                                            id="money_change_cogs_amount">{{currency()->format($totalCostOfGoodSold-$last_totalCostOfGoodSold,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title" id="percent_change_cogs_amount">
                                            @if($last_totalCostOfGoodSold == 0)
                                            100
                                            @else
                                            {{myRound((($totalCostOfGoodSold-$last_totalCostOfGoodSold)*100)/$last_totalCostOfGoodSold)}}
                                            @endif
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="mt-img">
                            <i class=""></i>
                        </div>
                        <div class="mt-body" id="cogs_account">
                            <table class="table table-striped  table-advance table-hover">
                                @foreach($costOfGoodSold as $accountRow)
                                @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] != 0 || !empty($accountRow['children']))
                                <tr>
                                    <td class="mparent" style="width: 20%;"><a
                                            href="{{url('/account/'.$accountRow['id'])}}"
                                            class="report_a">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($accountRow['Amount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($accountRow['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        {{myRound($accountRow['Amount']-$accountRow['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        @if($accountRow['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td class="fchild" style="width: 20%; ">
                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                            class="report_a">{{$fc['AccountName']}}</a>
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['Amount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['Amount']-$fc['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        @if(!empty($fc['children']))
                                        @if($fc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                        @endif
                                        @endif
                                    </td>
                                </tr>
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td class="schild">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}" class="report_a">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <td class="amountS">{{myRound($sc['Amount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($sc['LAmount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($sc['Amount']-$sc['LAmount']) }}
                                    </td>
                                    <td class="amountS">
                                        @if($sc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td class="tchild">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}" class="report_a">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <td class="amountS">{{myRound($tc['Amount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($tc['LAmount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($tc['Amount']-$tc['LAmount']) }}
                                    </td>
                                    <td class="amountS">
                                        @if($tc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                @if(!empty($sc['children']))
                                <tr class="borders">
                                    <td class="schild" style="width: 20%;"> @lang('layout.Total')
                                        {{$sc['AccountName']}} </td>
                                    <td class="amountS" style="width:20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['total'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        @if($sc['Ltotal'] == 0)
                                        [100]
                                        @else
                                        [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                        @endif
                                        @endif

                                    </td>
                                </tr>
                                @endif
                                <!-- end therd child -->
                                @endforeach
                                @endif
                                @if(!empty($fc['children']))
                                <tr class="borders">
                                    <td class="fchild" style="width: 20%;"> @lang('layout.Total')
                                        {{$fc['AccountName']}} </td>
                                    <td class="amountS" style="width:20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['total'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        @if($fc['Ltotal'] == 0)
                                        [100]
                                        @else
                                        [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                        @endif
                                        @endif

                                    </td>
                                </tr>
                                @endif
                                <!-- end second child -->
                                @endif
                                @endforeach
                                @endif
                                @if(!empty($accountRow['children']))
                                <tr class="borders">
                                    <td class="mparent" style="width: 20%;"> @lang('layout.Total')
                                        {{$accountRow['AccountName']}} </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['total'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['Ltotal'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        @if($accountRow['Ltotal'] == 0)
                                        (100)
                                        @else
                                        ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                        @endif

                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- end first chiled -->
                                @endif
                                @endforeach
                                <tr>
                                    <td style="font-weight:bold;font-size:16px">
                                        <b>@lang('layout.TotalCostOfGoodSold')</b>
                                    </td>
                                    <td style="font-weight:bold;font-size:16px" class="amountS">
                                        {{currency()->format($totalCostOfGoodSold,getRelatedCurrencyCode())}}</td>
                                    <td style="font-weight:bold;font-size:16px" class="amountS">
                                        {{currency()->format($last_totalCostOfGoodSold,getRelatedCurrencyCode())}}</td>
                                    <td style="font-weight:bold;font-size:16px" class="amountS">
                                        {{currency()->format($totalCostOfGoodSold-$last_totalCostOfGoodSold,getRelatedCurrencyCode())}}
                                    </td>
                                    <td style="font-weight:bold;font-size:16px" class="amountS">
                                        @if($last_totalCostOfGoodSold == 0)
                                        100
                                        @else
                                        {{myRound((($totalCostOfGoodSold-$last_totalCostOfGoodSold)*100)/$last_totalCostOfGoodSold)}}
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <!----------------END COGS ----------------->


                <!----------------BEGIN GROSS PROFIT ----------------->
                <div class="row">
                    <div class="col-md-9 col-sm-9">

                        <div>
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 20%;">
                                        <p class="report_a_title" style="font-weight: bold;">
                                            @lang('layout.GrossProfit')</p>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title" id="cogs_amount"
                                            style="font-weight: bold;">{{currency()->format($grossProfit,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title" id="last_cogs_amount"
                                            style="font-weight: bold;">{{currency()->format($last_grossProfit,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title" id="last_cogs_amount"
                                            style="font-weight: bold;">{{currency()->format($grossProfit-$last_grossProfit,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title" id="last_cogs_amount" style="font-weight: bold;">

                                            @if($last_grossProfit == 0)
                                            100
                                            @else
                                            {{myRound((($grossProfit-$last_grossProfit)*100)/$last_grossProfit)}}
                                            @endif
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                    </div>

                </div>
                <!----------------END GROSS PROFIT ----------------->

                <!----------------BEGIN EXPENSE ----------------->
                <div class="row">
                    <div class="col-md-9 col-sm-9">
                        <div onclick="showBody('expenses_account')">
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 20%;">
                                        <a class="report_a_title"><span id="expenses_account_fa"
                                                class="fa {{(session()->get(" system_direction")=="rtl"
                                                )?'fa-angle-left':'fa-angle-right'}} "> </span> @lang('layout.Expense')</a>
                                 </td>
                                <td class=" amountS" style="width: 20%;">
                                                <span class="report_a_title"
                                                    id="expense_amount">{{currency()->format($totalExpense,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title"
                                            id="last_expense_amount">{{currency()->format($last_totalExpense,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title"
                                            id="money_change_expense_amount">{{currency()->format($totalExpense-$last_totalExpense,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title" id="percent_change_expense_amount">

                                            @if($last_totalExpense == 0)
                                            100
                                            @else
                                            {{myRound((($totalExpense-$last_totalExpense)*100)/$last_totalExpense)}}
                                            @endif
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>


                        <div class="mt-img">
                            <i class=""></i>
                        </div>
                        <div class="mt-body" id="expenses_account">
                            <table class="table table-striped  table-advance table-hover">
                                @foreach($expense as $accountRow)
                                @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] != 0 || !empty($accountRow['children']))
                                <tr>
                                    <td class="mparent" style="width: 20%;"><a
                                            href="{{url('/account/'.$accountRow['id'])}}"
                                            class="report_a">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($accountRow['Amount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($accountRow['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        {{myRound($accountRow['Amount']-$accountRow['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        @if($accountRow['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td class="fchild" style="width: 20%; ">
                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                            class="report_a">{{$fc['AccountName']}}</a>
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['Amount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['Amount']-$fc['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        @if(!empty($fc['children']))
                                        @if($fc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                        @endif
                                        @endif
                                    </td>
                                </tr>
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td class="schild">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}" class="report_a">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <td class="amountS">{{myRound($sc['Amount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($sc['LAmount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($sc['Amount']-$sc['LAmount']) }}
                                    </td>
                                    <td class="amountS">
                                        @if($sc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td class="tchild">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}" class="report_a">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <td class="amountS">{{myRound($tc['Amount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($tc['LAmount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($tc['Amount']-$tc['LAmount']) }}
                                    </td>
                                    <td class="amountS">
                                        @if($tc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                @if(!empty($sc['children']))
                                <tr class="borders">
                                    <td class="schild" style="width: 20%;"> @lang('layout.Total')
                                        {{$sc['AccountName']}} </td>
                                    <td class="amountS" style="width:20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['total'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        @if($sc['Ltotal'] == 0)
                                        [100]
                                        @else
                                        [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                        @endif
                                        @endif

                                    </td>
                                </tr>
                                @endif
                                <!-- end therd child -->
                                @endforeach
                                @endif
                                @if(!empty($fc['children']))
                                <tr class="borders">
                                    <td class="fchild" style="width: 20%;"> @lang('layout.Total')
                                        {{$fc['AccountName']}} </td>
                                    <td class="amountS" style="width:20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['total'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        @if($fc['Ltotal'] == 0)
                                        [100]
                                        @else
                                        [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                        @endif
                                        @endif

                                    </td>
                                </tr>
                                @endif
                                <!-- end second child -->
                                @endif
                                @endforeach
                                @endif
                                @if(!empty($accountRow['children']))
                                <tr class="borders">
                                    <td class="mparent" style="width: 20%;"> @lang('layout.Total')
                                        {{$accountRow['AccountName']}} </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['total'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['Ltotal'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        @if($accountRow['Ltotal'] == 0)
                                        (100)
                                        @else
                                        ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                        @endif

                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- end first chiled -->
                                @endif
                                @endforeach
                                <tr>
                                    <th style=" font-size: 16px ;font-weight:bold">@lang('layout.TotalExpenses')
                                    </th>
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{currency()->format($totalExpense,getRelatedCurrencyCode())}}</td>
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{currency()->format($last_totalExpense,getRelatedCurrencyCode())}}</td>
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{currency()->format($totalExpense-$last_totalExpense,getRelatedCurrencyCode())}}
                                    </td>
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        @if($last_totalExpense == 0)
                                        100
                                        @else
                                        {{myRound((($totalExpense-$last_totalExpense)*100)/$last_totalExpense)}}
                                        @endif
                                    </td>

                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <!----------------END EXPENSE ----------------->

                <!----------------BEGIN Net Ordinary Income ----------------->
                <div class="row">
                    <div class="col-md-9 col-sm-9">
                        <div>
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 20%;">
                                        <p class="report_a_title" style="font-weight: bold;">
                                            @lang('layout.NetOrdinaryIncome')</p>
                                    </td>
                                    <td class="amountS" style="width:20%;">
                                        <span class="report_a_title" id="cogs_amount"
                                            style="font-weight: bold;">{{currency()->format($netOrdeinaryIncome,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width:20%;">
                                        <span class="report_a_title" id="last_cogs_amount"
                                            style="font-weight: bold;">{{currency()->format($last_netOrdeinaryIncome,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width:20%;">
                                        <span class="report_a_title" id="last_cogs_amount"
                                            style="font-weight: bold;">{{currency()->format($netOrdeinaryIncome-$last_netOrdeinaryIncome,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width:20%;">
                                        <span class="report_a_title" id="last_cogs_amount" style="font-weight: bold;">


                                            @if($last_netOrdeinaryIncome == 0)
                                            100
                                            @else
                                            {{myRound((($netOrdeinaryIncome-$last_netOrdeinaryIncome)*100)/$last_netOrdeinaryIncome)}}
                                            @endif

                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <!----------------END Net Ordinary Income ----------------->

                <!----------------BEGIN OTHER EXPENSE ----------------->
                <div class="row">
                    <div class="col-md-9 col-sm-9">
                        <div onclick="showBody('other_expenses_account')">
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 20%;">
                                        <a class="report_a_title"><span id="other_expenses_account_fa"
                                                class="fa {{(session()->get(" system_direction")=="rtl"
                                                )?'fa-angle-left':'fa-angle-right'}} "> </span> @lang('layout.OtherExpense')</a>
                                </td>
                                <td class=" amountS" style="width: 20%;">
                                                <span class="report_a_title"
                                                    id="other_expense_amount">{{currency()->format($totalOtherExpense,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title"
                                            id="last_other_expense_amount">{{currency()->format($last_totalOtherExpense,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title"
                                            id="money_change_other_expense_amount">{{currency()->format($totalOtherExpense-$last_totalOtherExpense,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title" id="percent_change_other_expense_amount">
                                            @if($last_totalOtherExpense == 0)
                                            100
                                            @else
                                            {{myRound((($totalOtherExpense-$last_totalOtherExpense)*100)/$last_totalOtherExpense)}}
                                            @endif
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="mt-img">
                            <i class=""></i>
                        </div>
                        <div class="mt-body" id="other_expenses_account">
                            <table class="table table-striped  table-advance table-hover">
                                @foreach($otherExpense as $accountRow)
                                @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] != 0 || !empty($accountRow['children']))
                                <tr>
                                    <td class="mparent" style="width: 20%;"><a
                                            href="{{url('/account/'.$accountRow['id'])}}"
                                            class="report_a">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($accountRow['Amount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($accountRow['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        {{myRound($accountRow['Amount']-$accountRow['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        @if($accountRow['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td class="fchild" style="width: 20%; ">
                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                            class="report_a">{{$fc['AccountName']}}</a>
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['Amount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['Amount']-$fc['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        @if(!empty($fc['children']))
                                        @if($fc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                        @endif
                                        @endif
                                    </td>
                                </tr>
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td class="schild">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}" class="report_a">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <td class="amountS">{{myRound($sc['Amount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($sc['LAmount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($sc['Amount']-$sc['LAmount']) }}
                                    </td>
                                    <td class="amountS">
                                        @if($sc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td class="tchild">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}" class="report_a">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <td class="amountS">{{myRound($tc['Amount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($tc['LAmount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($tc['Amount']-$tc['LAmount']) }}
                                    </td>
                                    <td class="amountS">
                                        @if($tc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                @if(!empty($sc['children']))
                                <tr class="borders">
                                    <td class="schild" style="width: 20%;"> @lang('layout.Total')
                                        {{$sc['AccountName']}} </td>
                                    <td class="amountS" style="width:20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['total'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        @if($sc['Ltotal'] == 0)
                                        [100]
                                        @else
                                        [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                        @endif
                                        @endif

                                    </td>
                                </tr>
                                @endif
                                <!-- end therd child -->
                                @endforeach
                                @endif
                                @if(!empty($fc['children']))
                                <tr class="borders">
                                    <td class="fchild" style="width: 20%;"> @lang('layout.Total')
                                        {{$fc['AccountName']}} </td>
                                    <td class="amountS" style="width:20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['total'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        @if($fc['Ltotal'] == 0)
                                        [100]
                                        @else
                                        [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                        @endif
                                        @endif

                                    </td>
                                </tr>
                                @endif
                                <!-- end second child -->
                                @endif
                                @endforeach
                                @endif
                                @if(!empty($accountRow['children']))
                                <tr class="borders">
                                    <td class="mparent" style="width: 20%;"> @lang('layout.Total')
                                        {{$accountRow['AccountName']}} </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['total'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['Ltotal'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        @if($accountRow['Ltotal'] == 0)
                                        (100)
                                        @else
                                        ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                        @endif

                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- end first chiled -->
                                @endif
                                @endforeach

                                <tr>
                                    <th style="font-size: 16px;font-weight:bold">@lang('layout.TotalOtherExpenses')
                                    </th>
                                    <td style="font-size: 16px;font-weight:bold" class="amountS">
                                        {{currency()->format($totalOtherExpense,getRelatedCurrencyCode())}}</td>
                                    <td style="font-size: 16px;font-weight:bold" class="amountS">
                                        {{currency()->format($last_totalOtherExpense,getRelatedCurrencyCode())}}</td>
                                    <td style="font-size: 16px;font-weight:bold" class="amountS">
                                        {{currency()->format($totalOtherExpense-$last_totalOtherExpense,getRelatedCurrencyCode())}}
                                    </td>
                                    <td style="font-size: 16px;font-weight:bold" class="amountS">
                                        @if($last_totalOtherExpense == 0)
                                        100
                                        @else
                                        {{myRound((($totalOtherExpense-$last_totalOtherExpense)*100)/$last_totalOtherExpense)}}
                                        @endif
                                    </td>

                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <!----------------END OTHER EXPENSE ----------------->

                <!----------------BEGIN OTHER INCOME ----------------->
                <div class="row">
                    <div class="col-md-9 col-sm-9">

                        <div onclick="showBody('other_income_accounts')">
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 20%;">
                                        <a class="report_a_title"><span id="other_income_accounts_fa"
                                                class="fa {{(session()->get(" system_direction")=="rtl"
                                                )?'fa-angle-left':'fa-angle-right'}} "> </span> @lang('layout.OtherIncome')</a>
                                </td>
                                <td class=" amountS" style="width: 20%;">
                                                <span class="report_a_title"
                                                    id="other_income_amount">{{currency()->format($totalOtherIncome,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title"
                                            id="last_other_income_amount">{{currency()->format($last_totalOtherIncome,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        <span class="report_a_title"
                                            id="money_change_other_income_amount">{{currency()->format($totalOtherIncome-$last_totalOtherIncome,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        @if($last_totalOtherIncome == 0)
                                        100
                                        @else
                                        {{myRound((($totalOtherIncome-$last_totalOtherIncome)*100)/$last_totalOtherIncome)}}
                                        @endif
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>


                        <div class="mt-img">
                            <i class=""></i>
                        </div>
                        <div class="mt-body" id="other_income_accounts">
                            <table class="table table-striped  table-advance table-hover">
                                @foreach($otherIncome as $accountRow)
                                @if($accountRow['Amount'] != 0 || $accountRow['LAmount'] != 0 || !empty($accountRow['children']))
                                <tr>
                                    <td class="mparent" style="width: 20%;"><a
                                            href="{{url('/account/'.$accountRow['id'])}}"
                                            class="report_a">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($accountRow['Amount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($accountRow['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        {{myRound($accountRow['Amount']-$accountRow['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        @if($accountRow['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($accountRow['Amount']-$accountRow['LAmount'])*100)/$accountRow['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || $fc['LAmount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td class="fchild" style="width: 20%; ">
                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                            class="report_a">{{$fc['AccountName']}}</a>
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['Amount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">{{myRound($fc['Amount']-$fc['LAmount']) }}
                                    </td>
                                    <td class="amountS" style="width: 20%;">
                                        @if(!empty($fc['children']))
                                        @if($fc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($fc['Amount']-$fc['LAmount'])*100)/$fc['LAmount'])}}
                                        @endif
                                        @endif
                                    </td>
                                </tr>
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td class="schild">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}" class="report_a">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <td class="amountS">{{myRound($sc['Amount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($sc['LAmount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($sc['Amount']-$sc['LAmount']) }}
                                    </td>
                                    <td class="amountS">
                                        @if($sc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($sc['Amount']-$sc['LAmount'])*100)/$sc['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td class="tchild">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}" class="report_a">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <td class="amountS">{{myRound($tc['Amount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($tc['LAmount']) }}
                                    </td>
                                    <td class="amountS">{{myRound($tc['Amount']-$tc['LAmount']) }}
                                    </td>
                                    <td class="amountS">
                                        @if($tc['LAmount'] == 0)
                                        100
                                        @else
                                        {{myRound((($tc['Amount']-$tc['LAmount'])*100)/$tc['LAmount'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                @if(!empty($sc['children']))
                                <tr class="borders">
                                    <td class="schild" style="width: 20%;"> @lang('layout.Total')
                                        {{$sc['AccountName']}} </td>
                                    <td class="amountS" style="width:20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['total'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        [{{myRound($sc['total']-$sc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($sc['children']))
                                        @if($sc['Ltotal'] == 0)
                                        [100]
                                        @else
                                        [{{myRound((($sc['total']-$sc['Ltotal'])*100)/$sc['Ltotal'])}}]
                                        @endif
                                        @endif

                                    </td>
                                </tr>
                                @endif
                                <!-- end therd child -->
                                @endforeach
                                @endif
                                @if(!empty($fc['children']))
                                <tr class="borders">
                                    <td class="fchild" style="width: 20%;"> @lang('layout.Total')
                                        {{$fc['AccountName']}} </td>
                                    <td class="amountS" style="width:20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['total'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        [{{myRound($fc['total']-$fc['Ltotal'])}}]
                                        @endif

                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($fc['children']))
                                        @if($fc['Ltotal'] == 0)
                                        [100]
                                        @else
                                        [{{myRound((($fc['total']-$fc['Ltotal'])*100)/$fc['Ltotal'])}}]
                                        @endif
                                        @endif

                                    </td>
                                </tr>
                                @endif
                                <!-- end second child -->
                                @endif
                                @endforeach
                                @endif
                                @if(!empty($accountRow['children']))
                                <tr class="borders">
                                    <td class="mparent" style="width: 20%;"> @lang('layout.Total')
                                        {{$accountRow['AccountName']}} </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['total'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['Ltotal'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        ({{myRound($accountRow['total']-$accountRow['Ltotal'])}})
                                        @endif
                                    </td>
                                    <td class="amountS" style="width: 20%; font-weight:bolder;">
                                        @if(!empty($accountRow['children']))
                                        @if($accountRow['Ltotal'] == 0)
                                        (100)
                                        @else
                                        ({{myRound((($accountRow['total']-$accountRow['Ltotal'])*100)/$accountRow['Ltotal'])}})
                                        @endif

                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- end first chiled -->
                                @endif
                                @endforeach
                                <tr>
                                    <th style=" font-size: 16px;font-weight:bold">@lang('layout.TotalOtherIncome')
                                    </th>
                                    <td style="font-size: 16px;font-weight:bold" class="amountS">
                                        {{currency()->format($totalOtherIncome,getRelatedCurrencyCode())}}</td>
                                    <td style="font-size: 16px;font-weight:bold" class="amountS">
                                        {{currency()->format($last_totalOtherIncome,getRelatedCurrencyCode())}}</td>
                                    <td style="font-size: 16px;font-weight:bold" class="amountS">
                                        {{currency()->format($totalOtherIncome-$last_totalOtherIncome,getRelatedCurrencyCode())}}
                                    </td>
                                    <td style="font-size: 16px;font-weight:bold" class="amountS">

                                        @if($last_totalOtherIncome == 0)
                                        100
                                        @else
                                        {{myRound((($totalOtherIncome-$last_totalOtherIncome)*100)/$last_totalOtherIncome)}}
                                        @endif
                                    </td>

                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <!----------------END OTHER INCOME ----------------->

                <!----------------BEGIN NET PROFIT ----------------->
                <div class="row">
                    <div class="col-md-9 col-sm-9">
                        <div>
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 20%;">
                                        <p class="report_a_title" style="font-weight: bold;"> @lang('layout.NetIncome')
                                        </p>
                                    </td>
                                    <td class="amountS" style="width:20%;">
                                        <span class="report_a_title" id="cogs_amount"
                                            style="font-weight: bold;">{{currency()->format($netProfit,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width:20%;">
                                        <span class="report_a_title" id="last_cogs_amount"
                                            style="font-weight: bold;">{{currency()->format($last_netProfit,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width:20%;">
                                        <span class="report_a_title" id="last_cogs_amount"
                                            style="font-weight: bold;">{{currency()->format($netProfit-$last_netProfit,getRelatedCurrencyCode())}}</span>
                                    </td>
                                    <td class="amountS" style="width:20%;">
                                        <span class="report_a_title" id="last_cogs_amount" style="font-weight: bold;">


                                            @if($last_netProfit == 0)
                                            100
                                            @else
                                            {{myRound((($netProfit-$last_netProfit)*100)/$last_netProfit)}}
                                            @endif

                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <!----------------END NET PROFIT ----------------->



            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>
@stop
@include('groupCompanyFilter.select')
@push('scripts')
<script type="text/javascript">




//Begin Toggle div
  function showBody(partName){
    if(partName == "income_accounts")
    {
        $('#income_accounts_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#income_accounts').toggle();
        $('#income_amount').toggle();
        $('#last_income_amount').toggle();
        $('#money_change_income_amount').toggle();
        $('#percent_change_income_amount').toggle();
    }    

    if(partName == "cogs_account")
    {
        $('#cogs_account_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#cogs_account').toggle();
        $('#cogs_amount').toggle();
        $('#last_cogs_amount').toggle();
        $('#money_change_cogs_amount').toggle();
        $('#percent_change_cogs_amount').toggle();
    }    


    if(partName == "expenses_account")
    {
        $('#expenses_account_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#expenses_account').toggle();
        $('#expense_amount').toggle();
        $('#last_expense_amount').toggle();
        $('#money_change_expense_amount').toggle();
        $('#percent_change_expense_amount').toggle();
    }    
    
    if(partName == "other_expenses_account")
    {
        $('#other_expenses_account_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#other_expenses_account').toggle();
        $('#other_expense_amount').toggle();
        $('#last_other_expense_amount').toggle();
        $('#money_change_other_expense_amount').toggle();
        $('#percent_change_other_expense_amount').toggle();
    }    
    
    if(partName == "other_income_accounts")
    {
        $('#other_income_accounts_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#other_income_accounts').toggle();
        $('#other_income_amount').toggle();
        $('#last_other_income_amount').toggle();
        $('#money_change_other_income_amount').toggle();
        $('#percent_change_other_income_amount').toggle();
    }      
  }

  function toggleList()
  {
    $('.mt-body').toggle();
    $('#toggle_list').toggleClass("fa-eye fa-eye-slash");

  

    
    $('#income_amount').toggle();
    $('#last_income_amount').toggle();
    $('#money_change_income_amount').toggle();
    $('#percent_change_income_amount').toggle();
    $('#cogs_amount').toggle();
    $('#last_cogs_amount').toggle();
    $('#money_change_cogs_amount').toggle();
    $('#percent_change_cogs_amount').toggle();
    $('#expense_amount').toggle();
    $('#last_expense_amount').toggle();
    $('#money_change_expense_amount').toggle();
    $('#percent_change_expense_amount').toggle();
    $('#other_expense_amount').toggle();
    $('#last_other_expense_amount').toggle();
    $('#money_change_other_expense_amount').toggle();
    $('#percent_change_other_expense_amount').toggle();
    $('#other_income_amount').toggle();
    $('#last_other_income_amount').toggle();
    $('#money_change_other_income_amount').toggle();
    $('#percent_change_other_income_amount').toggle();


    $('#income_accounts_fa').toggleClass("fa-angle-left fa-angle-down");
    $('#cogs_account_fa').toggleClass("fa-angle-left fa-angle-down");
    $('#expenses_account_fa').toggleClass("fa-angle-left fa-angle-down");
    $('#other_expenses_account_fa').toggleClass("fa-angle-left fa-angle-down");
    $('#other_income_accounts_fa').toggleClass("fa-angle-left fa-angle-down");
  }
</script>

@endpush