@extends('layouts.app')
@section('style')
<style>
    @media print {
        a[href]:after {
            content: none !important;
        }
    }

    .btn-gray {
        color: white;
        background-color: green;
    }

    .mt-icon.report{
    {{(session()->get("system_direction") == "rtl")?'right':'left'}}: 0px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }

    .mparent{
    /* padding: 4px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 30px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }          
    
    .fchild{
    /* padding: 8px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 60px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }          
    
    .schild{
    /* padding: 12px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 85px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }  

    .tchild{
    /* padding: 12px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 100px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }

    .amountS{
    padding: 0px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'left':'right'}};
    }

    .report_a {
        color: #393a3d;
    }

    a.report_a:hover {
        color: #393a3d;
        text-decoration: none;
    }

    .report_a_title {
        color: #393a3d;
    }

    a.report_a_title:hover {
        color: #393a3d;
        text-decoration: none;
    }

    .mt-widget-1 .mt-img {
        display: inline-block;
        /* border-radius: 50% !important; */
        border: 0px !important;
        margin: 25px 0 20px 0;
    }

    .mt-body {
        display: none;
    }

    .borders {
        text-decoration: underline;
        text-underline-position: under;
    }
</style>
@stop
@section('content')
@include('reports.modal')

<!-- BEGIN TAB PORTLET-->
<div class="row">
    <div class="portlet light bordered">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <!-- <span class="caption-subject font-green-sharp bold uppercase">@lang('menu.IncomeStatement')</span> -->
                </div>
                <div class="actions">
                </div>
                <div class="btn-group pull-right">
                    <i id="toggle_list" class="fa fa-eye-slash hidden-print text-success" style="font-size:25px; cursor:pointer"
                        onclick="toggleList()"></i>

                    <a onclick="window.print()" class="hidden-print">

                        <i class="fa fa-print" style="font-size:25px;"></i>
                    </a>

                </div>
            </div>
            <div class="portlet-body">

                <div id="company">
                    <company @company="setCompany"></company>
                </div>

                <div class="row">
                    <div class="col-md-12 col-sm-12">
                        <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                            <tr>
                                <td colspan="5" style="text-align: center; font-size:16px;font-weight:bold;color:black">
                                    {!!company()['name']!!}
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5" style="text-align: center;">
                                    @lang('menu.ProfitAndLossByClass')
                                </td>
                            </tr>
                            <tr>
                                <td colspan="5" style="text-align: center;">
                                    {{$date}}
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="row">
                    <div class="">
                        <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                            <tr style="background-color:#d3dff1">
                                <td style="width: 100px;">
                                    <span class="report_a_title"><b
                                            style="text-decoration: underline; font-size:16px">@lang('layout.AccountName')</b>
                                    </span>
                                </td>
                                @foreach($classes as $keyTi => $valueTi)
                                <td class="amountS" style="width: 100px;">
                                    <span class="report_a_title"><b
                                            style="text-decoration: underline; font-size:16px">{{$keyTi}}</b>
                                    </span>
                                </td>
                                @endforeach
                                <td class="amountS" style="width: 100px;">
                                    <span class="report_a_title"><b
                                            style="text-decoration: underline; font-size:16px">@lang('layout.Total')</b>
                                    </span>
                                </td>
                            </tr>

                        </table>
                    </div>
                </div>

                <!----------------BEGIN Income ----------------->
                <div class="row">
                    <div class="">

                        <div onclick="showBody('income_accounts')">
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 100px;">
                                        <a class="report_a_title"><span id="" class="fa {{(session()->get("
                                                system_direction")=="rtl" )?'fa-angle-left':'fa-angle-right'}} "> </span> @lang('layout.Income')</a>
                                        </td>
                                        <?php $totalIncome = 0 ?>
                                        @foreach($classes as $keyT => $valueT)
                                        <?php $totalIncome += $valueT['data']['totalIncome']; ?>
                                        <td class=" amountS" style="width: 100px;">
                                                <span class="report_a_title " id="">
                                                    {{currency()->format($valueT['data']['totalIncome'],getRelatedCurrencyCode())}}</span>
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">
                                        <span class="report_a_title " id="">
                                            {{myRound($totalIncome)}}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="mt-img">
                            <i class=""></i>
                        </div>
                        <div class="mt-body" id="income_accounts">
                            <table class="table table-striped  table-advance table-hover">
                                @foreach($income as $rowData)
                                <tr style="background-color:#f1ebdb">
                                    <td class="mparent" style="width: 100px;">
                                        <a href="{{url('/account/'.$rowData['id'])}}" class="report_a">{{$rowData['AccountName']}}</a>
                                    </td>
                                    <?php $amountRow = 0 ?>
                                    @foreach($rowData['Amount'] as $keyA => $valueA)
                                    <?php $amountRow += $valueA['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueA['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRow)}}</td>
                                </tr>
                                <!-- begin first chiled -->
                                @if (!empty($rowData['children']) && getShowSubAccount() != "false")
                                @foreach($rowData['children'] as $key=>$fc)
                                <tr style="background-color:#d3eceb">
                                    <td class="fchild" style="width: 100px;"><b>{{$key+1}}</b> <a
                                            href="{{url('/account/'.$fc['id'])}}"
                                            class="report_a">{{$fc['AccountName']}}</a></td>
                                    <?php $amountRowFirstCh = 0 ?>
                                    @foreach($fc['Amount'] as $keyF => $valueF)
                                    <?php $amountRowFirstCh += $valueF['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueF['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowFirstCh)}}</td>
                                </tr>
                                <!-- begin second chiled -->
                                @if (!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                <tr style="background-color:#cae8cd">
                                    <td class="schild" style="width: 100px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @else
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}"
                                            class="report_a">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <?php $amountRowSecCh = 0 ?>
                                    @foreach($sc['Amount'] as $keyS => $valueS)
                                    <?php $amountRowSecCh += $valueS['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueS['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowSecCh)}}</td>
                                </tr>
                                <!-- begin therd chiled -->
                                @if (!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                <tr style="background-color:#cad7e8">
                                    <td class="tchild" style="width: 100px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @else
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}"
                                            class="report_a">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <?php $amountRowSecCh = 0 ?>
                                    @foreach($tc['Amount'] as $keyS => $valueS)
                                    <?php $amountRowSecCh += $valueS['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueS['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowSecCh)}}</td>
                                </tr>
                                @if(!empty($tc['children']))
                                <tr style="background-color:#acceaf">
                                    <td class="tchild borders" style="width: 100px;"> @lang('layout.Total')
                                        {{$tc['AccountName']}} </td>
                                    <?php $totalRowSecCh = 0 ?>
                                    @foreach($tc['Amount'] as $keyS => $valueS)
                                    <?php $totalRowSecCh += $valueS['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($valueS['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($totalRowSecCh)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd chiled -->
                                @if(!empty($sc['children']))
                                <tr style="background-color:#acceaf">
                                    <td class="schild borders" style="width: 100px;"> @lang('layout.Total')
                                        {{$sc['AccountName']}} </td>
                                    <?php $totalRowSecCh = 0 ?>
                                    @foreach($sc['Amount'] as $keyS => $valueS)
                                    <?php $totalRowSecCh += $valueS['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($valueS['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($totalRowSecCh)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end second chiled -->
                                @if(!empty($fc['children']))
                                <tr style="background-color:#afd2d0" class="borders">
                                    <td class="fchild" style="width: 100px;"> @lang('layout.Total')
                                        {{$fc['AccountName']}} </td>
                                    <?php $totalRowFirstCh = 0 ?>
                                    @foreach($fc['Amount'] as $keyF => $valueF)
                                    <?php $totalRowFirstCh += $valueF['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($valueF['total'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($totalRowFirstCh)}}</td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @if(!empty($rowData['children']))
                                <tr style="background-color:#bdb6a4" class="borders">
                                    <td class="mparent" style="width: 100px;"> @lang('layout.Total')
                                        {{$rowData['AccountName']}} 
                                    </td>
                                    <?php $totalRow = 0 ?>
                                    @foreach($rowData['Amount'] as $keyA => $valueA)
                                    <?php $totalRow += $valueA['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($valueA['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($totalRow)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                <tr>
                                    <th style=" font-size: 16px ;font-weight:bold">@lang('layout.TotalIncome')</th>
                                    <?php $totalIncome = 0 ?>
                                    @foreach($classes as $keyT => $valueT)
                                    <?php $totalIncome += $valueT['data']['totalIncome']; ?>
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{currency()->format($valueT['data']['totalIncome'],getRelatedCurrencyCode())}}
                                    </td>
                                    @endforeach
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{myRound($totalIncome)}}
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>


                </div>

                <!----------------END Income ----------------->

                <!----------------BEGIN COGS ----------------->
                <div class="row">
                    <div class="">

                        <div onclick="showBody('cogs_account')">
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 100px;">
                                        <a class="report_a_title"><span id="" class="fa {{(session()->get("
                                                system_direction")=="rtl" )?'fa-angle-left':'fa-angle-right'}} "> </span> @lang('layout.CostOfGoodSold')</a>
                                        </td>
                                        <?php $totalCostOfGoodSold = 0 ?>
                                        @foreach($classes as $keyT => $valueT)
                                        <?php $totalCostOfGoodSold += $valueT['data']['totalCostOfGoodSold']; ?>
                                        <td class=" amountS" style="width: 100px;">
                                                <span class="report_a_title " id="">
                                                    {{currency()->format($valueT['data']['totalCostOfGoodSold'],getRelatedCurrencyCode())}}</span>
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">
                                        <span class="report_a_title " id="">
                                            {{myRound($totalCostOfGoodSold)}}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="mt-img">
                            <i class=""></i>
                        </div>
                        <div class="mt-body" id="cogs_account">
                            <table class="table table-striped  table-advance table-hover">
                                @foreach($costOfGoodSold as $rowData)
                                <tr style="background-color:#f1ebdb">
                                    <td class="mparent" style="width: 100px;">
                                        <a href="{{url('/account/'.$rowData['id'])}}" class="report_a">{{$rowData['AccountName']}}</a>
                                    </td>
                                    <?php $amountRow = 0 ?>
                                    @foreach($rowData['Amount'] as $keyA => $valueA)
                                    <?php $amountRow += $valueA['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueA['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRow)}}</td>
                                </tr>
                                <!-- begin first chiled -->
                                @if (!empty($rowData['children']) && getShowSubAccount() != "false")
                                @foreach($rowData['children'] as $key=>$fc)
                                <tr style="background-color:#d3eceb">
                                    <td class="fchild" style="width: 100px;"><b>{{$key+1}}</b> <a
                                            href="{{url('/account/'.$fc['id'])}}"
                                            class="report_a">{{$fc['AccountName']}}</a></td>
                                    <?php $amountRowFirstCh = 0 ?>
                                    @foreach($fc['Amount'] as $keyF => $valueF)
                                    <?php $amountRowFirstCh += $valueF['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueF['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowFirstCh)}}</td>
                                </tr>
                                <!-- begin second chiled -->
                                @if (!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                <tr style="background-color:#cae8cd">
                                    <td class="schild" style="width: 100px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @else
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}"
                                            class="report_a">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <?php $amountRowSecCh = 0 ?>
                                    @foreach($sc['Amount'] as $keyS => $valueS)
                                    <?php $amountRowSecCh += $valueS['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueS['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowSecCh)}}</td>
                                </tr>
                                <!-- begin therd chiled -->
                                @if (!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                <tr style="background-color:#cad7e8">
                                    <td class="tchild" style="width: 100px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @else
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}"
                                            class="report_a">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <?php $amountRowSecCh = 0 ?>
                                    @foreach($tc['Amount'] as $keyS => $valueS)
                                    <?php $amountRowSecCh += $valueS['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueS['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowSecCh)}}</td>
                                </tr>
                                @if(!empty($tc['children']))
                                <tr style="background-color:#acceaf">
                                    <td class="tchild borders" style="width: 100px;"> @lang('layout.Total')
                                        {{$tc['AccountName']}} </td>
                                    <?php $totalRowSecCh = 0 ?>
                                    @foreach($tc['Amount'] as $keyS => $valueS)
                                    <?php $totalRowSecCh += $valueS['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($valueS['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($totalRowSecCh)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd chiled -->
                                @if(!empty($sc['children']))
                                <tr style="background-color:#acceaf">
                                    <td class="schild borders" style="width: 100px;"> @lang('layout.Total')
                                        {{$sc['AccountName']}} </td>
                                    <?php $totalRowSecCh = 0 ?>
                                    @foreach($sc['Amount'] as $keyS => $valueS)
                                    <?php $totalRowSecCh += $valueS['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($valueS['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($totalRowSecCh)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end second chiled -->
                                @if(!empty($fc['children']))
                                <tr style="background-color:#afd2d0" class="borders">
                                    <td class="fchild" style="width: 100px;"> @lang('layout.Total')
                                        {{$fc['AccountName']}} </td>
                                    <?php $totalRowFirstCh = 0 ?>
                                    @foreach($fc['Amount'] as $keyF => $valueF)
                                    <?php $totalRowFirstCh += $valueF['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($valueF['total'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($totalRowFirstCh)}}</td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @if(!empty($rowData['children']))
                                <tr style="background-color:#bdb6a4" class="borders">
                                    <td class="mparent" style="width: 100px;"> @lang('layout.Total')
                                        {{$rowData['AccountName']}} 
                                    </td>
                                    <?php $totalRow = 0 ?>
                                    @foreach($rowData['Amount'] as $keyA => $valueA)
                                    <?php $totalRow += $valueA['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($valueA['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($totalRow)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                <tr>
                                    <th style=" font-size: 16px ;font-weight:bold">
                                        @lang('layout.TotalCostOfGoodSold')</th>
                                    <?php $totalCostOfGoodSold = 0 ?>
                                    @foreach($classes as $keyT => $valueT)
                                    <?php $totalCostOfGoodSold += $valueT['data']['totalCostOfGoodSold']; ?>
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{currency()->format($valueT['data']['totalCostOfGoodSold'],getRelatedCurrencyCode())}}
                                    </td>
                                    @endforeach
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{myRound($totalCostOfGoodSold)}}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <!----------------END COGS ----------------->

                <!----------------BEGIN GROSS PROFIT ----------------->
                <div class="row">
                    <div class="">
                        <div>
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr style="background-color:#f0f1ff">
                                    <td style="width: 100px;">
                                        <p class="report_a_title" style="font-weight: bold;">
                                            @lang('layout.GrossProfit')</p>
                                    </td>
                                    <?php $grossProfit = 0 ?>
                                    @foreach($classes as $keyT => $valueT)
                                    <?php $grossProfit += $valueT['data']['grossProfit']; ?>
                                    <td class="amountS" style="width: 100px;">
                                        <span class="report_a_title " id="">
                                            {{currency()->format($valueT['data']['grossProfit'],getRelatedCurrencyCode())}}</span>
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">
                                        <span class="report_a_title " id="">
                                            {{myRound($grossProfit)}}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                    </div>

                </div>
                <!----------------END GROSS PROFIT ----------------->

                <!----------------BEGIN EXPENSE ----------------->
                <div class="row">
                    <div class="">
                        <div onclick="showBody('expenses_account')">
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 100px;">
                                        <a class="report_a_title"><span id="" class="fa {{(session()->get("
                                                system_direction")=="rtl" )?'fa-angle-left':'fa-angle-right'}} "> </span> @lang('layout.Expense')</a>
                                        </td>
                                        <?php $totalExpense = 0 ?>
                                        @foreach($classes as $keyT => $valueT)
                                        <?php $totalExpense += $valueT['data']['totalExpense']; ?>
                                        <td class=" amountS" style="width: 100px;">
                                                <span class="report_a_title " id="">
                                                    {{currency()->format($valueT['data']['totalExpense'],getRelatedCurrencyCode())}}</span>
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">
                                        <span class="report_a_title " id="">
                                            {{myRound($totalExpense)}}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="mt-img">
                            <i class=""></i>
                        </div>
                        <div class="mt-body" id="expenses_account">
                            <table class="table table-striped  table-advance table-hover">
                                @foreach($expense as $rowData)
                                <tr style="background-color:#f1ebdb">
                                    <td class="mparent" style="width: 100px;">
                                        <a href="{{url('/account/'.$rowData['id'])}}" class="report_a">{{$rowData['AccountName']}}</a>
                                    </td>
                                    <?php $amountRow = 0 ?>
                                    @foreach($rowData['Amount'] as $keyA => $valueA)
                                    <?php $amountRow += $valueA['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueA['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRow)}}</td>
                                </tr>
                                <!-- begin first chiled -->
                                @if (!empty($rowData['children']) && getShowSubAccount() != "false")
                                @foreach($rowData['children'] as $key=>$fc)
                                <tr style="background-color:#d3eceb">
                                    <td class="fchild" style="width: 100px;"><b>{{$key+1}}</b> <a
                                            href="{{url('/account/'.$fc['id'])}}"
                                            class="report_a">{{$fc['AccountName']}}</a></td>
                                    <?php $amountRowFirstCh = 0 ?>
                                    @foreach($fc['Amount'] as $keyF => $valueF)
                                    <?php $amountRowFirstCh += $valueF['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueF['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowFirstCh)}}</td>
                                </tr>
                                <!-- begin second chiled -->
                                @if (!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                <tr style="background-color:#cae8cd">
                                    <td class="schild" style="width: 100px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @else
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}"
                                            class="report_a">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <?php $amountRowSecCh = 0 ?>
                                    @foreach($sc['Amount'] as $keyS => $valueS)
                                    <?php $amountRowSecCh += $valueS['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueS['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowSecCh)}}</td>
                                </tr>
                                <!-- begin therd chiled -->
                                @if (!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                <tr style="background-color:#cad7e8">
                                    <td class="tchild" style="width: 100px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @else
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}"
                                            class="report_a">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <?php $amountRowSecCh = 0 ?>
                                    @foreach($tc['Amount'] as $keyS => $valueS)
                                    <?php $amountRowSecCh += $valueS['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueS['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowSecCh)}}</td>
                                </tr>
                                @if(!empty($tc['children']))
                                <tr style="background-color:#acceaf">
                                    <td class="tchild borders" style="width: 100px;"> @lang('layout.Total')
                                        {{$tc['AccountName']}} </td>
                                    <?php $totalRowSecCh = 0 ?>
                                    @foreach($tc['Amount'] as $keyS => $valueS)
                                    <?php $totalRowSecCh += $valueS['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($valueS['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($totalRowSecCh)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd chiled -->
                                @if(!empty($sc['children']))
                                <tr style="background-color:#acceaf">
                                    <td class="schild borders" style="width: 100px;"> @lang('layout.Total')
                                        {{$sc['AccountName']}} </td>
                                    <?php $totalRowSecCh = 0 ?>
                                    @foreach($sc['Amount'] as $keyS => $valueS)
                                    <?php $totalRowSecCh += $valueS['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($valueS['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($totalRowSecCh)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end second chiled -->
                                @if(!empty($fc['children']))
                                <tr style="background-color:#afd2d0" class="borders">
                                    <td class="fchild" style="width: 100px;"> @lang('layout.Total')
                                        {{$fc['AccountName']}} </td>
                                    <?php $totalRowFirstCh = 0 ?>
                                    @foreach($fc['Amount'] as $keyF => $valueF)
                                    <?php $totalRowFirstCh += $valueF['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($valueF['total'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($totalRowFirstCh)}}</td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @if(!empty($rowData['children']))
                                <tr style="background-color:#bdb6a4" class="borders">
                                    <td class="mparent" style="width: 100px;"> @lang('layout.Total')
                                        {{$rowData['AccountName']}} 
                                    </td>
                                    <?php $totalRow = 0 ?>
                                    @foreach($rowData['Amount'] as $keyA => $valueA)
                                    <?php $totalRow += $valueA['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($valueA['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($totalRow)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                <tr>
                                    <th style=" font-size: 16px ;font-weight:bold">@lang('layout.TotalExpenses')
                                    </th>
                                    <?php $totalExpense = 0 ?>
                                    @foreach($classes as $keyT => $valueT)
                                    <?php $totalExpense += $valueT['data']['totalExpense']; ?>
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{currency()->format($valueT['data']['totalExpense'],getRelatedCurrencyCode())}}
                                    </td>
                                    @endforeach
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{myRound($totalExpense)}}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <!----------------END EXPENSE ----------------->

                <!----------------BEGIN Net Ordinary Income ----------------->
                <div class="row">
                    <div class="">
                        <div>
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr style="background-color:#f0f1ff">
                                    <td style="width: 100px;">
                                        <p class="report_a_title" style="font-weight: bold;">
                                            @lang('layout.NetOrdinaryIncome')</p>
                                    </td>
                                    <?php $netOrdeinaryIncome = 0 ?>
                                    @foreach($classes as $keyT => $valueT)
                                    <?php $netOrdeinaryIncome += $valueT['data']['netOrdeinaryIncome']; ?>
                                    <td class="amountS" style="width: 100px;">
                                        <span class="report_a_title " id="">
                                            {{currency()->format($valueT['data']['netOrdeinaryIncome'],getRelatedCurrencyCode())}}</span>
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">
                                        <span class="report_a_title " id="">
                                            {{myRound($netOrdeinaryIncome)}}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                    </div>

                </div>
                <!----------------END Net Ordinary Income ----------------->

                <!----------------BEGIN OTHER EXPENSE ----------------->
                <div class="row">
                    <div class="">
                        <div onclick="showBody('other_expenses_account')">
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 100px;">
                                        <a class="report_a_title"><span id="" class="fa {{(session()->get("
                                                system_direction")=="rtl" )?'fa-angle-left':'fa-angle-right'}} "> </span> @lang('layout.OtherExpense')</a>
                                        </td>
                                        <?php $totalOtherExpense = 0 ?>
                                        @foreach($classes as $keyT => $valueT)
                                        <?php $totalOtherExpense += $valueT['data']['totalOtherExpense']; ?>
                                        <td class=" amountS" style="width: 100px;">
                                                <span class="report_a_title " id="">
                                                    {{currency()->format($valueT['data']['totalOtherExpense'],getRelatedCurrencyCode())}}</span>
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">
                                        <span class="report_a_title " id="">
                                            {{myRound($totalOtherExpense)}}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="mt-img">
                            <i class=""></i>
                        </div>
                        <div class="mt-body" id="other_expenses_account">
                            <table class="table table-striped  table-advance table-hover">
                                @foreach($otherExpense as $rowData)
                                <tr style="background-color:#f1ebdb">
                                    <td class="mparent" style="width: 100px;">
                                        <a href="{{url('/account/'.$rowData['id'])}}" class="report_a">{{$rowData['AccountName']}}</a>
                                    </td>
                                    <?php $amountRow = 0 ?>
                                    @foreach($rowData['Amount'] as $keyA => $valueA)
                                    <?php $amountRow += $valueA['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueA['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRow)}}</td>
                                </tr>
                                <!-- begin first chiled -->
                                @if (!empty($rowData['children']) && getShowSubAccount() != "false")
                                @foreach($rowData['children'] as $key=>$fc)
                                <tr style="background-color:#d3eceb">
                                    <td class="fchild" style="width: 100px;"><b>{{$key+1}}</b> <a
                                            href="{{url('/account/'.$fc['id'])}}"
                                            class="report_a">{{$fc['AccountName']}}</a></td>
                                    <?php $amountRowFirstCh = 0 ?>
                                    @foreach($fc['Amount'] as $keyF => $valueF)
                                    <?php $amountRowFirstCh += $valueF['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueF['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowFirstCh)}}</td>
                                </tr>
                                <!-- begin second chiled -->
                                @if (!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                <tr style="background-color:#cae8cd">
                                    <td class="schild" style="width: 100px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @else
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}"
                                            class="report_a">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <?php $amountRowSecCh = 0 ?>
                                    @foreach($sc['Amount'] as $keyS => $valueS)
                                    <?php $amountRowSecCh += $valueS['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueS['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowSecCh)}}</td>
                                </tr>
                                <!-- begin therd chiled -->
                                @if (!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                <tr style="background-color:#cad7e8">
                                    <td class="tchild" style="width: 100px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @else
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}"
                                            class="report_a">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <?php $amountRowSecCh = 0 ?>
                                    @foreach($tc['Amount'] as $keyS => $valueS)
                                    <?php $amountRowSecCh += $valueS['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueS['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowSecCh)}}</td>
                                </tr>
                                @if(!empty($tc['children']))
                                <tr style="background-color:#acceaf">
                                    <td class="tchild borders" style="width: 100px;"> @lang('layout.Total')
                                        {{$tc['AccountName']}} </td>
                                    <?php $totalRowSecCh = 0 ?>
                                    @foreach($tc['Amount'] as $keyS => $valueS)
                                    <?php $totalRowSecCh += $valueS['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($valueS['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($totalRowSecCh)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd chiled -->
                                @if(!empty($sc['children']))
                                <tr style="background-color:#acceaf">
                                    <td class="schild borders" style="width: 100px;"> @lang('layout.Total')
                                        {{$sc['AccountName']}} </td>
                                    <?php $totalRowSecCh = 0 ?>
                                    @foreach($sc['Amount'] as $keyS => $valueS)
                                    <?php $totalRowSecCh += $valueS['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($valueS['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($totalRowSecCh)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end second chiled -->
                                @if(!empty($fc['children']))
                                <tr style="background-color:#afd2d0" class="borders">
                                    <td class="fchild" style="width: 100px;"> @lang('layout.Total')
                                        {{$fc['AccountName']}} </td>
                                    <?php $totalRowFirstCh = 0 ?>
                                    @foreach($fc['Amount'] as $keyF => $valueF)
                                    <?php $totalRowFirstCh += $valueF['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($valueF['total'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($totalRowFirstCh)}}</td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @if(!empty($rowData['children']))
                                <tr style="background-color:#bdb6a4" class="borders">
                                    <td class="mparent" style="width: 100px;"> @lang('layout.Total')
                                        {{$rowData['AccountName']}} 
                                    </td>
                                    <?php $totalRow = 0 ?>
                                    @foreach($rowData['Amount'] as $keyA => $valueA)
                                    <?php $totalRow += $valueA['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($valueA['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($totalRow)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                <tr>
                                    <th style=" font-size: 16px ;font-weight:bold">
                                        @lang('layout.TotalOtherExpenses')</th>
                                    <?php $totalOtherExpense = 0 ?>
                                    @foreach($classes as $keyT => $valueT)
                                    <?php $totalOtherExpense += $valueT['data']['totalOtherExpense']; ?>
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{currency()->format($valueT['data']['totalOtherExpense'],getRelatedCurrencyCode())}}
                                    </td>
                                    @endforeach
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{myRound($totalOtherExpense)}}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <!----------------END OTHER EXPENSE ----------------->

                <!----------------BEGIN OTHER INCOME ----------------->
                <div class="row">
                    <div class="">
                        <div onclick="showBody('other_income_accounts')">
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr>
                                    <td style="width: 100px;">
                                        <a class="report_a_title"><span id="" class="fa {{(session()->get("
                                                system_direction")=="rtl" )?'fa-angle-left':'fa-angle-right'}} "> </span> @lang('layout.OtherIncome')</a>
                                        </td>
                                        <?php $totalOtherIncome = 0 ?>
                                        @foreach($classes as $keyT => $valueT)
                                        <?php $totalOtherIncome += $valueT['data']['totalOtherIncome']; ?>
                                        <td class=" amountS" style="width: 100px;">
                                                <span class="report_a_title " id="">
                                                    {{currency()->format($valueT['data']['totalOtherIncome'],getRelatedCurrencyCode())}}</span>
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">
                                        <span class="report_a_title " id="">
                                            {{myRound($totalOtherIncome)}}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="mt-img">
                            <i class=""></i>
                        </div>
                        <div class="mt-body" id="other_income_accounts">
                            <table class="table table-striped  table-advance table-hover">
                                @foreach($otherIncome as $rowData)
                                <tr style="background-color:#f1ebdb">
                                    <td class="mparent" style="width: 100px;">
                                        <a href="{{url('/account/'.$rowData['id'])}}" class="report_a">{{$rowData['AccountName']}}</a>
                                    </td>
                                    <?php $amountRow = 0 ?>
                                    @foreach($rowData['Amount'] as $keyA => $valueA)
                                    <?php $amountRow += $valueA['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueA['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRow)}}</td>
                                </tr>
                                <!-- begin first chiled -->
                                @if (!empty($rowData['children']) && getShowSubAccount() != "false")
                                @foreach($rowData['children'] as $key=>$fc)
                                <tr style="background-color:#d3eceb">
                                    <td class="fchild" style="width: 100px;"><b>{{$key+1}}</b> <a
                                            href="{{url('/account/'.$fc['id'])}}"
                                            class="report_a">{{$fc['AccountName']}}</a></td>
                                    <?php $amountRowFirstCh = 0 ?>
                                    @foreach($fc['Amount'] as $keyF => $valueF)
                                    <?php $amountRowFirstCh += $valueF['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueF['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowFirstCh)}}</td>
                                </tr>
                                <!-- begin second chiled -->
                                @if (!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                <tr style="background-color:#cae8cd">
                                    <td class="schild" style="width: 100px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                        @else
                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}"
                                            class="report_a">{{$sc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <?php $amountRowSecCh = 0 ?>
                                    @foreach($sc['Amount'] as $keyS => $valueS)
                                    <?php $amountRowSecCh += $valueS['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueS['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowSecCh)}}</td>
                                </tr>
                                <!-- begin therd chiled -->
                                @if (!empty($sc['children']))
                                @foreach($sc['children'] as $key2=>$tc)
                                <tr style="background-color:#cad7e8">
                                    <td class="tchild" style="width: 100px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                        @else
                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}"
                                            class="report_a">{{$tc['AccountName']}}</a>
                                        <br>
                                    </td>
                                    <?php $amountRowSecCh = 0 ?>
                                    @foreach($tc['Amount'] as $keyS => $valueS)
                                    <?php $amountRowSecCh += $valueS['amount']; ?>
                                    <td class="amountS" style="width: 100px;">{{myRound($valueS['amount'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">{{myRound($amountRowSecCh)}}</td>
                                </tr>
                                @if(!empty($tc['children']))
                                <tr style="background-color:#acceaf">
                                    <td class="tchild borders" style="width: 100px;"> @lang('layout.Total')
                                        {{$tc['AccountName']}} </td>
                                    <?php $totalRowSecCh = 0 ?>
                                    @foreach($tc['Amount'] as $keyS => $valueS)
                                    <?php $totalRowSecCh += $valueS['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($valueS['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($totalRowSecCh)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd chiled -->
                                @if(!empty($sc['children']))
                                <tr style="background-color:#acceaf">
                                    <td class="schild borders" style="width: 100px;"> @lang('layout.Total')
                                        {{$sc['AccountName']}} </td>
                                    <?php $totalRowSecCh = 0 ?>
                                    @foreach($sc['Amount'] as $keyS => $valueS)
                                    <?php $totalRowSecCh += $valueS['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($valueS['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;text-decoration:underline overline">
                                        {{myRound($totalRowSecCh)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end second chiled -->
                                @if(!empty($fc['children']))
                                <tr style="background-color:#afd2d0" class="borders">
                                    <td class="fchild" style="width: 100px;"> @lang('layout.Total')
                                        {{$fc['AccountName']}} </td>
                                    <?php $totalRowFirstCh = 0 ?>
                                    @foreach($fc['Amount'] as $keyF => $valueF)
                                    <?php $totalRowFirstCh += $valueF['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($valueF['total'])}}</td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($totalRowFirstCh)}}</td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @if(!empty($rowData['children']))
                                <tr style="background-color:#bdb6a4" class="borders">
                                    <td class="mparent" style="width: 100px;"> @lang('layout.Total')
                                        {{$rowData['AccountName']}} 
                                    </td>
                                    <?php $totalRow = 0 ?>
                                    @foreach($rowData['Amount'] as $keyA => $valueA)
                                    <?php $totalRow += $valueA['total']; ?>
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($valueA['total'])}}
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px; font-weight:bolder;">
                                        {{myRound($totalRow)}}
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                <tr>
                                    <th style=" font-size: 16px ;font-weight:bold">@lang('layout.TotalOtherIncome')
                                    </th>
                                    <?php $totalOtherIncome = 0 ?>
                                    @foreach($classes as $keyT => $valueT)
                                    <?php $totalOtherIncome += $valueT['data']['totalOtherIncome']; ?>
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{currency()->format($valueT['data']['totalOtherIncome'],getRelatedCurrencyCode())}}
                                    </td>
                                    @endforeach
                                    <td style="font-size: 16px ;font-weight:bold" class="amountS">
                                        {{myRound($totalOtherIncome)}}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <!----------------END OTHER INCOME ----------------->

                <!----------------BEGIN Net Income ----------------->
                <div class="row">
                    <div class="">
                        <div>
                            <table class="table table-striped  table-advance table-hover" style="width: 100%;">
                                <tr style="background-color:#f0f1ff">
                                    <td style="width: 100px;">
                                        <p class="report_a_title" style="font-weight: bold;">
                                            @lang('layout.NetIncome')</p>
                                    </td>
                                    <?php $netProfit = 0 ?>
                                    @foreach($classes as $keyT => $valueT)
                                    <?php $netProfit += $valueT['data']['netProfit']; ?>
                                    <td class="amountS" style="width: 100px;">
                                        <span class="report_a_title " id="">
                                            {{currency()->format($valueT['data']['netProfit'],getRelatedCurrencyCode())}}</span>
                                    </td>
                                    @endforeach
                                    <td class="amountS" style="width: 100px;">
                                        <span class="report_a_title " id="">
                                            {{myRound($netProfit)}}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <!----------------END Net Income ----------------->




            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>


@stop
@include('groupCompanyFilter.select')
@push('scripts')
<script type="text/javascript">
    //Begin Toggle div
    function showBody(partName) {
        if (partName == "income_accounts") {
            $('#income_accounts_fa').toggleClass("fa-angle-left fa-angle-down");
            $('#income_accounts').toggle();
            $('#income_amount').toggle();
            $('#last_income_amount').toggle();
            $('#money_change_income_amount').toggle();
            $('#percent_change_income_amount').toggle();
        }

        if (partName == "cogs_account") {
            $('#cogs_account_fa').toggleClass("fa-angle-left fa-angle-down");
            $('#cogs_account').toggle();
            $('#cogs_amount').toggle();
            $('#last_cogs_amount').toggle();
            $('#money_change_cogs_amount').toggle();
            $('#percent_change_cogs_amount').toggle();
        }


        if (partName == "expenses_account") {
            $('#expenses_account_fa').toggleClass("fa-angle-left fa-angle-down");
            $('#expenses_account').toggle();
            $('#expense_amount').toggle();
            $('#last_expense_amount').toggle();
            $('#money_change_expense_amount').toggle();
            $('#percent_change_expense_amount').toggle();
        }

        if (partName == "other_expenses_account") {
            $('#other_expenses_account_fa').toggleClass("fa-angle-left fa-angle-down");
            $('#other_expenses_account').toggle();
            $('#other_expense_amount').toggle();
            $('#last_other_expense_amount').toggle();
            $('#money_change_other_expense_amount').toggle();
            $('#percent_change_other_expense_amount').toggle();
        }

        if (partName == "other_income_accounts") {
            $('#other_income_accounts_fa').toggleClass("fa-angle-left fa-angle-down");
            $('#other_income_accounts').toggle();
            $('#other_income_amount').toggle();
            $('#last_other_income_amount').toggle();
            $('#money_change_other_income_amount').toggle();
            $('#percent_change_other_income_amount').toggle();
        }
    }

    function toggleList() {
        $('.mt-body').toggle();
        $('#toggle_list').toggleClass("fa-eye fa-eye-slash");

        $('#income_amount').toggle();
        $('#last_income_amount').toggle();
        $('#money_change_income_amount').toggle();
        $('#percent_change_income_amount').toggle();
        $('#cogs_amount').toggle();
        $('#last_cogs_amount').toggle();
        $('#money_change_cogs_amount').toggle();
        $('#percent_change_cogs_amount').toggle();
        $('#expense_amount').toggle();
        $('#last_expense_amount').toggle();
        $('#money_change_expense_amount').toggle();
        $('#percent_change_expense_amount').toggle();
        $('#other_expense_amount').toggle();
        $('#last_other_expense_amount').toggle();
        $('#money_change_other_expense_amount').toggle();
        $('#percent_change_other_expense_amount').toggle();
        $('#other_income_amount').toggle();
        $('#last_other_income_amount').toggle();
        $('#money_change_other_income_amount').toggle();
        $('#percent_change_other_income_amount').toggle();

        $('#income_accounts_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#cogs_account_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#expenses_account_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#other_expenses_account_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#other_income_accounts_fa').toggleClass("fa-angle-left fa-angle-down");
    }
</script>

@endpush