@extends('layouts.app')
@section('style')
    <style>
        .border-buttom{
            border-bottom: 1px solid deepskyblue;

            margin: 20px;
        }
    </style>
@endsection
@section('content')
    <div class="row">
        <div class="row">

            <div class="col-lg-12">
                <div class="portlet light portlet-fit bordered">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class=" icon-layers font-green"></i>
                            <span class="caption-subject font-green bold uppercase">@lang('layout.IncomeAccount')</span>
                            {{--<div class="caption-desc font-grey-cascade"> Add <pre class="mt-code">.ribbon-round</pre> to your <pre class="mt-code">.ribbon</pre> element to add shadow. </div>--}}
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="mt-element-ribbon bg-grey-steel">
                                    <div class="ribbon ribbon-round ribbon-color-primary uppercase">@lang('layout.AllIncomeAccount') </div>
                                    <div class="ribbon-content">


                                        <div class="col-xs-6 col-md-6">@lang('layout.AccountName')</div>
                                        <div class="col-xs-6 col-md-6">price</div>
                                        @foreach($income as $incomeAccount)
                                            <div class="col-md-6">

                                                <div class="border-buttom">{{$incomeAccount->AccountName}}</div>
                                            </div>
                                            <div class="col-md-6">

                                                <div class="border-buttom">{{currency()->format($incomeAccount->Amount) }}</div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <p class="ribbon-content">
                                    <li class="list-group-item bg-blue bg-font-blue"> @lang('layout.TotalIncome') <div align="right"> {{currency()->format($totalIncome)}}</div></li>

                                    </p>

                                </div>
                            </div>

                            <div class="col-xs-12">
                                <div class="mt-element-ribbon bg-grey-steel">
                                    <div class="ribbon ribbon-round ribbon-color-primary uppercase">@lang('layout.AllCostOfGoodSoldAccount') </div>
                                    <div class="ribbon-content">

                                        <div class="col-xs-6 col-md-6">@lang('layout.AccountName')</div>
                                        <div class="col-xs-6 col-md-6">price</div>
                                        @foreach($costOfGoodSold as $incomeAccount)
                                            <div class="col-md-6">

                                                <div class="border-buttom">{{$incomeAccount->AccountName}}</div>
                                            </div>
                                            <div class="col-md-6">

                                                <div class="border-buttom">{{currency()->format($incomeAccount->Amount) }}</div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <p class="ribbon-content">
                                    <li class="list-group-item bg-red bg-font-red"> @lang('layout.TotalCostOfGoodSold') <div align="right"> {{currency()->format($totalCostOfGoodSold)}}</div></li>
                                    </p>

                                </div>
                            </div>
                            <div class="col-md-12">

                                <p>
                                <li class="list-group-item bg-green bg-font-green"> @lang('layout.GrossProfit')  <div align="right"> {{currency()->format($grossProfit)}}</div></li>
                                </p>
                            </div>

                            <div class="col-xs-12">
                                <div class="mt-element-ribbon bg-grey-steel">
                                    <div class="ribbon ribbon-round ribbon-color-primary uppercase">@lang('layout.AllExpenseAccount') </div>
                                    <div class="ribbon-content">


                                        <div class="col-xs-6 col-md-6">@lang('layout.AccountName')</div>
                                        <div class="col-xs-6 col-md-6">price</div>
                                        @foreach($expense as $incomeAccount)
                                            <div class="col-md-6">

                                                <div class="border-buttom">{{$incomeAccount->AccountName}}</div>
                                            </div>
                                            <div class="col-md-6">

                                                <div class="border-buttom">{{currency()->format($incomeAccount->Amount) }}</div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <p class="ribbon-content">
                                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.TotalOtherExpense') <div align="right"> {{currency()->format($totalExpense)}}</div></li>

                                </div>
                            </div>

                            <div class="col-xs-12">
                                <div class="mt-element-ribbon bg-grey-steel">
                                    <div class="ribbon ribbon-round ribbon-color-primary uppercase">@lang('layout.AllOtherExpenseAccount') </div>
                                    <div class="ribbon-content">


                                        <div class="col-xs-6 col-md-6">@lang('layout.AccountName')</div>
                                        <div class="col-xs-6 col-md-6">price</div>
                                        @foreach($otherExpense as $incomeAccount)
                                            <div class="col-md-6">

                                                <div class="border-buttom">{{$incomeAccount->AccountName}}</div>
                                            </div>
                                            <div class="col-md-6">

                                                <div class="border-buttom">{{currency()->format($incomeAccount->Amount) }}</div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <p class="ribbon-content">
                                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.TotalOtherExpense') <div align="right"> {{currency()->format($totalOtherExpense)}}</div></li>

                                </div>
                            </div>

                            <div class="col-xs-12">
                                <div class="mt-element-ribbon bg-grey-steel">
                                    <div class="ribbon ribbon-round ribbon-color-primary uppercase">@lang('layout.AllOtherIncomeAccount') </div>
                                    <div class="ribbon-content">

                                        <div class="col-xs-6 col-md-6">@lang('layout.AccountName')</div>
                                        <div class="col-xs-6 col-md-6">price</div>
                                        @foreach($otherIncome as $incomeAccount)
                                            <div class="col-md-6">

                                                <div class="border-buttom">{{$incomeAccount->AccountName}}</div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="border-buttom">{{currency()->format($incomeAccount->Amount) }}</div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <p class="ribbon-content">
                                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.TotalOtherIncome') <div align="right"> {{currency()->format($totalOtherIncome)}}</div></li>

                                </div>
                            </div>

                            <div class="col-md-12">

                                <p>
                                <li class="list-group-item bg-green bg-font-green"> @lang('layout.NetProfit')  <div align="right"> {{currency()->format($netProfit)}}</div></li>
                                </p>
                            </div>
                            {{--<div class="col-xs-12">--}}
                                {{--<div class="mt-element-ribbon bg-grey-steel">--}}
                                    {{--<div class="ribbon ribbon-right ribbon-round ribbon-color-info ribbon-shadow uppercase">Rounded Ribbon</div>--}}
                                    {{--<p class="ribbon-content">Duis mollis, est non commodo luctus, nisi erat porttitor ligula</p>--}}
                                {{--</div>--}}
                            {{--</div>--}}
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

 
@endsection

