@extends('layouts.factor-master')

@section('style')
<style type="text/css">
    ul,
    #treeUL {
        list-style-type: none;
    }

    #treeUL {
        margin: 0;
        padding: 0;
    }

    .rt1 {
        font-size: 24px;
        font-weight: bold;
        /* color: green; */
    }

    .rt2 {
        font-size: 22px;
        font-weight: bold;
        /* color: purple; */
    }

    .rt3 {
        font-size: 20px;
        font-weight: bold;
        /* color: red; */
    }

    .rt4 {
        font-size: 16px;
        font-weight: bold;
        text-align: center;
        color: white;
    }

    a {
        color: black;
        text-decoration: none;
    }

    a:hover {
        color: black;
        text-decoration: none;
    }

    .asset {
        /* background-color: #1BA39C; */
        color: black;
        border: 1px solid rgba(85, 85, 85, 0.169);
        border-radius: 5px;
        padding: 10px 0px 10px 40px; !important;
        /* background-color: ; */
        /* color: black; */
        text-align: center;
    }

    .currentasset {
        /* background-color: #1BBC9B; */
        color: black;
        padding: 0px 0px 0px 0px; !important;
        margin: 0px !important;
        /* color: black; */
        background-color: rgba(82, 82, 82, 0.169);
    }

    .assetOther {
        /* background-color: #026d57; */
        color: black;
    }

    .assetBank {
        /* background-color: #792600;
        color: white; */
        background-color: rgba(172, 172, 172, 0.602);
        color: black;
    }

    .assetReceiv {
        /* background-color: #37655b;
        color: white; */
        background-color: rgba(82, 82, 82, 0.169);
        color: black;
    }

    .fixasset {
        /* background-color: #026d57;
        color: white; */
        background-color: ;
        color: black;
    }

    .otherasset {
        background-color: #058c70;
        color: black;
    }

    .lib {
        background-color: #02558e;
        color: black;
    }

    .libPay {
        background-color: #286aa5;
        color: black;
    }

    .equity {
        background-color: #1a4171;
        color: black;
    }

    .am {
        font-size: 18px;
        color: black;
    }

    /*
    li {
        font-size: 16px;
        color: crimson;
        font-weight: 500;
    }
    .rootTree::before {
        content: "\25B6";
        color: black;
        display: inline-block;
        margin-right: 6px;
    }
    .rootTree-down::before {
        transform: rotate(90deg);
    }
    .children {
        display: none;
    }
    .active {
        display: block;
    }   */
</style>
@stop
@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.IncomeStatement')
    <span class="text-primary">(
        <b> {{getHomeCurrency()['name']}}) </b>
    </span>
</h3>
<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>
</table>
<br>

<ul id="treeUL">

    <li class="asset">
        <table class="rt1">

        </table>

        <ul class="children">
            <li class="currentasset">
                <table class="main main-table rt2">
                    <tr>
                        <td colspan="2" style="color:black; text-align: center;">@lang('layout.OrdinaryIncome/Expense') </td>
                    </tr>
                </table>

                <ul class="children" style="padding: 0px !important;">
                    <li class="assetOther" style="padding: 0px !important;">
                        <table class="main main-table rt3">
                            <tr>
                                <td colspan="2" style="color:black; text-align: center;">@lang('layout.Income') </td>
                            </tr>
                        </table>
                        <ul class="children">
                            <table class="main main-table">
                                @foreach($income as $accountRow)
                                @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                                <tr>
                                    <td style="padding: 6px;  font-weight: bolder; font-size: 25px">
                                        <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    <td class="am">{{myRound($accountRow['Amount']) }}
                                        @if(!empty($accountRow['children']))
                                        <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                        :{{myRound($accountRow['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td style="padding:0px 40px 0px 0px;  font-weight: bolder; font-size: 20px">
                                        <b style="color:black">{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}" style="">{{$fc['AccountName']}}</a>
                                    </td>
                                    <td class="am">{{myRound($fc['Amount']) }}
                                        @if(!empty($fc['children']))
                                        <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td style="padding:0px 80px 0px 0px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b style="color:black">{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b style="color:black">{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                        <br/>
                                    </td>
                                    <td class="am">{{myRound($sc['Amount']) }}
                                        @if(!empty($sc['children']))
                                        <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key1=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td style="padding:0px 100px 0px 0px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b style="color:black">{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b style="color:black">{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                        <br/>
                                    </td>
                                    <td class="am">{{myRound($tc['Amount']) }}
                                        @if(!empty($tc['children']))
                                        <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd chiled -->
                                @endforeach
                                @endif
                                <!-- end second chiled -->
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @endforeach
                            </table>
                        </ul>
                    </li>
                    <li class="assetOther">
                        <table class="main main-table rt3">
                            <tr>

                                <td style="color:black;">@lang('layout.TotalIncome') </td>
                                <td style="color:black;">{{myRound($totalIncome)}}</td>

                            </tr>
                        </table>
                    </li>

                    <li class="assetBank">
                        <table class="rt3">
                            <tr>
                                <td colspan="2" style="color:black; text-align: center;">
                                    @lang('layout.CostOfGoodSold') </td>
                            </tr>
                        </table>

                        <ul class="children">
                            <table class=" main-table">
                                @foreach($costOfGoodSold as $accountRow)
                                @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                                <tr>
                                    <td style="padding: 6px;  font-weight: bolder; font-size: 25px">
                                        <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    <td class="am">{{myRound($accountRow['Amount']) }}
                                        @if(!empty($accountRow['children']))
                                        <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                        :{{myRound($accountRow['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td style="padding:0px 40px 0px 0px;  font-weight: bolder; font-size: 20px">
                                        <b style="color:black">{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}" style="">{{$fc['AccountName']}}</a>
                                    </td>
                                    <td class="am">{{myRound($fc['Amount']) }}
                                        @if(!empty($fc['children']))
                                        <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td style="padding:0px 80px 0px 0px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b style="color:black">{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b style="color:black">{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                        <br/>
                                    </td>
                                    <td class="am">{{myRound($sc['Amount']) }}
                                        @if(!empty($sc['children']))
                                        <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key1=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td style="padding:0px 100px 0px 0px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b style="color:black">{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b style="color:black">{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                        <br/>
                                    </td>
                                    <td class="am">{{myRound($tc['Amount']) }}
                                        @if(!empty($tc['children']))
                                        <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd chiled -->
                                @endforeach
                                @endif
                                <!-- end second chiled -->
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @endforeach
                            </table>
                        </ul>
                    </li>
                    <li class="assetBank">
                        <table class="main main-table rt3">
                            <tr>
                                <td style="color:black;">@lang('layout.TotalCostOfGoodSold') </td>
                                <td style="color:black;">{{myRound($totalCostOfGoodSold)}}</td>
                            </tr>
                        </table>
                    </li>


                    <li class="assetReceiv">
                        <table class="main main-table rt3">
                            <tr>
                                <td style="color:black">@lang('layout.GrossProfit') </td>
                                <td style="color:black">{{myRound($grossProfit)}}</td>



                            </tr>
                        </table>
                    </li>

                    <li class="assetBank">
                        <table class="rt3">
                            <tr>
                                <td colspan="2" style="color:black;">@lang('layout.Expense') </td>
                            </tr>
                        </table>

                        <ul class="children">
                            <table class=" main-table">
                                @foreach($expense as $accountRow)
                                @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                                <tr>
                                    <td style="padding: 6px;  font-weight: bolder; font-size: 25px">
                                        <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    <td class="am">{{myRound($accountRow['Amount']) }}
                                        @if(!empty($accountRow['children']))
                                        <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                        :{{myRound($accountRow['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td style="padding:0px 40px 0px 0px;  font-weight: bolder; font-size: 20px">
                                        <b style="color:black">{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}" style="">{{$fc['AccountName']}}</a>
                                    </td>
                                    <td class="am">{{myRound($fc['Amount']) }}
                                        @if(!empty($fc['children']))
                                        <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td style="padding:0px 80px 0px 0px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b style="color:black">{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b style="color:black">{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                        <br/>
                                    </td>
                                    <td class="am">{{myRound($sc['Amount']) }}
                                        @if(!empty($sc['children']))
                                        <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key1=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td style="padding:0px 100px 0px 0px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b style="color:black">{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b style="color:black">{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                        <br/>
                                    </td>
                                    <td class="am">{{myRound($tc['Amount']) }}
                                        @if(!empty($tc['children']))
                                        <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd chiled -->
                                @endforeach
                                @endif
                                <!-- end second chiled -->
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @endforeach
                            </table>
                        </ul>
                    </li>
                    <li class="assetBank">
                        <table class="main main-table rt3">
                            <tr>
                                <td style="color:black;">@lang('layout.TotalExpense') </td>
                                <td style="color:black;">{{myRound($totalExpense)}}</td>
                            </tr>
                        </table>
                    </li>
                </ul>
            </li>
            <li class="currentasset">
                <table class="main main-table rt2">
                    <tr>
                        <td style="color:black">@lang('layout.NetOrdinaryIncome') </td>
                        <td style="color:black">{{myRound($netOrdeinaryIncome)}}</td>
                    </tr>
                </table>
            </li>

            <li class="fixasset">
                <table class="rt2">
                    <tr>
                        <td colspan="2" style="color:black">@lang('layout.OtherIncome/Expense') </td>
                    </tr>
                </table>
                <ul class="children" style="padding: 0px !important;">

                    <li class="assetReceiv">
                        <table class="rt3" style="">
                            <tr>
                                <td colspan="2" style="color:black">@lang('layout.OtherIncome') </td>
                            </tr>
                        </table>
                        <ul class="children">
                            <table class=" main-table">
                                @foreach($otherIncome as $accountRow)
                                @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                                <tr>
                                    <td style="padding: 6px;  font-weight: bolder; font-size: 25px">
                                        <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    <td class="am">{{myRound($accountRow['Amount']) }}
                                        @if(!empty($accountRow['children']))
                                        <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                        :{{myRound($accountRow['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td style="padding:0px 40px 0px 0px;  font-weight: bolder; font-size: 20px">
                                        <b style="color:black">{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}" style="">{{$fc['AccountName']}}</a>
                                    </td>
                                    <td class="am">{{myRound($fc['Amount']) }}
                                        @if(!empty($fc['children']))
                                        <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td style="padding:0px 80px 0px 0px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b style="color:black">{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b style="color:black">{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                        <br/>
                                    </td>
                                    <td class="am">{{myRound($sc['Amount']) }}
                                        @if(!empty($sc['children']))
                                        <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key1=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td style="padding:0px 100px 0px 0px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b style="color:black">{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b style="color:black">{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                        <br/>
                                    </td>
                                    <td class="am">{{myRound($tc['Amount']) }}
                                        @if(!empty($tc['children']))
                                        <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd chiled -->
                                @endforeach
                                @endif
                                <!-- end second chiled -->
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @endforeach
                            </table>
                        </ul>
                    </li>
                    <li class="assetReceiv">
                        <table class="main main-table rt3" style="">
                            <tr style="">

                                <td style="color:black;">@lang('layout.TotalOtherIncome') </td>
                                <td style="color:black;">{{myRound($totalOtherIncome)}}</td>

                            </tr>
                        </table>
                    </li>


                    <li class="assetBank" style="padding: 0px;">
                        <table class="rt3" style="padding: 0px !important;">
                            <tr>
                                <td colspan="2" style="color:black">@lang('layout.OtherExpense') </td>
                            </tr>
                        </table>

                        <ul class="children" style="padding: 0px !important;">
                            <table class=" main-table">
                                @foreach($otherExpense as $accountRow)
                                @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                                <tr>
                                    <td style="padding: 6px;  font-weight: bolder; font-size: 25px">
                                        <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                    </td>
                                    <td class="am">{{myRound($accountRow['Amount']) }}
                                        @if(!empty($accountRow['children']))
                                        <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                        :{{myRound($accountRow['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin first chiled -->
                                @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                                @foreach($accountRow['children'] as $key=>$fc)
                                @if($fc['Amount'] != 0 || !empty($fc['children']))
                                <tr>
                                    <td style="padding:0px 40px 0px 0px;  font-weight: bolder; font-size: 20px">
                                        <b style="color:black">{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}" style="">{{$fc['AccountName']}}</a>
                                    </td>
                                    <td class="am">{{myRound($fc['Amount']) }}
                                        @if(!empty($fc['children']))
                                        <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin second chiled -->
                                @if(!empty($fc['children']))
                                @foreach($fc['children'] as $key1=>$sc)
                                @if($sc['Amount'] != 0 || !empty($sc['children']))
                                <tr>
                                    <td style="padding:0px 80px 0px 0px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b style="color:black">{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b style="color:black">{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                        <br/>
                                    </td>
                                    <td class="am">{{myRound($sc['Amount']) }}
                                        @if(!empty($sc['children']))
                                        <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                <!-- begin therd chiled -->
                                @if(!empty($sc['children']))
                                @foreach($sc['children'] as $key1=>$tc)
                                @if($tc['Amount'] != 0 || !empty($tc['children']))
                                <tr>
                                    <td style="padding:0px 100px 0px 0px;">
                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                        <b style="color:black">{{$key1+1}}-{{$key+1}}</b>
                                        @endif
                                        @if(App::isLocale('en'))
                                        <b style="color:black">{{$key+1}}-{{$key1+1}}</b>
                                        @endif
                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                        <br/>
                                    </td>
                                    <td class="am">{{myRound($tc['Amount']) }}
                                        @if(!empty($tc['children']))
                                        <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                                        @endif
                                    </td>
                                </tr>
                                @endif
                                @endforeach
                                @endif
                                <!-- end therd chiled -->
                                @endforeach
                                @endif
                                <!-- end second chiled -->
                                @endforeach
                                @endif
                                <!-- end first chiled -->
                                @endforeach
                            </table>
                        </ul>
                    </li>
                    <li class="assetBank">
                        <table class="main main-table rt3">
                            <tr>
                                <td style="color:black;">@lang('layout.TotalOtherExpenses') </td>
                                <td style="color:black;">{{myRound($totalOtherExpense)}}</td>
                            </tr>
                        </table>
                    </li>
                </ul>
            </li>
            <li class="fixasset">
                <table class="main main-table rt2">
                    <tr>
                        <td style="color:black">@lang('layout.NetOtherIncome') </td>
                        <td style="color:black">{{myRound($netOtherIncome)}}</td>
                    </tr>
                </table>
            </li>

        </ul>
    </li>
    <li class="asset" style="padding: 0px;">
        <table class="main main-table rt1">
            <tr>

                <td style="color:black; text-align: center">@lang('layout.NetProfit') </td>
                <td style="color:black; text-align: center">{{myRound($netProfit)}}</td>

            </tr>
        </table>
    </li>
</ul>

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection