@extends('layouts.factor-master')

@section('style')
<style type="text/css">
    .a_style {
        color: black !important;
        text-decoration: none;
    }
</style>
@stop
@section('content')

<?php
$setting_jalali = isset(uSetting()->jalali_and_gerogarian_date);
$setting_date_type = isset(uSetting()->date_type);

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.IncomeStatement')
    <span class="text-primary">(
        <b> {{getHomeCurrency()['name']}}) </b>
    </span>
</h3>
<table class="main-table">
    <tr>
      @if($from_date)
     <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">    @if($setting_jalali == 'true')  {{convertDate($from_date, null, null, (($setting_date_type == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">    @if($setting_jalali) == 'true')  {{convertDate($to_date, null, null, (($setting_date_type == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
  </table>
<table id="main" class="main-table">

    <tr>
        <th>@lang('layout.Category')</th>
        <th>@lang('layout.AccountName')</th>
        {{-- <th>@lang('layout.AccountType')</th> --}}
        <th>@lang('layout.Amount')</th>
    </tr>
    <tr>
        <th colspan="3" style="background-color: #e8edff; color:#669;">@lang('layout.Income'):</th>
    </tr>
    @foreach($income as $accountRow)
    @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
    <tr>
        <td></td>
        <td style="padding: 6px; color: black; font-weight: bolder; font-size: 25px">
            <a href="{{url('/account/'.$accountRow['id'])}}" class="a_style">{{$accountRow['AccountName']}}</a>
        </td>
        <td>{{myRound($accountRow['Amount']) }}
            @if(!empty($accountRow['children']))
            <br>@lang('layout.Total') {{$accountRow['AccountName']}} :{{myRound($accountRow['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin first chiled -->
    @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
    @foreach($accountRow['children'] as $key=>$fc)
    @if($fc['Amount'] != 0 || !empty($fc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 40px 0px 0px; color: black; font-weight: bolder; font-size: 20px">
            <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}" class="a_style">{{$fc['AccountName']}}</a>
        </td>
        <td>{{myRound($fc['Amount']) }}
            @if(!empty($fc['children']))
            <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin second chiled -->
    @if(!empty($fc['children']))
    @foreach($fc['children'] as $key1=>$sc)
    @if($sc['Amount'] != 0 || !empty($sc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 80px 0px 0px;">
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a href="{{url('/account/'.$sc['id'])}}" class="a_style">{{$sc['AccountName']}}</a>
            <br>
        </td>
        <td>{{myRound($sc['Amount']) }}
            @if(!empty($sc['children']))
            <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin therd chiled -->
    @if(!empty($sc['children']))
    @foreach($sc['children'] as $key1=>$tc)
    @if($tc['Amount'] != 0 || !empty($tc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 100px 0px 0px;">
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a href="{{url('/account/'.$tc['id'])}}" class="a_style">{{$tc['AccountName']}}</a>
            <br>
        </td>
        <td>{{myRound($tc['Amount']) }}
            @if(!empty($tc['children']))
            <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    @endforeach
    @endif
    <!-- end therd chiled -->
    @endforeach
    @endif
    <!-- end second chiled -->
    @endforeach
    @endif
    <!-- end first chiled -->
    @endforeach
    <tr>
        <td colspan="2" style="background-color: #e8edff; color:#669; font-size: 12px"> @lang('layout.TotalIncome'):
        </td>
        <td style="background-color: #e8edff; color:#669;">{{myRound($totalIncome)}}</td>
    </tr>
    @foreach($costOfGoodSold as $accountRow)
    @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
    <tr>
        <td></td>
        <td style="padding: 6px; color: black; font-weight: bolder; font-size: 25px">
            <a href="{{url('/account/'.$accountRow['id'])}}" class="a_style">{{$accountRow['AccountName']}}</a>
        </td>
        <td>{{myRound($accountRow['Amount']) }}
            @if(!empty($accountRow['children']))
            <br>@lang('layout.Total') {{$accountRow['AccountName']}} :{{myRound($accountRow['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin first chiled -->
    @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
    @foreach($accountRow['children'] as $key=>$fc)
    @if($fc['Amount'] != 0 || !empty($fc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 40px 0px 0px; color: black; font-weight: bolder; font-size: 20px">
            <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}" class="a_style">{{$fc['AccountName']}}</a>
        </td>
        <td>{{myRound($fc['Amount']) }}
            @if(!empty($fc['children']))
            <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin second chiled -->
    @if(!empty($fc['children']))
    @foreach($fc['children'] as $key1=>$sc)
    @if($sc['Amount'] != 0 || !empty($sc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 80px 0px 0px;">
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a href="{{url('/account/'.$sc['id'])}}" class="a_style">{{$sc['AccountName']}}</a>
            <br>
        </td>
        <td>{{myRound($sc['Amount']) }}
            @if(!empty($sc['children']))
            <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin therd chiled -->
    @if(!empty($sc['children']))
    @foreach($sc['children'] as $key1=>$tc)
    @if($tc['Amount'] != 0 || !empty($tc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 100px 0px 0px;">
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a href="{{url('/account/'.$tc['id'])}}" class="a_style">{{$tc['AccountName']}}</a>
            <br>
        </td>
        <td>{{myRound($tc['Amount']) }}
            @if(!empty($tc['children']))
            <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    @endforeach
    @endif
    <!-- end therd chiled -->
    @endforeach
    @endif
    <!-- end second chiled -->
    @endforeach
    @endif
    <!-- end first chiled -->
    @endforeach
    <tr>
        <td colspan="2" style="background-color: #e8edff; color:#669; font-size: 12px">
            @lang('layout.TotalCostOfGoodSold'):</td>
        <td style="background-color: #e8edff; color:#669">{{myRound($totalCostOfGoodSold)}}</td>
    </tr>
    <tr>
        <th colspan="2" style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.GrossProfit'):
            {{-- <span style="margin-left: 78.5%;font-size: 15px">{{$totalAsset}}</span> --}}
        </th>
        <td style="background-color: #e8edff; color:#669;">{{myRound($grossProfit)}}</td>
    </tr>
    <tr>
        <th>@lang('layout.Category')</th>
        <th>@lang('layout.AccountName')</th>
        {{-- <th>@lang('layout.AccountType')</th> --}}
        <th>@lang('layout.Amount')</th>
    </tr>
    <tr>
    <tr>
        <th colspan="3" style="background-color: #e8edff; color:#669;">@lang('layout.AllExpenseAccounts'):</th>
    </tr>
    @foreach($expense as $accountRow)
    @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
    <tr>
        <td></td>
        <td style="padding: 6px; color: black; font-weight: bolder; font-size: 25px">
            <a href="{{url('/account/'.$accountRow['id'])}}" class="a_style">{{$accountRow['AccountName']}}</a>
        </td>
        <td>{{myRound($accountRow['Amount']) }}
            @if(!empty($accountRow['children']))
            <br>@lang('layout.Total') {{$accountRow['AccountName']}} :{{myRound($accountRow['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin first chiled -->
    @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
    @foreach($accountRow['children'] as $key=>$fc)
    @if($fc['Amount'] != 0 || !empty($fc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 40px 0px 0px; color: black; font-weight: bolder; font-size: 20px">
            <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}" class="a_style">{{$fc['AccountName']}}</a>
        </td>
        <td>{{myRound($fc['Amount']) }}
            @if(!empty($fc['children']))
            <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin second chiled -->
    @if(!empty($fc['children']))
    @foreach($fc['children'] as $key1=>$sc)
    @if($sc['Amount'] != 0 || !empty($sc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 80px 0px 0px;">
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a href="{{url('/account/'.$sc['id'])}}" class="a_style">{{$sc['AccountName']}}</a>
            <br>
        </td>
        <td>{{myRound($sc['Amount']) }}
            @if(!empty($sc['children']))
            <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin therd chiled -->
    @if(!empty($sc['children']))
    @foreach($sc['children'] as $key1=>$tc)
    @if($tc['Amount'] != 0 || !empty($tc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 100px 0px 0px;">
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a href="{{url('/account/'.$tc['id'])}}" class="a_style">{{$tc['AccountName']}}</a>
            <br>
        </td>
        <td>{{myRound($tc['Amount']) }}
            @if(!empty($tc['children']))
            <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    @endforeach
    @endif
    <!-- end therd chiled -->
    @endforeach
    @endif
    <!-- end second chiled -->
    @endforeach
    @endif
    <!-- end first chiled -->
    @endforeach
    <tr>
        <th colspan="2" style="background-color: #e8edff; color:#669; font-size: 12px">
            @lang('layout.TotalOtherExpenses'):
            {{-- <span style="margin-left: 70%;">{{$TotalLiability}}</span> --}}
        </th>
        <td style="background-color: #e8edff; color:#669;">{{myRound($totalExpense)}}</td>

    </tr>
    <tr>
        <th colspan="3" style="background-color: #e8edff; color:#669;">@lang('layout.AllOtherExpenseAccounts'):</th>
    </tr>
    @foreach($otherExpense as $accountRow)
    @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
    <tr>
        <td></td>
        <td style="padding: 6px; color: black; font-weight: bolder; font-size: 25px">
            <a href="{{url('/account/'.$accountRow['id'])}}" class="a_style">{{$accountRow['AccountName']}}</a>
        </td>
        <td>{{myRound($accountRow['Amount']) }}
            @if(!empty($accountRow['children']))
            <br>@lang('layout.Total') {{$accountRow['AccountName']}} :{{myRound($accountRow['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin first chiled -->
    @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
    @foreach($accountRow['children'] as $key=>$fc)
    @if($fc['Amount'] != 0 || !empty($fc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 40px 0px 0px; color: black; font-weight: bolder; font-size: 20px">
            <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}" class="a_style">{{$fc['AccountName']}}</a>
        </td>
        <td>{{myRound($fc['Amount']) }}
            @if(!empty($fc['children']))
            <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin second chiled -->
    @if(!empty($fc['children']))
    @foreach($fc['children'] as $key1=>$sc)
    @if($sc['Amount'] != 0 || !empty($sc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 80px 0px 0px;">
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a href="{{url('/account/'.$sc['id'])}}" class="a_style">{{$sc['AccountName']}}</a>
            <br>
        </td>
        <td>{{myRound($sc['Amount']) }}
            @if(!empty($sc['children']))
            <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin therd chiled -->
    @if(!empty($sc['children']))
    @foreach($sc['children'] as $key1=>$tc)
    @if($tc['Amount'] != 0 || !empty($tc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 100px 0px 0px;">
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a href="{{url('/account/'.$tc['id'])}}" class="a_style">{{$tc['AccountName']}}</a>
            <br>
        </td>
        <td>{{myRound($tc['Amount']) }}
            @if(!empty($tc['children']))
            <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    @endforeach
    @endif
    <!-- end therd chiled -->
    @endforeach
    @endif
    <!-- end second chiled -->
    @endforeach
    @endif
    <!-- end first chiled -->
    @endforeach

    <tr>
        <th colspan="2" style="background-color: #e8edff; color:#669; font-size: 12px">
            @lang('layout.TotalOtherExpenses'):
            {{-- <span style="margin-left: 90%;">{{$TotalEquities}}</span> --}}
        </th>
        <td style="background-color: #e8edff; color:#669;">{{myRound($totalOtherExpense)}}</td>

    </tr>
    <tr>
        <th>@lang('layout.Category')</th>
        <th>@lang('layout.AccountName')</th>
        {{-- <th>@lang('layout.AccountType')</th> --}}
        <th>@lang('layout.Amount')</th>
    </tr>
    <tr>
    <tr>
        <th colspan="3" style="background-color: #e8edff; color:#669;">@lang('layout.AllOtherIncomeAccounts'):</th>
    </tr>
    @foreach($otherIncome as $accountRow)
    @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
    <tr>
        <td></td>
        <td style="padding: 6px; color: black; font-weight: bolder; font-size: 25px">
            <a href="{{url('/account/'.$accountRow['id'])}}" class="a_style">{{$accountRow['AccountName']}}</a>
        </td>
        <td>{{myRound($accountRow['Amount']) }}
            @if(!empty($accountRow['children']))
            <br>@lang('layout.Total') {{$accountRow['AccountName']}} :{{myRound($accountRow['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin first chiled -->
    @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
    @foreach($accountRow['children'] as $key=>$fc)
    @if($fc['Amount'] != 0 || !empty($fc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 40px 0px 0px; color: black; font-weight: bolder; font-size: 20px">
            <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}" class="a_style">{{$fc['AccountName']}}</a>
        </td>
        <td>{{myRound($fc['Amount']) }}
            @if(!empty($fc['children']))
            <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin second chiled -->
    @if(!empty($fc['children']))
    @foreach($fc['children'] as $key1=>$sc)
    @if($sc['Amount'] != 0 || !empty($sc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 80px 0px 0px;">
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a href="{{url('/account/'.$sc['id'])}}" class="a_style">{{$sc['AccountName']}}</a>
            <br>
        </td>
        <td>{{myRound($sc['Amount']) }}
            @if(!empty($sc['children']))
            <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    <!-- begin therd chiled -->
    @if(!empty($sc['children']))
    @foreach($sc['children'] as $key1=>$tc)
    @if($tc['Amount'] != 0 || !empty($tc['children']))
    <tr>
        <td></td>
        <td style="padding:0px 100px 0px 0px;">
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b>{{$key1+1}}-{{$key+1}}</b>
            @endif
            @if(App::isLocale('en'))
            <b>{{$key+1}}-{{$key1+1}}</b>
            @endif
            <a href="{{url('/account/'.$tc['id'])}}" class="a_style">{{$tc['AccountName']}}</a>
            <br>
        </td>
        <td>{{myRound($tc['Amount']) }}
            @if(!empty($tc['children']))
            <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
            @endif
        </td>
    </tr>
    @endif
    @endforeach
    @endif
    <!-- end therd chiled -->
    @endforeach
    @endif
    <!-- end second chiled -->
    @endforeach
    @endif
    <!-- end first chiled -->
    @endforeach
    <tr>
        <th colspan="2" style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalOtherIncome'):
            {{-- <span style="margin-left: 70%;">{{$TotalLiability}}</span> --}}
        </th>
        <td style="background-color: #e8edff; color:#669;">{{myRound($totalOtherIncome)}}</td>

    </tr>
    <tr>
        <th colspan="2" style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.NetProfit'):
            {{-- <span style="margin-left: 70%;">{{$TotalLiability}}</span> --}}
        </th>
        <td style="background-color: #e8edff; color:#669;">{{myRound($netProfit)}}</td>

    </tr>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection