@extends('layouts.app')
@section('style')
@endsection
@section('content') 
<div class="">

    <div class="portlet light " >
        <div class="portlet-title" id="backbtn" >
            <div class="caption">
                <i class="fa fa-area-chart font-blue" style="font-size: 25px"></i>&nbsp;
                <span class="caption-subject font-black-haze bold uppercase">@lang('menu.Charts')</span>
            </div>     
        </div>
        <div class="portlet-body form">
                
            <div class="row" id="system_setting" >
                <div class="profile">
                    <div class="tabbable-line tabbable-full-width">
                    <ul class="nav nav-tabs">
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab_1_6">
                            <div class="row">  
                                <div class="col-lg-12 col-md-12 col-sm-12 col-md-12">
                                    <div class="tab-content">
                                <!----------------------------------------------------------------------------
                                | BEGIN  Sales Charts
                                |---------------------------------------------------------------------------->


                                        <div id="tab_6" class="tab-pane active">
                                            <div id="accordion2" class="panel-group">
                                                <div class="panel panel-secondary" style="border: 1px solid rgba(185, 185, 185, 0.571);">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion3" href="#accordion1_3" >@lang('layout.ItemProfitAndLostReport') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_3" class="panel-collapse  collapse in"> 
                                                        <div class="panel-body"> 
                                                            <div class="table-scrollable">
                                                                <div class="col-md-12 col-sm-12" id="sales-chart">
                                                                    <div class="portlet light">
                                                                        <div class="portlet-title">
                                                                            <div class="caption font-dark">
                                                                                <i class="fa fa-area-chart font-blue" style="font-size: 25px"></i>&nbsp;
                                                                                <span class="caption-subject bold uppercase">@lang('layout.ItemProfitAndLostReport')</span>
                                                                            </div>
                                                                            <div class="actions">
                                                                                <button  class="btn green" onclick="printChart('sales_chart')" ><i class="fa fa-print"></i></button>
                                                                                <button  class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                            </div>
                                                                        </div>
                                                                        <div class="portlet-body">
                                                                        <form v-on:submit.prevent="getData()">
                                                                        <div class="row">
                                                                        <table id="table_content"
                                                                        class="table table-striped table-bordered table-advance">

                                                                            <tr>
                                                                                <td class="highlight">
                                                                                    <v-select placeholder="@lang('layout.Measure')" label="name" :options="{{ $measures}}" v-model="measure" ></v-select>
                                                                                </td>
                                                                                <td class="highlight">
                                                                            
                                                                                    <v-select placeholder="@lang('layout.InventorySite')" label="name" :options="{{ $inventorySite}}" v-model="inventorySite" ></v-select>
                                                                                </td>
                                                                                <td class="highlight">
                                                                                    <v-select placeholder="@lang('layout.InventoryCategory')" label="name" :options="{{ $inventoryCategory}}" v-model="inventoryCategory" ></v-select>
                                                                                </td>
                                                                                <td>
                                                                                    <v-select placeholder="@lang('layout.Item')" class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist">
                                                                                    </v-select>
                                                                                    
                                                                                </td>
                                                                                <td class="highlight">
                                                                                <div class="form-group">
                                                                                    <div class="input-group">
                                                                                        <input class="form-control date" id="sale_chart_from_date"  autocomplete="off">
                                                                                        
                                                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                                                        <input class="form-control date" id="sale_chart_to_date"  autocomplete="off">
                                                                                    </div>
                                                                                </div>
                                                                                </td>
                                                                                <td>
                                                                                <button type="submit" class="btn blue"><i class="fa fa-repeat"></i></button>
                                                                                </td>
                                                                            </tr>  
                                                                            </table>
                                                                            </div>
                                                                            </form>


                                                                        <div class="alert alert-success text-center" v-show="loading">
                                                                            <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                        </div>
                                                                    

                                                                        <div >
                                                                            <canvas  id="sales_chart" height="190" width="600" ></canvas>
                                                                        </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                
                                                            </div>


                                                        <!-- <div class="row">
                                                                <div class="col-md-6 col-sm-6">

                                                                <div class="col-md-12 col-sm-12" id="max-sale-item-chart">
                                                                    <div :class="fullSc">
                                                                        <div class="portlet-title">
                                                                            <div class="caption font-dark">
                                                                                <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                                                                                <span class="caption-subject bold uppercase">@lang('layout.MaxSaleItem')</span>
                                                                            </div>
                                                                                <div class="actions">
                                                                                    <button type="submit" class="btn green" onclick="printChart('max_sale_item_chart')" ><i class="fa fa-print"></i></button>
                                                                                    <button type="submit" class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                                    <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title="" @click="fullScreen()">
                                                                                        <i class="fa fa-expand"></i>
                                                                                </a>

                                                                                </div>
                                                                        </div>


                                                                        <div class="portlet-body" >
                                                                            <div class="alert alert-info" v-show="loading">
                                                                                <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                            </div>
                                                                            <div  >
                                                                                <canvas  id="max_sale_item_chart" height="280" width="600" ></canvas>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                                
                                                                <div class="col-md-6 col-sm-6">

                                                                <div class="col-md-12 col-sm-12" id="min-sale-item-chart">
                                                                    <div :class="fullSc">
                                                                        <div class="portlet-title">
                                                                            <div class="caption font-dark">
                                                                                <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                                                                                <span class="caption-subject bold uppercase">@lang('layout.MinSaleItem')</span>
                                                                            </div>
                                                                            <div class="actions">
                                                                                    <button  class="btn green" onclick="printChart('min_sale_item_chart')" ><i class="fa fa-print"></i></button>
                                                                                    
                                                                                    <button  class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                                    <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title=""  @click="fullScreen()">
                                                                                        <i class="fa fa-expand"></i>
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="portlet-body">
                                                                            <div class="alert alert-info" v-show="loading">
                                                                                <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                            </div>
                                                                            <div >
                                                                                <canvas  id="min_sale_item_chart" height="280" width="600" ></canvas>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                    
                                                                </div>-->
                                                            

                                                        </div>

                                                        
                                                    </div>
                                                </div>
                                    
                                            </div>
                                        </div>
                                <!----------------------------------------------------------------------------
                                | End  Sales Charts
                                |---------------------------------------------------------------------------->            
                                
                                
                        
                                    </div>
                                </div>
                                
                                <!--<canvas id="chart_multy" height="280" width="600"></canvas>-->

                                


                                    
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--end tab-pane-->
                    </div>
                </div>
        <!-- END FORM-->
        </div>
    </div> 
</div>  
@endsection

@push('scripts')
<script src="{{ asset('chart/Chart.bundle.js') }}"></script>

<script>
Vue.component('v-select', VueSelect.VueSelect);

//--------------------------------------------------------
//              Begin Sale                       
//--------------------------------------------------------//

let sales = new Vue({
        el:'#sales-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'item_profit_and_lost',
            measure:null,
            inventorySite:null,
            inventoryCategory:null,
            fullSc:'portlet light bordered',
			selectedItem: null,
			itemlist: []
	  
	  

        },
        mounted(){
         this.getData();
        },
        methods: {
		onItemSearch(search, loading) {
			loading(true);
			this.searchItem(search, loading, this);
		  },

		  //ajax call to get items
		  searchItem(search, loading, vm) {
			axios.get("{{route('callMethod.search')}}", {
				params: {
				  method_name: 'anyTable',
				  'search_column': 'name',
				  'table_name': 'items',
				  keyword: search,
				}
			  })
			  .then(function(response) {
				this.itemlist = [];
				if (response.data.length > 0) {
				  vm.itemlist = response.data;
				  console.log('data', vm.itemlist);
				}
				loading(false);
			  })
			  .catch(function(error) {
				console.log(error);
			  })
		  },
	  
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                type_temp=this.type;
                measure_unit = '';
                site = '';
                category = '';
                item = '';
                if(this.measure !=null)
                {
                 measure_unit = this.measure.id;
                }
				if(this.inventorySite !=null)
                {
                 site = this.inventorySite.id;
                }
				if(this.inventoryCategory !=null)
                {
                 category = this.inventoryCategory.id;
                }
				if(this.selectedItem !=null)
                {
                 item = this.selectedItem.id;
                }

				console.log('new',item);
                var from_date = document.getElementById('sale_chart_from_date').value;
                var to_date   = document.getElementById('sale_chart_to_date').value;
                
               axios.get(
			   "{{route('home.chartjsTest')}}?type="+type_temp
			   +"&measure_unit="+measure_unit
			   +"&from_date="+from_date
			   +"&to_date="+to_date
			   +"&site="+site
			   +"&category="+category
			   +"&item="+item)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            sales.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_sales = document.getElementById("sales_chart");
                sales.chart = new Chart(ctx_sales, {
                type: 'bar',
                // type: 'polarArea',
                // type: 'doughnut',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:3
                        }],
                },
                options: {
                    legend:{
                        display:false,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            // fontSize:18,
                            // fontColor:'red',
                            // boxWidth:80
                            // boxHeight:80

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgba(82, 82, 82, 0.169)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.ItemProfitAndLostReport")',
                        // position:'left',
                        // fontSize: 16,
                    }
                }
            }); 
            }

            }
        }); 

//--------------------------------------------------------
//              End Sales                      
//--------------------------------------------------------//


//--------------------------------------------------------
//              Begin max_sale_item_chart                      
//--------------------------------------------------------//

let maxSales = new Vue({
        el:'#max-sale-item-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'max_sales',
            measure:null,
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                type_temp=this.type;
                measure_unit = '';
                if(this.measure !=null)
                {
                 measure_unit = this.measure.id;
                }


                // var from_date = document.getElementById('sale_chart_from_date').value;
                // var to_date   = document.getElementById('sale_chart_to_date').value;
                
               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            maxSales.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_max_sales = document.getElementById("max_sale_item_chart");
                maxSales.chart = new Chart(ctx_max_sales, {
                type: 'bar',
                // type: 'polarArea',
                // type: 'doughnut',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:false,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            // fontSize:18,
                            // fontColor:'red',
                            // boxWidth:80
                            // boxHeight:80

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgba(82, 82, 82, 0.169)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.MaxSaleItem")',
                        // position:'left',
                        // fontSize: 16,
                    }
                }
            }); 
            }

            }
        }); 

//--------------------------------------------------------
//              End max_sale_item_chart                      
//--------------------------------------------------------//


//--------------------------------------------------------
//              Begin min_sale_item_chart                      
//--------------------------------------------------------//

let minSales = new Vue({
        el:'#min-sale-item-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'min_sales',
            measure:null,
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                type_temp=this.type;
                measure_unit = '';
                if(this.measure !=null)
                {
                 measure_unit = this.measure.id;
                }


                // var from_date = document.getElementById('sale_chart_from_date').value;
                // var to_date   = document.getElementById('sale_chart_to_date').value;
                
               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            minSales.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_min_sales = document.getElementById("min_sale_item_chart");
                minSales.chart = new Chart(ctx_min_sales, {
                type: 'bar',
                // type: 'polarArea',
                // type: 'doughnut',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:false,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            // fontSize:18,
                            // fontColor:'red',
                            // boxWidth:80
                            // boxHeight:80

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgba(82, 82, 82, 0.169)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.MinSaleItem")',
                        // position:'left',
                        // fontSize: 16,
                    }
                }
            }); 
            }

            }
        }); 

//--------------------------------------------------------
//              End min_sale_item_chart                      
//--------------------------------------------------------//


//--------------------------------------------------------
//              Print Function   Chart                     
//--------------------------------------------------------//
function printChart(chartId){
    id = chartId;

    var canvas = document.getElementById(id);
    var win = window.open(canvas.toDataURL(),'_blank','toolbar=yse,scrollbars=yes,resizable=yes');
    // var win = window.open(canvas.toDataURL(),'_blank');

    win.document.write("<br><img onclick = 'window.print()' src='"+canvas.toDataURL()+"'/>");

}

//--------------------------------------------------------
//           End   Print Function   Chart                     
//--------------------------------------------------------// 




    // var brothers ={
	// 	label:"Brothers",
	// 	data:[14,14,15],
	// 	backgroundColor:'rgb(0,99,132,0.6)',
	// 	borderWidth:0,
	// 	yAxisID:"y-axis-brothers"
	// };    
	// var sisters ={
	// 	label:"sisters",
	// 	data:[1,1.2,1.3],
	// 	backgroundColor:'rgb(99,132,0,0.6)',
	// 	borderWidth:0,
	// 	yAxisID:"y-axis-sisters"
	// };
	
	// var person = {
	// 	labels:['one','two','three'],
	// 	datasets:[brothers,sisters]
	// };
	
	// var chartOptions  = {
	// 	scales:{
	// 		xAxes:[{
	// 			barPercentage:1,
	// 			categoryPercentage:0.6
	// 		}],
	// 		yAxes:[{
	// 			id:"y-axis-brothers"
	// 		},
	// 		{
	// 			id:"y-axis-sisters"
	// 		}]
	// 	}
	// }



    // window.onload = function() {
  
    // //today Income And Expense
    // var ctx6 = document.getElementById("chart_multy").getContext("2d");
    //     var myBar6 = new Chart(ctx6, {
    //         type: 'bar',
    //         data: person,
    //         options: chartOptions
    //     });   
    // }; 

</script>

@endpush









