@extends('layouts.app')
@section('style')
<style type="text/css">
    #main {
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
        border-collapse: collapse;
        width: 100%;
    }

    #main th,
    #main td {
        border: 1px solid #ddd;
        padding: 8px;
    }

    /* #main tr:hover {
            background-color: #ddd;
        } */

    #main th {
        padding-top: 12px;
        padding-bottom: 12px;

        background-color: #768585;
        color: black;
    }

    .doubleLine {
        text-decoration-line: underline;
        text-decoration-style: double;
    }

    .modal-mask {
        position: fixed;
        z-index: 9998;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, .5);
        display: table;
        transition: opacity .3s ease;
    }

    .modal-wrapper {
        display: table-cell;
        vertical-align: middle;
    }

    .modal-container {
        width: 80%;
        max-width: 90%;
        margin: 0px auto;
        padding: 20px 30px;
        background-color: #fff;
        border-radius: 2px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
        transition: all .3s ease;
        font-family: Helvetica, Arial, sans-serif;
    }

    .modal-header h3 {
        margin-top: 0;
        color: #42b983;
    }

    .modal-body {
        margin: 20px 0;
    }

    .modal-default-button {
        float: right;
    }

    .modal-enter {
        opacity: 0;
    }

    .modal-leave-active {
        opacity: 0;
    }

    .modal-enter .modal-container,
    .modal-leave-active .modal-container {
        -webkit-transform: scale(1.1);
        transform: scale(1.1);
    }



    ul,
    #treeUL {
        list-style-type: none;
    }

    #treeUL {
        margin: 0;
        padding: 0;
    }

    .rt1 {
        font-size: 24px;
        font-weight: bold;
        /* color: green; */
    }

    .rt2 {
        font-size: 22px;
        font-weight: bold;
        /* color: purple; */
    }

    .rt3 {
        font-size: 20px;
        font-weight: bold;
        /* color: red; */
    }

    .rt4 {
        font-size: 16px;
        font-weight: bold;
        text-align: center;
        color: black;
    }

    a {
        font-size: 16px;
        color: black;
    }

    a:hover {
        color: rgba(0, 0, 0, 0.799);
        text-decoration: none;
    }

    .asset {
        border: 1px solid rgba(85, 85, 85, 0.169);
        border-radius: 5px;
        padding: 10px 0px 10px 40px; !important;
        background-color: ;
        color: black;
        text-align: center;
    }

    .currentasset {
        padding: 0px 0px 0px 40px; !important;
        margin: 0px !important;
        color: black;
        background-color: rgba(82, 82, 82, 0.169);
    }

    .assetOther {
        background-color: ;
        color: black;
        /* padding: 0px 0px 0px 40px; */
    }

    .assetBank {
        background-color: rgba(172, 172, 172, 0.602);
        color: black;
    }

    .assetReceiv {
        background-color: rgba(82, 82, 82, 0.169);
        color: black;
    }

    .fixasset {
        background-color: ;
        color: black;
        
    }

    .otherasset {
        background-color: #058c70;
        color: black;
    }

    .lib {
        background-color: #02558e;
        color: black;
    }

    .libPay {
        background-color: #286aa5;
        color: black;
    }

    .equity {
        background-color: #1a4171;
        color: black;
    }

    .am {
        font-size: 18px;
    }

    /*
    li {
        font-size: 16px;
        color: crimson;
        font-weight: 500;
    }
    .rootTree::before {
        content: "\25B6";
        color: black;
        display: inline-block;
        margin-right: 6px;
    }
    .rootTree-down::before {
        transform: rotate(90deg);
    }
    .children {
        display: none;
    }
    .active {
        display: block;
    }   */
</style>
@stop
@section('content')

<div id="print-modal" v-cloak>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'financial_income'"
        @closed="closeModal">

        <div slot="body">
            <div class="row">
                <input type="hidden" name="report_type" value="financial_income1">
                <div class="form-group">
                    <div class="col-md-12">
                        <label class="control-label ">@lang('layout.Date')</label>
                        <select name="period" v-model="period" @input="getDates()" class="form-control">
                            <option value="CustomDates">@lang('type.CustomDates')</option>
                            <option value="Today">@lang('type.Today')</option>
                            <option value="Yesterday">@lang('type.Yesterday')</option>
                            <option value="ThisWeek">@lang('type.ThisWeek')</option>
                            <option value="LastWeek">@lang('type.LastWeek')</option>
                            <option value="WeekToDate">@lang('type.WeekToDate')</option>
                            <option value="ThisMonth">@lang('type.ThisMonth')</option>
                            <option value="MonthToDate">@lang('type.MonthToDate')</option>
                            <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                            <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                            <option value="ThisYear">@lang('type.ThisYear')</option>
                            <option value="YearToDate">@lang('type.YearToDate')</option>
                        </select>
                    </div>
                    <div class="col-md-12" v-show="period == 'CustomDates'">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" autocomplete="off"
                                    v-model="from_date" name="from_date">
                                <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                <span class="input-group-addon"> @lang('layout.To')</span>
                                <input class="form-control date" id="range-to-example" autocomplete="off"
                                    v-model="to_date" name="to_date">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                @lang('menu.IncomeStatement') &nbsp;&nbsp;
                <span class="text-primary">(
                    <i class="fa fa-money"></i> &nbsp;
                    <b> {{getHomeCurrency()['name']}}) </b>
                </span>
            </div>
            <div class="tools"> </div>
            <div class="btn-group pull-right">
                @permission(['financialReport-list'])
                <a href="{{route('financialReport.income')}}">
                    <button class="btn btn-success">
                        <i class="fa fa-file"></i> @lang('layout.IncomeStatement')(@lang('layout.Default'))
                    </button>
                </a>
                @endpermission

                @permission('financialReport-export')
                <span id="anchore-modal">
                    <button type="submit" @click.prevent="showModal" class="btn btn-success">
                        <i class="fa fa-print"></i>
                    </button>
                </span>
                @endpermission

            </div>
        </div>
        <div class="portlet-body">
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>

            <ul id="treeUL">
                <div class="asset">
                    <li>
                        <table id="main" class="rt1">

                        </table>

                        <ul class="children">
                            <div class="currentasset">
                                <li>
                                    <table id="main" class="rt2">
                                        <tr>
                                            <td colspan="2">@lang('layout.OrdinaryIncome/Expense') </td>
                                        </tr>
                                    </table>

                                    <ul class="children">
                                        <div class="assetOther">
                                            <li>
                                                <table id="main" class="rt3">
                                                    <tr>
                                                        <td colspan="2">@lang('layout.Income') </td>
                                                    </tr>
                                                </table>
                                                <ul class="children">
                                                    <table id="main" class=" main-table">
                                                        @foreach($income as $incomeAccount)
                                                        @if($incomeAccount['Amount'] != 0 ||
                                                        !empty($incomeAccount['children']))
                                                        <tr>
                                                            <td style="padding: 6px;  font-weight: bolder; font-size: 25px">
                                                                <a
                                                                    href="{{url('/account/'.$incomeAccount['id'])}}">{{$incomeAccount['AccountName']}}</a>


                                                            </td>
                                                            <td class="am">{{myRound($incomeAccount['Amount']) }}
                                                                @if(!empty($incomeAccount['children']))
                                                                <br>@lang('layout.Total')
                                                                {{$incomeAccount['AccountName']}}
                                                                :{{myRound($incomeAccount['total'])}}
                                                                @endif
                                                            </td>

                                                        </tr>
                                                        @endif

                                                        @if(!empty($incomeAccount['children']) && getShowSubAccount() !="false")
                                                        @foreach($incomeAccount['children'] as $key=>$fc)
                                                        @if($fc['Amount'] != 0 || !empty($fc['children']))

                                                        <tr>
                                                            <td style=" font-weight: bolder; font-size: 20px"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                <b>{{$key+1}}</b> <a
                                                                    href="{{url('/account/'.$fc['id'])}}"
                                                                    style="">{{$fc['AccountName']}}</a>
                                                            </td>
                                                            <td class="am">{{myRound($fc['Amount']) }}
                                                                @if(!empty($fc['children']))
                                                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                :{{myRound($fc['total'])}}
                                                                @endif

                                                            </td>

                                                        </tr>
                                                        @endif

                                                        <!-- begin second chiled -->
                                                        @if(!empty($fc['children']))
                                                        @foreach($fc['children'] as $key1=>$sc)
                                                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                        <tr>
                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            <td class="am">{{myRound($sc['Amount']) }}
                                                                @if(!empty($sc['children']))
                                                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                :{{myRound($sc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin therd chiled -->
                                                        @if(!empty($sc['children']))
                                                        @foreach($sc['children'] as $key2=>$tc)
                                                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                        <tr>
                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            <td class="am">{{myRound($tc['Amount']) }}
                                                                @if(!empty($tc['children']))
                                                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                :{{myRound($tc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        @endforeach
                                                        @endif
                                                        <!-- end therd chiled -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end second chiled -->
                                                        @endforeach
                                                        @endif
                                                        @endforeach
                                                    </table>
                                                </ul>
                                            </li>
                                            <li>
                                                <table id="main" class="rt3">
                                                    <tr>

                                                        <td>@lang('layout.TotalIncome') </td>
                                                        <td>{{myRound($totalIncome)}}</td>

                                                    </tr>
                                                </table>
                                            </li>
                                        </div>
                                        <div class="assetBank">
                                            <li>
                                                <table id="main" class="rt3">
                                                    <tr>
                                                        <td colspan="2">@lang('layout.CostOfGoodSold') </td>
                                                    </tr>
                                                </table>

                                                <ul class="children">
                                                    <table id="main" class=" main-table">
                                                        @foreach($costOfGoodSold as $incomeAccount)
                                                        @if($incomeAccount['Amount'] != 0 ||
                                                        !empty($incomeAccount['children']))
                                                        <tr>

                                                            <td style="padding: 6px;  font-weight: bolder; font-size: 25px">
                                                                <a
                                                                    href="{{url('/account/'.$incomeAccount['id'])}}">{{$incomeAccount['AccountName']}}</a>


                                                            </td>
                                                            <td class="am">{{myRound($incomeAccount['Amount']) }}

                                                                @if(!empty($incomeAccount['children']))
                                                                <br>@lang('layout.Total')
                                                                {{$incomeAccount['AccountName']}}
                                                                :{{myRound($incomeAccount['total'])}}
                                                                @endif
                                                            </td>

                                                        </tr>
                                                        @endif

                                                        @if(!empty($incomeAccount['children']) && getShowSubAccount() !="false")
                                                        @foreach($incomeAccount['children'] as $key=>$fc)
                                                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                                                        <tr>
                                                            <td
                                                                style="font-weight: bolder; font-size: 20px"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                <b>{{$key+1}}</b> <a
                                                                    href="{{url('/account/'.$fc['id'])}}"
                                                                    style="">{{$fc['AccountName']}}</a>


                                                            </td>
                                                            <td class="am">{{myRound($fc['Amount']) }}

                                                                @if(!empty($fc['children']))
                                                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                :{{myRound($fc['total'])}}
                                                                @endif
                                                            </td>

                                                        </tr>
                                                        @endif

                                                        <!-- begin second chiled -->
                                                        @if(!empty($fc['children']))
                                                        @foreach($fc['children'] as $key1=>$sc)
                                                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                        <tr>
                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            <td class="am">{{myRound($sc['Amount']) }}
                                                                @if(!empty($sc['children']))
                                                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                :{{myRound($sc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin therd chiled -->
                                                        @if(!empty($sc['children']))
                                                        @foreach($sc['children'] as $key2=>$tc)
                                                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                        <tr>
                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            <td class="am">{{myRound($tc['Amount']) }}
                                                                @if(!empty($tc['children']))
                                                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                :{{myRound($tc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        @endforeach
                                                        @endif
                                                        <!-- end therd chiled -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end second chiled -->
                                                        @endforeach
                                                        @endif
                                                        @endforeach
                                                    </table>
                                                </ul>
                                            </li>
                                            <li>
                                                <table id="main" class="rt3">
                                                    <tr>
                                                        <td>@lang('layout.TotalCostOfGoodSold') </td>
                                                        <td>{{myRound($totalCostOfGoodSold)}}</td>



                                                    </tr>
                                                </table>
                                            </li>
                                        </div>
                                        <div class="assetReceiv">

                                            <li>
                                                <table id="main" class="rt3">
                                                    <tr>
                                                        <td>@lang('layout.GrossProfit') </td>
                                                        <td>{{myRound($grossProfit)}}</td>



                                                    </tr>
                                                </table>
                                            </li>
                                        </div>
                                        <div class="assetBank" >
                                            <li>
                                                <table id="main" class="rt3">
                                                    <tr>
                                                        <td colspan="2">@lang('layout.Expense') </td>
                                                    </tr>
                                                </table>

                                                <ul class="children">
                                                    <table id="main" class=" main-table">
                                                        @foreach($expense as $incomeAccount)
                                                        @if($incomeAccount['Amount'] != 0 ||
                                                        !empty($incomeAccount['children']))
                                                        <tr>
                                                            <td style="padding: 6px;  font-weight: bolder; font-size: 25px">
                                                                <a
                                                                    href="{{url('/account/'.$incomeAccount['id'])}}">{{$incomeAccount['AccountName']}}</a>


                                                            </td>
                                                            <td class="am">{{myRound($incomeAccount['Amount']) }}
                                                                @if(!empty($incomeAccount['children']))
                                                                <br>@lang('layout.Total')
                                                                {{$incomeAccount['AccountName']}}
                                                                :{{myRound($incomeAccount['total'])}}
                                                                @endif

                                                            </td>

                                                        </tr>
                                                        @endif

                                                        @if(!empty($incomeAccount['children']) && getShowSubAccount() !="false")
                                                        @foreach($incomeAccount['children'] as $key=>$fc)
                                                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                                                        <tr>
                                                            <td style="font-weight: bolder; font-size: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                <b>{{$key+1}}</b> <a
                                                                    href="{{url('/account/'.$fc['id'])}}"
                                                                    style="">{{$fc['AccountName']}}</a>


                                                            </td>
                                                            <td class="am">{{myRound($fc['Amount']) }}
                                                                @if(!empty($fc['children']))
                                                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                :{{myRound($fc['total'])}}
                                                                @endif
                                                            </td>

                                                        </tr>
                                                        @endif

                                                        <!-- begin second chiled -->
                                                        @if(!empty($fc['children']))
                                                        @foreach($fc['children'] as $key1=>$sc)
                                                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                        <tr>
                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            <td class="am">{{myRound($sc['Amount']) }}
                                                                @if(!empty($sc['children']))
                                                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                :{{myRound($sc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin therd chiled -->
                                                        @if(!empty($sc['children']))
                                                        @foreach($sc['children'] as $key2=>$tc)
                                                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                        <tr>
                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            <td class="am">{{myRound($tc['Amount']) }}
                                                                @if(!empty($tc['children']))
                                                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                :{{myRound($tc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        @endforeach
                                                        @endif
                                                        <!-- end therd chiled -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end second chiled -->
                                                        @endforeach
                                                        @endif
                                                        @endforeach
                                                    </table>
                                                </ul>
                                            </li>
                                            <li>
                                                <table id="main" class="rt3">
                                                    <tr>
                                                        <td>@lang('layout.TotalExpense') </td>
                                                        <td>{{myRound($totalExpense)}}</td>



                                                    </tr>
                                                </table>
                                            </li>
                                        </div>
                                    </ul>
                                </li>
                                <li >
                                    <table id="main" class="rt2">
                                        <tr>
                                            <td>@lang('layout.NetOrdinaryIncome') </td>
                                            <td>{{myRound($netOrdeinaryIncome)}}</td>
                                        </tr>
                                    </table>
                                </li>
                            </div>
                            <div class="fixasset">
                                <li class="">
                                    <table id="main" class="rt2">
                                        <tr style="background: rgba(189, 189, 189, 0.169);">
                                            <td colspan="2" style="background: rgba(189, 189, 189, 0.169);">@lang('layout.OtherIncome/Expense') </td>
                                        </tr>
                                    </table>
                                    <ul class="children" style="padding: 0px !important;">
                                        <div class="assetOther">
                                            <li style="background: rgba(189, 189, 189, 0.169);">
                                                <table id="main" class="rt3">
                                                    <tr>
                                                        <td colspan="2">@lang('layout.OtherIncome') </td>
                                                    </tr>
                                                </table>
                                                <ul class="children">
                                                    <table id="main" class=" main-table">
                                                        @foreach($otherIncome as $incomeAccount)
                                                        @if($incomeAccount['Amount'] != 0 ||
                                                        !empty($incomeAccount['children']))
                                                        <tr>

                                                            <td style="padding: 6px;  font-weight: bolder; font-size: 25px">
                                                                <a
                                                                    href="{{url('/account/'.$incomeAccount['id'])}}">{{$incomeAccount['AccountName']}}</a>


                                                            </td>
                                                            <td class="am">{{myRound($incomeAccount['Amount']) }}
                                                                @if(!empty($incomeAccount['children']))
                                                                <br>@lang('layout.Total')
                                                                {{$incomeAccount['AccountName']}}
                                                                :{{myRound($incomeAccount['total'])}}
                                                                @endif
                                                            </td>

                                                        </tr>
                                                        @endif

                                                        @if(!empty($incomeAccount['children']) && getShowSubAccount() !="false")
                                                        @foreach($incomeAccount['children'] as $key=>$fc)
                                                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                                                        <tr>
                                                            <td style=" font-weight: bolder; font-size: 20px"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                <b>{{$key+1}}</b> <a
                                                                    href="{{url('/account/'.$fc['id'])}}"
                                                                    style="">{{$fc['AccountName']}}</a>


                                                            </td>
                                                            <td class="am">{{myRound($fc['Amount']) }}

                                                                @if(!empty($fc['children']))
                                                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                :{{myRound($fc['total'])}}
                                                                @endif
                                                            </td>

                                                        </tr>
                                                        @endif

                                                        <!-- begin second chiled -->
                                                        @if(!empty($fc['children']))
                                                        @foreach($fc['children'] as $key1=>$sc)
                                                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                        <tr>
                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            <td class="am">{{myRound($sc['Amount']) }}
                                                                @if(!empty($sc['children']))
                                                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                :{{myRound($sc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin therd chiled -->
                                                        @if(!empty($sc['children']))
                                                        @foreach($sc['children'] as $key2=>$tc)
                                                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                        <tr>
                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            <td class="am">{{myRound($tc['Amount']) }}
                                                                @if(!empty($tc['children']))
                                                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                :{{myRound($tc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        @endforeach
                                                        @endif
                                                        <!-- end therd chiled -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end second chiled -->
                                                        @endforeach
                                                        @endif
                                                        @endforeach
                                                    </table>
                                                </ul>
                                            </li>
                                            <li style="background: rgba(189, 189, 189, 0.169);">
                                                <table id="main" class="rt3">
                                                    <tr>

                                                        <td>@lang('layout.TotalOtherIncome') </td>
                                                        <td>{{myRound($totalOtherIncome)}}</td>

                                                    </tr>
                                                </table>
                                            </li>
                                        </div>
                                        <div class="assetBank">
                                            <li>
                                                <table id="main" class="rt3">
                                                    <tr>
                                                        <td colspan="2">@lang('layout.OtherExpense') </td>
                                                    </tr>
                                                </table>

                                                <ul class="children">
                                                    <table id="main" class=" main-table">
                                                        @foreach($otherExpense as $incomeAccount)
                                                        @if($incomeAccount['Amount'] != 0 ||
                                                        !empty($incomeAccount['children']))
                                                        <tr>

                                                            <td style="padding: 6px;  font-weight: bolder; font-size: 25px">
                                                                <a
                                                                    href="{{url('/account/'.$incomeAccount['id'])}}">{{$incomeAccount['AccountName']}}</a>


                                                            </td>
                                                            <td class="am">{{myRound($incomeAccount['Amount']) }}
                                                                @if(!empty($incomeAccount['children']))
                                                                <br>@lang('layout.Total')
                                                                {{$incomeAccount['AccountName']}}
                                                                :{{myRound($incomeAccount['total'])}}
                                                                @endif
                                                            </td>

                                                        </tr>
                                                        @endif

                                                        @if(!empty($incomeAccount['children']) && getShowSubAccount() !="false")
                                                        @foreach($incomeAccount['children'] as $key=>$fc)
                                                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                                                        <tr>
                                                            <td style="font-weight: bolder; font-size: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                <b>{{$key+1}}</b> <a
                                                                    href="{{url('/account/'.$fc['id'])}}"
                                                                    style="">{{$fc['AccountName']}}</a>


                                                            </td>
                                                            <td class="am">{{myRound($fc['Amount']) }}
                                                                @if(!empty($fc['children']))
                                                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                :{{myRound($fc['total'])}}
                                                                @endif

                                                            </td>

                                                        </tr>
                                                        @endif
                                                        <!-- begin second chiled -->
                                                        @if(!empty($fc['children']))
                                                        @foreach($fc['children'] as $key1=>$sc)
                                                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                        <tr>
                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            <td class="am">{{myRound($sc['Amount']) }}
                                                                @if(!empty($sc['children']))
                                                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                :{{myRound($sc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin therd chiled -->
                                                        @if(!empty($sc['children']))
                                                        @foreach($sc['children'] as $key2=>$tc)
                                                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                        <tr>
                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            <td class="am">{{myRound($tc['Amount']) }}
                                                                @if(!empty($tc['children']))
                                                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                :{{myRound($tc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        @endforeach
                                                        @endif
                                                        <!-- end therd chiled -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end second chiled -->
                                                        @endforeach
                                                        @endif
                                                        @endforeach
                                                    </table>
                                                </ul>
                                            </li>
                                            <li>
                                                <table id="main" class="rt3">
                                                    <tr>
                                                        <td>@lang('layout.TotalOtherExpenses') </td>
                                                        <td>{{myRound($totalOtherExpense)}}</td>



                                                    </tr>
                                                </table>
                                            </li>
                                        </div>
                                    </ul>
                                </li>
                                <li>
                                    <table id="main" class="rt2">
                                        <tr>
                                            <td>@lang('layout.NetOtherIncome') </td>
                                            <td>{{myRound($netOtherIncome)}}</td>
                                        </tr>
                                    </table>
                                </li>
                            </div>
                            <table id="main" class="rt1">
                                <tr>
    
                                    <td>@lang('layout.NetProfit') </td>
                                    <td>{{myRound($netProfit)}}</td>
    
                                </tr>
                            </table>
                        </ul>
                    </li>
                    <li>
                        
                    </li>
                </div>
            </ul>
        </div>
    </div>
</div>
@endsection
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script type="text/javascript">
    var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                items: null,


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });

        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
</script>
@endpush