@extends('layouts.app')
@section('style')
<style type="text/css">
    #main {
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
        border-collapse: collapse;
        width: 100%;
    }
    #main th,
    #main td {
        border: 1px solid #ddd;
        padding: 8px;
    }
    /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
    #main tr:hover {
        background-color: #ddd;
    }
    #main th {
        padding-top: 12px;
        padding-bottom: 12px;
        /*text-align: left;*/
        background-color: #768585;
        color: white;
    }
</style>
@stop
@section('content')
<div id="print-modal" v-cloak>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'financial_income'"
        @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <label class="control-label ">@lang('layout.Date')</label>
                        <select name="period" v-model="period" @input="getDates()" class="form-control">
                            <option value="CustomDates">@lang('type.CustomDates')</option>
                            <option value="Today">@lang('type.Today')</option>
                            <option value="Yesterday">@lang('type.Yesterday')</option>
                            <option value="ThisWeek">@lang('type.ThisWeek')</option>
                            <option value="LastWeek">@lang('type.LastWeek')</option>
                            <option value="WeekToDate">@lang('type.WeekToDate')</option>
                            <option value="ThisMonth">@lang('type.ThisMonth')</option>
                            <option value="MonthToDate">@lang('type.MonthToDate')</option>
                            <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                            <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                            <option value="ThisYear">@lang('type.ThisYear')</option>
                            <option value="YearToDate">@lang('type.YearToDate')</option>
                        </select>
                    </div>
                    <div class="col-md-12" v-show="period == 'CustomDates'">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" autocomplete="off"
                                    v-model="from_date" name="from_date">
                                <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                <span class="input-group-addon"> @lang('layout.To')</span>
                                <input class="form-control date" id="range-to-example" autocomplete="off"
                                    v-model="to_date" name="to_date">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>




<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                @lang('menu.IncomeStatement') &nbsp;&nbsp;
                <span class="text-primary">(
                    <i class="fa fa-money"></i> &nbsp;
                    <b> {{getHomeCurrency()['name']}}) </b>
                </span>
            </div>
            <div class="tools"> </div>
            <div class="btn-group pull-right">
                @permission(['financialReport-list'])
                <a href="{{route('financialReport1.income')}}">
                    <button class="btn btn-success">
                        <i class="fa fa-file"></i> @lang('layout.IncomeStatement')(1)
                    </button>
                </a>
                @endpermission

                @permission('financialReport-export')
                <span id="anchore-modal">
                    <button type="submit" @click.prevent="showModal" class="btn btn-success">
                        <i class="fa fa-print"></i>
                    </button>
                </span>
                @endpermission

            </div>
        </div>
        <div class="portlet-body">
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
            <table id="main">
                <tr style="background-color: rgba(82, 82, 82, 0.169);">
                    <th class="text-center" style="font-weight: bolder;background: rgba(82, 82, 82, 0.169); color: black;">@lang('layout.Category')</th>
                    <th class="text-center" style="font-weight: bolder;background: rgba(82, 82, 82, 0.169); color: black;">@lang('layout.AccountName')</th>
                    {{-- <th>@lang('layout.AccountType')</th> --}}
                    <th class="text-center" style="font-weight: bolder;background: rgba(82, 82, 82, 0.169); color: black;">@lang('layout.Amount')</th>
                </tr>
                <tr>
                    <th colspan="3" style="background-color: rgba(189, 189, 189, 0.169); color:#669;text-align: center;font-size: 25px;font-weight: bold;">@lang('layout.Income')</th>
                </tr>
                @foreach($income as $incomeAccount)
                @if($incomeAccount['Amount'] != 0 || !empty($incomeAccount['children']))
                <tr>
                    <td></td>
                    <td style="padding: 6px; color: #29B4B6; font-weight: bolder; font-size: 25px">
                        <a href="{{url('/account/'.$incomeAccount['id'])}}" style="text-decoration: none;">{{$incomeAccount['AccountName']}}</a>
                    </td>
                    <td>{{myRound($incomeAccount['Amount']) }}
                        @if(!empty($incomeAccount['children']))
                        <br>@lang('layout.Total') {{$incomeAccount['AccountName']}}
                        :{{myRound($incomeAccount['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                <!-- begin first chiled -->
                @if(!empty($incomeAccount['children']) && getShowSubAccount() !="false")
                @foreach($incomeAccount['children'] as $key=>$fc)
                @if($fc['Amount'] != 0 || !empty($fc['children']))
                <tr>
                    <td></td>
                    <td style="color: rgb(36, 81, 36); font-weight: bolder; font-size: 16px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                            style="color: rgb(36, 81, 36); text-decoration: none;">{{$fc['AccountName']}}</a>
                    </td>
                    <td>{{myRound($fc['Amount']) }}
                        @if(!empty($fc['children']))
                        <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                <!-- begin second chiled -->
                @if(!empty($fc['children']))
                @foreach($fc['children'] as $key1=>$sc)
                @if($sc['Amount'] != 0 || !empty($sc['children']))
                <tr>
                    <td></td>
                    <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        @if(App::isLocale('fa') || App::isLocale('pa'))
                        <b>{{$key1+1}}-{{$key+1}}</b>
                        @endif
                        @if(App::isLocale('en'))
                        <b>{{$key+1}}-{{$key1+1}}</b>
                        @endif
                        <a style="color: #8e29b6;" href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                        <br>
                    </td>
                    <td>{{myRound($sc['Amount']) }}
                        @if(!empty($sc['children']))
                        <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                <!-- begin therd chiled -->
                @if(!empty($sc['children']))
                @foreach($sc['children'] as $key2=>$tc)
                @if($tc['Amount'] != 0 || !empty($tc['children']))
                <tr>
                    <td></td>
                    <td >&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        @if(App::isLocale('fa') || App::isLocale('pa'))
                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                        @endif
                        @if(App::isLocale('en'))
                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                        @endif
                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                        <br>
                    </td>
                    <td>{{myRound($tc['Amount']) }}
                        @if(!empty($tc['children']))
                        <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                @endforeach
                @endif
                <!-- end therd child -->
                @endforeach
                @endif
                <!-- end second child -->
                @endforeach
                @endif
                <!-- end first chiled -->
                @endforeach
                <tr>
                    <td colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#669; font-size: 20px; font-weight: bolder;">
                        @lang('layout.TotalIncome')
                        :
                    </td>
                    <td style="background-color: rgba(189, 189, 189, 0.169); color:#669;">{{myRound($totalIncome)}}</td>
                </tr>
                @foreach($costOfGoodSold as $incomeAccount)
                @if($incomeAccount['Amount'] != 0 || !empty($incomeAccount['children']))
                <tr>
                    <td></td>
                    <td style="padding: 6px; color: rgb(36, 81, 36); font-weight: bolder; font-size: 25px">
                        <a href="{{url('/account/'.$incomeAccount['id'])}}">{{$incomeAccount['AccountName']}}</a>
                    </td>
                    {{-- <td></td> --}}
                    <td>{{myRound($incomeAccount['Amount']) }}
                        @if(!empty($incomeAccount['children']))
                        <br>@lang('layout.Total') {{$incomeAccount['AccountName']}}
                        :{{myRound($incomeAccount['total'])}}
                        @endif
                    </td>

                </tr>
                @endif

                @if(!empty($incomeAccount['children']) && getShowSubAccount() !="false")
                @foreach($incomeAccount['children'] as $key=>$fc)
                @if($fc['Amount'] != 0 || !empty($fc['children']))
                <tr>
                    <td></td>

                    <td style="color: rgb(36, 81, 36); font-weight: bolder; font-size: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                            style="color: rgb(36, 81, 36)">{{$fc['AccountName']}}</a>


                    </td>
                    {{-- <td></td> --}}
                    <td>{{myRound($fc['Amount']) }}

                        @if(!empty($fc['children']))
                        <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                        @endif
                    </td>

                </tr>
                @endif
                <!-- begin second chiled -->
                @if(!empty($fc['children']))
                @foreach($fc['children'] as $key1=>$sc)
                @if($sc['Amount'] != 0 || !empty($sc['children']))
                <tr>
                    <td></td>
                    <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        @if(App::isLocale('fa') || App::isLocale('pa'))
                        <b>{{$key1+1}}-{{$key+1}}</b>
                        @endif
                        @if(App::isLocale('en'))
                        <b>{{$key+1}}-{{$key1+1}}</b>
                        @endif
                        <a style="color: #8e29b6;" href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                        <br>
                    </td>
                    <td>{{myRound($sc['Amount']) }}
                        @if(!empty($sc['children']))
                        <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                <!-- begin therd chiled -->
                @if(!empty($sc['children']))
                @foreach($sc['children'] as $key2=>$tc)
                @if($tc['Amount'] != 0 || !empty($tc['children']))
                <tr>
                    <td></td>
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        @if(App::isLocale('fa') || App::isLocale('pa'))
                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                        @endif
                        @if(App::isLocale('en'))
                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                        @endif
                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                        <br>
                    </td>
                    <td>{{myRound($tc['Amount']) }}
                        @if(!empty($tc['children']))
                        <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                @endforeach
                @endif
                <!-- end therd child -->
                @endforeach
                @endif
                <!-- end second child -->
                @endforeach
                @endif
                @endforeach
                <tr>
                    <td colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#669; font-size: 20px; font-weight: bolder;">
                        @lang('layout.TotalCostOfGoodSold'):
                    </td>
                    <td style="background-color: rgba(189, 189, 189, 0.169); color:#669">
                        {{currency()->format($totalCostOfGoodSold,getRelatedCurrencyCode())}}</td>
                </tr>
                <tr>
                    <th colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#669; font-size: 20px; font-weight: bolder;">
                        @lang('layout.GrossProfit'):
                        {{-- <span style="margin-left: 78.5%;font-size: 15px">{{$totalAsset}}</span> --}}
                    </th>
                    <td style="background-color: rgba(189, 189, 189, 0.169); color:#669;">{{myRound($grossProfit)}}</td>
                </tr>
                <tr style="background-color: rgba(82, 82, 82, 0.169);">
                    <th class="text-center" style="background-color: rgba(82, 82, 82, 0.169);color: black;">@lang('layout.Category')</th>
                    <th class="text-center" style="background-color: rgba(82, 82, 82, 0.169);color: black;">@lang('layout.AccountName')</th>
                    {{-- <th>@lang('layout.AccountType')</th> --}}
                    <th class="text-center" style="background-color: rgba(82, 82, 82, 0.169);color: black;">@lang('layout.Amount')</th>
                </tr>
                <tr>
                <tr>
                    <th colspan="3" style="background-color: rgba(189, 189, 189, 0.169); color:#669;text-align: center; font-size: 25px; font-weight: bold;">@lang('layout.AllExpenseAccounts')
                    </th>
                </tr>
                @foreach($expense as $expenseRo)
                @if($expenseRo['Amount'] != 0 || !empty($expenseRo['children']))
                <tr>

                    <td></td>
                    <td style="padding: 0px 6px; color: rgb(36, 81, 36); font-weight: bolder; font-size: 16px;">
                        <a href="{{url('/account/'.$expenseRo['id'])}}" style="text-decoration: none;">{{$expenseRo['AccountName']}}</a>
                    </td>
                    {{-- <td></td> --}}
                    <td>{{myRound($expenseRo['Amount']) }}
                        @if(!empty($expenseRo['children']))
                        <br>@lang('layout.Total') {{$expenseRo['AccountName']}} :{{myRound($expenseRo['total'])}}
                        @endif

                    </td>

                </tr>
                @endif
                @if(!empty($expenseRo['children']) && getShowSubAccount() !="false")
                @foreach($expenseRo['children'] as $key=>$fc)
                @if($fc['Amount'] != 0 || !empty($fc['children']))
                <tr>
                    <td></td>

                    <td style="color: rgb(36, 81, 36); font-weight: bolder; font-size: 16px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                            style="color: rgb(36, 81, 36); text-decoration: none;">{{$fc['AccountName']}}</a>


                    </td>
                    {{-- <td></td> --}}
                    <td>{{myRound($fc['Amount']) }}
                        @if(!empty($fc['children']))
                        <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                        @endif
                    </td>

                </tr>
                @endif

                <!-- begin second chiled -->
                @if(!empty($fc['children']))
                @foreach($fc['children'] as $key1=>$sc)
                @if($sc['Amount'] != 0 || !empty($sc['children']))
                <tr>
                    <td></td>
                    <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        @if(App::isLocale('fa') || App::isLocale('pa'))
                        <b>{{$key1+1}}-{{$key+1}}</b>
                        @endif
                        @if(App::isLocale('en'))
                        <b>{{$key+1}}-{{$key1+1}}</b>
                        @endif
                        <a style="color: #8e29b6;" href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                        <br>
                    </td>
                    <td>{{myRound($sc['Amount']) }}
                        @if(!empty($sc['children']))
                        <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                <!-- begin therd chiled -->
                @if(!empty($sc['children']))
                @foreach($sc['children'] as $key2=>$tc)
                @if($tc['Amount'] != 0 || !empty($tc['children']))
                <tr>
                    <td></td>
                    <td >&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        @if(App::isLocale('fa') || App::isLocale('pa'))
                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                        @endif
                        @if(App::isLocale('en'))
                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                        @endif
                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                        <br>
                    </td>
                    <td>{{myRound($tc['Amount']) }}
                        @if(!empty($tc['children']))
                        <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                @endforeach
                @endif
                <!-- end therd child -->
                @endforeach
                @endif
                <!-- end second child -->
                @endforeach
                @endif
                @endforeach
                <tr>
                    <th colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#669; font-size: 20px; font-weight: bolder;">
                        @lang('layout.TotalOtherExpenses'):
                        {{-- <span style="margin-left: 70%;">{{$TotalLiability}}</span> --}}
                    </th>
                    <td style="background-color: rgba(189, 189, 189, 0.169); color:#669;">{{myRound($totalExpense)}}</td>

                </tr>
                <tr>
                    <th colspan="3" style="background-color: rgba(189, 189, 189, 0.169); color:#669;font-size: 20px;">
                        @lang('layout.AllOtherExpenseAccounts'):</th>
                </tr>
                @foreach($otherExpense as $incomeAccount)
                @if($incomeAccount['Amount'] != 0 || !empty($incomeAccount['children']))
                <tr>

                    <td></td>
                    <td style="padding: 6px; color: #29B4B6; font-weight: bolder; font-size: 25px">
                        <a href="{{url('/account/'.$incomeAccount['id'])}}" style="text-decoration: none;">{{$incomeAccount['AccountName']}}</a>


                    </td>
                    {{-- <td></td> --}}
                    <td>{{myRound($incomeAccount['Amount']) }}
                        @if(!empty($incomeAccount['children']))
                        <br>@lang('layout.Total') {{$incomeAccount['AccountName']}}
                        :{{myRound($incomeAccount['total'])}}
                        @endif
                    </td>

                </tr>
                @endif
                @if(!empty($incomeAccount['children']) && getShowSubAccount() !="false")
                @foreach($incomeAccount['children'] as $key=>$fc)
                @if($fc['Amount'] != 0 || !empty($fc['children']))
                <tr>
                    <td></td>

                    <td style="color: #29B4B6; font-weight: bolder; font-size: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                            style="color: #29B4B6">{{$fc['AccountName']}}</a>


                    </td>
                    {{-- <td></td> --}}
                    <td>{{myRound($fc['Amount']) }}
                        @if(!empty($fc['children']))
                        <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                        @endif

                    </td>

                </tr>
                @endif

                <!-- begin second chiled -->
                @if(!empty($fc['children']))
                @foreach($fc['children'] as $key1=>$sc)
                @if($sc['Amount'] != 0 || !empty($sc['children']))
                <tr>
                    <td></td>
                    <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        @if(App::isLocale('fa') || App::isLocale('pa'))
                        <b>{{$key1+1}}-{{$key+1}}</b>
                        @endif
                        @if(App::isLocale('en'))
                        <b>{{$key+1}}-{{$key1+1}}</b>
                        @endif
                        <a style="color: #8e29b6;" href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                        <br>
                    </td>
                    <td>{{myRound($sc['Amount']) }}
                        @if(!empty($sc['children']))
                        <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                <!-- begin therd chiled -->
                @if(!empty($sc['children']))
                @foreach($sc['children'] as $key2=>$tc)
                @if($tc['Amount'] != 0 || !empty($tc['children']))
                <tr>
                    <td></td>
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        @if(App::isLocale('fa') || App::isLocale('pa'))
                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                        @endif
                        @if(App::isLocale('en'))
                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                        @endif
                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                        <br>
                    </td>
                    <td>{{myRound($tc['Amount']) }}
                        @if(!empty($tc['children']))
                        <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                @endforeach
                @endif
                <!-- end therd child -->
                @endforeach
                @endif
                <!-- end second child -->
                @endforeach
                @endif
                @endforeach

                <tr>
                    <th colspan="2" style="background-color:rgba(189, 189, 189, 0.169); color:#669; font-size: 20px; font-weight: bolder;">
                        @lang('layout.TotalOtherExpenses'):
                        {{-- <span style="margin-left: 90%;">{{$TotalEquities}}</span> --}}
                    </th>
                    <td style="background-color:rgba(189, 189, 189, 0.169); color:#669;">{{myRound($totalOtherExpense)}}</td>

                </tr>
                <tr style="background-color: rgba(82, 82, 82, 0.169);">
                    <th class="text-center" style="background-color: rgba(82, 82, 82, 0.169);">@lang('layout.Category')</th>
                    <th class="text-center" style="background-color: rgba(82, 82, 82, 0.169);">@lang('layout.AccountName')</th>
                    {{-- <th>@lang('layout.AccountType')</th> --}}
                    <th class="text-center" style="background-color: rgba(82, 82, 82, 0.169);">@lang('layout.Amount')</th>
                </tr>
                <tr>
                    <th colspan="3" style="background-color:rgba(189, 189, 189, 0.169); color:#669;font-size: 20px;font-weight: bolder;">
                        @lang('layout.AllOtherIncomeAccounts'):</th>
                </tr>
                @foreach($otherIncome as $incomeAccount)
                @if($incomeAccount['Amount'] != 0 || !empty($incomeAccount['children']))
                <tr>

                    <td></td>
                    <td style="padding: 6px; color: #29B4B6; font-weight: bolder; font-size: 25px"><a
                            href="{{url('/account/'.$incomeAccount['id'])}}">{{$incomeAccount['AccountName']}}</a>


                    </td>
                    {{-- <td></td> --}}
                    <td>{{myRound($incomeAccount['Amount']) }}
                        @if(!empty($incomeAccount['children']))
                        <br>@lang('layout.Total') {{$incomeAccount['AccountName']}}
                        :{{myRound($incomeAccount['total'])}}
                        @endif
                    </td>

                </tr>
                @endif
                @if(!empty($incomeAccount['children']) && getShowSubAccount() !="false")
                @foreach($incomeAccount['children'] as $key=>$fc)
                @if($fc['Amount'] != 0 || !empty($fc['children']))
                <tr>
                    <td></td>

                    <td style="color: #29B4B6; font-weight: bolder; font-size: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                            style="color: #29B4B6">{{$fc['AccountName']}}</a>


                    </td>
                    {{-- <td></td> --}}
                    <td>{{myRound($fc['Amount']) }}

                        @if(!empty($fc['children']))
                        <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                        @endif
                    </td>

                </tr>
                @endif

                <!-- begin second chiled -->
                @if(!empty($fc['children']))
                @foreach($fc['children'] as $key1=>$sc)
                @if($sc['Amount'] != 0 || !empty($sc['children']))
                <tr>
                    <td></td>
                    <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        @if(App::isLocale('fa') || App::isLocale('pa'))
                        <b>{{$key1+1}}-{{$key+1}}</b>
                        @endif
                        @if(App::isLocale('en'))
                        <b>{{$key+1}}-{{$key1+1}}</b>
                        @endif
                        <a style="color: #8e29b6;" href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                        <br>
                    </td>
                    <td>{{myRound($sc['Amount']) }}
                        @if(!empty($sc['children']))
                        <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                <!-- begin therd chiled -->
                @if(!empty($sc['children']))
                @foreach($sc['children'] as $key2=>$tc)
                @if($tc['Amount'] != 0 || !empty($tc['children']))
                <tr>
                    <td></td>
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        @if(App::isLocale('fa') || App::isLocale('pa'))
                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                        @endif
                        @if(App::isLocale('en'))
                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                        @endif
                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                        <br>
                    </td>
                    <td>{{myRound($tc['Amount']) }}
                        @if(!empty($tc['children']))
                        <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                        @endif
                    </td>
                </tr>
                @endif
                @endforeach
                @endif
                <!-- end therd child -->
                @endforeach
                @endif
                <!-- end second child -->
                @endforeach
                @endif
                @endforeach
                <tr>
                    <th colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#669; font-size: 20px; font-weight: bolder;">
                        @lang('layout.TotalOtherIncome'):
                        {{-- <span style="margin-left: 70%;">{{$TotalLiability}}</span> --}}
                    </th>
                    <td style="background-color: rgba(189, 189, 189, 0.169); color:#669;">{{myRound($totalOtherIncome)}}</td>

                </tr>
                @if(systemConfig()[29] == 1)
                <tr>
                    <th colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#669; font-size: 20px; font-weight: bolder;">
                        @lang('layout.ChangeRateProfit'):
                    </th>
                    <td style="background-color: rgba(189, 189, 189, 0.169); color:#669;">{{myRound($TodayNetProfit)}}</td>

                </tr>
                @endif
                <tr>
                    <th colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#669; font-size: 20px; font-weight: bolder;">
                        @lang('layout.NetProfit'):
                        {{-- <span style="margin-left: 70%;">{{$TotalLiability}}</span> --}}
                    </th>
                    <td style="background-color: rgba(189, 189, 189, 0.169); color:#669;">{{myRound($netProfit)}}</td>

                </tr>
            </table>
        </div>
    </div>
</div>
@endsection
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script type="text/javascript">
    var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                items: null,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });

        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
</script>
@endpush