@extends('layouts.app')
@section('style')
@endsection
@section('content') 
<div class="row">
    <div class="portlet light " >
        <div class="portlet-title" id="backbtn" >
            <div class="caption">
                <i class="fa fa-area-chart font-blue" style="font-size: 25px"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('menu.Charts')</span>
            </div>
        </div>
        <div class="portlet-body form">          
            <div class="row" id="system_setting" >
                <div class="profile">
                    <div class="tabbable-line tabbable-full-width">
                        <ul class="nav nav-tabs">
                            <!--             <li class="">
                                <a href="#tab_1_1" data-toggle="tab" aria-expanded="false"> Overview </a>
                            </li>
                            <li class="">
                                <a href="#tab_1_3" data-toggle="tab" aria-expanded="false"> Account </a>
                            </li>
                            <li class="active">
                                <a href="#tab_1_6" data-toggle="tab" aria-expanded="true"> Help </a>
                            </li> -->
                        </ul>
                    <div class="tab-content">
                    <div class="tab-pane active" id="tab_1_6">
                        <div class="">
                            <!-- <div class="col-lg-2 col-md-2 col-sm-12 col-md-12 hidden-print">
                                <ul class="ver-inline-menu tabbable margin-bottom-10">
                                    <li class="active">
                                        <a data-toggle="tab" href="#tab_6" aria-expanded="true" >
                                            <i class="icon-briefcase" style="color: red;font-size: 18px;"></i> @lang('layout.Account') </a>
                                    </li>
                                
                                    <li class="">
                                        <a data-toggle="tab" href="#tab_1" aria-expanded="true">
                                            <i class="fa fa-group" style="color: red;font-size: 18px;"></i> @lang('layout.Members') </a>
                                    </li>
                                    <li class="">
                                        <a data-toggle="tab" href="#tab_2" aria-expanded="true">
                                            <i class="fa fa-home" style="color: red;font-size: 18px;"></i> @lang('menu.Dashboard')</a>
                                    </li>
                                    
                                    <li class="">
                                        <a data-toggle="tab" href="#tab_4" aria-expanded="true">
                                            <i class="fa fa-credit-card" style="color: red;font-size: 18px;"></i> @lang('layout.ReceiveAndPayment') </a>
                                    </li>
                                    <li class="">
                                        <a data-toggle="tab" href="#tab_5" aria-expanded="true">
                                            <i class="fa fa-industry" style="color: red;font-size: 18px;"></i> @lang('layout.BuildSetting') </a>
                                    </li> 
                                    
                                    <li class="">
                                        <a data-toggle="tab" href="#tab_7" aria-expanded="true">
                                            <i class="fa fa-database" style="color: red;font-size: 18px;"></i> @lang('layout.Inventory') </a>
                                    </li>
                                    <li class="">
                                        <a data-toggle="tab" href="#tab_8" aria-expanded="true">
                                            <i class="fa fa-building-o" style="color: red;font-size: 18px;"></i> @lang('menu.TransportCompany') </a>
                                    </li>
                                    <li class="">
                                        <a data-toggle="tab" href="#tab_9" aria-expanded="true">
                                            <i class="icon-basket" style="color: red;font-size: 18px;"></i> @lang('layout.SaleAndPurchase') </a>
                                    </li> 
                                    <li class="">
                                        <a data-toggle="tab" href="#tab_10" aria-expanded="true">
                                            <i class="fa fa-file-code-o" style="color: red;font-size: 18px;"></i> @lang('menu.Report') </a>
                                    </li>
                                    <li class="">
                                        <a data-toggle="tab" href="#tab_11" aria-expanded="true">
                                            <i class="fa fa-history" style="color: red;font-size: 18px;"></i> @lang('menu.Backups') </a>
                                    </li>
                                </ul>
                            </div> -->
                            <div class="col-lg-12 col-md-12 col-sm-12 col-md-12">
                                <div class="tab-content"> 
                                    <!----------------------------------------------------------------------------
                                    | BEGIN  Account Charts
                                    |---------------------------------------------------------------------------->
                                    <div id="tab_6" class="tab-pane active" style="padding: 10px;">
                                        <div id="accordion1" class="panel-group">
                                            <div class="panel panel-secondary" style="border: 1px solid rgba(185, 185, 185, 0.571);">
                                                <div class="panel-heading">
                                                    <h4 class="panel-title">
                                                        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1" onclick="FirstToggleIcon(this)">@lang('layout.Assets') <i class="fa fa-angle-up"></i></a>
                                                    </h4>
                                                </div>
                                                <div id="accordion1_1" class="panel-collapse collapse in">
                                                    <div class="panel-body"> 
                                                        <div class="table-scrollable">
                                                            <div class="col-md-12 col-sm-12" id="account-chart">
                                                                <div class="portlet light">
                                                                    <div class="portlet-title">
                                                                        <div class="caption font-dark">
                                                                            <i class="fa fa-area-chart font-blue" style="font-size: 25px"></i>&nbsp;
                                                                            <span class="caption-subject bold uppercase">@lang('layout.Assets') </span>
                                                                        </div>
                                                                        <div class="actions">
                                                                            <button  class="btn green" onclick="printChart('test_chart')" ><i class="fa fa-print"></i></button>
                                                                            <button  class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                        </div> 
                                                                    </div>
                                                                    <div class="portlet-body">
                                                                        <!-- <form v-on:submit.prevent="getData()">
                                                                            <div class="row">
                                                                                <div class="form-group col-md-6" >
                                                                                    <label class="control-label col-md-3">@lang('layout.AccountType'):</label>
                                                                                    <div class="col-md-9">
                                                                                        <v-select placeholder="@lang('layout.SelectType')" label="type" :options="{{ $type}}" v-model="type" ></v-select>
                                                                                    </div>
                                                                                    
                                                                                </div>
                                                                                <div class="form-group col-md-6" >
                                                                                    <div class="col-md-7">
                                                                                        <button type="submit" class="btn blue"><i class="fa fa-repeat"></i></button>
                                                                                    </div>
                                                                                    
                                                                                </div>
                                                                            </div>
                                                                        </form> -->
                                                                        <div class="alert alert-success text-center" v-show="loading">
                                                                            <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                        </div>
                                                                        <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                                                            <div style="padding: 0px;margin:0px;" class="dashboard-stat2" v-show="this.chart !=null && !loading">
                                                                                <table class="dashboard-tabel table-bordered" width="100%">
                                                                                    <thead>
                                                                                        <tr style="background-color: rgba(185, 185, 185, 0.571);">
                                                                                            <th colspan="2" class="text-center">@lang('layout.Total') </th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        <span>
                                                                                        @foreach($assets_type_data AS $asset)
                                                                                        <tr>
                                                                                            <td class="highlight text-center">
                                                                                            {{__('layout.' . ucfirst($asset->type))}} 
                                                                                            </td>
                                                                                            <td class="text-center"> {{myRound($asset->balance)}}</td>
    
                                                                                        </tr>
                                                                                        @endforeach 
                                                                                        <tr style="color: green;">
                                                                                            <td class="highlight text-center">
                                                                                            @lang('layout.Total')
                                                                                            </td>
                                                                                            <td class="text-center">{{myRound($total_assets)}} {{getHomeCurrency()['code']}}</td>
    
                                                                                        </tr>
                                                                                        </span>
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12" style="margin-bottom: 20px;">
                                                                            <div >
                                                                                <canvas  id="test_chart" height="280" width="600" ></canvas>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-6 col-sm-6">
                                                                <div class="col-md-12 col-sm-12" id="bank-account-chart">
                                                                    <div :class="fullSc">
                                                                        <div class="portlet-title">
                                                                            <div class="caption font-dark">
                                                                                <i class="fa fa-area-chart font-blue" style="font-size: 25px"></i>&nbsp;
                                                                                <span class="caption-subject bold uppercase">@lang('layout.Assets')</span>
                                                                            </div>
                                                                            <div class="actions">
                                                                                <button type="submit" class="btn green" onclick="printChart('bank_account_chart')" ><i class="fa fa-print"></i></button>
                                                                                <button type="submit" class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                                <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title="" @click="fullScreen()">
                                                                                    <i class="fa fa-expand"></i>
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="portlet-body" >
                                                                            <div class="alert alert-success text-center" v-show="loading">
                                                                                <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                            </div>
                                                                            <div >
                                                                                <canvas  id="bank_account_chart" height="280" width="600" ></canvas>
                                                                            </div>
                                                                            <div style="padding: 0px;margin:0px" class="dashboard-stat2" v-show="this.chart !=null && !loading">
                                                                                <table class="dashboard-tabel table-bordered" width="100%">
                                                                                    <thead>
                                                                                        <tr style="background-color: rgba(185, 185, 185, 0.571);">
                                                                                            <th colspan="2" class="text-center">@lang('layout.Total') </th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        <span>
                                                                                        @foreach($assets_type_data AS $asset)
                                                                                        <tr>
                                                                                            <td class="highlight text-center">
                                                                                            {{__('layout.' . ucfirst($asset->type))}} 
                                                                                            </td>
                                                                                            <td class=" text-center"> {{myRound($asset->balance)}}</td>

                                                                                        </tr>
                                                                                        @endforeach 
                                                                                        <tr style="color: green; text-align: center;">
                                                                                            <td class="highlight">
                                                                                            @lang('layout.Total')
                                                                                            </td>
                                                                                            <td class="text-center">{{myRound($total_assets)}} {{getHomeCurrency()['code']}}</td>
                                                                                        </tr>
                                                                                        </span>
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>     
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6 col-sm-6">
                                                                <div class="col-md-12 col-sm-12" id="bank-account-negitive-chart">
                                                                    <div :class="fullSc">
                                                                        <div class="portlet-title">
                                                                            <div class="caption font-dark">
                                                                                <i class="fa fa-area-chart font-blue" style="font-size: 25px"></i>&nbsp;
                                                                                <span class="caption-subject bold uppercase">@lang('layout.Bank')</span>
                                                                            </div>
                                                                            <div class="actions">
                                                                                <button  class="btn green" onclick="printChart('bank_account_negitive_chart')" ><i class="fa fa-print"></i></button>
                                                                                <button  class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                                <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title=""  @click="fullScreen()">
                                                                                    <i class="fa fa-expand"></i>
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="portlet-body">
                                                                            <div class="alert alert-success text-center" v-show="loading">  
                                                                                <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                            </div>
                                                                            <div >
                                                                                <canvas  id="bank_account_negitive_chart" height="280" width="600" ></canvas>
                                                                            </div>
                                                                            <div style="padding: 0px;margin:0px" class="dashboard-stat2" v-show="this.chart !=null && !loading">
                                                                                <table class="dashboard-tabel table-bordered" width="100%">
                                                                                    <thead>
                                                                                        <tr style="background-color: rgba(185, 185, 185, 0.571);">
                                                                                            <th colspan="2" class="text-center">@lang('layout.Total') </th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        <span>
                                                                                        <tr>
                                                                                            <td class="highlight text-center">
                                                                                            {{myRound($total_bank_amout)}}
                                                                                            </td>
                                                                                            <td class="text-center"> {{getHomeCurrency()['code']}}</td>
                                                    
                                                                                            </tr>
                                                                                        </span>
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!----------------------------------------------------------------------------
                                    | End Acount Charts
                                    |---------------------------------------------------------------------------->             
                            
                                    <!----------------------------------------------------------------------------
                                    | BEGIN  Income And Expenses Charts
                                    |---------------------------------------------------------------------------->
                                    <div id="tab_6" class="tab-pane active" style="padding: 10px;">
                                        <div id="accordion2" class="panel-group">
                                            <div class="panel panel-secondary" style="border: 1px solid rgba(185, 185, 185, 0.571);;">
                                                <div class="panel-heading">
                                                    <h4 class="panel-title">
                                                        <a class="accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion2" href="#accordion1_2" onclick="toggleIcon(event)">@lang('layout.IncomeAndExpense') <i class="fa fa-angle-down" id="changeIcon"  style="font-size: 20px;"></i></a>
                                                    </h4>
                                                </div>
                                                <div id="accordion1_2" class="panel-collapse collapsed collapse">
                                                    <div class="panel-body"> 
                                                        <div class="table-scrollable">
                                                            <div class="col-md-12 col-sm-12" id="income-and-expense-chart">
                                                                <div class="portlet light">
                                                                    <div class="portlet-title">
                                                                        <div class="caption font-dark">
                                                                            <i class="fa fa-area-chart font-blue" style="font-size: 25px"></i>&nbsp;
                                                                            <span class="caption-subject bold uppercase">@lang('layout.IncomeAndExpense')</span>
                                                                        </div>
                                                                        <div class="actions">
                                                                            <button  class="btn green" onclick="printChart('income_and_expense_chart')" ><i class="fa fa-print"></i></button>
                                                                            <button  class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                        </div>
                                                                    </div>
                                                                    <div class="portlet-body">
                                                                        <div class="alert alert-success text-center" v-show="loading">
                                                                            <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                        </div>
                                                                        <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                                                            <div style="padding: 0px;margin:0px" class="dashboard-stat2" v-show="this.chart !=null && !loading">
                                                                                <table class="dashboard-tabel table-bordered" width="100%">
                                                                                    <thead>
                                                                                        <tr style="background-color: rgba(185, 185, 185, 0.571);">
                                                                                            <th colspan="2" class="text-center">@lang('layout.Total') </th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        <span>
                                                                                        @foreach($income_expense_all AS $asset)
                                                                                            <tr>
                                                                                                <td class="highlight text-center">
                                                                                                {{__('layout.' . ucfirst($asset['type']))}} 
                                                                                                </td>
                                                                                                <td class="text-center"> {{myRound($asset['balance'])}}</td>
    
                                                                                            </tr>
                                                                                        @endforeach 
                                                                                        <tr style="background-color: rgba(185, 185, 185, 0.571);">
                                                                                            <td style="color: green;text-align: center;">@lang('layout.Income') </td>
                                                                                            <td style="color: red;text-align: center;">@lang('layout.Expense') </td>
                                                                                        </tr>
                                                                                        <tr>
                                                                                            <td class="highlight" style="color: green;text-align: center;">
                                                                                            {{myRound($Incomes_t)}} {{getHomeCurrency()['code']}}
                                                                                            </td>
                                                                                            <td class="highlight" style="color: red;text-align: center;">
                                                                                            {{myRound($Expense_t)}} {{getHomeCurrency()['code']}}
                                                                                            </td>
                                                                                            </tr>
                                                                                        </span>
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12" style="margin-bottom: 10px;">
                                                                            <div>
                                                                                <canvas  id="income_and_expense_chart" height="280" width="600" ></canvas>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-6 col-sm-6">
                                                                <div class="col-md-12 col-sm-12" id="total-income-and-expense-chart">
                                                                    <div :class="fullSc">
                                                                        <div class="portlet-title">
                                                                            <div class="caption font-dark">
                                                                                <i class="fa fa-area-chart font-blue" style="font-size: 25px"></i>&nbsp;
                                                                                <span class="caption-subject bold uppercase">@lang('layout.Expense')</span>
                                                                            </div>
                                                                            <div class="actions">
                                                                                <button type="submit" class="btn green" onclick="printChart('total_income_and_expense_chart')" ><i class="fa fa-print"></i></button>
                                                                                <button type="submit" class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                                <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title="" @click="fullScreen()">
                                                                                    <i class="fa fa-expand"></i>
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="portlet-body" >
                                                                            <div class="alert alert-success text-center" v-show="loading">
                                                                                <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                            </div>
                                                                            <div  >
                                                                                <canvas  id="total_income_and_expense_chart" height="280" width="600" ></canvas>
                                                                            </div>
                                                                            <div style="padding: 0px;margin:10px 0px;" class="dashboard-stat2" v-show="this.chart !=null && !loading">
                                                                                <table class="dashboard-tabel table-bordered" width="100%">
                                                                                    <thead>
                                                                                        <tr style="background-color: rgba(185, 185, 185, 0.571);">
                                                                                            <th colspan="2" class="text-center">@lang('layout.Total') </th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        <span>
                                                                                        <tr>
                                                                                            <td class="highlight text-center">
                                                                                            {{myRound($total_expenses)}}
                                                                                            </td>
                                                                                            <td class="text-center"> {{getHomeCurrency()['code']}}</td>

                                                                                            </tr>
                                                                                        </span>
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6 col-sm-6">
                                                                <div class="col-md-12 col-sm-12" id="today-income-and-expense-chart">
                                                                    <div :class="fullSc">
                                                                        <div class="portlet-title">
                                                                            <div class="caption font-dark">
                                                                                <i class="fa fa-area-chart font-blue" style="font-size: 25px"></i>&nbsp;
                                                                                <span class="caption-subject bold uppercase">@lang('layout.IncomeAndExpense')</span>
                                                                            </div>
                                                                            <div class="actions">
                                                                                <button  class="btn green" onclick="printChart('today_income_and_expense_chart')" ><i class="fa fa-print"></i></button>
                                                                                <!-- <button  class="btn red" onclick="downloadChart('today_income_and_expense_chart','chart')" ><i class="fa fa-print"></i></button> -->
                                                                                <button  class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                                <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title=""  @click="fullScreen()">
                                                                                    <i class="fa fa-expand"></i>
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="portlet-body">
                                                                            <div class="alert alert-success text-center" v-show="loading">
                                                                                <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                            </div>
                                                                            <div >
                                                                                <canvas  id="today_income_and_expense_chart" height="280" width="600" ></canvas>
                                                                            </div>
                                                                            <div style="padding: 0px;margin:0px" class="dashboard-stat2" v-show="this.chart !=null && !loading">
                                                                                <table class="dashboard-tabel table-bordered" width="100%">
                                                                                    <thead>
                                                                                        <tr style="background-color: rgba(185, 185, 185, 0.571);">
                                                                                            <th colspan="3" class="text-center">@lang('layout.Total') </th>
                                                                                        </tr>
                                                                                        <tr style="background-color: rgba(185, 185, 185, 0.571);">
                                                                                            <th class="text-center">@lang('layout.Income') </th>
                                                                                            <th class="text-center">@lang('layout.Expense') </th>
                                                                                            <th class="text-center">@lang('layout.NetProfit') </th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        <span>
                                                                                        <tr>
                                                                                            <td class="highlight text-center" style="color: green;">
                                                                                            {{myRound($Incomes_t)}} {{getHomeCurrency()['code']}}
                                                                                            </td>
                                                                                            <td class="highlight text-center" style="color: red;">
                                                                                            {{myRound($Expense_t)}} {{getHomeCurrency()['code']}}
                                                                                            </td>
                                                                                            <td class="highlight text-center" >
                                                                                            {{myRound($Incomes_t-$Expense_t)}} {{getHomeCurrency()['code']}}
                                                                                            </td>
                                                                                            </tr>
                                                                                        </span>
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!----------------------------------------------------------------------------
                                    | End  Income And Expenses Charts
                                    |---------------------------------------------------------------------------->
                                    
                                    <!----------------------------------------------------------------------------
                                    | BEGIN  Sales Charts
                                    |---------------------------------------------------------------------------->

                                    <!-- <div id="tab_6" class="tab-pane active">
                                            <div id="accordion2" class="panel-group">
                                                <div class="panel panel-primary">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion3" href="#accordion1_3" >@lang('menu.Sales') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_3" class="panel-collapse collapsed collapse">
                                                        <div class="panel-body"> 
                                                            <div class="table-scrollable">
                                                                <div class="col-md-12 col-sm-12" id="sales-chart">
                                                                    <div class="portlet light">
                                                                        <div class="portlet-title">
                                                                            <div class="caption font-dark">
                                                                                <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                                                                                <span class="caption-subject bold uppercase">@lang('layout.Sale_char')</span>
                                                                            </div>
                                                                            <div class="actions">
                                                                            
                                                                                    <button  class="btn green" onclick="printChart('sales_chart')" ><i class="fa fa-print"></i></button>
                                                                                    <button  class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                                
                                                                                
                                                                            </div>

                                                                            
                                                                            
                                                                        </div>



                                                                        <div class="portlet-body">

                                                                        <form v-on:submit.prevent="getData()">
                                                                                <div class="row">
                                                                                    <div class="form-group col-md-4" >
                                                                                        <div class="col-md-9">
                                                                                            <v-select placeholder="@lang('layout.Measure')" label="name" :options="{{ $measures}}" v-model="measure" ></v-select>
                                                                                        </div>
                                                                                        
                                                                                    </div>
                                                                                    <div class="form-group col-md-4" >
                                                                                            <div class="form-group">
                                                                                                <div class="input-group">
                                                                                                    <input class="form-control date" id="sale_chart_from_date"  autocomplete="off">
                                                                                                    
                                                                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                                                                    <input class="form-control date" id="sale_chart_to_date"  autocomplete="off">
                                                                                                </div>
                                                                                            </div>
                                                                                            
                                                                                        </div> 
                                                                                    <div class="form-group col-md-4" >
                                                                                        <div class="col-md-7">
                                                                                            <button type="submit" class="btn blue"><i class="fa fa-repeat"></i></button>
                                                                                        </div>
                                                                                        
                                                                                    </div>
                                                                                </div>
                                                                            </form>


                                                                        <div class="alert alert-info" v-show="loading">
                                                                            <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                        </div>
                                                                    

                                                                        <div >
                                                                            <canvas  id="sales_chart" height="280" width="600" ></canvas>
                                                                        </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                
                                                            </div>


                                                            <div class="row">
                                                                <div class="col-md-6 col-sm-6">

                                                                <div class="col-md-12 col-sm-12" id="max-sale-item-chart">
                                                                    <div :class="fullSc">
                                                                        <div class="portlet-title">
                                                                            <div class="caption font-dark">
                                                                                <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                                                                                <span class="caption-subject bold uppercase">@lang('layout.MaxSaleItem')</span>
                                                                            </div>
                                                                                <div class="actions">
                                                                                    <button type="submit" class="btn green" onclick="printChart('max_sale_item_chart')" ><i class="fa fa-print"></i></button>
                                                                                    <button type="submit" class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                                    <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title="" @click="fullScreen()">
                                                                                        <i class="fa fa-expand"></i>
                                                                                </a>

                                                                                </div>
                                                                        </div>


                                                                        <div class="portlet-body" >
                                                                            <div class="alert alert-info" v-show="loading">
                                                                                <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                            </div>
                                                                            <div  >
                                                                                <canvas  id="max_sale_item_chart" height="280" width="600" ></canvas>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                                
                                                                <div class="col-md-6 col-sm-6">

                                                                <div class="col-md-12 col-sm-12" id="min-sale-item-chart">
                                                                    <div :class="fullSc">
                                                                        <div class="portlet-title">
                                                                            <div class="caption font-dark">
                                                                                <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                                                                                <span class="caption-subject bold uppercase">@lang('layout.MinSaleItem')</span>
                                                                            </div>
                                                                            <div class="actions">
                                                                                    <button  class="btn green" onclick="printChart('min_sale_item_chart')" ><i class="fa fa-print"></i></button>
                                                                                    
                                                                                    <button  class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                                    <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title=""  @click="fullScreen()">
                                                                                        <i class="fa fa-expand"></i>
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="portlet-body">
                                                                            <div class="alert alert-info" v-show="loading">
                                                                                <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                            </div>
                                                                            <div >
                                                                                <canvas  id="min_sale_item_chart" height="280" width="600" ></canvas>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                    
                                                                </div>
                                                            

                                                        </div>

                                                        
                                                    </div>
                                                </div>
                                    
                                            </div>
                                        </div>-->
                                    <!----------------------------------------------------------------------------
                                    | End  Sales Charts
                                    |---------------------------------------------------------------------------->            
                                    
                                    <!----------------------------------------------------------------------------
                                    | BEGIN  Member Charts
                                    |---------------------------------------------------------------------------->

                                    <!--<div id="tab_6" class="tab-pane active">
                                        <div id="accordion2" class="panel-group">
                                            <div class="panel panel-primary">
                                                <div class="panel-heading">
                                                    <h4 class="panel-title">
                                                        <a class="accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion4" href="#accordion1_4" >@lang('layout.Members') </a>
                                                    </h4>
                                                </div>
                                                <div id="accordion1_4" class="panel-collapse collapsed collapse">
                                                    <div class="panel-body"> 
                                                        <!-- <div class="table-scrollable">
                                                            <div class="col-md-12 col-sm-12" id="sales-chart">
                                                                <div class="portlet light">
                                                                    <div class="portlet-title">
                                                                        <div class="caption font-dark">
                                                                            <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                                                                            <span class="caption-subject bold uppercase">@lang('layout.Sale_char')</span>
                                                                        </div>
                                                                        <div class="actions">
                                                                        
                                                                                <button  class="btn green" onclick="printChart('sales_chart')" ><i class="fa fa-print"></i></button>
                                                                                <button  class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                            
                                                                            
                                                                        </div>

                                                                        
                                                                        
                                                                    </div>



                                                                    <div class="portlet-body">

                                                                    <form v-on:submit.prevent="getData()">
                                                                            <div class="row">
                                                                                <div class="form-group col-md-4" >
                                                                                    <div class="col-md-9">
                                                                                        <v-select placeholder="@lang('layout.Measure')" label="name" :options="{{ $measures}}" v-model="measure" ></v-select>
                                                                                    </div>
                                                                                    
                                                                                </div>
                                                                                <div class="form-group col-md-4" >
                                                                                        <div class="form-group">
                                                                                            <div class="input-group">
                                                                                                <input class="form-control date" id="sale_chart_from_date"  autocomplete="off">
                                                                                                
                                                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                                                <input class="form-control date" id="sale_chart_to_date"  autocomplete="off">
                                                                                            </div>
                                                                                        </div>
                                                                                        
                                                                                    </div> 
                                                                                <div class="form-group col-md-4" >
                                                                                    <div class="col-md-7">
                                                                                        <button type="submit" class="btn blue"><i class="fa fa-repeat"></i></button>
                                                                                    </div>
                                                                                    
                                                                                </div>
                                                                            </div>
                                                                        </form>


                                                                    <div class="alert alert-info" v-show="loading">
                                                                        <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                    </div>
                                                                

                                                                    <div >
                                                                        <canvas  id="sales_chart" height="280" width="600" ></canvas>
                                                                    </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                        </div> -->


                                                    <!-- <div class="row">
                                                            <div class="col-md-6 col-sm-6">

                                                            <div class="col-md-12 col-sm-12" id="max-sale-customer-chart">
                                                                <div :class="fullSc">
                                                                    <div class="portlet-title">
                                                                        <div class="caption font-dark">
                                                                            <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                                                                            <span class="caption-subject bold uppercase">@lang('layout.MaxSaleCustomer')</span>
                                                                        </div>
                                                                            <div class="actions">
                                                                                <button type="submit" class="btn green" onclick="printChart('max_sale_customer_chart')" ><i class="fa fa-print"></i></button>
                                                                                <button type="submit" class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                                <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title="" @click="fullScreen()">
                                                                                    <i class="fa fa-expand"></i>
                                                                            </a>

                                                                            </div>
                                                                    </div>


                                                                    <div class="portlet-body" >
                                                                        <div class="alert alert-info" v-show="loading">
                                                                            <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                        </div>
                                                                        <div  >
                                                                            <canvas  id="max_sale_customer_chart" height="280" width="600" ></canvas>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            </div>
                                                            
                                                            <div class="col-md-6 col-sm-6">

                                                            <div class="col-md-12 col-sm-12" id="min-sale-customer-chart">
                                                                <div :class="fullSc">
                                                                    <div class="portlet-title">
                                                                        <div class="caption font-dark">
                                                                            <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                                                                            <span class="caption-subject bold uppercase">@lang('layout.MinSaleCustomer')</span>
                                                                        </div>
                                                                        <div class="actions">
                                                                                <button  class="btn green" onclick="printChart('min_sale_customer_chart')" ><i class="fa fa-print"></i></button>
                                                                                
                                                                                <button  class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                                                                                <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title=""  @click="fullScreen()">
                                                                                    <i class="fa fa-expand"></i>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                    <div class="portlet-body">
                                                                        <div class="alert alert-info" v-show="loading">
                                                                            <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                                                                        </div>
                                                                        <div >
                                                                            <canvas  id="min_sale_customer_chart" height="280" width="600" ></canvas>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            </div>
                                                
                                                            </div>-->
                                                        

                                                <!--   </div>

                                                    
                                                </div>
                                            </div>
                                
                                        </div>
                                    </div>-->
                                    <!----------------------------------------------------------------------------
                                    | End  Member Charts
                                    |---------------------------------------------------------------------------->
                                </div>
                            </div>  
                        </div>
                    </div>
                        </div>
                    </div>
                    <!--end tab-pane-->
                </div>
                <!-- <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button class="btn btn-success" @click="saveSetting">
                    <i class="icon-settings"></i> @lang('layout.SaveChanges')</button>
                </div> -->
            </div>
            <!-- END FORM-->
        </div>
    </div> 
</div>
@endsection
@push('scripts')
<script src="{{ asset('chart/Chart.bundle.js') }}"></script>
<script>
    function toggleIcon(event){
        event.preventDefault();
        var icon = document.getElementById('changeIcon');
        if(icon.classList.contains('fa-angle-down')){
            icon.classList.remove('fa-angle-down');
            icon.classList.add('fa-angle-up');
        }
        else{
            icon.classList.remove('fa-angle-up');
            icon.classList.add('fa-angle-down');
        }
    }
    function FirstToggleIcon(element){
        const icon = element.querySelector('i');
        icon.classList.toggle('fa-angle-up');
        icon.classList.toggle('fa-angle-down');
    }
</script>
<script>
Vue.component('v-select', VueSelect.VueSelect);
//--------------------------------------------------------
//              Begin Accounts                       
//--------------------------------------------------------//
let account = new Vue({
        el:'#account-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'assets'

        },
        mounted(){
           this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                // toggleBlock(true);
                var type      =  (this.type)?this.type:null;
                var type_temp='';
                if(type)
                {
                    type_temp=type;
                } 

               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            console.log('ssssss',this.dates,this.label,this.color)

                            account.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                    ;

            },
            chartData(dates,label,color){
                var chart_link = account;
                var ctx_test = document.getElementById("test_chart");
                account.chart = new Chart(ctx_test, {
                type: 'polarArea',
                // type: 'pie',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:true,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            fontSize:14,
                            // fontWeight:"bold",
                            // fontColor:'red',
                            boxWidth:20,
                            boxHeight:20

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgb(0, 255, 0)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.Assets")',
                        position:'left',
                        fontSize: 20,
                    }
                }
            }); 



            ////////////////
            // ctx_test.onclick = function(e){
            //     var slice = chart_link.chart.getElementAtEvent(e);
            //     if(!slice.length) return;
            //     var label = slice[0]._model.label;

            //     console.log('label',label)
            // }
            
            ////////////////

            
            }

            }
        }); 

//--------------------------------------------------------
//              End Accounts                       
//--------------------------------------------------------//



//--------------------------------------------------------
//              Begin Accounts                       
//--------------------------------------------------------//
let bankAccount = new Vue({
        el:'#bank-account-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'assets_by_type',
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                    type_temp=this.type;

               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            bankAccount.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            // printChart(){
            //     var printContents = document.getElementById('chart').innerHTML;
            //     var originalContents = document.body.innerHTML;

            //     document.body.innerHTML  = printContents;

            //     window.print();
            //     document.body.innerHTML  = originalContents;

            // },

            chartData(dates,label,color){
                var ctx_bank_account = document.getElementById("bank_account_chart");
                bankAccount.chart = new Chart(ctx_bank_account, {
                type: 'bar',
                // type: 'polarArea',
                // type: 'doughnut',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:false,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            // fontSize:18,
                            // fontColor:'red',
                            // boxWidth:80
                            // boxHeight:80

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgb(0, 255, 0)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.Assets")',
                        // position:'left',
                        // fontSize: 16,
                    }
                }
            }); 


           
            }

            }
        }); 
        
        
let bankAccountNegitive = new Vue({
        el:'#bank-account-negitive-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'assets_by_type_bank',
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                    type_temp=this.type;

               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            bankAccountNegitive.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_bank_account_negitive = document.getElementById("bank_account_negitive_chart");
                bankAccountNegitive.chart = new Chart(ctx_bank_account_negitive, {
                // type: 'polarArea',
                // type: 'doughnut',
                type: 'bar',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:false,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            // fontSize:18,
                            // fontColor:'red',
                            // boxWidth:80
                            // boxHeight:80

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgb(0, 255, 0)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.Bank")',
                        // position:'left',
                        // fontSize: 16,
                    }
                }
            }); 
            }

            }
        }); 

//--------------------------------------------------------
//              End Accounts                       
//--------------------------------------------------------//


//--------------------------------------------------------
//              Begin  Income And Expense                       
//--------------------------------------------------------//
let incomeAndExpense = new Vue({
        el:'#income-and-expense-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'income_expense_all',
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                    type_temp=this.type;

               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            incomeAndExpense.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_income_and_expense = document.getElementById("income_and_expense_chart");
                incomeAndExpense.chart = new Chart(ctx_income_and_expense, {
                // type: 'polarArea',
                type: 'doughnut',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:true,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            fontSize:14,
                            fontColor:'red',
                            boxWidth:20,
                            boxHeight:20

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgb(0, 255, 0)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.IncomeAndExpense")',
                        position:'left',
                        fontSize: 20,
                    }
                }
            }); 
            }

            }
        }); 
//--------------------------------------------------------
//              End Income And Expense                       
//--------------------------------------------------------//

//--------------------------------------------------------
//              Begin TOtal Income And Expense                       
//--------------------------------------------------------//

let totalIncomeAndExpense = new Vue({
        el:'#total-income-and-expense-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'expenses',
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                type_temp=this.type;

               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            totalIncomeAndExpense.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_total_income_and_expense = document.getElementById("total_income_and_expense_chart");
                totalIncomeAndExpense.chart = new Chart(ctx_total_income_and_expense, {
                // type: 'polarArea',
                // type: 'bar',
                type: 'doughnut',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:false,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            fontSize:14,
                            fontColor:'red',
                            boxWidth:20,
                            boxHeight:20

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgb(0, 255, 0)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.Expense")',
                        position:'left',
                        fontSize: 20,
                    }
                }
            }); 
            }

            }
        }); 

//--------------------------------------------------------
//              End TOtal Income And Expense                       
//--------------------------------------------------------//

//--------------------------------------------------------
//              Begin Today Income And Expense                       
//--------------------------------------------------------//

let todayIncomeAndExpense = new Vue({
        el:'#today-income-and-expense-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'income_expense_all_total',
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                type_temp=this.type;

               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            todayIncomeAndExpense.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_today_income_and_expense = document.getElementById("today_income_and_expense_chart");
                todayIncomeAndExpense.chart = new Chart(ctx_today_income_and_expense, {
                // type: 'bar',
                // type: 'polarArea',
                // type: 'doughnut',
                type: 'bar',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:false,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            // fontSize:18,
                            // fontColor:'red',
                            // boxWidth:80
                            // boxHeight:80

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgb(0, 255, 0)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.IncomeAndExpense")',
                        // position:'left',
                        // fontSize: 16,
                    }
                }
            }); 
            }

            }
        }); 

//--------------------------------------------------------
//              End Today Income And Expense                       
//--------------------------------------------------------//

//--------------------------------------------------------
//              Begin Sale                       
//--------------------------------------------------------//

let sales = new Vue({
        el:'#sales-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'sales',
            measure:null,
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                type_temp=this.type;
                measure_unit = '';
                if(this.measure !=null)
                {
                 measure_unit = this.measure.id;
                }


                var from_date = document.getElementById('sale_chart_from_date').value;
                var to_date   = document.getElementById('sale_chart_to_date').value;
                
               axios.get("{{route('home.chartjsTest')}}?type="+type_temp+"&measure_unit="+measure_unit+"&from_date="+from_date+"&to_date"+to_date)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            sales.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_sales = document.getElementById("sales_chart");
                sales.chart = new Chart(ctx_sales, {
                type: 'bar',
                // type: 'polarArea',
                // type: 'doughnut',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:false,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            // fontSize:18,
                            // fontColor:'red',
                            // boxWidth:80
                            // boxHeight:80

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgb(0, 255, 0)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.Sale_char")',
                        // position:'left',
                        // fontSize: 16,
                    }
                }
            }); 
            }

            }
        }); 

//--------------------------------------------------------
//              End Sales                      
//--------------------------------------------------------//


//--------------------------------------------------------
//              Begin max_sale_item_chart                      
//--------------------------------------------------------//

let maxSales = new Vue({
        el:'#max-sale-item-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'max_sales',
            measure:null,
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                type_temp=this.type;
                measure_unit = '';
                if(this.measure !=null)
                {
                 measure_unit = this.measure.id;
                }


                // var from_date = document.getElementById('sale_chart_from_date').value;
                // var to_date   = document.getElementById('sale_chart_to_date').value;
                
               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            maxSales.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_max_sales = document.getElementById("max_sale_item_chart");
                maxSales.chart = new Chart(ctx_max_sales, {
                type: 'bar',
                // type: 'polarArea',
                // type: 'doughnut',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:false,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            // fontSize:18,
                            // fontColor:'red',
                            // boxWidth:80
                            // boxHeight:80

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgb(0, 255, 0)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.MaxSaleItem")',
                        // position:'left',
                        // fontSize: 16,
                    }
                }
            }); 
            }

            }
        }); 

//--------------------------------------------------------
//              End max_sale_item_chart                      
//--------------------------------------------------------//


//--------------------------------------------------------
//              Begin min_sale_item_chart                      
//--------------------------------------------------------//

let minSales = new Vue({
        el:'#min-sale-item-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'min_sales',
            measure:null,
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                type_temp=this.type;
                measure_unit = '';
                if(this.measure !=null)
                {
                 measure_unit = this.measure.id;
                }


                // var from_date = document.getElementById('sale_chart_from_date').value;
                // var to_date   = document.getElementById('sale_chart_to_date').value;
                
               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            minSales.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_min_sales = document.getElementById("min_sale_item_chart");
                minSales.chart = new Chart(ctx_min_sales, {
                type: 'bar',
                // type: 'polarArea',
                // type: 'doughnut',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:false,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            // fontSize:18,
                            // fontColor:'red',
                            // boxWidth:80
                            // boxHeight:80

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgb(0, 255, 0)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.MinSaleItem")',
                        // position:'left',
                        // fontSize: 16,
                    }
                }
            }); 
            }

            }
        }); 

//--------------------------------------------------------
//              End min_sale_item_chart                      
//--------------------------------------------------------//


//--------------------------------------------------------
//              Begin max_sale_customer_chart                     
//--------------------------------------------------------//

let maxSaleCustomer = new Vue({
        el:'#max-sale-customer-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'max_sale_customer',
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                type_temp=this.type;

               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            maxSaleCustomer.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_max_sale_customer = document.getElementById("max_sale_customer_chart");
                maxSaleCustomer.chart = new Chart(ctx_max_sale_customer, {
                // type: 'bar',
                // type: 'polarArea',
                type: 'doughnut',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:true,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            // fontSize:18,
                            // fontColor:'red',
                            // boxWidth:80
                            // boxHeight:80

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgb(0, 255, 0)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.MaxSaleCustomer")',
                        // position:'left',
                        // fontSize: 16,
                    }
                }
            }); 
            }

            }
        });  

//--------------------------------------------------------
//              End max_sale_customer_chart                       
//--------------------------------------------------------//


//--------------------------------------------------------
//              Begin min_sale_customer_chart                     
//--------------------------------------------------------//

let minSaleCustomer = new Vue({
        el:'#min-sale-customer-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],
            loading:false,
            type:'min_sale_customer',
            fullSc:'portlet light bordered'

        },
        mounted(){
        //    this.getData();
        },
        methods: { 
            getData: function() {
                this.loading = true;
                if(this.chart !=null){
                    this.chart.destroy();
                }
                
                type_temp=this.type;

               axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

                    .then(response =>{
                       if(response.data.todayIncomeExpense.length>0){

                            this.dates = response.data.todayIncomeExpense;
                            this.label = response.data.todayIncomeExpenseLabel;
                            this.color = response.data.todayIncomeExpenseColor;

                            minSaleCustomer.chartData(this.dates,this.label,this.color);
                       }
                       
                      
                    })
                    
                    .catch(function (error) {
                    })
                    .finally(()=>(this.loading=false));
                
            },
            fullScreen(){
                if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
                    this.fullSc = 'portlet light bordered';
                }
                else
                {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates,label,color){
                var ctx_min_sale_customer = document.getElementById("min_sale_customer_chart");
                minSaleCustomer.chart = new Chart(ctx_min_sale_customer, {
                // type: 'bar',
                // type: 'polarArea',
                type: 'doughnut',
                // type: 'line',
                // type: 'radar',
                // type: 'bubble',
                // type: 'scatter',
                data:{
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth:2
                        }],
                },
                options: {
                    legend:{
                        display:true,
                        position:'right',
                        align:'center',
                      
                        labels:{
                            // fontSize:18,
                            // fontColor:'red',
                            // boxWidth:80
                            // boxHeight:80

                            
                        }
                    },
                    elements: {
                        rectangle: {
                            borderWidth: 2,
                            borderColor: 'rgb(0, 255, 0)',
                            borderSkipped: 'bottom'
                        }
                    },
                    responsive: true,
                    title: {
                        display: true,
                        text: '@lang("layout.MinSaleCustomer")',
                        // position:'left',
                        // fontSize: 16,
                    }
                }
            }); 
            }

            }
        }); 

//--------------------------------------------------------
//              End min_sale_customer_chart                       
//--------------------------------------------------------//







//--------------------------------------------------------
//              Print Function   Chart                     
//--------------------------------------------------------//
function printChart(chartId){
    id = chartId;

    var canvas = document.getElementById(id);
    var win = window.open(canvas.toDataURL(),'_blank','toolbar=yse,scrollbars=yes,resizable=yes');
    // var win = window.open(canvas.toDataURL(),'_blank');

    win.document.write("<br><img onclick = 'window.print()' src='"+canvas.toDataURL()+"'/>");

    // 'today_income_and_expense_chart','chart'
}

//--------------------------------------------------------
//           End   Print Function   Chart                     
//--------------------------------------------------------// 

</script>
@endpush