@extends('layouts.factor-master')

@section('style')

<style>
  .hs{
    font-size: 18px;
    font-weight: bold;
    height: 30px;
  }
  .doubleLine {
				text-decoration-line: underline;
				text-decoration-style: double;
			}
  .tit{
      font-weight: bold;
      font-size: 16px;
  }

</style>
@endsection
@section('content')
<?php
$report = customeReportNew('account_show');
$_date= !in_array('date', $report);
$_description= !in_array('description', $report);
$_user= !in_array('user', $report);
$_unit= !in_array('unit', $report);
$_qut_in= !in_array('qut_in', $report);
$_qut_out= !in_array('qut_out', $report);
$_rate= !in_array('rate', $report);
$_balance= !in_array('balance', $report);
$_balance_base= !in_array('balance_base', $report);
$_total= !in_array('total', $report);


?>


<h3 class="table-caption" style="text-align: center;">@lang('menu.CashFlowStatement') 
				<span class="text-primary">(
					<b>  {{getHomeCurrency()['name']}}) </b>
				</span></h3>
<table class="main-table" >
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>


<br>

<table class="main-table" cellpadding="8px">
 <thead>
 
</thead>
<tr>
    <td class="tit " style="text-align: center;font-size: 25px; font-weight: bolder;" colspan="2">@lang('layout.OperatingActivities')</td> 
</tr>

<tr>
    <td class="tit">@lang('layout.NetProfit/NetIncome')</td> 
    <td class="center tit">{{myRound($netProfit)}}</td>
</tr>
<tr>
    <td class="tit "  colspan="2">@lang('layout.AdjustmentsToReconcileNetIncome')</td> 
</tr>
<tr>
    <td class="tit "  colspan="2">@lang('layout.ToNetCashProvidedByOperations')</td> 
</tr>

@foreach($accountReceivable AS $accountReceivable)
<tr>
    <td class="center ">{{$accountReceivable->name}}</td>
    <td class="center ">{{myRound($accountReceivable->amount)}}</td>
</tr>
@endforeach 


@foreach($otherCurrentAsset AS $otherCurrentAsset)
<tr>
    <td class="center ">{{$otherCurrentAsset->name}}</td>
    <td class="center ">{{myRound($otherCurrentAsset->amount)}}</td>
</tr>
@endforeach 

@foreach($PayableAccounts AS $PayableAccounts)
<tr>
    <td class="center ">{{$PayableAccounts->name}}</td>
    <td class="center ">{{myRound($PayableAccounts->amount)}}</td>
</tr>
@endforeach 

@foreach($otherCurrentLiabilityAccounts AS $otherCurrentLiabilityAccounts)
<tr>
    <td class="center ">{{$otherCurrentLiabilityAccounts->name}}</td>
    <td class="center ">{{myRound($otherCurrentLiabilityAccounts->amount)}}</td>
</tr>
@endforeach 

@foreach($loanAccounts AS $loanAccounts)
<tr>
    <td class="center ">{{$loanAccounts->name}}</td>
    <td class="center ">{{myRound($loanAccounts->amount)}}</td>
</tr>
@endforeach 

@foreach($CreditCardAccounts AS $CreditCardAccounts)
<tr>
    <td class="center ">{{$CreditCardAccounts->name}}</td>
    <td class="center ">{{myRound($CreditCardAccounts->amount)}}</td>
</tr>
@endforeach 

<tr>
    <td class="tit">@lang('layout.NetCashProvidedByOperatingActivities')</td> 
    <td class="center tit">{{myRound($NetcashprovidedbyOperatingActivities)}}</td>
</tr>
<tr>
    <td class="tit "  colspan="2">@lang('layout.InvestmentActivities')</td> 
</tr>
@foreach($fixedAssets AS $fixedAssets)
<tr>
    <td class="center ">{{$fixedAssets->name}}</td>
    <td class="center ">{{myRound($fixedAssets->amount)}}</td>
</tr>
@endforeach

@foreach($otherAssets AS $otherAssets)
<tr>
    <td class="center ">{{$otherAssets->name}}</td>
    <td class="center ">{{myRound($otherAssets->amount)}}</td>
</tr>
@endforeach 

<tr>
    <td class="tit">@lang('layout.NetCashProvidedByInvestingActivities')</td> 
    <td class="center tit">{{myRound($NetcashprovidedbyInvestingActivities)}}</td>
</tr>

<tr>
    <td class="tit "  colspan="2">@lang('layout.FinancingActivities')</td> 
</tr>

@foreach($equity AS $equity)
<tr>
    <td class="center ">{{$equity->name}}</td>
    <td class="center ">{{myRound($equity->amount)}}</td>
</tr>
@endforeach 

@foreach($longTermLiabilityAccounts AS $longTermLiabilityAccounts)
<tr>
    <td class="center ">{{$longTermLiabilityAccounts->name}}</td>
    <td class="center ">{{myRound($longTermLiabilityAccounts->amount)}}</td>
</tr>
@endforeach 

<tr>
    <td class="tit">@lang('layout.NetCashProvidedByFinancingActivities')</td> 
    <td class="center tit">{{myRound($CashflowfromFinancing)}}</td>
</tr>

<tr>
    <td class="tit">@lang('layout.NetCashIncreaseForPeriod')</td> 
    <td class="center tit" >{{myRound($Netcashincreaseforperiod)}}</td>
</tr>
<tr>
    <td class="tit">@lang('layout.CashAtEndOfPeriod')</td> 
    <td class="center tit" >{{myRound($Netcashincreaseforperiod)}}</td>
</tr>



</table>




<br>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection