@extends('layouts.app')
@section('style')
<link href="{{url('/assets/global/plugins/jstree/dist/themes/default/style.min.css')}}" rel="stylesheet" type="text/css" />

    <style type="text/css">
        @media print{
            a[href]:after{
                content: none !important;
            }
        }
 
        #main {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
            background-color: rgba(218, 218, 218, 0.36);
            /* eaefec */
            
            
        }

        #main th, #main td {
            border: 2px solid rgba(185, 185, 185, 0.39);
            padding: 8px;
        }

        /* #main tr:hover {
            background-color: #ddd;
        } */

        #main th {
            padding-top: 12px;
            padding-bottom: 12px;

            background-color: #768585;
            color: white;
        }

        .doubleLine {
            text-decoration-line: underline;
            text-decoration-style: double;
        }

        .tit{
            font-weight: bold;
            font-size: 16px;
            color: black;
        }
  .center { 
      text-align: center !important;
      font-size: 16px;
      color: black;
    }
    a{
        color: black;
    }  
    a:hover{
        color: black;
        text-decoration: none;
    }
   

    </style>
@stop
@section('content')





    <div id="print-modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'cashFlowStatement'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-12" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off" v-model="from_date"
                                           name="from_date">
                                    <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                    <span class="input-group-addon"> @lang('layout.To')</span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off" v-model="to_date" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
					@lang('layout.CashFlowStatement')  &nbsp;&nbsp;
					<span class="text-primary">(
						<i class="fa fa-money hidden-print"></i> &nbsp;
						<b>  {{getHomeCurrency()['name']}}) </b>
					</span>
                </div>
                <div class="tools"> </div>
                <div class="btn-group pull-right">
                    @permission('build-export')
                        <span id="anchore-modal" class="hidden-print">
                            <button type="submit" @click.prevent="showModal" class="btn btn-success">
                                <i class="fa fa-print"></i>
                            </button>
                        </span>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <div class="hidden-print">
                    <template v-cloak id="company_ll">
                        <company @company="setCompany"></company>
                    </template>
                </div>
                
                <div class="row">
                    <div class="col-lg-12 col-md-8" style="border: 1px solid rgba(185, 185, 185, 0.571); padding: 10px 30px;border-radius: 5px;">
                        <table id="main">
                            <thead>
                            
                            </thead>
                            <tr>
                                <td class="tit text-center" style="font-size: 20px; font-weight: bolder;" colspan="2">@lang('layout.OperatingActivities')</td> 
                            </tr>

                            <tr>
                                <td class="tit">@lang('layout.NetProfit/NetIncome')</td> 
                                <td class="center tit">{{myRound($netProfit)}}</td>
                            </tr>
                            <tr>
                                <td class="tit "  colspan="2">@lang('layout.AdjustmentsToReconcileNetIncome')</td> 
                            </tr>
                            <tr>
                                <td class="tit "  colspan="2">@lang('layout.ToNetCashProvidedByOperations')</td> 
                            </tr>

                            @foreach($accountReceivable AS $accountReceivable)
                            <tr>
                                <td class="center ">
                                    <a href="{{url('/account/'.$accountReceivable['id'])}}">{{$accountReceivable->name}}</a>
                                </td>
                                
                                <td class="center ">{{myRound($accountReceivable->amount)}}</td>
                            </tr>
                            @endforeach 


                            @foreach($otherCurrentAsset AS $otherCurrentAsset)
                            <tr>
                                <td class="center "><a href="{{url('/account/'.$otherCurrentAsset['id'])}}">{{$otherCurrentAsset->name}}</a></td>
                                <td class="center ">{{myRound($otherCurrentAsset->amount)}}</td>
                            </tr>
                            @endforeach 

                            @foreach($PayableAccounts AS $PayableAccounts)
                            <tr>
                                <td class="center "><a href="{{url('/account/'.$PayableAccounts['id'])}}">{{$PayableAccounts->name}}</a></td>
                                <td class="center ">{{myRound($PayableAccounts->amount)}}</td>
                            </tr>
                            @endforeach 

                            @foreach($otherCurrentLiabilityAccounts AS $otherCurrentLiabilityAccounts)
                            <tr>
                                <td class="center "><a href="{{url('/account/'.$otherCurrentLiabilityAccounts['id'])}}">{{$otherCurrentLiabilityAccounts->name}}</a></td>
                                <td class="center ">{{myRound($otherCurrentLiabilityAccounts->amount)}}</td>
                            </tr>
                            @endforeach 

                            @foreach($loanAccounts AS $loanAccounts)
                            <tr>
                                <td class="center "><a href="{{url('/account/'.$loanAccounts['id'])}}">{{$loanAccounts->name}}</a></td>
                                <td class="center ">{{myRound($loanAccounts->amount)}}</td>
                            </tr>
                            @endforeach 

                            @foreach($CreditCardAccounts AS $CreditCardAccounts)
                            <tr>
                                <td class="center "><a href="{{url('/account/'.$CreditCardAccounts['id'])}}">{{$CreditCardAccounts->name}}</a></td>
                                <td class="center ">{{myRound($CreditCardAccounts->amount)}}</td>
                            </tr>
                            @endforeach 

                            <tr>
                                <td class="tit">@lang('layout.NetCashProvidedByOperatingActivities')</td> 
                                <td class="center tit">{{myRound($NetcashprovidedbyOperatingActivities)}}</td>
                            </tr>
                            <tr>
                                <td class="tit "  colspan="2">@lang('layout.InvestmentActivities')</td> 
                            </tr>
                            @foreach($fixedAssets AS $fixedAssets)
                            <tr>
                                <td class="center "><a href="{{url('/account/'.$fixedAssets['id'])}}">{{$fixedAssets->name}}</a></td>
                                <td class="center ">{{myRound($fixedAssets->amount)}}</td>
                            </tr>
                            @endforeach

                            @foreach($otherAssets AS $otherAssets)
                            <tr>
                                <td class="center "><a href="{{url('/account/'.$otherAssets['id'])}}">{{$otherAssets->name}}</a></td>
                                <td class="center ">{{myRound($otherAssets->amount)}}</td>
                            </tr>
                            @endforeach 

                            <tr>
                                <td class="tit">@lang('layout.NetCashProvidedByInvestingActivities')</td> 
                                <td class="center tit">{{myRound($NetcashprovidedbyInvestingActivities)}}</td>
                            </tr>

                            <tr>
                                <td class="tit "  colspan="2">@lang('layout.FinancingActivities')</td> 
                            </tr>

                            @foreach($equity AS $equity)
                            <tr>
                                <td class="center "><a href="{{url('/account/'.$equity['id'])}}">{{$equity->name}}</a></td>
                                <td class="center ">{{myRound($equity->amount)}}</td>
                            </tr>
                            @endforeach 

                            @foreach($longTermLiabilityAccounts AS $longTermLiabilityAccounts)
                            <tr>
                                <td class="center "><a href="{{url('/account/'.$longTermLiabilityAccounts['id'])}}">{{$longTermLiabilityAccounts->name}}</a></td>
                                <td class="center ">{{myRound($longTermLiabilityAccounts->amount)}}</td>
                            </tr>
                            @endforeach 

                            <tr>
                                <td class="tit">@lang('layout.NetCashProvidedByFinancingActivities')</td> 
                                <td class="center tit">{{myRound($CashflowfromFinancing)}}</td>
                            </tr>

                            <tr>
                                <td class="tit">@lang('layout.NetCashIncreaseForPeriod')</td> 
                                <td class="center tit" >{{myRound($Netcashincreaseforperiod)}}</td>
                            </tr>
                            <tr>
                                <td class="tit">@lang('layout.CashAtEndOfPeriod')</td> 
                                <td class="center tit" style="font-size: 18px;">{{myRound($Netcashincreaseforperiod)}}</td>
                            </tr>
                        </table>
                    </div>
                </div>
                

             
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- BEGIN TAB PORTLET-->
    <div class=" pull-right">


    </div>
    <br>
    <br>







@endsection
@include('groupCompanyFilter.select')
@include('print.modal')

@push('scripts')
<script src="{{url('/assets/pages/scripts/ui-tree.min.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/global/plugins/jstree/dist/jstree.min.js')}}" type="text/javascript"></script>




    <script type="text/javascript">

        var toggler = document.querySelectorAll(".rootTree");
            Array.from(toggler).forEach(item => {
                item.addEventListener("click", () => {
                    item.parentElement .querySelector(".children") .classList.toggle("active");
                    item.classList.toggle("rootTree-down");
                });
            });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                items: null,


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });

        // start app
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>
@endpush