@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title">
            <div class="caption">
                <i class=""></i>@lang('layout.ExpenseInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr> 
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.Type') 
                        </th>
                        <th>
                            <i class="fa  fa-user"></i> @lang('layout.Vendor') 
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Currency')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Rate')
                        </th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        <th>
                            <i class="fa fa-briefcase"></i> @lang('layout.Description')
                        </th>
						<th>
                            <i class="fa  "></i> @lang('layout.Total')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td class="hidden-xs"> {{ $expenseInfo->type}}  </td>
                        <td class="hidden-xs"> {{ $expenseInfo->vendor}}  </td>
                        <td class="hidden-xs"> {{ $expenseInfo->currency}}  </td>
                        <td class="hidden-xs"> {{ $expenseInfo->rate}}  </td>
                        <td class="hidden-xs"> {{ $expenseInfo->date}}  </td>
                        <td class="hidden-xs"> {{ $expenseInfo->description}}  </td>
                        <td class="hidden-xs"> {{ $expenseInfo->Total}} {{getHomeCurrency()["code"]}} </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.ExpenseDetails') </span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="Inoice_Details"/>
                           <input type="hidden" name="id" value="{{$expenseInfo->member_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="Inoice_Details"/>
                           <input type="hidden" name="id" value="{{$expenseInfo->member_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="invoices">
                        <thead>
                        <tr>
                            <th>@lang('layout.Account') </th>
                            <th>@lang('layout.Type') </th>
                            <th>@lang('layout.Description') </th>
                            <th>@lang('layout.Amount') </th> 
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')

<script>
    $(document).ready(function () {
        $('#invoices').DataTable({
            ajax:'{{route("expense.show",['WriteCheckExpense',$expenseInfo->p_id])}}', 
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [  
                { data: 'account', name: 'account' },
                { data: 'type', name: 'type' },
                { data: 'description', name: 'description' },
                { data: 'amount', name: 'amount' },
                  ]
        });


    });
</script>


@endpush
