@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'ExpenseList'" @closed="closeModal">
            <div slot=body>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------      
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">
                       <ul class="nav nav-tabs">
                           <li class="active">
                               <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                           </li>
                           @if(systemConfig()[2] != 0 )
                                   @permission(['customreport-list'])
                           <li class="">
                               <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                           </li>
                           @endpermission
                           @endif
                       </ul>
                       <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                <div class="portlet light bordered">
                                    <input type="hidden" name="type_name" value="Expens_type"/>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.Category') </label>
                                            <v-select class="vue-select2"
                                                    v-model="selected_expense_category"
                                                    label="name"
                                                    :options="expense_category"
                                                    @search="onCategorySearch"
                                                    >
                                            </v-select>
                                            <input type="hidden" name="category_id" :value="(!selected_expense_category)?null:selected_expense_category.id">
                                        </div>
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.Bank') </label>
                                            <v-select class="vue-select2"
                                                    v-model="selected_bank"
                                                    label="name"
                                                    :options="bank"
                                                    @search="searchAccount"
                                                    >
                                            </v-select>
                                            <input type="hidden" name="bank_id" :value="(!selected_bank)?null:selected_bank.id">
                                        </div> 
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.Type') </label>
                                            <select name="expense_type" id="" class="form-control">
                                                <option value="">@lang('layout.SelectType')</option>
                                                    <option value="Bill">@lang('layout.Bill')</option>
                                                    <option value="WriteCheck">@lang('layout.WriteCheck')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.ReferenceNumber') </label>
                                            <v-select class="vue-select2" v-model="selce_ref" label="expense_ref"
                                                    :options="expense_ref">
                                            </v-select>
                                            <input type="hidden" name="expense_ref"
                                                v-model="(!selce_ref)?null:selce_ref.expense_ref">
                                        </div>
                                        <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                            @if(getFinancialClass() =='true') 
                                            @permission('financialClass-list')
                                            <div class="col-md-3">
                                                <label class="control-label"> @lang('menu.FinancialClass')</label>
                                                <select name="financial_class_id" class="form-control" >
                                                    <option value="">@lang('layout.SelectClass')</option>
                                                    <option value="Unclassified">Unclassified</option>
                                                    <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                                </select>
                                            </div>
                                            @endpermission
                                            @endif
                                            <div class="col-md-3">
                                                <label class="control-label ">@lang('layout.Expense') </label>
                                                <v-select class="vue-select2" v-model="selected_expense" label="name" :options="expense" @search="searchExpense" >
                                                </v-select>
                                                <input type="hidden" name="expense_id" :value="(!selected_expense)?null:selected_expense.id">
                                            </div> 
                                            <div class="col-md-3">
                                                <label class="control-label ">@lang('layout.AllCategory') </label>
                                                <select name="all_categories" id="" class="form-control">
                                                    <option value="">@lang('layout.SelectCategory')</option>
                                                    <option value="total_by_category_and_class">@lang('layout.TotalByExpenseCategoryAndClass')</option>
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.Date')</label>
                                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                    <option value="CustomDates">@lang('type.CustomDates')</option>
                                                    <option value="Today">@lang('type.Today')</option>
                                                    <option value="Yesterday">@lang('type.Yesterday')</option>
                                                    <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                    <option value="LastWeek">@lang('type.LastWeek')</option>
                                                    <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                    <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                    <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                    <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                    <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                    <option value="ThisYear">@lang('type.ThisYear')</option>
                                                    <option value="YearToDate">@lang('type.YearToDate')</option>
                                                </select>
                                            </div>
                                            <div class="col-md-8" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                           </div> 
                           <div class="tab-pane" id="tab2"> 
                              <div class="portlet light bordered">
                                   <div class="portlet-body">
                                       <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                           @csrf
                                           <input type="hidden" name="part_name" value="expense_index">
                                           <div class="col-md-12 col-sm-12 col-xs-12">
                                               <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                   <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn">
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                   </div>
                                               </div>
                                           </div>
                                           <div class="margiv-top-10">
                                               <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                           </div>
                                        </form>
                                   </div>
                                </div>
                            </div>
                   </div>
               </div>
           </div>
           <!----------------------------------------------
           ----Begin Report Body And Custome Report-------
           ----------------------------------------------->

            </div>
        </report-modal>
    </div>
    <div id="settingModal" v-cloak>
        <setting-modal :pdf-route="route" v-if="is_show" :value-type="'expense'" @closed="closeModal">
            <div slot="header" class="text-center">
                <h4 style="font-weight: bold;">@lang('layout.CustomForms')</h4>
            </div>
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="mt-checkbox-inline col-md-2" style="padding: 0px;margin-bottom: 10px;" v-for="(row,itemIndex) in customReportData">
                            <div class="form-group">
                                <table class="table table-striped table-bordered table-advance">
                                    <tr style="background-color: rgba(227, 227, 227, 0.757)">
                                        <th style="text-align: center;">@{{ row.Name }}</th>
                                    </tr>
                                    <tr>
                                        <td style="text-align: center;">
                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                            <label class="switch">
                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                :checked="row.checkedColumn" >
                                                <span class="slider round"></span>
                                            </label>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </setting-modal>
    </div>
    <!-- END PAGE HEADER-->
    <!-- app -->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="col-md-2 col-sm-2">
                <span class="caption-subject bold uppercase" style="font-size: 20px;">@lang('layout.ExpenseList')</span>
            </div>
            <div class="col-md-5 col-sm-6" id="date_part">
                <div class="form-group">
                    <div class="input-group">
                        <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" autocomplete="off" />
                        <span class="input-group-addon btn"  @Click="getData()" > @lang('layout.Search') </span>
                    </div>
                </div>
            </div>
            <div class="portlet-title">
                <div class="caption font-dark">
                    <!-- <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ExpenseList')</span> -->
                </div>
                <div class="tools"></div>
                @permission('expense-create')
                <div class="pull-right">
                    <span id="setting-modal">
                        <button type="submit" @click.prevent="showModal" class="btn" style="background-color: rgb(80, 129, 141);color: white;">
                            <i class="fa fa-wrench"></i>
                        </button>
                    </span>
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    <a href="{{route('expense.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                </div>
                @endpermission
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="expense">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.ExpenseNumber')</th>
                            <th>@lang('layout.ReferenceNumber')</th>
                            <th>@lang('layout.Vendor')</th>
                            <th>@lang('layout.Account') </th>
                            @if(getCustomeForm('expense', 'date'))
                            <th>@lang('layout.Date')</th>
                            @endif
                            @if(getCustomeForm('expense','overdueDate'))
                            <th>@lang('layout.OverdueDate')</th>
                            @endif
                            @if(getCustomeForm('expense','hour'))
                            <th>@lang('layout.Hour')</th>
                            @endif
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Currency')</th>
                            @if(getCustomeForm('expense','status'))
                            @if(systemConfig()[5] != 0 )
                            <th>@lang('layout.Status')</th>
                            @endif
                            @endif
                            @if(getCustomeForm('expense','user'))
                            <th>@lang('layout.User')</th>
                            @endif
                            @if(getCustomeForm('expense','description'))
                            <th>@lang('layout.Description')</th>
                            @endif
                            <th>@lang('layout.Actions') </th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@include('layouts.setting_model')
@push('scripts')
    <script>
        var cust_rep = {!!customeReportNewData('expense_index')!!};
        function printVoucher(id) {
            var a = document.createElement('a');
            a.href = "{{url('printExpense')}}/" + id ;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        let data_table;
        function getRecord() {
            // console.log(234, vtr.from_date, vtr.to_date);
            data_table = $('#expense').DataTable({
                ajax: {
                    ajax: '{{route("expense.index")}}',
                    data: {
                        from_date: vtr.from_date,
                        to_date: vtr.to_date
                    }
                },
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:4}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                destroy: true,
                paging: true,
                buttons: [{
                        extend: 'excel',
                        text: '',
                        key: {
                            key: 'x',
                            altkey: true
                        }
                    }],
                columns: [
                    {data: 'number', name: 'number'},
                    {data: 'expense_number', name: 'purchases.expense_number'},
                    {data: 'expense_ref', name: 'expense_ref'},
                    {data: 'vendor', name: 'members.name'},
                    {data: 'account', name: 'accounts.name'},
                    @if(getCustomeForm('expense', 'date'))
                    {data: 'date', name: 'purchases.date' @if(getGeneralSearch()) , searchable: false @endif},
                    @endif
                    @if(getCustomeForm('expense','overdueDate'))
                    {data: 'overdue_date', name: 'purchases.overdue_date' @if(getGeneralSearch()) , searchable: false @endif},
                    @endif
                    @if(getCustomeForm('expense','hour'))
                    {data: 'hour', name: 'purchases.hour' , searchable: false},
                    @endif
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'currency', name: 'transactions.unit'},
                    @if(getCustomeForm('expense','status'))
                    @if(systemConfig()[5] != 0 )
                    {data: 'status', name: 'expenses.status', searchable: false},
                    @endif
                    @endif
                    @if(getCustomeForm('expense','user'))
                    {data: 'username', name: 'users.name'},
                    @endif
                    @if(getCustomeForm('expense','description'))
                    {data: 'description', name: 'purchases.description' @if(getGeneralSearch()) , searchable: false @endif},
                    @endif
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        }
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            getRecord();
        });
        Vue.component('v-select', VueSelect.VueSelect);
        var expense_ref = {!!$expense_ref!!};
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                expense_ref:expense_ref,
                selce_ref:null,
                financial_classes: {!!getFinancialClassList()!!},
                selected_expense_category:null,
                expense_category:[],
                selected_bank:null,
                bank:[],
                selected_expense:null,
                expense:[],
                customReportData:
                [
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.ExpenseNumber")', column_name: 'expense_number',checkedColumn:(cust_rep.expense_number)?'checked':'',column_percentage:(cust_rep.expense_number___percent)?cust_rep.expense_number___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_rep.reference_number)?'checked':'',column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.OverdueDate")', column_name: 'overdueDate',checkedColumn:(cust_rep.overdueDate)?'checked':'',column_percentage:(cust_rep.overdueDate___percent)?cust_rep.overdueDate___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_rep.account)?'checked':'',column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''},
                 {Name: '@lang("layout.Vendor")', column_name: 'vendor',checkedColumn:(cust_rep.vendor)?'checked':'',column_percentage:(cust_rep.vendor___percent)?cust_rep.vendor___percent:''},
                 {Name: '@lang("layout.Invoice")', column_name: 'invoice',checkedColumn:(cust_rep.invoice)?'checked':'',column_percentage:(cust_rep.invoice___percent)?cust_rep.invoice___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.PerCurrency")', column_name: 'per_currency',checkedColumn:(cust_rep.per_currency)?'checked':'',column_percentage:(cust_rep.per_currency___percent)?cust_rep.per_currency___percent:''},
                 {Name: '@lang("layout.HomeCurrencyTotal")', column_name: 'home_currency_total',checkedColumn:(cust_rep.home_currency_total)?'checked':'',column_percentage:(cust_rep.home_currency_total___percent)?cust_rep.home_currency_total___percent:''},
                 {Name: '@lang("layout.Project")', column_name: 'project',checkedColumn:(cust_rep.project)?'checked':'',column_percentage:(cust_rep.project___percent)?cust_rep.project___percent:''},
                 {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},       
                ],
                cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                onCategorySearch(search, loading) {
                    loading(true);
                    this.searchCategory(search, loading, this);
                },
                //ajax call to get expense_categories
                searchCategory(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'expense_categories',
                        }
                    })
                    .then(function (response) {
                        this.expense_category = [];
                        if (response.data.length > 0) {
                            vm.expense_category = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                //ajax call to get bank
                searchAccount(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'accounts',
                            filterColumn: 'type',
                            filterValue: 'bank',
                        }
                    })
                    .then(function (response) {
                        this.bank = [];
                        if (response.data.length > 0) {
                            vm.bank = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                //ajax call to get expense
                searchExpense(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'accounts',
                            filterColumn: 'type',
                            filterValue: 'expense',
                        }
                    })
                    .then(function (response) {
                        this.expense = [];
                        if (response.data.length > 0) {
                            vm.expense = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });
        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table== 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
        var vtr = new Vue({
            el: '#date_part',
            data: {
                from_date: null,
                to_date: null,
            },
            methods: {
                getData() {
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                    // console.log(234, this.from_date, this.to_date,this.$refs.from_date.value);
                    getRecord();
                }
            }
        });

        // custome part start
        var cust_form = {!!customeForm('expense')!!};
        var sm = new Vue({
            el: '#settingModal',
            data: {
                is_show: false,
                route: '{!!route("customForm.store") !!}',
                customReportData:
                [    
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_form.date)?'checked':''},
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_form.description)?'checked':''},
                    {Name: '@lang("layout.Project")', column_name: 'project',checkedColumn:(cust_form.project)?'checked':''},
                    {Name: '@lang("layout.ContractName")', column_name: 'contractName',checkedColumn:(cust_form.contractName)?'checked':''},
                    {Name: '@lang("layout.Invoice")', column_name: 'invoice',checkedColumn:(cust_form.invoice)?'checked':''},
                    {Name: '@lang("layout.OverdueDate")', column_name: 'overdueDate',checkedColumn:(cust_form.overdueDate)?'checked':''},
                    {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_form.hour)?'checked':''},
                    {Name: '@lang("layout.Memo")', column_name: 'memo',checkedColumn:(cust_form.memo)?'checked':''},
                    {Name: '@lang("layout.BuildExpense")', column_name: 'buildExpense',checkedColumn:(cust_form.buildExpense)?'checked':''},
                    {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_form.status)?'checked':''},
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_form.user)?'checked':''},              
                ],
                cust_form:cust_form
            },
            watch: {
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });
        new Vue({
            el: '#setting-modal',
            methods: {
                showModal: function () {
                    // console.log('trr')
                    sm.$data.is_show = true
                }
            }
        }); 
        // custome part end 
    </script>
@endpush