@extends('layouts.app')
@section('style')
<style type="text/css">
    body, html{
        height: 100%;
    }
    .background{
        position: relative;
        width: 100%;
        height: 100vh;
        background-image: url('{{asset('menu_img/SaleImages/Capture6.PNG')}}');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        overflow-y: auto;
    }
    .overlay{
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.651);
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding-top: 20px;
    }
    .cards{
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        max-width: 1600px;
        padding: 10px;
        box-sizing: border-box;
        gap: 10px;
    }
    .allCards{ 
        width: 19%;
        /* height: 80px; */
        min-height: 90px;
        background-color: white;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(235, 232, 232, 0.877);
        transition: .5s;
    }
    .allMainCard{ 
        width: 19%;
        /* height: 80px; */
        min-height: 100px;
        border-radius: 10px;
        transition: .5s;
    }
    .allMainCard:hover{
        text-decoration: none;
    }
    .allCards:hover{
        background-color: rgba(255, 255, 255, 0.787);
        transition: .5s;
    }
    .allCards:hover a{
        text-decoration: none;
    }
    @media(max-width: 1024px){
        .allCards{
            width: 22%;
        }
        .allMainCard{
            width: 22%;
        }
    }
    @media(max-width: 768px){
        .allCards{
            width: 45%;
        }
        .allMainCard{
            width: 45%;
        }
    }
    @media(max-width: 480px){
        .allCards{
            width: 90%;
        }
        .allMainCard{
            width: 90%;
        }
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="background">
    <div class="overlay">
        <div class="cards">
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('menu.Expenses')</h3>
                <div >
                    <div class="btn-group">
                        @permission('purchase-create')
                        <a href="{{route('purchase.create')}}" type="button" class="btn topBtn" style="background-color: #50818d;color: white;">@lang('layout.AddNew')</a>
                        <button type="button" class="btn topBtn dropdown-toggle btn-success" data-toggle="dropdown" id="dropdownButton">
                            <span class="caret"></span>
                        </button>
                        @endpermission
                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                            @permission('expense-create')
                            <li>
                                <a href="{{route('expense.create')}}">@lang('menu.Expenses')</a>
                            </li>
                            @endpermission
                            @permission('dailyExpenses-create')
                            <li>
                                <a href="{{route('dailyExpense.create')}}">@lang('menu.DailyExpenses')</a>
                            </li>
                            @endpermission
                            @if(systemConfig()[23] == 1)
                            @permission('itemexpense-create')
                            <li>
                                <a href="{{route('itemExpense.create')}}">@lang('menu.ItemExpense')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[23] == 1)
                            @if(systemConfig()[7] != 0)
                            @permission('itemexpense-create')
                            <li>
                                <a href="{{route('oilItemExpense.create')}}">@lang('menu.OilItemExpense')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
                            @if(systemConfig()[23] == 1)
                            @permission('itemExpenseCategory-list')
                            <li>
                                <a href="{{route('itemExpenseCategory.create')}}">@lang('menu.ItemExpenseCategory')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                    </div>
                    <a href="#" class="btn btn-danger">@lang('layout.Back') <i class="fa fa-reply"></i></a>
                </div>
            </div>
            <div class="cards">
                @permission('expense-list')
                <a href="{{route('expense.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Expenses')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($allExpenses){{myround($allExpenses->base_amount)}} {{getHomeCurrency()['code']}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('dailyExpenses-list')
                <a href="{{route('dailyExpense.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.DailyExpenses')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-credit-card"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($dailyExpense){{myround($dailyExpense->base_amount)}} {{getHomeCurrency()['code']}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @if(systemConfig()[23] == 1)
                @permission('itemexpense-list')
                <a href="{{route('itemExpense.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ItemExpense')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_oil_item_expense)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @if(systemConfig()[7] != 0)
                @permission('itemexpense-list')
                <a href="{{route('oilItemExpense.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.OilItemExpense')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_oil_item_expense)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @endif
                @permission('ReturnExpense-list')
                <a href="{{route('returnExpense.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ReturnExpense')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color:  #1fa7f2;" class="fa fa-mail-forward"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_home_currency)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('expenseCategory-list')
                <a href="{{route('expenseCategory.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ExpenseCategory')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(251, 239, 91, 1);" class="fa fa-arrows"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$total_expenseCategoryType_count}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @if(systemConfig()[23] == 1)
                @permission('itemExpenseCategory-list')
                <a href="{{route('itemExpenseCategory.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ItemExpenseCategory')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(163, 209, 118, 1);" class="fa fa-reorder"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$expenseCategory}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @permission('customsExpense-list')
                <a href="{{route('customsExpense.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.CustomsExpense')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(89, 192, 148, 1);" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_home_currency_customsExpense)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush