@extends('layouts.factor-master')
@section('style')
<style>
  .tdata{
    font-weight: bold;
    height: 30px;
  }  
  .tdata1{
    height: 30px;
  }
</style>
@endsection
@section('content')
<?php
$report = customeReport('expense_detail');
$_account=in_array('account', $report);
$_type=in_array('type', $report);
$_description=in_array('description', $report);
$_amount=in_array('amount', $report);

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.ExpenseReport')</h3>


@if($info && $info !=[])
<table class="main-table">
 
  <tr class="bg"> 
    <td class="center tdata">@lang('layout.ExpenseNumber')</td>
    <td class="center tdata">@lang('layout.ReferenceNumber')</td>
    <td class="center tdata">@lang('layout.Vendor')</td>
    <td class="center tdata">@lang('layout.Account')</td>
    <td class="center tdata">@lang('layout.Type')</td>
    <td class="center tdata">@lang('layout.Description')</td>
  </tr>
  <tr>
    <td class="center">{{$info->expense_number}}</td>
    <td class="center">{{$info->expense_ref}}</td>
    <td class="center">{{$info->vendor}}</td>
    <td class="center">{{$info->account}}</td>
    <td class="center">{{$info->type}}</td>
    <td class="center">

        @if(isset($report_format))
        {{$info->description}}
        @else
        {!! wordwrap($info->description,40,"<br/>\n",false) !!}
        @endif


  </td>
  </tr>


</table>
<table class="main-table">
 
  <tr class="bg"> 
    @if(systemConfig()[20] == 1)
    <td class="center tdata">@lang('layout.Contract')</td>
    @endif
    <td class="center tdata">@lang('layout.Currency')</td>
    <td class="center tdata">@lang('layout.Rate')</td>
    <td class="center tdata">@lang('layout.Total')</td>
    

    @if($info->type == 'BillExpense' && $total_payment)
    <td class="center tdata">@lang('layout.Recipt')</td>
    <td class="center tdata">@lang('layout.Remain')</td>
    @endif
  </tr>
  <tr>
    @if(systemConfig()[20] == 1)
    <td class="center">{{$info->contract}}</td>
    @endif
    <td class="center">{{$info->currency}}</td>
    <td class="center">{{$info->rate}}</td>
    <td class="center">{{$info->Total_currency}}</td>
    @if($info->type == 'BillExpense' && $total_payment)
    <td class="center">{{ myRound($total_payment)}}</td>
    <td class="center">{{ myRound($info->Total_currency-$total_payment)}}</td>
    @endif

  </tr>


</table>
<br>
@endif


<table class="main-table">
<thead>
  <tr class="bg">
 <td class="center tdata"> @lang('layout.Record') </td>
 @if($_account)<td class="center tdata"> @lang('layout.Account')</td>@endif
 @if($_type)<td class="center tdata" > @lang('layout.Type')</td>@endif
 @if($_description)<td class="center tdata" > @lang('layout.Description')</td>@endif
 @if($_amount)<td class="center tdata" > @lang('layout.Amount')</td> @endif

</tr>
</thead>
<tbody>
<?php
$count = 0;
?>
@foreach($data AS $record)

<tr>
<td class="center">{{++$count}}</td>
@if($_account)<td  class="center">{{$record->account}}</td>@endif
@if($_type)<td  class="center">{{$record->type}}</td>@endif
@if($_description)<td  class="center">

    @if(isset($report_format))
    {{$record->description}}
    @else
    {!! wordwrap($record->description,40,"<br/>\n",false) !!}
    @endif

</td>@endif
@if($_amount)<td  class="center">{{$record->amount}}</td> @endif

</tr>
@endforeach   
</tbody>
</table>
@if($info->type == 'BillExpense' && $total_payment)
<h3 class="table-caption" style="text-align: center;">@lang('layout.Payment')</h3>
<table class="main-table">
<thead>
  <tr class="bg">
 <td class="center tdata"> @lang('layout.Record') </td>
 <td class="center tdata"> @lang('layout.Account')</td>
 <td class="center tdata" > @lang('layout.Currency')</td>
 <td class="center tdata" > @lang('layout.Rate')</td>
 <td class="center tdata" > @lang('layout.Amount')</td> 

</tr>
</thead>
<tbody>
<?php
$count = 0;
?>
@foreach($purchasePayment AS $pay)

<tr>
<td class="center">{{++$count}}</td>
<td  class="center">{{$pay->account_name}}</td>
<td  class="center">{{$pay->unit}}</td>
<td  class="center">{{$pay->rate}}</td>
<td  class="center">{{$pay->amount}}</td> 
</tr>
@endforeach   
</tbody>
</table>
@endif


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection

