@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('style')
    <link rel="stylesheet" href="{{url('/vue/v-autocomplete.css')}}">
    <!-- <link rel="stylesheet" href="{{url('/vue/style.css')}}"> -->
    <style>
        .dashboard-stat2 {
            padding: 0;
        }
        table {
            border-collapse: collapse;
            border-spacing: 0;
            width: 100%;
            border: 1px solid #ddd;
        }
        th, td {
            text-align: left;
            padding-bottom: 0px;
        }
        tr {
            border-bottom: 1px solid #ddd;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2
        }
        [v-cloak] {
            display: none;
        }
        .row-height {
            height: 55px;
        }
        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            padding: 5px 15px;
        }
        .v-autocomplete-list {
            z-index: 1000 !important;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            height: 22px;
            font-size: 16px;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .dashboard-stat2 {
            padding-bottom: 0;
        }
        .dashboard-tabel td {
            padding: 0 4px;
        }
        .badge3 {
            ext-align: center;
            width: 100%;
            font-size: 18px !important;
            line-height: 34px;
            height: 34px;
            color: #fff;
            padding: 3px 6px;
        }
        .paddint-both {
            padding: 5px;
        }
        .paddint-both:hover {
            color: red;
        }
    </style>
    <style type="text/css">
        #table_content thead th {
            background-color: rgb(84, 199, 211);
            color: #ffffff;
            font-size: 14px;
        }
        #table_content > tbody > tr.odd > td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: rgb(224, 234, 234);
        }
        #table_content > tbody > tr.even > td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: #eceff361;
        }
        #table_content > tbody > tr.even > td.td_one, #table_content > tbody > tr.odd > td.td_one {
            font-size: 14px;
            color: #404040;
            font-weight: bold;
        }
        .input_style {
            min-width: 110px;
        }
        .inner_input {
            min-width: 80px;
            height: 30px;
        }
        td a i {
            color: #686868;
            font-size: 16px;
            margin: 10px;
            vertical-align: middle;
            border: none;
        }
        #table_content tr.even td input:focus, #table_content tr.odd td input:focus {
            outline: 2px solid #191919 !important;
        }
        #table_content > tbody > tr.odd > td > .input-group > .input-group-addon {
            border: none;
            background-color: rgb(197, 200, 208);
        }
        #table_content > tbody > tr.even > td > .input-group > .input-group-addon {
            border: none;
        }
        #table_content tr:nth-child(odd) {
            background-color: #eee !important;
        }
        #table_content tr:nth-child(even) {
            background-color: #fff !important;
        }
        .inpu-number-fild {
            background-color: white;
            height: 34px;
            border: none;
        }
        #table_content input[type=number], select {
            height: 34px;
            border: none !important;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
        .select_style{
            outline:1px solid #c2cad8 !important
        }
        .btn {
            display: table-cell;
        }
        .v-select input[type=search], .v-select input[type=search]:focus {
            padding: 0px !important;
        }
    </style>
@stop
@section('content')
@include("layouts.Cmodal")
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateExpense')</span>
                    {{--<span class="caption-helper">some info...</span>--}}
                </div>
            </div>
            <div class="portlet-body form" id="salse"> 
                {{Form::open(['route' => 'expense.store','method' => 'POST','class' => 'form-horizontal','id'=>'expense-form', 'files'=> true])}}
                <div v-cloak>
                    <div class="row" style="margin-bottom: 20px; padding: 10px;">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 50px;">
                            <div class="row container" v-if="statusAttachment">
                                <div class="col-md-6">
                                    <span style="color: red;"> @lang('message.SaveAttachmentMessage') </span>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-md-4">
                                    <label class="control-label" style="cursor: pointer;" for="attachment">@lang('layout.Attachment') </label>
                                    <input type="checkbox" v-model="statusAttachment" id="attachment" name="attachment" style="transform: scale(1.8);cursor: pointer; margin-right: 10px;">
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class=" ">
                                            <label class="control-label">@lang('layout.ExpenseType') </label>
                                            {{Form::select('type',['writeCheck' => __('layout.Writecheck'),'bill' => __('layout.Bill')],'Accounts Receivable',[ 'v-model'=>'expenseType','class'=>'form-control select_style',"v-validate"=>"'required'","data-vv-as"=>__('layout.ExpenseType')])}}
                                            <span class="required">@{{errors.first('type')}}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.ExpenseNumber')</label> 
                                            <input type="number" name="expense_number" v-validate="'required|numeric'"
                                                   data-vv-as="@lang('layout.ExpenseNumber')"  @input="checkExpenseNo()" 
                                                   class="form-control" v-model="expense_number">
                                            <span class="required">@{{ errors.first('expense_number') }}</span>  
                                            <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label> 
                                            <input type="text" name="expense_ref" v-model="refNumber" class="form-control" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Currency') </label>
                                            <v-select v-model="selectedCurrency" label="code" :options="setRates">
                                            </v-select>
                                            <input type="hidden" name="currency" :value="selectedCurrency.code"/>
                                        </div>
                                    </div>
                                </div>
                                <span v-if="expenseType == 'writeCheck'">
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <div class="">
                                                <label class="control-label">@lang('layout.Account') </label>
                                                <select class="form-control select_style" name="bank_account" v-model="defaultAccount"
                                                        v-on:change="test(defaultAccount)">
                                                    <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                        Account.name }}
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </span>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-4 col-md-4': 'col-lg-5 col-md-5' }} col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Vendor')</label>
                                            <div class="input-group">
                                                <v-select label="name" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                                                <input type="hidden" name="vendor" v-validate="(expenseType == 'bill')?'required':''" data-vv-as="@lang('layout.Vendor')" :value="!selected_vendor?null:selected_vendor.id" :required="expenseType == 'bill'" >
                                                <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                    <i class="fa fa-plus" style="color: white"></i>
                                                </span> 
                                            </div>
                                            <span class="required">@{{ errors.first('vendor') }}</span>
                                        </div>
                                        {{--<div class="col-md-8 ">--}}
                                        {{--<div class="input-group" :class="{'has-error':discount<0 || discount>100 }">--}}
                                        {{--<input  v-model="discountFiled" class="form-control"--}}
                                        {{--type="number" min="0"--}}
                                        {{--max="100">--}}
                                        {{--<span  v-if="discountIsAmount"  @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selectedCurrency.symbol}}</span>--}}
                                        {{--<span  v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" >%</span>--}}
                                        {{--<input type="hidden" name="discount" :value="discount">--}}
                                        {{--</div>--}}
                                        {{--</div>--}}
                                    </div>
                                </div>
                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-1 col-md-1': 'col-lg-2 col-md-2' }} col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="" :class="{'has-error':selectedCurrency.rate < 0}">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <input v-model="selectedCurrency.rate" :readonly="averageRate && expenseType == 'writeCheck'" class="form-control" type="number" min="0">
                                            <span v-if="differentRate" style="background: #efefef; font-size: 14px;" class="required">@lang('message.DifferentRateMsg')</span>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.rate">
                                </div>	
                                @if(auth()->user()->company()->first()->tag == 1)
                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <div class="" :class="{'has-error':selectedCurrency.hq_rate < 0}">
                                                <label class="control-label">@lang('layout.ExchangeRateHQ') </label>
                                                <div class="input-group">
                                                    <input v-model="selectedCurrency.hq_rate" class="form-control" type="number" min="0">
                                                </div>
                                            </div>
                                        </div>
                                        <input type="hidden" name="currency_rate_hq" :value="selectedCurrency.hq_rate">
                                    </div>
                                @endif
                                <span v-if="expenseType == 'writeCheck'">
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <div class="form-group">           
                                            <div class="">
                                                <label class="control-label">@lang('layout.Amount') </label>
                                                <span v-show="false">@{{defaultAmount=((!selectedBank)?null:selectedBank.balance-subtotal)}}</span>
                                                <input type="number" class="form-control" v-model="Number.parseFloat(defaultAmount).toFixed(precision())" disabled>
                                            </div>
                                        </div>

                                    </div>
                                </span>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('expense','date')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Date') </label>
                                            <input type="text" name="date" class="form-control date" id="date" autocomplete="off"  @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif />
                                            <span class="required">@{{ errors.first('date') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('expense','description')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Description') </label>
                                            <textarea name="description" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                </div>
								@if(systemConfig()[5] != 0 )
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('expense','project')) displayNone @endif">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Project')</label>
                                            <v-select class="vue-select2" label="name" @search="ProjectSearch" :options="project_list" v-model="selectedProject">
                                            </v-select>
                                            <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                @if(systemConfig()[20] == 1)
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('expense','contractName')) displayNone @endif">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.ContractName')</label>
                                            <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name" :options="{{$contract}}">
                                            </v-select>
                                            <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                        </div>
                                    </div>
                                @endif 
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('expense','invoice')) displayNone @endif"> 
                                    <div class="from-group">
                                        <div class="col-md-12" style="padding: 0px !important;">
                                            <label class="control-label">@lang('layout.Invoice')</label>
                                            <v-select class="vue-select2" label="name" @search="saleSearch" :options="sales_list" v-model="selectedSale">
                                            </v-select>
                                            <input type="hidden" name="sale_id" v-model.number="(!selectedSale)?null:selectedSale.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('expense','overdueDate')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.OverdueDate') </label>
                                            <input type="text" name="overdue_date" class="form-control date" id="date" autocomplete="off"  />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('expense','hour')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Hour')</label>
                                            <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                                @if(getHourType() == 24)
                                                <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                @else
                                                <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                @endif
                                                <span class="input-group-btn">
                                                    <button class="btn default" type="button">
                                                        <i class="fa fa-clock-o"></i>
                                                    </button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-12 col-sm-12 col-xs-12 @if(!getCustomeForm('expense','memo')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Memo')</label>
                                            <textarea name="memo" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-12 col-xs-12 @if(!getCustomeForm('expense','buildExpense')) displayNone @endif">
                                    <div class="form-group">
                                        <div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                            <label class="control-label">@lang('layout.BuildExpense')</label>
                                            <input type="checkbox" name="build_expense_confirm" id="" value="On">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                <div class="dashboard-stat2" style="margin-top: 20px;">
                                    <table class="dashboard-tabel" width="100%">
                                        <tr v-if="expenseType !== 'bill'">
                                            <td>
                                                <small>@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">@{{ Number.parseFloat(subtotal).toFixed(2)}}</span>
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr v-if="expenseType == 'bill'">
                                            <td>
                                                <small>@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">@{{ Number.parseFloat(subtotal-payeds).toFixed(2)}}</span>
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr v-if="expenseType == 'bill'">
                                            <td>
                                                <small>@lang('layout.Pyments') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">@{{ Number.parseFloat(payeds).toFixed(2)}}</span>
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr v-if="expenseType == 'bill'">
                                            <td>
                                                <small>@lang('layout.Sub-Total') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800"> @{{ Number.parseFloat(subtotal).toFixed(2)}}</span>
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                            </td>
                                        </tr>
                                        {{--<tr>--}}
                                        {{--<td>--}}
                                        {{--<small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(2) }}%)</small>--}}
                                        {{--</td>--}}
                                        {{--<td class="text-right">--}}
                                        {{--<span class="text-right" data-counter="counterup"--}}
                                        {{--data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(2) }}</span>--}}
                                        {{--<small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>--}}
                                        {{--</td>--}}
                                        {{--</tr>--}}
                                        {{--<tr>--}}
                                        {{--<td>--}}
                                        {{--<small>@lang('layout.Payment'):</small>--}}
                                        {{--</td>--}}
                                        {{--<td class="text-right">--}}
                                        {{--<small class="font-green-sharp">--}}
                                        {{--<span class="text-right" data-counter="counterup"--}}
                                        {{--data-value="7800">@{{ payeds.toFixed(2)}}</span>--}}
                                        {{--<small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>--}}
                                        {{--</small>--}}
                                        {{--</td>--}}
                                        {{--</tr>--}} 
                                        {{--<tr>--}}
                                        {{--<td>--}}
                                        {{--<small>Sub-Total:</small>--}}
                                        {{--</td>--}}
                                        {{--<td class="text-right">--}}
                                        {{--<span class="text-right" data-counter="counterup"--}}
                                        {{--data-value="7800">@{{ subtotal.toFixed(2)}}</span>--}}
                                        {{--<small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>--}}
                                        {{--</td>--}}
                                        {{--</tr>--}}
                                    </table>
                                </div>
                            </div>
                        </div> 
                    </div> 
                    {{-- Attachment Started ............................................................. --}}
                    <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                        <div class="row">
                            <div class="container"  v-if="statusAttachment">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                        <input type="text" name="attachment_title" class="form-control">
                                    </div>
                                </div>   
                                <input type="hidden" name="attachment_path" value="uploads/Expense">
                                <input type="hidden" name="attachment_table_name" value="purchases"> 
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="attachment_description" rows="8" style="resize: none" class="form-control"></textarea>
                                </div>
                                <div class="col-md-6">
                                    <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                        <div>
                                            <span class="btn default btn-file">
                                                <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                <input type="hidden" value="" name=""><input type="file" name="attachment_photo"> 
                                            </span>    
                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                        </div>
                                        <div class="fileinput-new thumbnail" style="width: 100%; height: 168px;">
                                            <img src="" alt=""> </div>
                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 168px; line-height: 10px;"> </div>
                                    </div>
                                </div> 
                            </div>
                        </div>
                    </div>
                    {{-- <div class="row container"  v-if="statusAttachment"> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                <input type="text" name="attachment_title" class="form-control">
                            </div>
                        </div>   
                        <input type="hidden" name="attachment_path" value="uploads/Expense">
                        <input type="hidden" name="attachment_table_name" value="purchases"> 
                    </div>
                    <div class="row container"style="margin-bottom: 20px;"  v-if="statusAttachment"> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.Description')</label>
                                <textarea name="attachment_description" rows="3" style="resize: none" class="form-control"></textarea>
                            </div>
                        </div>
                        <div class="col-md-5" style="margin-top: 5px;">
                            <div class="form-group">
                                <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                    <div>
                                        <span class="btn default btn-file">
                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                            <input type="hidden" value="" name=""><input type="file" name="attachment_photo"> </span>    
                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                    </div>
                                    <div class="fileinput-new thumbnail" style="width: 100%; height: 70px;">
                                        <img src="" alt=""> </div>
                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 80; line-height: 10px;"> </div>
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-1"></div>
                    </div> --}}
                    {{-- End Attachment ......................................................... --}}
                    <div class="row">
                        <table id="table_content" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th style="min-width: 130px" class="text-center">@lang('layout.SelectAccount')</th>
                                    <th style="min-width: 130px" class="text-center">@lang('layout.AccountType')</th>
                                    <th style="min-width: 100px" class="text-center">@lang('layout.ExpenseCategory')</th>
                                    <th style="min-width: 100px" class="text-center">@lang('layout.Description')</th>
                                    <th style="min-width: 100px" class="text-center">@lang('layout.Amount')</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tr v-for="(row, itemIndex) in expense" class="even">
                                <td class="td_one">
                                    <span class="badge badge3 badge-success badge-roundless" style="background-color: transparent !important;color: black;"> @{{itemIndex+1}} </span>
                                </td>
                                <td class="td_one">
                                    <v-autocomplete :items="row.items" v-model="row.item"
                                        :get-label='getLabel'
                                        :min-len='0'
                                        :component-item='tpl' v-on:update-items='expenseUpdate'
                                        :input-attrs="{}"
                                        @focus="expenseIndex(itemIndex)"
                                        placeholder="@lang('layout.SelectAccount')"
                                        style="min-width: 220px  ;">
                                    </v-autocomplete>
                                    <input v-if="row.item" type="hidden" name="expense[]" :value="row.item.id">
                                </td>
                                <td>
                                    <input type="text" class="form-control" v-model="!row.item?null:row.item.type" required disabled/> 
                                </td>
                                <td>
                                    <select v-model="!row.item?null:categories[itemIndex].name">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option v-for="obj in category" :value="obj.id">@{{obj.name}}</option>
                                    </select>
                                    <input v-if="row.item" type="hidden" name="expense_category_id[]" :value="categories[itemIndex].name">
                                </td>
                                <td>
                                    <input name='expense_description[]' type="text" class="form-control" autocomplete="off" placeholder="@lang('layout.Description')" required/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <vue-numeric
                                            class="form-control"
                                            v-model="row.amount"
                                            :max="99999999999999"
                                            :currency="selectedCurrency.code"
                                            :precision="precision()"
                                            >
                                        </vue-numeric>
                                        <input name='expense_amount[]' type="hidden" class="form-control" v-model="row.amount" placeholder="@lang('layout.Amount')" required />
                                        <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteExpense(itemIndex)"> <i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                        </table>
                    </div>




                    <span v-if="expenseType == 'bill'">
                        <div v-if="payments.length >0  " class="row" style="overflow-x: scroll; max-height: 200px">
                        <div class="table-responsive333">
                            <table id="table_content" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th class="text-center" style="min-width: 8px;"> # </th>
                                        <th class="text-center" style="min-width: 160px;">@lang('layout.SelectAccount')</th>
                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                        <th class="text-center" style="min-width: 100px;">@lang('layout.Currency')</th>
                                        <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                        @if(auth()->user()->company()->first()->tag != 1)
                                            <th class="text-center" style="min-width: 120px;">@lang('layout.TotalHQ')</th>
                                        @endif
                                        <th style="min-width: 20px;"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="(payment,Index) in payments" class="even">
                                        <td class="td_one"> 
                                            <span class="badge badge3 badge-success badge-roundless"> @{{Index+1}} </span>
                                        </td>
                                        <td class="td_one">
                                            <v-autocomplete :items="payment.items" v-model="payment.item"
                                                            :get-label='getLabel'
                                                            :min-len='0'
                                                            :component-item='tpl' v-on:update-items='updatePayment'
                                                            :input-attrs="{}"
                                                            @focus="setPaymentIndex(Index)"
                                                            placeholder="@lang('layout.SelectAccount')">
                                            </v-autocomplete>
                                            <input type="hidden" name="payment_id[]" :value="!payment.item?null:payment.item.id">
                                        </td>
                                        <td>
                                            <input v-bind:disabled="!payment.item?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                                type="number" v-model.number="!payment.item?null:payment.item.rate "
                                                class="form-control"
                                                placeholder="@lang('layout.Rate')" required/>
                                            <input v-if="payment.item" type="hidden" name="payment_rate[]"
                                                v-bind:value="payment.item.rate">
                                            <input v-if="payment.item" type="hidden" name="payment_rate_hq[]"
                                                v-bind:value="payment.item.hq_rate">
                                        </td>
                                        <td>
                                            <input type="text" name="payment_Currency[]" class="form-control"
                                                v-model="!payment.item?null:payment.item.code"
                                                placeholder="@lang('layout.Currency')" required disabled/>
                                            <input v-if="payment.item" type="hidden" name="payment_currency[]"
                                                v-bind:value="payment.item.code"/>
                                        </td>
                                        <td>
                                            <vue-numeric
                                                class="form-control"
                                                v-model="payment.amount"
                                                :max="99999999999999"
                                                :currency="(!payment.item)?null:payment.item.code"
                                                :precision="precision()"
                                                >
                                            </vue-numeric>
                                            <input v-if="payment.item" type="hidden" name="payment_amount[]" v-bind:value="payment.amount">
                                        </td>
                                        <td>
                                            @if(systemConfig()[30] == 1)
                                            <div class="input-group">
                                                <input type="number" class="form-control"
                                                    :value="!payment.item?null:((payment.amount / payment.item.static_rate * payment.item.rate )*selectedCurrency.static_rate/selectedCurrency.rate).toFixed(3)"
                                                    placeholder="@lang('layout.Total')" style="min-width: 100px" required
                                                    disabled/>
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                            @else 
                                            <div class="input-group">
                                                <input type="number" class="form-control"
                                                    :value="!payment.item?null:(payment.amount*selectedCurrency.rate/payment.item.rate).toFixed(3)"
                                                    placeholder="@lang('layout.Total')" style="min-width: 100px" required
                                                    disabled/>
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                            @endif
                                        </td>
                                        @if(auth()->user()->company()->first()->tag != 1)
                                            <td>
                                                @if(systemConfig()[30] == 1)
                                                <div class="input-group">
                                                    <input type="number" class="form-control"
                                                        :value="!payment.item?null:((payment.amount / payment.item.static_rate * payment.item.hq_rate )*selectedCurrency.static_rate/selectedCurrency.hq_rate).toFixed(3)"
                                                        placeholder="@lang('layout.Total')" style="min-width: 100px" required
                                                        disabled/>
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                @else 
                                                <div class="input-group">
                                                    <input type="number" class="form-control"
                                                        :value="!payment.item?null:(payment.amount*selectedCurrency.hq_rate/payment.item.hq_rate).toFixed(3)"
                                                        placeholder="@lang('layout.Total')" style="min-width: 100px" required
                                                        disabled/>
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                @endif
                                            </td>
                                        @endif
                                        <td>
                                            <span v-on:click="deletePayment(Index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    </span>
                    <div class="row text-center" style="margin-top: 10px;">
                        {{--<button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addInventory">@lang('layout.AddItem')--}}
                        {{--</button>--}}
                        {{--<button v-if="services.length <= 0 " type="button" class="btn default" @click="addService">@lang('layout.Addservice')--}}
                        {{--</button>--}}
                        <button type="button" class="btn green" :disabled="disabled" 
                                @click="handleSubmit($event)">@lang('layout.Submit')</button>
                        <button type="button" class="btn blue"
                        :disabled="disabled" @click="checkOldList($event)">@lang('layout.SaveAndNew')</button>
                    </div>

                </div>
                {{Form::close()}}
                <cmodal :show='showModal' @close="showModal=false">
                </cmodal>

            </div>

        </div>

    </div>
    </div>


    <script type="text/x-template" id="checkbox-template">

        <div>
            <b>#@{{item.id}}</b>
            <span>@{{ item.name }}</span>
            {{--<span>@{{item.qty }}</span>--}}
            {{--<span>@{{item.description}}</span>--}}
        </div>
    </script>
@endsection

@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script src="{{url('/vue/v-autocomplete.js')}}"></script>
    <script>
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueNumeric.default);

        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    classes: [],
                    selectedClass: null,
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Vendor") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {
                    sales.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            sales.selected_vendor = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        var Currency = {!! $currency!!}
        var AllAccounts = {!! $all_accounts!!};
        var Banks ={!! $banks!!}
        var Category = {!! $category !!};
        var InventoryAll = null;
        var serviceAll = null;
        var Account = {!! $allBank !!};
        let bankes = {!! $bankes !!};

        let homeCurrency = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};

        Vue.use(VAutocomplete.default);
        Vue.use(VeeValidate);

        var temp = Vue.component('my-checkbox', {
            template: '#checkbox-template',
            props: {
                item: {required: true},
                searchText: {required: true}
            }

        });

        var sales = new Vue({
            el: '#salse',
            data: {
                dynamic_time:'',
                currencyRate: 1,
                vendor: [],
                selected_vendor: null,
                selectedCurrency: {!!json_encode(getHomeCurrency()) !!},
                discountFiled: 0,
                refNumber: '',
                expense_number: "{{$expense_number}}",
                old_expense_number: "{{$expense_number}}",
                number_Error: false,
                showModal: false,
                date: '',
                statusAttachment: false,
                averageRate: false,
                discountIsAmount: false,
                disabled: false,
                differentRate: false,
                selectedProject: null,
                selectedContract: null,
                project_list: [], 
                selectedSale: null,
                sales_list: [], 
                currencyList: Currency,
                listAccounts: [],
                category: Category,
                categories: [
                    {
                        name: [],
                    },
                    {
                        name: [],
                    }
                ],
                expense: [
                    {
                    items: [],
                    item: null,
                    amount: 0,
                },
                    {
                        items: [],
                        item: null,
                        amount: 0,
                    }
                ],
                payments: [],
                paymentIndex: 0,
                temp_amount: 0,
                eindex: 0,
                expenseType: 'writeCheck',
                account: {},
                tpl: temp,
                bankes: bankes,
                selectedBank: null,
                defuilt_banks: null,
                defaultValue: 0,
                defaultAmount: 0,
                defaultAccount: 0,
                amount: null,
                amount_check: null
            },
 
            computed: {
                setRates() {
                    let rates = [];
                    let expenseType = this.expenseType;
                    this.currencyList.forEach((b) => {

                        ratesFetched.forEach((a) => {
                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    static_rate: a.static_rate,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currencyList.forEach((a) => {
                        let found = false;

                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {

                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                    // this. = [];
                    let acc = _.clone(Account);
                    Account = [];
                    acc.forEach((a) => {
                        rates.forEach((r) => {
                            if (a.code == r.code) {
                                Account.push({
                                    amount: a.amount,
                                    code: a.code,
                                    id:a.id,
                                    name: a.name,
                                    rate: @if(getAverageRate() =="true") a.rate @else r.rate @endif,
                                    static_rate: @if(getAverageRate() =="true") a.static_rate @else r.static_rate @endif,
                                    hq_rate: r.hq_rate
                                });
                                this.bankes.push({
                                    amount: a.amount,
                                    balance: a.balance,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    rate: @if(getAverageRate() =="true") a.rate @else r.rate @endif,
                                    static_rate: @if(getAverageRate() =="true") a.static_rate @else r.static_rate @endif,
                                    hq_rate: r.hq_rate
                                })
                            }
                        });
                    });
                    return rates;
                },

                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },
                accountUpdate() {
                    var b = _.clone(Banks);

                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    });

                    if (this.defuilt_banks) {
                        this.defaultValue = this.defuilt_banks.id;
                        this.defuilt_banks = null;
                    }else{
                        if (test[0]) {
                            this.defaultValue = test[0].id;
                        }
                    }
                    // console.log(4444,this.defaultValue, test);

                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                if (this.bankes[x].balance!=undefined) {
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.defaultValue;
                                    this.averageRate = false;
                                    @if(getAverageRate() =="true")
                                    if (this.bankes[x].avg_rate && this.expenseType == 'writeCheck') {
                                        this.set_avg_rate(this.bankes[x].avg_rate);
                                    }
                                    @endif
                                    break;
                                }
                            }
                        }

                    }
                    return test;
                },
                subtotal: function () {

                    var sum = 0;
                    for (var i = 0; i < this.expense.length; i++) {
                        if (this.expense[i].item)
                        // sum +=parseFloat(Number(this.expense[i]['item']['amount']));
                            sum += parseFloat(Number(this.expense[i].amount));

                    }
                    this.amount_check = sum;
                    return sum;
                },
                payeds: function () {
                    this.differentRate = false;
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item && this.payments[i]['item']['rate'] > 0) {
                            @if(systemConfig()[30] == 1)
                            sum += parseFloat((this.payments[i]['amount'] /this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selectedCurrency.static_rate / this.selectedCurrency.rate );
                            @else 
                            sum += parseFloat(this.payments[i]['amount'] * this.selectedCurrency.rate / this.payments[i]['item']['rate']);
                            @endif
                            if (this.selectedCurrency.code == this.payments[i]['item']['code'] && this.payments[i]['amount']) {
                                if (this.selectedCurrency.rate != this.payments[i]['item']['rate']) {
                                    this.differentRate = true;
                                }
                            }
                        }
                    }
                    return sum;
                },

            },

            mounted: function () {
                var selected_banks=_.find(this.bankes,(v)=>v.id=={!! getDropdown('expense', 'bank') !!});
                if(selected_banks){
                    this.defaultAccount = selected_banks.id;
                    var selected_currency=_.find(this.setRates,(v)=>v.code==selected_banks.code);
                    // currency
                    this.selectedCurrency = selected_currency;

                    console.log(this.selectedCurrency);

                    this.defuilt_banks = selected_banks;
                }

                var selected_A = null;
                var bank=_.find(Account,(v)=>v.id=={!! getDropdown('expense', 'account') !!});
                if (bank) {
                    selected_A = bank;
                }

                this.payments.push({
                    items: Account,
                    item: selected_A,
                    amount: 0
                });
                this.dynamicTime()

                // console.log(123, selected_banks, selected_currency);
            },

            methods: {
                //BEGIN - Used for dynamic input time
                dynamicTime()
                        {
                            this.time_interval = setInterval(() => {
                                const now = new Date()
                                @if(getHourType() == 24)
                                    const hours = now.getHours().toString().padStart(2,'0')
                                    const minutes = now.getMinutes().toString().padStart(2,'0') 
                                    // const seconds = now.getSeconds().toString().padStart(2,'0')
                                    this.dynamic_time = `${hours}:${minutes}`
                                @else
                                    const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                                    this.dynamic_time = `${timeString}`
                                @endif
                                
                            },1000);
                        },
                        stopDynamicTime()
                        {
                            clearInterval(sales.time_interval)
                        },
                        changeTime()
                        {
                            sales.dynamic_time = sales.$refs.time_input.value
                        },
                    //END - Used for dynamic input time
                handleSubmit(e) { 
                    this.$validator.validate()
                    .then(valid => {
                    if (valid) {

                    var bank_id = this.defaultAccount;
                    var date = document.getElementById('date').value;
                    var amount = this.amount_check;

                if (amount && this.selectedCurrency && this.selected_vendor) {
                    sales.disabled = true;
                    var currencies = this.selectedCurrency.code;
                    var member_id = this.selected_vendor.id;
                    // console.log(currencies , member_id , bank_id , date, amount);
                    // console.log(amount_check); 
                    // console.log(bank , currencies , expense , date_value , amount_check);
                    axios.get("{{route('expense.checkOldValue')}}", {
                        params: {
                            currencies: currencies,
                            member_id: member_id,
                            bank_id: bank_id,
                            date: date,
                            amount: amount,
                            }}).then(function (response) {
                            if (response.data) {
                                swal({
                                title: "{{__('layout.DuplicateData')}}",
                                text: "",  
                                icon: "warning",
                                buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                warningMode: true,
                            })
                                .then((willDelete) => {
                                    if (willDelete) {
                                        regForm(e.target);
                                        sales.disabled = false;
                                    } else {
                                        sales.disabled = false;
                                    }
                                });
                            }else{                                
                                regForm(e.target);   
                                sales.disabled = false; 
                            }
                         }) .catch(function (error) {
                            sales.disabled = false;
                            console.log(error);
                        })  
                    }
                }
                    });
                },
                itemSelected(item) {
                    alert('selected');
                    console.log('Selected item!', item)
                },
                itemClicked(item) {
                    console.log('You clicked an item!', item)
                    alert('clicked');
                },
                getLabel(item) {
                    if (item) {
                        return item.name
                    }
                    return ''
                },
                updatePayment(text) {
                    var Animals1 = Account.slice();
                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item != null) {
                            if (Animals1.findIndex((item) => item.name == this.payments[i].item.name) != -1)
                                Animals1.splice(Animals1.findIndex((item) => item.name == this.payments[i].item.name), 1)
                        }

                    }

                    this.payments[this.paymentIndex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())
                    })
                    if (this.paymentIndex == this.payments.length - 1)
                        this.newPayment()
                    if (this.payments[this.paymentIndex].item != null)
                        this.payeds;

                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Vendor'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            sales.vendor = [];
                            sales.vendor = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

                setPaymentIndex(index) {
                    this.paymentIndex = index;
                    this.updatePayment('')
                },
                newPayment() {
                    this.payments.push({
                            items: [],
                            item: null,
                            amount: 0,
                        }
                    )
                },
                deletePayment(index) {
                    this.payments.splice(index, 1)
                },

				// Search Project

				ProjectSearch:_.debounce((search,loading)=>{
				   sales.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						sales.project_list=response.data;
						// console.log('test 22',sales.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),
				
				// Search sale

				saleSearch:_.debounce((search,loading)=>{
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchSales',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
                    sales.sales_list=[];
					 if(response.data.length>0)
					 {
						sales.sales_list=response.data;
						// console.log('test 22',response.data);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),
				
                bankUpdate(text) {
                    var b = _.clone(this.accounts)

                    this.listAccounts = b.filter((account) => {
                        return (new RegExp(text.toLowerCase())).test(account.name.toLowerCase())
                    })

                }, 
                newExpense() {
                    this.expense.push({
                        items: [],
                        item: null,
                        amount: 0,
                    });
                    this.categories.push({name: []});
                }, 
                deleteExpense(index) {
                    this.expense.splice(index, 1);
                    this.categories.splice(index, 1);
                },
                expenseUpdate(text) {
                    var Animals1 = AllAccounts.slice();


                    this.expense[this.eindex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())
                    });


                    if (this.eindex == this.expense.length - 1)
                        this.newExpense()
                    // if (this.expense[this.eindex].item != null)
                    //     this.priceUpdate(this.eindex);

                },
                expenseIndex(text) {
                    this.eindex = text
                    this.expenseUpdate('')
                },
                submitForm() { 
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("expense-form").submit()

                        } else {

                        }
                    });

                },
                test(defaultAccount) {
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                if (this.bankes[x].balance!=undefined) {
                                this.selectedBank = this.bankes[x];
                                this.averageRate = false;
                                @if(getAverageRate() =="true")
                                if (this.bankes[x].avg_rate && this.expenseType == 'writeCheck') {
                                    this.set_avg_rate(this.bankes[x].avg_rate);
                                }
                                @endif
                                break;
                            }
                            }
                        }
                    }
                },

                set_avg_rate(avg_rate) {
                    let vv = this;
                    setTimeout(() => {
                        vv.averageRate = true;
                        vv.selectedCurrency.rate = avg_rate;
                    }, 300);
                },


                defaultValueM() {
                    this.discountFiled = 0;
                    discountIsAmount = false;

                    this.categories = [
                        {
                            name: [],
                        },
                        {
                            name: [],
                        }
                    ];
                    this.expense = [{
                        items: [],
                        item: null,
                        amount: 0,
                    },
                        {
                            items: [],
                            item: null,
                            amount: 0,
                        }
                    ];
                    this.payments = [
                        {
                            items: [],
                            item: null,
                            amount: 0,
                        }
                    ];
                    this.paymentIndex = 0;
                    this.eindex = 0;
                    //this.expenseType:null,
                    this.account = {};
                    //tpl: temp,
                    //this.selectedBank= null;
                    // defaultValue: 0,
                    // defaultAmount:0,
                    //this.defaultAccount= null;
                    var number = (Number(this.old_expense_number) + 1);
                    this.expense_number = number;
                    this.old_expense_number = number;
                    this.amount = null;
                    
                    sales.disabled = false;
                },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {
                                sales.disabled = true;
                                var url = "{{route('expense.store')}}";
                                form_id = 'expense-form';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);

                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            //$('#success-sound')[0].play();
                                            toastr.success('', response.data.message);

                                            sales.defaultValueM();
                                            // location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            sales.disabled = false;
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        sales.disabled = false;
                                        console.log(error);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },
 

            checkOldList(){
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                var bank_id = this.defaultAccount;
                var date = document.getElementById('date').value;
                var amount = this.amount_check;
                if(this.expenseType != 'writeCheck'){
                    bank_id = null;
                }
                if (amount && this.selectedCurrency && this.selected_vendor) {
                    sales.disabled = true;
                    var currencies = this.selectedCurrency.code;
                    var member_id = this.selected_vendor.id;
                    // console.log(currencies , member_id , bank_id , date, amount);

                    axios.get("{{route('expense.checkOldValue')}}", {
                        params: {
                            currencies: currencies,
                            member_id: member_id,
                            bank_id: bank_id,
                            date: date,
                            amount: amount,
                            }}).then(function (response) {
                                // console.log(response.data);
                                if (response.data) {
                                swal({
                                title: "{{__('layout.DuplicateData')}}",
                                text: "",
                                icon: "warning",
                                buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                infoMode: true,
                            })
                                .then((willDelete) => {
                                    if (willDelete) {
                                        sales.saveAndNew(); 
                                    } else {
                                        sales.disabled = false;
                                    }
                                });
                            }else{
                                sales.saveAndNew(); 
                            }
                            // loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                            sales.disabled = false;
                        }) 

                }
                }
            });
            }, 

            onComplete: function() {
                document.getElementById("account-form").submit()
                //this.$emit('on-complete')
                //alert('Yay. Done!');
            },
              checkExpenseNo() {
                        var chack = 'false';
                        var number = sales.expense_number;
                        if (number != null) {
                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        number: sales.expense_number,
                                        method_name: 'Search_expense_number',
                                        table_name: 'purchases'
                                    },
                                })
                                .then(function(response) {
                                    // console.log(number);
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        // console.log(response.data.result);
                                        // sales.temp_items=response.data;
                                        sales.number_msg = "@lang('layout.DuplicateData')";
                                        sales.number_Error = true;
                                    } else {
                                        sales.number_msg = 'no';
                                        sales.number_Error = false;

                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                });

                        }
                    },


            }
        });


    </script>
@endpush