@extends('layouts.app')
@section('content')
@section('style')
    <link rel="stylesheet" href="{{url('/vue/v-autocomplete.css')}}">
    <link rel="stylesheet" href="{{url('/vue/style.css')}}">
@stop


<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewInvetorySite')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">
                <a href="" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                <a href="" class="reload" data-original-title="" title=""> </a>
                <a href="" class="remove" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;">
            <!-- BEGIN FORM-->

            <div class="form-body">
                <div id="app">
                    <table class="table">
                        <thead>
                        <tr>
                            <td><strong>Title</strong></td>
                            <td><strong>Description</strong></td>
                            <td><strong>File</strong></td>
                            <td></td>
                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="row in rows">
                            <td>
                                {{ Form::select('my-select',
                                [1, 2, 3],
                                 null,
                                ['v-on:change'=>'myMethod']) }}
                            </td>
                            <td><input type="text" v-model="row.title"></td>
                            <td><input type="text" v-model="row.description"></td>
                            <td><input type="file" @change="setFilename($event);"></td>
                            <td><a v-on:click="removeElement(row);" style="cursor: pointer">Remove</a></td>
                        </tr>
                        </tbody>
                    </table>
                    <div>
                        <button class="button btn-primary" @click="addRow">Add row</button>
                    </div>
                </div>
            </div>

        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script src="{{url('/vue/v-autocomplete.js')}}"></script>
    <script type="text/javascript">
        var app = new Vue({
            el: "#app",
            data: {
                rows: [
                    {title: "XEngine for Sale", description: "An application"},
                    {title: "There is no place like 127.0.0.1", description: "Best tool for your security."}
                ]
            },
            methods: {
                myMethod: function () {
                    this.rows.push({title: "", description: ""});
                },
                removeElement: function (row) {
                    var index = this.rows.indexOf(row);
                    this.rows.splice(index, 1);
                },
                setFilename: function (event) {
                    this.filename = event.target.name;
                }
            }
        });
    </script>


@endpush
